/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openinstaller.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybridElementTreeModel
implements TreeModel {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private final List<TreeModelListener> gListeners = new ArrayList<TreeModelListener>();
    private String gRootNode = "\u0000";
    private Map<String, List<String>> gHierarchyMap = new HashMap<String, List<String>>();

    public HybridElementTreeModel(Map<String, List<String>> aHashMap, String aRootID) {
        this.gHierarchyMap = aHashMap;
        if (this.gHierarchyMap.containsKey(aRootID)) {
            this.setRoot(aRootID);
        } else {
            ArrayList<String> theRootChildren = new ArrayList<String>();
            Iterator<String> theIterator = this.gHierarchyMap.keySet().iterator();
            while (theIterator.hasNext()) {
                theRootChildren.add(theIterator.next());
            }
            this.gHierarchyMap.put(this.gRootNode, theRootChildren);
        }
    }

    private void setRoot(String aRootID) {
        this.gRootNode = aRootID;
    }

    @Override
    public final Object getRoot() {
        return this.gRootNode;
    }

    @Override
    public final Object getChild(Object aNode, int aIndex) {
        String theNode = (String)aNode;
        String theChild = null;
        if (this.gHierarchyMap.containsKey(theNode) && this.gHierarchyMap.get(theNode).size() > aIndex) {
            Iterator<String> theIterChildren = this.gHierarchyMap.get(theNode).iterator();
            for (int theIndex = 0; theIndex <= aIndex && theIterChildren.hasNext(); ++theIndex) {
                theChild = theIterChildren.next();
            }
        }
        return theChild;
    }

    @Override
    public final int getChildCount(Object aNode) {
        String theNode = (String)aNode;
        if (this.gHierarchyMap.containsKey((String)aNode) && this.gHierarchyMap.get(theNode) != null) {
            return this.gHierarchyMap.get(theNode).size();
        }
        return -1;
    }

    @Override
    public final boolean isLeaf(Object aNode) {
        return this.getChildCount(aNode) != -1;
    }

    @Override
    public final void valueForPathChanged(TreePath aPath, Object aNewValue) {
    }

    @Override
    public final int getIndexOfChild(Object aNode, Object aSubNode) {
        String theNode = (String)aNode;
        if (this.gHierarchyMap.containsKey((String)aNode) && this.gHierarchyMap.get(theNode) != null) {
            return this.gHierarchyMap.get(theNode).indexOf((String)aNode);
        }
        return -1;
    }

    @Override
    public final void addTreeModelListener(TreeModelListener aListener) {
        if (aListener != null && !this.gListeners.contains(aListener)) {
            this.gListeners.add(aListener);
        }
    }

    @Override
    public final void removeTreeModelListener(TreeModelListener aListener) {
        if (aListener != null) {
            this.gListeners.remove(aListener);
        }
    }

    public final void display() {
        this.visitAllNodes(this);
    }

    public final void visitAllNodes(HybridElementTreeModel aSubTree) {
        Object theRoot = this.getRoot();
        this.visitAllNodes(theRoot);
    }

    public final void visitAllNodes(Object aNode) {
        for (int theIndex = 0; theIndex < this.getChildCount(aNode); ++theIndex) {
            Object theNode = this.getChild(aNode, theIndex);
            this.visitAllNodes(theNode);
        }
    }
}

