/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.logging.Logger;
import org.openinstaller.provider.dependency.ENVirtualUser;
import org.openinstaller.provider.dependency.HybridComponentElement;
import org.openinstaller.provider.dependency.PersistenceTable;
import org.openinstaller.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybridGroupElement
extends Observable
implements Observer {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private String gIdentifier = null;
    private List<HybridComponentElement> gProviders = null;
    private List<String> gRequesters = null;
    private final PersistenceTable gChoiceTable = new PersistenceTable();

    public HybridGroupElement(String aIdentifier) {
        this.setIdentifier(aIdentifier);
    }

    public HybridGroupElement(String aIdentifier, HybridComponentElement aProvider) {
        this.setIdentifier(aIdentifier);
        this.addProvider(aProvider);
    }

    public HybridGroupElement(String aIdentifier, List<HybridComponentElement> aProviders) {
        this.setIdentifier(aIdentifier);
        this.setProviders(aProviders);
    }

    private void setIdentifier(String aIdentifier) {
        this.gIdentifier = aIdentifier;
    }

    public final String getIdentifier() {
        return this.gIdentifier;
    }

    public final void setProviders(List<HybridComponentElement> aConstituants) {
        this.gProviders = aConstituants;
    }

    public final void addProvider(HybridComponentElement aConstituant) {
        this.gProviders.add(aConstituant);
    }

    public final List<String> getProvidersID() {
        ArrayList<String> theResult = new ArrayList<String>();
        Iterator<HybridComponentElement> theIterator = this.gProviders.iterator();
        while (theIterator.hasNext()) {
            theResult.add(theIterator.next().getIdentifier());
        }
        return theResult;
    }

    public final List<HybridComponentElement> getProviders() {
        ArrayList<HybridComponentElement> theClone = new ArrayList<HybridComponentElement>();
        HashSet<HybridComponentElement> theSetFilter = new HashSet<HybridComponentElement>();
        for (HybridComponentElement theHybridComponentElement : this.gProviders) {
            if (!theSetFilter.add(theHybridComponentElement)) continue;
            theClone.add(theHybridComponentElement);
        }
        return theClone;
    }

    public final List<String> getRequestersID() {
        return this.gRequesters;
    }

    public final void setRequesters(List<String> aContent) {
        this.gRequesters = aContent;
    }

    public final void addRequesterID(String aRequesterID) {
        this.gRequesters.add(aRequesterID);
    }

    @Override
    public final void update(Observable aObservable, Object aArg) {
        boolean theOperation = (Boolean)aArg;
        List<HybridComponentElement> theHCEAnswer = null;
        if (theOperation) {
            theHCEAnswer = ENVirtualUser.picksGroupOptions(this.getProviders());
        }
        this.updateTable(aObservable, theOperation, theHCEAnswer);
    }

    private void updateTable(Observable aObservable, boolean aSelect, List<HybridComponentElement> aObservers) {
        String theObservableHEId = ((HybridComponentElement)aObservable).getIdentifier();
        List<HybridComponentElement> theSelection = aObservers == null ? this.getProviders() : aObservers;
        for (int theIndex = 0; theIndex < theSelection.size(); ++theIndex) {
            HybridComponentElement theObserverHE = theSelection.get(theIndex);
            String theObserverHEId = theObserverHE.getIdentifier();
            if (aSelect) {
                this.gChoiceTable.addSelection(theObservableHEId, theObserverHEId);
                aObservable.addObserver(theObserverHE);
                theObserverHE.updateCount(aSelect);
                continue;
            }
            aObservable.deleteObserver(theObserverHE);
            this.gChoiceTable.delSelection(theObservableHEId, theObserverHEId);
        }
    }

    public final Map<String, Set<String>> getPersistenceTable() {
        return this.gChoiceTable.getSelectionTable();
    }
}

