/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bindings.component.CapabilityRefVersion;
import org.openinstaller.bindings.component.ComponentRefVersion;
import org.openinstaller.bindings.component.IdentityVersion;
import org.openinstaller.bindings.component.PrequalifiedDiscreteVersion;
import org.openinstaller.bindings.component.PrequalifiedRangeVersion;
import org.openinstaller.bindings.component.QualifiedDiscreteVersion;
import org.openinstaller.bindings.component.QualifiedDiscreteVersions;
import org.openinstaller.bindings.component.QualifiedRangeVersion;
import org.openinstaller.bindings.component.QualifiedRangeVersions;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Version;
import org.openinstaller.util.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionObject {
    private final Map<String, Compatibilities> gMapOfCompatibilities = new HashMap<String, Compatibilities>();
    private static final String INCLUDED = "included";
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public final Version getBaseline(String aComponentID) {
        return this.gMapOfCompatibilities.get(aComponentID).getBaseline();
    }

    public final void setBaseline(String aComponentID, String aBaseline) {
        this.forceCheckEntry(aComponentID);
        Compatibilities theCompatibilities = this.gMapOfCompatibilities.get(aComponentID);
        theCompatibilities.setBaseline(aBaseline);
        this.gMapOfCompatibilities.put(aComponentID, theCompatibilities);
    }

    public final List<Version> getDiscretes(String aComponentID) {
        if (this.gMapOfCompatibilities.containsKey(aComponentID)) {
            return this.gMapOfCompatibilities.get(aComponentID).getDiscrete();
        }
        return new ArrayList<Version>();
    }

    public final List<VersionRange> getRanges(String aComponentID) {
        if (this.gMapOfCompatibilities.containsKey(aComponentID)) {
            return this.gMapOfCompatibilities.get(aComponentID).getRange();
        }
        return new ArrayList<VersionRange>();
    }

    private void forceCheckEntry(String aEntry) {
        if (!this.gMapOfCompatibilities.containsKey(aEntry)) {
            this.gMapOfCompatibilities.put(aEntry, new Compatibilities());
        }
    }

    public final void addDiscrete(String aComponentID, Version aVersion) {
        this.forceCheckEntry(aComponentID);
        Compatibilities theCompatibilities = this.gMapOfCompatibilities.get(aComponentID);
        theCompatibilities.addDiscrete(aVersion);
        this.gMapOfCompatibilities.put(aComponentID, theCompatibilities);
    }

    public final void addRange(String aComponentID, VersionRange aVersionRange) {
        this.forceCheckEntry(aComponentID);
        Compatibilities theCompatibilities = this.gMapOfCompatibilities.get(aComponentID);
        theCompatibilities.addRange(aVersionRange);
        this.gMapOfCompatibilities.put(aComponentID, theCompatibilities);
    }

    public final VersionObject versCompat2versObject(String aDefaultComponentID, IdentityVersion aVersion) {
        VersionObject theVersionObject = new VersionObject();
        theVersionObject.setBaseline(aDefaultComponentID, aVersion.getVersionBaseline());
        if (aVersion.getQualifiedCompatibleVersions() != null) {
            for (Object theElement : aVersion.getQualifiedCompatibleVersions().getContent()) {
                Iterator theIterComponentIDs;
                Class<?> theType = theElement.getClass();
                if (theType == QualifiedDiscreteVersions.class) {
                    QualifiedDiscreteVersions theQualifiedDiscreteVersions = (QualifiedDiscreteVersions)theElement;
                    for (QualifiedDiscreteVersion theVersionDiscrete : theQualifiedDiscreteVersions.getQualifiedDiscreteVersion()) {
                        Version theVersionIdentifier = new Version(theVersionDiscrete.getVersionIdentifier().getValue());
                        theIterComponentIDs = theVersionDiscrete.getQualifier().iterator();
                        while (theIterComponentIDs.hasNext()) {
                            theVersionObject.addDiscrete((String)theIterComponentIDs.next(), theVersionIdentifier);
                        }
                    }
                }
                if (theType != QualifiedRangeVersions.class) continue;
                QualifiedRangeVersions theQualifiedRangeVersions = (QualifiedRangeVersions)theElement;
                for (QualifiedRangeVersion theVersion : theQualifiedRangeVersions.getQualifiedRangeVersion()) {
                    try {
                        VersionRange theVersionRange = new VersionRange(new Version(theVersion.getLow().getValue()), theVersion.getLow().getBorder().value().equals(INCLUDED), new Version(theVersion.getHigh().getValue()), theVersion.getHigh().getBorder().value().equals(INCLUDED));
                        theIterComponentIDs = theVersion.getQualifier().iterator();
                        while (theIterComponentIDs.hasNext()) {
                            theVersionObject.addRange((String)theIterComponentIDs.next(), theVersionRange);
                        }
                    }
                    catch (InvalidArgumentException theEIAEx) {
                        LOGGER.log(Level.WARNING, "ERROR_CREATING_VERSION_RANGE", theEIAEx);
                    }
                }
            }
        }
        return theVersionObject;
    }

    public final VersionObject versCompat2versObject(String aDefaultComponentID, CapabilityRefVersion aVersion) {
        VersionObject theVersionObject = new VersionObject();
        theVersionObject.setBaseline(aDefaultComponentID, aVersion.getVersionBaseline());
        if (aVersion.getQualifiedCompatibleVersions() != null) {
            for (Object theElement : aVersion.getQualifiedCompatibleVersions().getContent()) {
                Iterator theIterComponentIDs;
                Class<?> theType = theElement.getClass();
                if (theType == QualifiedDiscreteVersions.class) {
                    QualifiedDiscreteVersions theQualifiedDiscreteVersions = (QualifiedDiscreteVersions)theElement;
                    for (QualifiedDiscreteVersion theVersionDiscrete : theQualifiedDiscreteVersions.getQualifiedDiscreteVersion()) {
                        Version theVersionIdentifier = new Version(theVersionDiscrete.toString());
                        theIterComponentIDs = theVersionDiscrete.getQualifier().iterator();
                        while (theIterComponentIDs.hasNext()) {
                            theVersionObject.addDiscrete((String)theIterComponentIDs.next(), theVersionIdentifier);
                        }
                    }
                }
                if (theType != QualifiedRangeVersions.class) continue;
                QualifiedRangeVersions theQualifiedRangeVersions = (QualifiedRangeVersions)theElement;
                for (QualifiedRangeVersion theVersion : theQualifiedRangeVersions.getQualifiedRangeVersion()) {
                    try {
                        VersionRange theVersionRange = new VersionRange(new Version(theVersion.getLow().getValue()), theVersion.getLow().getBorder().value().equals(INCLUDED), new Version(theVersion.getHigh().getValue()), theVersion.getHigh().getBorder().value().equals(INCLUDED));
                        theIterComponentIDs = theVersion.getQualifier().iterator();
                        while (theIterComponentIDs.hasNext()) {
                            theVersionObject.addRange((String)theIterComponentIDs.next(), theVersionRange);
                        }
                    }
                    catch (InvalidArgumentException theEIAEx) {
                        LOGGER.log(Level.WARNING, "ERROR_CREATING_VERSION_RANGE", theEIAEx);
                    }
                }
            }
        }
        return theVersionObject;
    }

    public final VersionObject versCompat2versObject(String aDefaultComponentID, ComponentRefVersion aVersion) {
        VersionObject theVersionObject = new VersionObject();
        theVersionObject.setBaseline(aDefaultComponentID, aVersion.getVersionBaseline());
        if (aVersion.getPrequalifiedCompatibleVersions() != null && aVersion.getPrequalifiedCompatibleVersions().getPrequalifiedDiscreteVersions() != null) {
            for (PrequalifiedDiscreteVersion theVersionDiscrete : aVersion.getPrequalifiedCompatibleVersions().getPrequalifiedDiscreteVersions().getPrequalifiedDiscreteVersion()) {
                Version theVersionIdentifier = new Version(theVersionDiscrete.getVersionIdentifier().getValue());
                theVersionObject.addDiscrete(aDefaultComponentID, theVersionIdentifier);
            }
        }
        if (aVersion.getPrequalifiedCompatibleVersions() != null && aVersion.getPrequalifiedCompatibleVersions().getPrequalifiedRangeVersions() != null) {
            for (PrequalifiedRangeVersion theVersion : aVersion.getPrequalifiedCompatibleVersions().getPrequalifiedRangeVersions().getPrequalifiedRangeVersion()) {
                try {
                    VersionRange theVersionRange = new VersionRange(new Version(theVersion.getLow().getValue()), theVersion.getLow().getBorder().value().equals(INCLUDED), new Version(theVersion.getHigh().getValue()), theVersion.getHigh().getBorder().value().equals(INCLUDED));
                    theVersionObject.addRange(aDefaultComponentID, theVersionRange);
                }
                catch (InvalidArgumentException theEIAEx) {
                    LOGGER.log(Level.WARNING, "ERROR_CREATING_VERSION_RANGE", theEIAEx);
                }
            }
        }
        return theVersionObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Compatibilities {
        private Version gBaseLineVersion;
        private final List<Version> gDiscretes = new ArrayList<Version>();
        private final List<VersionRange> gRanges = new ArrayList<VersionRange>();

        public final Version getBaseline() {
            return this.gBaseLineVersion;
        }

        public final void setBaseline(String aBaseLine) {
            this.gBaseLineVersion = new Version(aBaseLine);
        }

        public final void addDiscrete(Version aVersion) {
            this.gDiscretes.add(aVersion);
        }

        public final List<Version> getDiscrete() {
            return this.gDiscretes;
        }

        public final void addRange(VersionRange aVersionRange) {
            this.gRanges.add(aVersionRange);
        }

        public final List<VersionRange> getRange() {
            return this.gRanges;
        }
    }
}

