/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.operation;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.NoSuchMemberException;
import org.openinstaller.contracts.product.ProductNodeInterface;
import org.openinstaller.provider.dependency.DependencyControl;
import org.openinstaller.provider.dependency.MediaProduct;
import org.openinstaller.provider.dependency.legacy.LegacyData;
import org.openinstaller.provider.operation.Operation;
import org.openinstaller.provider.operation.OperationManager;
import org.openinstaller.provider.operation.ProductMap;
import org.openinstaller.provider.sims.SIMSControl;
import org.openinstaller.sims.Backend;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.sims.legacy.LegacyMap;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Platform;
import org.openinstaller.util.install.Common;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationData {
    private static final Logger LOGGER;
    private ProductMap gProductMap = null;
    private String gInstallHome = null;
    private static List<SystemProduct> gDetectedLegacyProdList;
    private static List<SystemProduct> gSkipList;

    public ProductMap getProductMap(String aInstallHome) throws EnhancedException {
        if (this.gProductMap == null || new File(this.gInstallHome).compareTo(new File(aInstallHome)) != 0) {
            this.createProductMap(aInstallHome);
        }
        return this.gProductMap;
    }

    public Operation.OPTYPE determineOperationType(Set<SystemProduct> aSysProducts, String aMode) {
        Operation.OPTYPE theOp = Enum.valueOf(Operation.OPTYPE.class, aMode);
        LOGGER.finer("OPTYPE = " + theOp.toString());
        if (aSysProducts == null || theOp == Operation.OPTYPE.REMOVE) {
            return theOp;
        }
        for (SystemProduct theSysProd : aSysProducts) {
            LOGGER.finer(" ^ " + theSysProd.toString() + " 's state = " + theSysProd.getState().toString());
            if (theSysProd.getState() != Backend.EntityState.DAMAGED && theSysProd.getState() != Backend.EntityState.PARTIALLY_INSTALLED && theSysProd.getState() != Backend.EntityState.INSTALLED) continue;
            theOp = Enum.valueOf(Operation.OPTYPE.class, "UPGRADE");
            return theOp;
        }
        return theOp;
    }

    public void registerLegacy(List<SystemProduct> aLegacyProductList) {
        if (aLegacyProductList != null) {
            SIMSControl theSIMSCntrl = new SIMSControl(SIMSControl.SIMSCommand.INITIALIZE, null);
            try {
                BusResponse theResponse = ControlBus.getInstance().publishRequest(new BusRequest("SIMSRequest", (Object)theSIMSCntrl), "svc://general/sims");
            }
            catch (InvalidArgumentException theIAEx) {
                LOGGER.log(Level.FINE, "CANNOT_INITIALIZE_SIMS", theIAEx);
            }
            catch (NoSuchMemberException theNSMEx) {
                LOGGER.log(Level.FINE, "CANNOT_INITIALIZE_SIMS", theNSMEx);
            }
            for (SystemProduct theDetectedProd : aLegacyProductList) {
                if (theDetectedProd.getState() != Backend.EntityState.DAMAGED && theDetectedProd.getState() != Backend.EntityState.PARTIALLY_INSTALLED && theDetectedProd.getState() != Backend.EntityState.INSTALLED) continue;
                SystemProduct theSIMSProd = null;
                try {
                    LOGGER.finest("@ Looking for detected product " + theDetectedProd.toString() + " in SIMS");
                    theSIMSProd = OperationManager.getSIMSProduct(theDetectedProd.getName(), theDetectedProd.getVersion().toString());
                }
                catch (EnhancedException theEx) {
                    LOGGER.log(Level.FINE, "Cannot retrieve SystemProduct .. ", theEx);
                }
                if (theSIMSProd != null) {
                    LOGGER.finer(theSIMSProd.toString() + " is already registered into SIMS. Skipping registration");
                    continue;
                }
                LOGGER.fine("Detected a legacy product = " + theDetectedProd.toString() + " Registering into SIMS Repository cache ...");
                SIMSControl theSIMSCmd = new SIMSControl(SIMSControl.SIMSCommand.REGISTER_ALL_LEGACY, theDetectedProd);
                try {
                    BusResponse theSIMSResp = ControlBus.getInstance().publishRequest(new BusRequest("RegisterLegacyRequest", (Object)theSIMSCmd), "svc://general/sims");
                    gSkipList.add(theDetectedProd);
                }
                catch (NoSuchMemberException theNSMEx) {
                    LOGGER.log(Level.FINE, "COULD_NOT_REGISTER_LEGACY_PRODUCTS", theNSMEx);
                }
                catch (InvalidArgumentException theIAEx) {
                    LOGGER.log(Level.FINE, "COULD_NOT_REGISTER_LEGACY_PRODUCTS", theIAEx);
                }
            }
        }
    }

    public void createProductMap(String aInstallHome) throws EnhancedException {
        LOGGER.finest(ClassUtils.getFQMethodName() + " entered");
        this.gInstallHome = aInstallHome;
        LOGGER.finest(ClassUtils.getFQMethodName() + " : Install home is " + this.gInstallHome);
        DependencyControl theDC = new DependencyControl(DependencyControl.COMMAND.GET_PRODUCT_NODE_ROOT, null);
        BusResponse theBR = ControlBus.getInstance().publishRequest(new BusRequest("DependencyRequest", (Object)theDC), "svc://general/Dependency");
        if (theBR == null) {
            throw new EnhancedException("CANNOT_FIND_PRODUCT_NODE", new String[0]);
        }
        if (theBR.getException() != null) {
            throw new EnhancedException("CANNOT_CREATE_PRODUCT_MAP", (Throwable)theBR.getException(), new String[0]);
        }
        ProductNodeInterface thePNI = (ProductNodeInterface)theBR.getResult();
        if (null == thePNI) {
            throw new EnhancedException("NO_MEDIA_PRODUCT_FOUND", new String[0]);
        }
        String prodInst = Common.getDefaultProductID();
        String theMode = null;
        try {
            theMode = Common.getProcessingMode();
        }
        catch (EnhancedException theEEx) {
            theEEx.addContext("CANNOT_CREATE_PRODUCT_MAP", new String[0]);
            throw theEEx;
        }
        LinkedHashSet<SystemProduct> theProductList = new LinkedHashSet<SystemProduct>();
        Set<SystemProduct> theDefaultProductSet = this.getAllVersions(prodInst);
        MediaProduct theHybrid = (MediaProduct)thePNI;
        LinkedHashSet<SystemProduct> theLegacySysProducts = new LinkedHashSet<SystemProduct>();
        if ("INSTALL".equalsIgnoreCase(theMode)) {
            LOGGER.finer("Perform legacy detection only if the mode is Install and the product is  notfound in SIMS already. Default processing mode = " + theMode);
            this.legacyDetection();
            LOGGER.finer("% Adding versions of detected product " + prodInst);
            theDefaultProductSet = this.getAllVersions(prodInst);
            if (null != theDefaultProductSet && !theDefaultProductSet.isEmpty()) {
                theProductList.addAll(theDefaultProductSet);
            }
            for (SystemProduct theDetectedProd : gDetectedLegacyProdList) {
                Set<SystemProduct> theDepProds = this.getAllVersions(theDetectedProd.getName());
                if (null == theDepProds || theDepProds.isEmpty()) continue;
                theProductList.addAll(theDepProds);
            }
        } else if (theDefaultProductSet != null && !theDefaultProductSet.isEmpty()) {
            theProductList.addAll(theDefaultProductSet);
        }
        if (!theProductList.isEmpty()) {
            LOGGER.finest("The product list is not empty. Adding to legacy sys products.");
            theLegacySysProducts.addAll(theProductList);
        }
        for (SystemProduct theP : theLegacySysProducts) {
            LOGGER.finer("@ Product found in SIMS = " + theP.toString());
        }
        Operation.OPTYPE theOp = this.determineOperationType(theLegacySysProducts, theMode);
        LOGGER.finer(" * O p e r = " + theOp.toString());
        this.gProductMap = new ProductMap(theLegacySysProducts, theHybrid, theOp, Platform.getCurrentPlatform());
    }

    public Set<SystemProduct> getAllVersions(String aProductName) {
        LOGGER.finer("@About to get products from SIMS repository for " + aProductName);
        Set theLegacyProdSet = null;
        try {
            SIMSControl theSIMSCntrl = new SIMSControl(SIMSControl.SIMSCommand.GET_PRODUCT_VERSIONS, aProductName);
            BusResponse theSIMSResp = ControlBus.getInstance().publishRequest(new BusRequest("SIMSRequest", (Object)theSIMSCntrl), "svc://general/sims");
            if (theSIMSResp != null) {
                if (theSIMSResp.getException() == null) {
                    theLegacyProdSet = (Set)theSIMSResp.getResult();
                } else {
                    LOGGER.log(Level.FINER, "Exception occured while retrieving legacy versions ...", theSIMSResp.getException());
                }
            } else {
                LOGGER.finer("Could not locate product versions ...");
            }
        }
        catch (InvalidArgumentException theIAEx) {
            LOGGER.log(Level.FINE, "Exception occured trying to retrieve product versions ..", theIAEx);
        }
        catch (NoSuchMemberException theNSMEx) {
            LOGGER.log(Level.FINE, "Exception occured trying to retrieve product versions ..", theNSMEx.getMessage());
        }
        return theLegacyProdSet;
    }

    public void legacyDetection() {
        try {
            DependencyControl theLegDC = new DependencyControl(DependencyControl.COMMAND.GET_LEGACY_DATA, null);
            BusResponse theLegResp = ControlBus.getInstance().publishRequest(new BusRequest("LegacyRequest", (Object)theLegDC), "svc://general/Dependency");
            if (theLegResp == null) {
                LOGGER.log(Level.FINE, "COULD_NOT_FIND_LEGACY_PRODUCTS");
                return;
            }
            if (theLegResp.getException() != null) {
                LOGGER.log(Level.INFO, "COULD_NOT_FIND_LEGACY_PRODUCTS", theLegResp.getException());
                return;
            }
            List theLegacyDataList = (List)theLegResp.getResult();
            if (theLegacyDataList == null) {
                LOGGER.fine("No legacy data was found .... Just return");
                return;
            }
            for (LegacyData theLegacyData : theLegacyDataList) {
                LOGGER.finer("@ Legacy hybrid = " + theLegacyData.getLegacyHybrid().getID());
                ArrayList<MediaProduct> theSequencedProductList = new ArrayList<MediaProduct>();
                theSequencedProductList.addAll(OperationManager.getLegacyProductList(Operation.OPTYPE.INSTALL, theLegacyData));
                for (MediaProduct theProd : theSequencedProductList) {
                    LOGGER.finer(" @Product in sequence is = " + theProd.getID() + " ver = " + theProd.getVersion());
                    SystemProduct theProduct = this.detectLegacy(theProd);
                    if (theProduct == null) continue;
                    gDetectedLegacyProdList.add(theProduct);
                    LOGGER.finest("% Product [ " + theProduct.toString() + "] added to the list of detected products");
                }
            }
            this.registerLegacy(gDetectedLegacyProdList);
        }
        catch (EnhancedException theEEx) {
            LOGGER.log(Level.INFO, "COULD_NOT_DETECT_PRODUCT", theEEx);
        }
    }

    public void getProductCollection(MediaProduct aLegacyProduct, List<MediaProduct> aProdList) {
        LOGGER.finer("@ Generating Product list for " + aLegacyProduct.getID());
        aProdList.add(aLegacyProduct);
        for (MediaProduct theFeature : aLegacyProduct.getFeatures()) {
            this.getProductCollection(theFeature, aProdList);
        }
        for (MediaProduct theDepProd : aLegacyProduct.getDependencies()) {
            LOGGER.finer("@ Adding " + theDepProd.getID() + " to product collection");
            aProdList.add(theDepProd);
        }
    }

    public SystemProduct detectLegacy(MediaProduct aLegacyProduct) {
        SystemProduct theDetectedProduct = null;
        LOGGER.fine(" * * Getting legacy sims product for " + aLegacyProduct.getID() + " version = " + aLegacyProduct.getVersion());
        DependencyControl theLegSIMSCtrl = new DependencyControl(DependencyControl.COMMAND.GET_LEGACY_SIMS_PRODUCT, aLegacyProduct);
        try {
            BusResponse theResp = ControlBus.getInstance().publishRequest(new BusRequest("LegSIMSRequest", (Object)theLegSIMSCtrl), "svc://general/Dependency");
            if (theResp != null) {
                if (theResp.getException() == null) {
                    Object theProdObj = theResp.getResult();
                    SystemProduct theLegacySIMSProduct = null;
                    if (theProdObj != null) {
                        theLegacySIMSProduct = (SystemProduct)theProdObj;
                    }
                    List<String> theKeyFiles = aLegacyProduct.getKeyFiles(Platform.getCurrentPlatform());
                    Map<String, String> theRegEntries = aLegacyProduct.getRegistryEntries(Platform.getCurrentPlatform());
                    LegacyMap theLegMap = new LegacyMap(theLegacySIMSProduct, theKeyFiles, theRegEntries);
                    SIMSControl theLegSIMSCmd = new SIMSControl(SIMSControl.SIMSCommand.DETECT_LEGACY, theLegMap);
                    BusResponse theLegSIMSResp = ControlBus.getInstance().publishRequest(new BusRequest("DetectLegacyRequest", (Object)theLegSIMSCmd), "svc://general/sims");
                    if (theLegSIMSResp != null) {
                        if (theLegSIMSResp.getException() == null) {
                            Object theLegSIMSObj = theLegSIMSResp.getResult();
                            if (theLegSIMSObj != null) {
                                theDetectedProduct = (SystemProduct)theLegSIMSObj;
                            }
                        } else {
                            LOGGER.log(Level.INFO, "ERROR_DETECTING_PRODUCT", theLegSIMSResp.getException());
                        }
                    } else {
                        LOGGER.log(Level.INFO, "COULD_NOT_DETECT_PRODUCT", "name=" + aLegacyProduct.getID());
                    }
                } else {
                    LOGGER.log(Level.INFO, "ERROR_RETRIEVING_LEGACY_PRODUCT", theResp.getException());
                }
            } else {
                LOGGER.log(Level.INFO, "ERROR_RETRIEVING_LEGACY_PRODUCT", "name=" + aLegacyProduct.getID());
            }
        }
        catch (EnhancedException theEEx) {
            LOGGER.log(Level.INFO, "COULD_NOT_DETECT_PRODUCT", theEEx);
        }
        return theDetectedProduct;
    }

    public static List<SystemProduct> getDetectedProductList() {
        return gDetectedLegacyProdList;
    }

    public static List<SystemProduct> getSkipList() {
        return gSkipList;
    }

    static {
        gDetectedLegacyProdList = new ArrayList<SystemProduct>();
        gSkipList = new ArrayList<SystemProduct>();
        LOGGER = Logger.getLogger(ClassUtils.getClassName());
    }
}

