/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.operation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusException;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.dependency.ComponentDescriptor;
import org.openinstaller.provider.dependency.DependencyControl;
import org.openinstaller.provider.dependency.DependencyManager;
import org.openinstaller.provider.dependency.DependencyTree;
import org.openinstaller.provider.dependency.MediaProduct;
import org.openinstaller.provider.dependency.PlatformInstUnit;
import org.openinstaller.provider.dependency.legacy.LegacyData;
import org.openinstaller.provider.operation.Operation;
import org.openinstaller.provider.operation.OperationData;
import org.openinstaller.provider.operation.OperationImpossibleException;
import org.openinstaller.provider.sims.SIMSControl;
import org.openinstaller.sims.Backend;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Platform;
import org.openinstaller.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperationManager {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static List<SystemProduct> gExcludeList = new ArrayList<SystemProduct>();
    private static Operation.OPTYPE gOpType;

    private OperationManager() {
    }

    public static List<Operation> getOperations(Set<SystemProduct> aCurrent, MediaProduct aTarget, Operation.OPTYPE aOp, Platform aTargetPlatform) throws OperationImpossibleException {
        if (aOp != Operation.OPTYPE.INSTALL && aOp != Operation.OPTYPE.REMOVE && aOp != Operation.OPTYPE.UPGRADE) {
            OperationImpossibleException theOPIEx = new OperationImpossibleException("UNSUPPORTED_OPERATION", "operation=" + (Object)((Object)aOp));
            theOPIEx.addContext("SUPPORTED_OPERATIONS", new String[]{"operation=" + (Object)((Object)Operation.OPTYPE.INSTALL), "operation=" + (Object)((Object)Operation.OPTYPE.REMOVE)});
            throw theOPIEx;
        }
        Vector<Operation> theOps = new Vector<Operation>();
        gOpType = aOp;
        switch (aOp) {
            case INSTALL: {
                LOGGER.fine("Generating install sequence.  Current product:[+ " + aCurrent + "] target: [" + aTarget + "] TargetPlatform:" + aTargetPlatform);
                theOps.addAll(OperationManager.installMedia(aTarget, aTargetPlatform));
                break;
            }
            case REMOVE: {
                LOGGER.fine("Generating removal/uninstall sequence.  Current product:[+ " + aCurrent + "] target: [" + "] TargetPlatform:" + aTargetPlatform);
                theOps.addAll(OperationManager.uninstallSystem(aCurrent, null));
                break;
            }
            case UPGRADE: {
                LOGGER.fine("Generating upgrade sequence. Upgrade consists of remove and install sequence.Current product : [ " + aCurrent + " ] Target : [ " + aTarget + " ] TargetPlatform : " + aTargetPlatform);
                theOps.addAll(OperationManager.upgradeSystem(aCurrent, aTarget, aTargetPlatform));
                break;
            }
            default: {
                OperationImpossibleException theOPIEx = new OperationImpossibleException("UNSUPPORTED_OPERATION", "operation=" + (Object)((Object)aOp));
                theOPIEx.addContext("SUPPORTED_OPERATIONS", new String[]{"operation=" + (Object)((Object)Operation.OPTYPE.INSTALL), "operation=" + (Object)((Object)Operation.OPTYPE.REMOVE)});
                throw theOPIEx;
            }
        }
        LinkedHashSet<Operation> theFinalOps = new LinkedHashSet<Operation>();
        theFinalOps.addAll(theOps);
        theOps.clear();
        for (Operation theOper : theFinalOps) {
            theOps.add(theOper);
        }
        return theOps;
    }

    private static List<Operation> installMedia(MediaProduct aTarget, Platform aTargetPlatform) throws OperationImpossibleException {
        List<MediaProduct> theProds;
        Vector<Operation> theOps = new Vector<Operation>();
        ArrayList<MediaProduct> theProdsToConfig = new ArrayList<MediaProduct>();
        if (aTarget == null) {
            return theOps;
        }
        try {
            theProds = OperationManager.getProductList(Operation.OPTYPE.INSTALL);
            LOGGER.fine("Products to install from media: " + theProds);
        }
        catch (EnhancedException theEx) {
            throw new OperationImpossibleException("CANNOT_GET_PRODUCT_LIST", theEx, "operation=" + (Object)((Object)Operation.OPTYPE.INSTALL));
        }
        for (MediaProduct theProd : theProds) {
            if (!OperationManager.canInstall(theProd)) {
                LOGGER.finest("@ Skipping " + theProd.getID() + " since its not upgradeable");
                continue;
            }
            theOps.addAll(OperationManager.getInstallOperations(theProd, aTargetPlatform));
            try {
                if (ConfigHelper.canConfigure(theProd.getID())) {
                    theProdsToConfig.add(theProd);
                } else {
                    LOGGER.fine("SKIPPING CONFIGURE operations for " + theProd + "since it has no configuration schema");
                }
            }
            catch (EnhancedException theEx) {
                throw new OperationImpossibleException("CANNOT_DETERMINE_PRODUCT_CONFIG_REQ", "product=" + theProd.getID());
            }
            LOGGER.fine("Generating REGISTER operations for product " + theProd);
            theOps.add(new Operation(Operation.OPTYPE.REGISTER, null, null, null, theProd));
        }
        for (MediaProduct theProd : theProdsToConfig) {
            LOGGER.fine("Generating CONFIGURE operations for " + theProd.getID());
            theOps.addAll(OperationManager.getConfigureOperations(theProd));
        }
        for (MediaProduct theProd : theProds) {
            LOGGER.fine("Generating INSTALL_IMAGE_CONFIGURE operations for " + theProd.getID());
            Operation theOperation = new Operation(Operation.OPTYPE.INSTALL_IMAGE_CONFIGURE, null, null, null, theProd);
            theOps.add(theOperation);
        }
        return theOps;
    }

    private static List<MediaProduct> getProductList(Operation.OPTYPE aOp) throws EnhancedException {
        DependencyControl.COMMAND theCmd;
        switch (aOp) {
            case INSTALL: {
                theCmd = DependencyControl.COMMAND.GET_SEQUENCED_COMPONENT;
                break;
            }
            case REMOVE: {
                theCmd = DependencyControl.COMMAND.GET_REVERSE_SEQUENCED_COMPONENT;
                break;
            }
            default: {
                throw new RuntimeException("Unknown operation selected: " + (Object)((Object)aOp));
            }
        }
        DependencyControl theDC = new DependencyControl(theCmd, null);
        BusRequest theBR = new BusRequest("ComponentList", (Object)theDC);
        BusResponse theResp = ControlBus.getInstance().publishRequest(theBR, "svc://general/Dependency");
        List theComps = (List)theResp.getResult();
        ArrayList<MediaProduct> theResult = new ArrayList<MediaProduct>();
        for (ComponentDescriptor theComp : theComps) {
            try {
                theResult.add(OperationManager.getHybrid(theComp));
            }
            catch (Exception theEx) {
                throw new EnhancedException("CANNOT_CREATE_HYBRID_COMP", (Throwable)theEx, new String[]{"component=" + theComp});
            }
        }
        return theResult;
    }

    private static MediaProduct getHybrid(ComponentDescriptor aComp) throws EnhancedException {
        DependencyControl theDC = new DependencyControl(DependencyControl.COMMAND.GET_PRODUCT_NODE, aComp.getIdentityIdentifier());
        BusRequest theBR = new BusRequest("GenComp", (Object)theDC);
        BusResponse theResp = ControlBus.getInstance().publishRequest(theBR, "svc://general/Dependency");
        if (theResp.getException() != null) {
            throw new EnhancedException("CANNOT_GET_HYBRID_ADAPTER", new String[]{"component=" + aComp.getIdentityIdentifier()});
        }
        return (MediaProduct)theResp.getResult();
    }

    private static List<Operation> uninstallSystem(Set<SystemProduct> aCurrent, MediaProduct aTarget) throws OperationImpossibleException {
        List<MediaProduct> theProds;
        ArrayList<Operation> theOps = new ArrayList<Operation>();
        if (aCurrent == null) {
            return theOps;
        }
        ArrayList<SystemProduct> theProdsToUninstall = new ArrayList<SystemProduct>();
        try {
            theProds = OperationManager.getProductList(Operation.OPTYPE.REMOVE);
            for (MediaProduct theProd : theProds) {
                LOGGER.finer(" @ Uninstall : " + theProd.getID() + " " + theProd.getVersion());
                SystemProduct theSysProd = OperationManager.getSIMSProduct(theProd.getID(), theProd.getVersionStr());
                if (theSysProd == null) continue;
                if (gOpType == Operation.OPTYPE.REMOVE && theSysProd.isCritical()) {
                    LOGGER.finest(theSysProd.getID() + " is CRITICAL. Skipping removal");
                    continue;
                }
                if (gOpType == Operation.OPTYPE.REMOVE && OperationManager.isNeededByOtherProduct(theSysProd, theProds)) {
                    LOGGER.fine("Skipping uninstall of " + theSysProd + " since its required elsewhere");
                    continue;
                }
                if ((gOpType == Operation.OPTYPE.REMOVE || gOpType == Operation.OPTYPE.UPGRADE && OperationManager.canUnregister(theSysProd)) && ConfigHelper.canConfigure(theProd.getID())) {
                    theOps.add(new Operation(Operation.OPTYPE.UNCONFIGURE, null, theSysProd, null, null));
                }
                LOGGER.finer("@ Adding to uninstall list : " + theSysProd.toString());
                theProdsToUninstall.add(theSysProd);
            }
            for (SystemProduct theSysProd : theProdsToUninstall) {
                LOGGER.finer("@ Getting uninstall operations for " + theSysProd.toString());
                theOps.addAll(OperationManager.getUninstallOperations(theSysProd, aTarget));
                if ((gOpType != Operation.OPTYPE.REMOVE || !OperationManager.containedWillBeUninstalled(theProdsToUninstall, theSysProd)) && (gOpType != Operation.OPTYPE.UPGRADE || !OperationManager.canUnregister(theSysProd))) continue;
                LOGGER.finer("@ Unregister " + theSysProd.toString());
                theOps.add(new Operation(Operation.OPTYPE.UNREGISTER, null, theSysProd, null, null));
            }
        }
        catch (EnhancedException theEx) {
            throw new OperationImpossibleException("CANNOT_GET_PRODUCT_LIST", theEx, "operation=" + (Object)((Object)Operation.OPTYPE.REMOVE));
        }
        for (MediaProduct theProd : theProds) {
            LOGGER.fine("Generating INSTALL_IMAGE_RESET operations for " + theProd.getID());
            Operation theOperation = new Operation(Operation.OPTYPE.INSTALL_IMAGE_RESET, null, null, null, theProd);
            theOps.add(theOperation);
        }
        return theOps;
    }

    private static boolean containedWillBeUninstalled(List<SystemProduct> aProdsToUninstall, SystemProduct aSysProd) {
        if (aProdsToUninstall.containsAll(aSysProd.getContainedProducts())) {
            return true;
        }
        for (SystemProduct theProd : aSysProd.getContainedProducts()) {
            if (aProdsToUninstall.contains(theProd) || theProd.getState() == Backend.EntityState.NOT_INSTALLED) continue;
            return false;
        }
        return true;
    }

    private static boolean isNeededByOtherProduct(SystemProduct aSysProd, List<MediaProduct> theSelectedProds) throws SIMSException {
        Set theProds;
        try {
            BusResponse theResp = ControlBus.getInstance().publishRequest(new BusRequest("product retrieval", (Object)new SIMSControl(SIMSControl.SIMSCommand.GET_ALL_PRODUCTS, null)), "svc://general/sims");
            if (theResp.getException() != null) {
                throw new SIMSException((Throwable)theResp.getException(), "CANNOT_RETRIEVE_PRODUCTS", new String[0]);
            }
            theProds = (Set)theResp.getResult();
        }
        catch (InvalidArgumentException theEIAEx) {
            throw new SIMSException((Throwable)theEIAEx, "CANNOT_RETRIEVE_PRODUCT", new String[0]);
        }
        catch (BusException theBe) {
            throw new SIMSException((Throwable)theBe, "CANNOT_RETRIEVE_PRODUCT", new String[0]);
        }
        for (SystemProduct theProd : theProds) {
            if (OperationManager.isInList(theProd, theSelectedProds) || !OperationManager.prodIsRequired(aSysProd, theProd)) continue;
            LOGGER.fine("Product " + aSysProd + " is required by " + theProd);
            return true;
        }
        return false;
    }

    private static boolean prodIsRequired(SystemProduct aSysProd, SystemProduct aProd) {
        for (SystemProduct theRequired : aProd.getRequiredProducts()) {
            if (theRequired.equals((Object)aSysProd)) {
                return true;
            }
            if (!OperationManager.prodIsRequired(aSysProd, theRequired)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInList(SystemProduct aProd, List<MediaProduct> aProdList) {
        for (MediaProduct theHybrid : aProdList) {
            if (!theHybrid.getID().equals(aProd.getName()) || !aProd.getVersion().equals((Object)theHybrid.getVersion())) continue;
            return true;
        }
        return false;
    }

    private static List<Operation> getUninstallOperations(SystemProduct aSystem, MediaProduct aTarget) {
        ArrayList<Operation> theOps = new ArrayList<Operation>();
        for (Package theNextPkg : aSystem.getContainedPackages()) {
            if (theNextPkg.getState() == Backend.EntityState.NOT_INSTALLED) continue;
            Version theTargetVersion = null;
            if (null != aTarget) {
                LOGGER.finest("@ Uninstall : About to check package versions ..");
                try {
                    List<PlatformInstUnit> thePlatformInstUnits = aTarget.getCoreInstallableUnits(Platform.getCurrentPlatform());
                    List<PlatformInstUnit> theLocalizedPlatformInstUnits = aTarget.getLocalizedInstallableUnits(Platform.getCurrentPlatform());
                    if (theLocalizedPlatformInstUnits != null && theLocalizedPlatformInstUnits.size() != 0) {
                        thePlatformInstUnits.addAll(theLocalizedPlatformInstUnits);
                    }
                    for (PlatformInstUnit thePlatformInstUnit : thePlatformInstUnits) {
                        String thePkgVer;
                        if (thePlatformInstUnit == null || !theNextPkg.getName().equalsIgnoreCase(thePlatformInstUnit.getIU().getCoreInstallableUnitName()) || null == (thePkgVer = thePlatformInstUnit.getIU().getVersion()) || "".equals(thePkgVer)) continue;
                        theTargetVersion = new Version(thePkgVer.trim());
                    }
                }
                catch (EnhancedException theEEx) {
                    LOGGER.log(Level.FINE, "Could not get InstallableUnits" + (Object)((Object)theEEx));
                    continue;
                }
            }
            if (null != theTargetVersion && theNextPkg.getVersion().compareTo(theTargetVersion) > 0) {
                LOGGER.fine("@ Install package = " + theNextPkg.getID() + " Media package = " + aTarget.getID());
                LOGGER.fine("Installed package won't be removed as it is of higher version than the one on media");
                continue;
            }
            theOps.add(new Operation(Operation.OPTYPE.REMOVE, theNextPkg, aSystem, null, null));
            theOps.add(new Operation(Operation.OPTYPE.UNREGISTER, theNextPkg, aSystem, null, null));
        }
        return theOps;
    }

    public static List<LegacyData> getLegacyData() throws EnhancedException {
        LOGGER.finer("@Getting legacy dependency graphs");
        ArrayList<LegacyData> theLegacyDataList = new ArrayList();
        DependencyControl theLegDC = new DependencyControl(DependencyControl.COMMAND.GET_LEGACY_DATA, null);
        BusRequest theBR = new BusRequest("LegacyDependencyMap", (Object)theLegDC);
        BusResponse theResp = ControlBus.getInstance().publishRequest(theBR, "svc://general/Dependency");
        if (theResp == null) {
            throw new EnhancedException("COULD_NOT_RETRIEVE_LEGACY_DATA", new String[0]);
        }
        if (theResp.getException() != null) {
            throw new EnhancedException("ERROR_RETRIEVING_LEGACY_DATA", (Throwable)theResp.getException(), new String[0]);
        }
        Object theLegacyDataObj = theResp.getResult();
        if (theLegacyDataObj == null) {
            throw new EnhancedException("COULD_NOT_RETRIEVE_LEGACY_DATA", new String[0]);
        }
        theLegacyDataList = (List)theLegacyDataObj;
        return theLegacyDataList;
    }

    public static List<MediaProduct> getLegacyProductList(Operation.OPTYPE aOpType, LegacyData aLegacyData) throws EnhancedException {
        ArrayList<MediaProduct> theOrderedList = new ArrayList<MediaProduct>();
        MediaProduct theHybrid = aLegacyData.getLegacyHybrid();
        DependencyManager theDepMgr = aLegacyData.getDependencyMgr();
        DependencyTree theDepTree = theDepMgr.getDependencyTree();
        ArrayList<ComponentDescriptor> theCompList = new ArrayList<ComponentDescriptor>();
        if (Operation.OPTYPE.REMOVE == aOpType) {
            LOGGER.finer("Getting the reverse order list of legacy components for removal from dependency");
            theCompList.addAll(theDepTree.getReverseSequencedComponents());
        } else if (Operation.OPTYPE.INSTALL == aOpType) {
            LOGGER.finer("Getting the order list of legacy components from dependency");
            theCompList.addAll(theDepTree.getSequencedComponents());
        }
        if (!theCompList.isEmpty()) {
            theOrderedList.addAll(OperationManager.getLegacyHybridElements(theCompList, theDepMgr));
        } else {
            LOGGER.finest(theHybrid.getID() + " 's Component Descriptor list for legacy is empty. No big deal. ");
        }
        return theOrderedList;
    }

    public static List<MediaProduct> getLegacyHybridElements(List<ComponentDescriptor> aCompDescList, DependencyManager aDepMgr) throws EnhancedException {
        LOGGER.finest("@ Getting list of legacy products from Component descriptors");
        ArrayList<MediaProduct> theHybridList = new ArrayList<MediaProduct>();
        for (ComponentDescriptor theCompDesc : aCompDescList) {
            LOGGER.finer("@ Component desc = " + theCompDesc.getIdentityIdentifier());
            theHybridList.add(aDepMgr.getProductNode(theCompDesc.getIdentityIdentifier()));
        }
        return theHybridList;
    }

    public static List<Operation> upgradeSystem(Set<SystemProduct> aCurrent, MediaProduct aTarget, Platform aTargetPlatform) throws OperationImpossibleException {
        ArrayList<Operation> theOps = new ArrayList<Operation>();
        ArrayList<SystemProduct> theProdsToUninstall = new ArrayList<SystemProduct>();
        gExcludeList.clear();
        for (SystemProduct theDiscoveredProduct : aCurrent) {
            LegacyData theLegacyProductData = null;
            try {
                LOGGER.finer("@ Getting legacy data for " + theDiscoveredProduct);
                theLegacyProductData = OperationManager.getLegacyProductData(theDiscoveredProduct);
            }
            catch (EnhancedException theEEx) {
                LOGGER.log(Level.FINE, "COULD_NOT_GET_HYBRID_ELEMENTS_FOR_UPGRADE", theEEx);
            }
            List<Object> theLegacyProductsToRemove = new ArrayList();
            List<MediaProduct> theMediaProductList = null;
            try {
                theMediaProductList = OperationManager.getProductList(Operation.OPTYPE.REMOVE);
            }
            catch (EnhancedException theEEx) {
                LOGGER.finer("Could not retrieve the media list of products to remove");
            }
            if (theLegacyProductData != null) {
                try {
                    theLegacyProductsToRemove = OperationManager.getLegacyProductList(Operation.OPTYPE.REMOVE, theLegacyProductData);
                    for (Object theProdToRemove : theLegacyProductsToRemove) {
                        String theVersion = OperationManager.getLegacyProductVersion((MediaProduct)theProdToRemove);
                        if (null == theVersion) {
                            theVersion = ((MediaProduct)theProdToRemove).getVersionStr();
                        }
                        LOGGER.finest("Check removability for " + ((MediaProduct)theProdToRemove).getID() + " with Version " + theVersion);
                        SystemProduct theSIMSLegacyProduct = OperationManager.getSIMSProduct(((MediaProduct)theProdToRemove).getID(), theVersion);
                        if (theSIMSLegacyProduct == null) continue;
                        MediaProduct theMediaTarget = OperationManager.getMediaProduct(theMediaProductList, theSIMSLegacyProduct.getName());
                        if (OperationManager.isProductRemovable(theSIMSLegacyProduct, theMediaTarget)) {
                            theProdsToUninstall.add(theSIMSLegacyProduct);
                            continue;
                        }
                        LOGGER.finer("@ Excluding " + theSIMSLegacyProduct.getID() + " from Install");
                        OperationManager.addToExcludeList(theSIMSLegacyProduct);
                    }
                    continue;
                }
                catch (EnhancedException theEEx) {
                    LOGGER.log(Level.WARNING, "COULD_NOT_GENERATE_UPGRADE_OPS", theEEx);
                    throw new OperationImpossibleException("COULD_NOT_GENERATE_UPGRADE_OPS", theEEx, new String[0]);
                }
            }
            try {
                LOGGER.finest("@ Checking if OI installed legacy product " + theDiscoveredProduct + " can be removed");
                MediaProduct theMediaTarget = OperationManager.getMediaProduct(theMediaProductList, theDiscoveredProduct.getName());
                if (OperationManager.isProductRemovable(theDiscoveredProduct, theMediaTarget)) {
                    Object theProdToRemove;
                    theProdToRemove = new LinkedHashSet();
                    theProdToRemove.add(theDiscoveredProduct);
                    theOps.addAll(OperationManager.uninstallSystem((Set<SystemProduct>)theProdToRemove, aTarget));
                    continue;
                }
                LOGGER.finer("@ Excluding " + theDiscoveredProduct.getID() + " from Install");
                OperationManager.addToExcludeList(theDiscoveredProduct);
            }
            catch (EnhancedException theEEx) {
                LOGGER.log(Level.WARNING, "COULD_NOT_GET_GENERATE_UPGRADE_OPS", theEEx);
                throw new OperationImpossibleException("COULD_NOT_GET_GENERATE_UPGRADE_OPS", theEEx, new String[0]);
            }
        }
        for (SystemProduct theSysProd : theProdsToUninstall) {
            LOGGER.finer("@ Upgrade Operation : Adding uninstall of " + theSysProd);
            theOps.addAll(OperationManager.getUninstallOperations(theSysProd, aTarget));
        }
        theOps.addAll(OperationManager.installMedia(aTarget, aTargetPlatform));
        return theOps;
    }

    public static LegacyData getLegacyProductData(SystemProduct aSIMSLegacyProduct) throws EnhancedException {
        List<LegacyData> theLegacyDataList = OperationManager.getLegacyData();
        for (LegacyData theLegacyData : theLegacyDataList) {
            List<MediaProduct> theHybridList = OperationManager.getLegacyProductList(Operation.OPTYPE.REMOVE, theLegacyData);
            for (MediaProduct theHybrid : theHybridList) {
                if (!aSIMSLegacyProduct.getName().equalsIgnoreCase(theHybrid.getID())) continue;
                LOGGER.finer(" Legacy Hybrid for SIMS product found = " + aSIMSLegacyProduct.toString());
                return theLegacyData;
            }
        }
        return null;
    }

    public static boolean isProductRemovable(SystemProduct aProduct, MediaProduct aTarget) {
        if (null == aProduct || null == aTarget) {
            return false;
        }
        LOGGER.finest("@ Comparing system = " + aProduct.getName() + " version = " + aProduct.getVersion().toString() + " to media = " + aTarget.getID() + " version = " + aTarget.getVersion());
        int theCompareResult = aProduct.getVersion().compareTo(aTarget.getVersion());
        if (theCompareResult > 0) {
            return false;
        }
        if (aProduct.getState() != Backend.EntityState.NOT_INSTALLED && aProduct.getState() != Backend.EntityState.INSTALLED) {
            LOGGER.finest(aProduct.toString() + "is Removeable because its " + aProduct.getState());
            return true;
        }
        if (theCompareResult == 0) {
            LOGGER.finest(" @ Checking Product release. Versions are same on media & system");
            Version theSysRelease = aProduct.getRelease();
            Version theMediaRelease = new Version(aTarget.getRelease(Platform.getCurrentPlatform()));
            if (theSysRelease != null && theMediaRelease != null) {
                LOGGER.finest(" @ System Release = " + theSysRelease.toString() + " Media Release = " + theMediaRelease);
                if (theSysRelease.compareTo(theMediaRelease) >= 0) {
                    LOGGER.finest(aProduct.getID() + " cannot be removed ");
                    return false;
                }
            }
        }
        LOGGER.finest(" @Legacy " + aProduct.toString() + " needs to upgrade to " + aTarget.getID() + " " + aTarget.getVersion());
        return true;
    }

    public static boolean areFeaturesRemovable(Iterator<SystemProduct> aContainedProducts, Iterator<MediaProduct> aTargetFeatures) {
        if (aContainedProducts == null || aTargetFeatures == null) {
            return true;
        }
        boolean canRemove = true;
        block0: while (aContainedProducts.hasNext() && canRemove) {
            SystemProduct theContainedProduct = aContainedProducts.next();
            while (aTargetFeatures.hasNext()) {
                MediaProduct theFeature = aTargetFeatures.next();
                if (!theContainedProduct.getName().equalsIgnoreCase(theFeature.getID())) continue;
                if (theContainedProduct.getVersion().compareTo(theFeature.getVersion()) != 1) continue block0;
                canRemove = false;
                continue block0;
            }
        }
        return canRemove;
    }

    public static List<Operation> getLegacyRemoveOps(SystemProduct aProduct, MediaProduct aLegacyHybridElement) {
        ArrayList<Operation> theLegacyRemoveOps = new ArrayList<Operation>();
        return theLegacyRemoveOps;
    }

    private static List<Operation> getRepairOperations(SystemProduct aCurrent, MediaProduct aTarget, Platform aTargetPlatform) throws OperationImpossibleException {
        ArrayList<Operation> theOps = new ArrayList<Operation>();
        try {
            Operation theOp;
            Package theNewPkg;
            for (PlatformInstUnit theUnit : aTarget.getCoreInstallableUnits(aTargetPlatform)) {
                if (theUnit == null) continue;
                theNewPkg = new Package(theUnit.getIU().getCoreInstallableUnitName(), aTarget.getVersion(), "instance0");
                theOp = new Operation(Operation.OPTYPE.INSTALL, null, null, theNewPkg, aTarget, theUnit.getPlatform());
                theOp.setData(theUnit.getParameters());
                theOps.add(theOp);
                theOps.add(new Operation(Operation.OPTYPE.REREGISTER, null, aCurrent, theNewPkg, aTarget, theUnit.getPlatform()));
            }
            if (ConfigHelper.getBooleanValue("L10nSelection.directory.INSTALL_L10N")) {
                for (PlatformInstUnit theInstallableUnit : aTarget.getLocalizedInstallableUnits(aTargetPlatform)) {
                    if (theInstallableUnit == null) continue;
                    theNewPkg = new Package(theInstallableUnit.getIU().getCoreInstallableUnitName(), aTarget.getVersion(), "instance0");
                    theOp = new Operation(Operation.OPTYPE.INSTALL, null, null, theNewPkg, aTarget, theInstallableUnit.getPlatform());
                    theOp.setData(theInstallableUnit.getParameters());
                    theOps.add(theOp);
                    theOps.add(new Operation(Operation.OPTYPE.REREGISTER, null, aCurrent, theNewPkg, aTarget, theInstallableUnit.getPlatform()));
                }
            }
        }
        catch (EnhancedException theEx) {
            throw new OperationImpossibleException("CANNOT_GENERATE_REPAIR_OPS", theEx, "component=" + aTarget.getID(), "platform=" + aTargetPlatform);
        }
        theOps.add(new Operation(Operation.OPTYPE.REPAIR, null, aCurrent, null, aTarget));
        return theOps;
    }

    private static List<Operation> getConfigureOperations(MediaProduct aTarget) {
        ArrayList<Operation> theOps = new ArrayList<Operation>();
        theOps.add(new Operation(Operation.OPTYPE.CONFIGURE, null, null, null, aTarget));
        return theOps;
    }

    private static List<Operation> getInstallOperations(MediaProduct aTarget, Platform aTargetPlatform) throws OperationImpossibleException {
        ArrayList<Operation> theOps = new ArrayList<Operation>();
        for (MediaProduct theRequired : aTarget.getDependencies()) {
            if (theRequired == null) continue;
            try {
                if (!aTarget.needsPreconfig(theRequired) || !ConfigHelper.canConfigure(theRequired.getID())) continue;
                theOps.addAll(OperationManager.getConfigureOperations(theRequired));
            }
            catch (EnhancedException theEx) {
                throw new OperationImpossibleException("CANNOT_CONFIGURE_COMP", "component=" + theRequired.getID());
            }
        }
        try {
            ArrayList<PlatformInstUnit> thePlatformPkgList = new ArrayList<PlatformInstUnit>();
            thePlatformPkgList.addAll(aTarget.getCoreInstallableUnits(aTargetPlatform));
            if (ConfigHelper.getBooleanValue("L10nSelection.directory.INSTALL_L10N")) {
                thePlatformPkgList.addAll(aTarget.getLocalizedInstallableUnits(aTargetPlatform));
            }
            for (PlatformInstUnit theUnit : thePlatformPkgList) {
                if (theUnit == null) continue;
                String thePkgVerStr = theUnit.getIU().getVersion();
                if (null == thePkgVerStr || "".equals(thePkgVerStr)) {
                    thePkgVerStr = aTarget.getVersionStr();
                }
                Package theNewPkg = new Package(theUnit.getIU().getCoreInstallableUnitName(), new Version(thePkgVerStr), "instance0");
                Operation theInstallOp = new Operation(Operation.OPTYPE.INSTALL, null, null, theNewPkg, aTarget, theUnit.getPlatform());
                theInstallOp.setData(theUnit.getParameters());
                theOps.add(theInstallOp);
                theOps.add(new Operation(Operation.OPTYPE.REGISTER, null, null, theNewPkg, aTarget, theUnit.getPlatform()));
            }
        }
        catch (EnhancedException theEx) {
            throw new OperationImpossibleException("CANNOT_GENERATE_INSTALL_OPS", theEx, "component=" + aTarget.getID(), "platform=" + aTargetPlatform);
        }
        return theOps;
    }

    public static SystemProduct getSIMSProduct(String aID, String aVersion) throws SIMSException {
        SystemProduct theTmpProd = null;
        try {
            theTmpProd = new SystemProduct(aID, new Version(aVersion), "instance0", "");
            BusResponse theResp = ControlBus.getInstance().publishRequest(new BusRequest("product retrieval", (Object)new SIMSControl(SIMSControl.SIMSCommand.GET_PRODUCT_BY_INSTANCE, theTmpProd)), "svc://general/sims");
            if (theResp.getException() != null) {
                throw new SIMSException((Throwable)theResp.getException(), "CANNOT_RETRIEVE_PRODUCT", new String[]{"product=" + theTmpProd});
            }
            return (SystemProduct)theResp.getResult();
        }
        catch (InvalidArgumentException theEIAEx) {
            throw new SIMSException((Throwable)theEIAEx, "CANNOT_RETRIEVE_PRODUCT", new String[]{"product=" + theTmpProd});
        }
        catch (BusException theBe) {
            throw new SIMSException((Throwable)theBe, "CANNOT_RETRIEVE_PRODUCT", new String[]{"product=" + theTmpProd});
        }
    }

    public static MediaProduct getMediaProduct(List<MediaProduct> aMediaList, String aProductName) {
        for (MediaProduct theMediaProd : aMediaList) {
            if (!theMediaProd.getID().equalsIgnoreCase(aProductName)) continue;
            return theMediaProd;
        }
        return null;
    }

    private static void addToExcludeList(SystemProduct aProduct) {
        LOGGER.finer("@ Excluding " + aProduct.getID() + " from Install");
        gExcludeList.add(aProduct);
    }

    private static String getLegacyProductVersion(MediaProduct aLegacyProductToRemove) {
        ArrayList<SystemProduct> theProductCollection = new ArrayList<SystemProduct>();
        theProductCollection.addAll(OperationData.getDetectedProductList());
        for (SystemProduct theDetectedProd : theProductCollection) {
            LOGGER.finer("@ Detected Prod = " + theDetectedProd.toString() + " @ Legacy Prod = " + aLegacyProductToRemove.getID());
            if (!theDetectedProd.getName().equalsIgnoreCase(aLegacyProductToRemove.getID())) continue;
            Version theLegacyVer = aLegacyProductToRemove.getVersion();
            if (theDetectedProd.getVersion().compareTo(theLegacyVer) == 0) continue;
            LOGGER.finer("@ Correct Version for " + aLegacyProductToRemove.getID() + " is not " + aLegacyProductToRemove.getVersion() + " , but " + theDetectedProd.getVersion().toString());
            return theDetectedProd.getVersion().toString();
        }
        return null;
    }

    private static boolean canInstall(MediaProduct aProductToInstall) {
        for (SystemProduct theExcludeProd : gExcludeList) {
            if (!theExcludeProd.getName().equalsIgnoreCase(aProductToInstall.getID())) continue;
            return false;
        }
        return true;
    }

    private static boolean canUnregister(SystemProduct aProduct) {
        List<SystemProduct> theSkipList = OperationData.getSkipList();
        for (SystemProduct theDetectedProd : theSkipList) {
            if (!aProduct.getName().equalsIgnoreCase(aProduct.getName())) continue;
            return false;
        }
        return true;
    }
}

