/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.sims;

import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusException;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.core.EngineConfigCommand;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.provider.sims.SIMSControl;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.sims.SIMSContext;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.sims.legacy.LegacyDetector;
import org.openinstaller.sims.legacy.LegacyMap;
import org.openinstaller.sims.util.SimsUtils;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;

public final class SIMSProvider
implements ServiceProvider {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private SIMSContext gSIMSContext;

    public void init(ControlBus aBus) throws BusException {
        try {
            BusRequest theReq = new BusRequest("Mode-Request", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.DRY_RUN_FILE));
            BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
            Object theModeObj = theResp.getResult();
            boolean theDryRunMode = theModeObj != null;
            this.gSIMSContext = new SIMSContext(theDryRunMode);
        }
        catch (InvalidArgumentException theEIAEx) {
            throw new BusException((Throwable)theEIAEx, "CANT_INITIALIZE_SIMS");
        }
        catch (SIMSException theSIMSEx) {
            throw new BusException((Throwable)theSIMSEx, "CANT_INITIALIZE_SIMS");
        }
        LOGGER.log(Level.FINE, "SIMS Initialized");
    }

    public void shutdown() {
    }

    public void receiveEvent(ControlBus aBus, BusEvent aEvent) {
    }

    public void receiveRequest(ControlBus aBus, BusRequest aReq, BusResponse aResp) {
        if (this.gSIMSContext == null) {
            aResp.setException((Exception)((Object)new EnhancedException("SIMS_NOT_INITIALIZED", new String[0])));
            return;
        }
        if (!SIMSControl.class.isInstance(aReq.getData())) {
            aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
            return;
        }
        switch (((SIMSControl)aReq.getData()).getCommand()) {
            case GET_DOMAIN: {
                String theDomain = this.gSIMSContext.getDomain();
                aResp.setFinalResult((Object)theDomain);
                break;
            }
            case SET_DOMAIN: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                if (String.class.isInstance(theSIMSData)) {
                    String theDomainName = (String)theSIMSData;
                    try {
                        this.gSIMSContext.setDomain(theDomainName);
                    }
                    catch (SIMSException theSIMSEx) {
                        aResp.setException((Exception)((Object)theSIMSEx));
                    }
                    break;
                }
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                break;
            }
            case GET_ALTROOT: {
                String theRoot = this.gSIMSContext.getAlternateRoot();
                aResp.setFinalResult((Object)theRoot);
                break;
            }
            case SET_ALTROOT: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                if (String.class.isInstance(theSIMSData)) {
                    String theNewRoot = (String)theSIMSData;
                    try {
                        this.gSIMSContext.setAlternateRoot(theNewRoot);
                    }
                    catch (SIMSException theSIMSEx) {
                        aResp.setException((Exception)((Object)theSIMSEx));
                    }
                    break;
                }
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                break;
            }
            case REGISTER_PACKAGE: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                if (Package.class.isInstance(theSIMSData)) {
                    Package thePkg = (Package)theSIMSData;
                    try {
                        this.gSIMSContext.registerPackage(false, thePkg, null);
                    }
                    catch (SIMSException theSIMSEx) {
                        aResp.setException((Exception)((Object)theSIMSEx));
                    }
                    catch (InvalidArgumentException theIAEx) {
                        aResp.setException((Exception)((Object)theIAEx));
                    }
                    break;
                }
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                aResp.setFinalResult(null);
                break;
            }
            case REGISTER_ALL: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                if (SystemProduct.class.isInstance(theSIMSData)) {
                    SystemProduct theProduct = (SystemProduct)theSIMSData;
                    try {
                        this.gSIMSContext.registerAll(false, theProduct, null);
                    }
                    catch (SIMSException theSIMSEx) {
                        aResp.setException((Exception)((Object)theSIMSEx));
                    }
                    break;
                }
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                aResp.setFinalResult(null);
                break;
            }
            case REGISTER_PRODUCT: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                if (SystemProduct.class.isInstance(theSIMSData)) {
                    SystemProduct theProduct = (SystemProduct)theSIMSData;
                    try {
                        this.gSIMSContext.registerProduct(false, theProduct, null);
                    }
                    catch (SIMSException theSIMSEx) {
                        aResp.setException((Exception)((Object)theSIMSEx));
                    }
                    catch (InvalidArgumentException theIAEx) {
                        aResp.setException((Exception)((Object)theIAEx));
                    }
                    break;
                }
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                aResp.setFinalResult(null);
                break;
            }
            case UNREGISTER_PACKAGE: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                if (Package.class.isInstance(theSIMSData)) {
                    Package thePkg = (Package)theSIMSData;
                    try {
                        this.gSIMSContext.unregisterPackage(thePkg, null);
                    }
                    catch (SIMSException theSIMSEx) {
                        aResp.setException((Exception)((Object)theSIMSEx));
                    }
                    catch (InvalidArgumentException theIAEx) {
                        aResp.setException((Exception)((Object)theIAEx));
                    }
                    break;
                }
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                aResp.setFinalResult(null);
                break;
            }
            case UNREGISTER_ALL: 
            case UNREGISTER_PRODUCT: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                if (SystemProduct.class.isInstance(theSIMSData)) {
                    SystemProduct theProduct = (SystemProduct)theSIMSData;
                    try {
                        this.gSIMSContext.unregisterProduct(theProduct, null);
                    }
                    catch (SIMSException theSIMSEx) {
                        aResp.setException((Exception)((Object)theSIMSEx));
                    }
                    catch (InvalidArgumentException theIAEx) {
                        aResp.setException((Exception)((Object)theIAEx));
                    }
                    break;
                }
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                aResp.setFinalResult(null);
                break;
            }
            case GET_PACKAGE: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                if (Package.class.isInstance(theSIMSData)) {
                    Package thePackage = (Package)theSIMSData;
                    try {
                        Package thePkgInstance = this.gSIMSContext.getPackageInstance(thePackage);
                        aResp.setFinalResult((Object)thePkgInstance);
                    }
                    catch (SIMSException theSIMSEx) {
                        aResp.setException((Exception)((Object)theSIMSEx));
                    }
                    catch (InvalidArgumentException theIAEx) {
                        aResp.setException((Exception)((Object)theIAEx));
                    }
                    break;
                }
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                break;
            }
            case GET_PRODUCT_BY_INSTANCE: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                if (SystemProduct.class.isInstance(theSIMSData)) {
                    SystemProduct theProduct = (SystemProduct)theSIMSData;
                    try {
                        SystemProduct theProductInstance = this.gSIMSContext.getProductInstance(theProduct);
                        aResp.setFinalResult((Object)theProductInstance);
                    }
                    catch (SIMSException theSIMSEx) {
                        aResp.setException((Exception)((Object)theSIMSEx));
                    }
                    catch (InvalidArgumentException theIAEx) {
                        aResp.setException((Exception)((Object)theIAEx));
                    }
                    break;
                }
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                break;
            }
            case GET_PRODUCT_BY_NAME: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                if (String.class.isInstance(theSIMSData)) {
                    String theProduct = (String)theSIMSData;
                    try {
                        Set theProductInstances = this.gSIMSContext.getProductInstances(theProduct, null);
                        if (theProductInstances == null || theProductInstances.isEmpty()) {
                            aResp.setFinalResult(null);
                            break;
                        }
                        aResp.setFinalResult(theProductInstances.iterator().next());
                    }
                    catch (SIMSException theSIMSEx) {
                        aResp.setException((Exception)((Object)theSIMSEx));
                    }
                    catch (InvalidArgumentException theIAEx) {
                        aResp.setException((Exception)((Object)theIAEx));
                    }
                    break;
                }
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                break;
            }
            case GET_PRODUCT_VERSIONS: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                if (String.class.isInstance(theSIMSData)) {
                    String theProduct = (String)theSIMSData;
                    LOGGER.fine("Will inspect " + theProduct + " now");
                    try {
                        Set theProductInstances = this.gSIMSContext.getProductInstances(theProduct, null);
                        aResp.setFinalResult((Object)theProductInstances);
                    }
                    catch (SIMSException theSIMSEx) {
                        LOGGER.fine("SIMS Exception occured " + theSIMSEx.getMessage());
                        aResp.setException((Exception)((Object)theSIMSEx));
                    }
                    catch (InvalidArgumentException theIAEx) {
                        LOGGER.fine("Invalid Argument Exception occured " + theIAEx.getMessage());
                        aResp.setException((Exception)((Object)theIAEx));
                    }
                    break;
                }
                LOGGER.fine("Invalid SIMS request");
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                break;
            }
            case GET_PRODUCT_DEPENDENTS: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                if (SystemProduct.class.isInstance(theSIMSData)) {
                    SystemProduct theProduct = (SystemProduct)theSIMSData;
                    try {
                        Set theProductInstances = this.gSIMSContext.getProductDependents(theProduct);
                        aResp.setFinalResult((Object)theProductInstances);
                    }
                    catch (SIMSException theSIMSEx) {
                        aResp.setException((Exception)((Object)theSIMSEx));
                    }
                    break;
                }
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                break;
            }
            case GET_ALL_PACKAGES: {
                try {
                    Set theRegisteredPkgs = this.gSIMSContext.getAllPackages();
                    aResp.setFinalResult((Object)theRegisteredPkgs);
                }
                catch (SIMSException theSIMSEx) {
                    aResp.setException((Exception)((Object)theSIMSEx));
                }
                catch (InvalidArgumentException theIAEx) {
                    aResp.setException((Exception)((Object)theIAEx));
                }
                break;
            }
            case GET_ALL_PRODUCTS: {
                try {
                    Set theRegisteredProds = this.gSIMSContext.getAllProducts();
                    aResp.setFinalResult((Object)theRegisteredProds);
                }
                catch (SIMSException theSIMSEx) {
                    aResp.setException((Exception)((Object)theSIMSEx));
                }
                catch (InvalidArgumentException theIAEx) {
                    aResp.setException((Exception)((Object)theIAEx));
                }
                break;
            }
            case GET_ATTRIBUTES: {
                break;
            }
            case INITIALIZE: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                try {
                    ProgressListener theListener = null;
                    if (theSIMSData != null) {
                        if (!ProgressListener.class.isInstance(theSIMSData)) {
                            aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                            break;
                        }
                        theListener = (ProgressListener)theSIMSData;
                    }
                    this.gSIMSContext.initialize(theListener);
                }
                catch (SIMSException theSIMSEx) {
                    aResp.setException((Exception)((Object)theSIMSEx));
                }
                break;
            }
            case DETECT_LEGACY: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                try {
                    LegacyMap theLegMap = null;
                    if (theSIMSData != null) {
                        if (!LegacyMap.class.isInstance(theSIMSData)) {
                            aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                            break;
                        }
                        theLegMap = (LegacyMap)theSIMSData;
                        File theInstallHome = SimsUtils.getFinalAltRoot((String)this.gSIMSContext.getAlternateRoot(), (String)this.gSIMSContext.getDomain());
                        LegacyDetector theLegacyDetector = new LegacyDetector(theLegMap.getLegacyProduct(), theLegMap.getKeyFiles(), theLegMap.getRegistryEntryMap(), theInstallHome.getAbsolutePath());
                        try {
                            aResp.setFinalResult((Object)theLegacyDetector.getDetectionResult());
                        }
                        catch (EnhancedException theEEx) {
                            aResp.setException((Exception)((Object)theEEx));
                        }
                        break;
                    }
                    aResp.setException((Exception)((Object)new SIMSException("INVALID_REQUEST_DATA", new String[]{"request=" + aReq})));
                }
                catch (EnhancedException theEEx) {
                    aResp.setException((Exception)((Object)theEEx));
                }
                break;
            }
            case REGISTER_ALL_LEGACY: {
                Object theSIMSData = ((SIMSControl)aReq.getData()).getData();
                if (SystemProduct.class.isInstance(theSIMSData)) {
                    SystemProduct theLegacyProduct = (SystemProduct)theSIMSData;
                    try {
                        LOGGER.fine("@ About to register legacy product and all its contained products/packages");
                        this.gSIMSContext.registerAll(true, theLegacyProduct, null);
                    }
                    catch (SIMSException theSIMSEx) {
                        aResp.setException((Exception)((Object)theSIMSEx));
                    }
                    break;
                }
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                aResp.setFinalResult(null);
                break;
            }
            default: {
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq})));
                aResp.setFinalResult(null);
            }
        }
    }

    public String getName() {
        return "svc://general/sims";
    }
}

