/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.NoSuchMemberException;
import org.openinstaller.provider.dependency.DependencyControl;
import org.openinstaller.provider.platform.PlatformCommand;
import org.openinstaller.provider.system.SystemResources;
import org.openinstaller.provider.system.util.SystemUtils;
import org.openinstaller.provider.task.TaskControl;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Msg;
import org.openinstaller.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemResourceManager {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    private SystemResourceManager() {
    }

    public static Map<String, String> getSystemResourceStatus() throws EnhancedException {
        List<SystemResources> theRequiredResources = SystemResourceManager.getRequiredResources();
        List<SystemResources> theAvailableResources = SystemResourceManager.getAvailableResources(theRequiredResources);
        if (theAvailableResources.isEmpty()) {
            LOGGER.log(Level.INFO, "MISSING_AVAILABLE_SYSTEM_RESOURCES_INFO");
            return SystemResourceManager.unknownResourceStatus();
        }
        if (theRequiredResources.isEmpty()) {
            LOGGER.log(Level.INFO, "MISSING_REQUIRED_SYSTEM_RESOURCES_INFO");
            return SystemResourceManager.unknownResourceStatus();
        }
        return SystemResourceManager.compareResources(theAvailableResources, theRequiredResources);
    }

    public static Map<String, String> compareResources(List<SystemResources> aAvailableResources, List<SystemResources> aRequiredResources) throws EnhancedException {
        Object theAvailableResValue = null;
        Object theRequiredResValue = null;
        double PERCENT = 0.05;
        HashMap<String, String> theResourceStatus = new HashMap<String, String>();
        for (SystemResources theRequiredRes : aRequiredResources) {
            SystemResources.ResourceType theResType = theRequiredRes.getResourceType();
            theRequiredResValue = theRequiredRes.getResourceValue();
            theAvailableResValue = null;
            for (SystemResources theAvailableRes : aAvailableResources) {
                if (!theAvailableRes.getResourceType().equals((Object)theResType)) continue;
                theAvailableResValue = theAvailableRes.getResourceValue();
                break;
            }
            if (null == theRequiredResValue || null == theAvailableResValue) {
                LOGGER.finest("Do not have available value for required resource " + theRequiredRes.getResourceType().toString());
                theResourceStatus.put(Msg.get((String)theResType.name(), (Object[])new Object[0]), Msg.get((String)"na", (Object[])new Object[0]));
                continue;
            }
            switch (theResType) {
                case DISK: 
                case CPU: 
                case RAM: 
                case SWAP: 
                case TOTAL_MEMORY: {
                    long theReqValue = (Long)theRequiredResValue;
                    long theAvailValue = (Long)theAvailableResValue;
                    if (theResType.equals((Object)SystemResources.ResourceType.DISK)) {
                        long theAcceptableValue = theReqValue + 10L;
                        LOGGER.log(Level.FINER, theResType.getKey() + " -> " + "Avail=" + theAvailValue + " Req=" + theReqValue + " Accept=" + theAcceptableValue);
                        if (theAvailValue >= theAcceptableValue) {
                            theResourceStatus.put(Msg.get((String)theResType.name(), (Object[])new Object[0]), Msg.get((String)"ok_values", (Object[])new Object[]{SystemResourceManager.getDisplayStringForAmount(theResType, theAvailValue)}));
                            break;
                        }
                        LOGGER.log(Level.WARNING, "LOW_DISK_SPACE", new String[]{"required=" + theReqValue, "available=" + theAvailValue});
                        theResourceStatus.put(Msg.get((String)theResType.name(), (Object[])new Object[0]), Msg.get((String)"low_values", (Object[])new Object[]{SystemResourceManager.getDisplayStringForAmount(theResType, theReqValue), SystemResourceManager.getDisplayStringForAmount(theResType, theAvailValue)}));
                        break;
                    }
                    long theAcceptableValue = Math.round((double)theReqValue - (double)theReqValue * 0.05);
                    LOGGER.log(Level.FINER, theResType.getKey() + " -> " + "Avail=" + theAvailValue + " Req=" + theReqValue + " Accept=" + theAcceptableValue);
                    if (theAvailValue >= theAcceptableValue) {
                        theResourceStatus.put(Msg.get((String)theResType.name(), (Object[])new Object[0]), Msg.get((String)"ok_values", (Object[])new Object[]{SystemResourceManager.getDisplayStringForAmount(theResType, theAvailValue)}));
                        break;
                    }
                    theResourceStatus.put(Msg.get((String)theResType.name(), (Object[])new Object[0]), Msg.get((String)"low_values", (Object[])new Object[]{SystemResourceManager.getDisplayStringForAmount(theResType, theReqValue), SystemResourceManager.getDisplayStringForAmount(theResType, theAvailValue)}));
                    break;
                }
                case INSTALL_REQ_PATCHES: {
                    HashSet<String> theMissingPatchesForInstall = new HashSet<String>();
                    List theReqPatchList = (List)theRequiredResValue;
                    List theAvailPatchList = (List)theAvailableResValue;
                    for (String theReqPatch : theReqPatchList) {
                        if (theAvailPatchList.contains(theReqPatch)) continue;
                        theMissingPatchesForInstall.add(theReqPatch);
                    }
                    if (theMissingPatchesForInstall.size() > 0) {
                        StringBuffer theList = new StringBuffer();
                        for (String thePatchID : theMissingPatchesForInstall) {
                            theList.append(thePatchID);
                            theList.append("  ");
                        }
                        if (theMissingPatchesForInstall.size() > 1) {
                            theResourceStatus.put(Msg.get((String)theResType.name(), (Object[])new Object[0]), Msg.get((String)"missing_patches", (Object[])new Object[0]) + theList);
                            break;
                        }
                        theResourceStatus.put(Msg.get((String)theResType.name(), (Object[])new Object[0]), Msg.get((String)"missing_patch", (Object[])new Object[0]) + theList);
                        break;
                    }
                    theResourceStatus.put(Msg.get((String)theResType.name(), (Object[])new Object[0]), Msg.get((String)"ok", (Object[])new Object[0]));
                    break;
                }
                case EXECUTION_REQ_PATCHES: {
                    HashSet<String> theMissingPatchesForExec = new HashSet<String>();
                    List theReqPatchList = (List)theRequiredResValue;
                    List theAvailPatchList = (List)theAvailableResValue;
                    for (String theReqPatch : theReqPatchList) {
                        if (theAvailPatchList.contains(theReqPatch)) continue;
                        theMissingPatchesForExec.add(theReqPatch);
                    }
                    if (theMissingPatchesForExec.size() > 0) {
                        StringBuffer theList = new StringBuffer();
                        for (String thePatchID : theMissingPatchesForExec) {
                            theList.append(thePatchID);
                            theList.append("  ");
                        }
                        if (theMissingPatchesForExec.size() > 1) {
                            theResourceStatus.put(Msg.get((String)theResType.name(), (Object[])new Object[0]), Msg.get((String)"missing_patches", (Object[])new Object[0]) + theList);
                            break;
                        }
                        theResourceStatus.put(Msg.get((String)theResType.name(), (Object[])new Object[0]), Msg.get((String)"missing_patch", (Object[])new Object[0]) + theList);
                        break;
                    }
                    theResourceStatus.put(Msg.get((String)theResType.name(), (Object[])new Object[0]), Msg.get((String)"ok", (Object[])new Object[0]));
                }
            }
        }
        return theResourceStatus;
    }

    private static String getDisplayStringForAmount(SystemResources.ResourceType aResType, long aValue) {
        switch (aResType) {
            case CPU: {
                if (aValue >= 1024L) {
                    return Msg.get((String)"ghz", (Object[])new Object[]{(double)aValue / 1024.0});
                }
                return Msg.get((String)"mhz", (Object[])new Object[]{aValue});
            }
            case DISK: 
            case RAM: 
            case SWAP: 
            case TOTAL_MEMORY: {
                if (aValue >= 1024L) {
                    return Msg.get((String)"gb", (Object[])new Object[]{(double)aValue / 1024.0});
                }
                return Msg.get((String)"mb", (Object[])new Object[]{aValue});
            }
            case INSTALL_REQ_PATCHES: 
            case EXECUTION_REQ_PATCHES: {
                throw new RuntimeException("Cannot convert patch ID to long");
            }
        }
        return Long.toString(aValue);
    }

    public static List<SystemResources> getAvailableResources(List<SystemResources> aRequiredResources) {
        ArrayList<SystemResources> theAvailableResources = new ArrayList<SystemResources>();
        String theInstallHome = SystemResourceManager.getInstallHome();
        LOGGER.finest("Retrieving available resources...");
        block9: for (SystemResources theRes : aRequiredResources) {
            switch (theRes.getResourceType()) {
                case SWAP: {
                    LOGGER.finest("Retrieving swap space");
                    theAvailableResources.add(new SystemResources(SystemResources.ResourceType.SWAP, SystemResourceManager.getSystemSwapSpace()));
                    continue block9;
                }
                case CPU: {
                    LOGGER.finest("Retrieving cpu speed");
                    theAvailableResources.add(new SystemResources(SystemResources.ResourceType.CPU, SystemResourceManager.getSystemProcessor()));
                    continue block9;
                }
                case DISK: {
                    LOGGER.finest("Retrieving disk space");
                    theAvailableResources.add(new SystemResources(SystemResources.ResourceType.DISK, SystemResourceManager.getUsableDiskSpace(theInstallHome)));
                    continue block9;
                }
                case EXECUTION_REQ_PATCHES: {
                    LOGGER.fine("Skipping retrieval of execution required patches");
                    continue block9;
                }
                case INSTALL_REQ_PATCHES: {
                    LOGGER.finest("Retrieving required patches");
                    theAvailableResources.add(new SystemResources(SystemResources.ResourceType.INSTALL_REQ_PATCHES, SystemResourceManager.getInstalledPatches()));
                    continue block9;
                }
                case RAM: {
                    LOGGER.finest("Retrieving ram");
                    theAvailableResources.add(new SystemResources(SystemResources.ResourceType.RAM, SystemResourceManager.getSystemMemory()));
                    continue block9;
                }
                case TOTAL_MEMORY: {
                    LOGGER.finest("Retrieving total memory");
                    theAvailableResources.add(new SystemResources(SystemResources.ResourceType.TOTAL_MEMORY, SystemResourceManager.getSystemTotalMemory()));
                    continue block9;
                }
            }
            LOGGER.log(Level.WARNING, "UNEXPECTED_RUNTIME_WARNING", new String[]{"value=" + (Object)((Object)theRes.getResourceType()), "stack=" + Arrays.toString(Thread.currentThread().getStackTrace())});
        }
        LOGGER.finest("Done retrieving available resources...");
        return theAvailableResources;
    }

    public static List<SystemResources> getRequiredResources() {
        ArrayList<SystemResources> theRequiredResources;
        block16: {
            theRequiredResources = new ArrayList<SystemResources>();
            try {
                BusRequest theDPRequest = new BusRequest("DependencyRequest", (Object)new DependencyControl(DependencyControl.COMMAND.GET_REQUIREMENTS, Platform.getCurrentPlatform()));
                BusResponse theDPResponse = ControlBus.getInstance().publishRequest(theDPRequest, "svc://general/Dependency");
                if (null != theDPResponse && null == theDPResponse.getException()) {
                    Object theResult = theDPResponse.getResult();
                    if (null == theResult) {
                        LOGGER.log(Level.INFO, "COULD_NOT_RETRIEVE_REQUIRED_RESOURCES");
                        return theRequiredResources;
                    }
                    Map theReqMap = (Map)theResult;
                    Set theReqSet = theReqMap.entrySet();
                    block11: for (Map.Entry theReqEntry : theReqSet) {
                        for (SystemResources.ResourceType theResType : SystemResources.ResourceType.values()) {
                            if (!theResType.getKey().equals(theReqEntry.getKey())) continue;
                            Long theResValue = 0L;
                            List theReqResList = (List)theReqEntry.getValue();
                            List<Long> theReqList = null;
                            switch (theResType) {
                                case DISK: {
                                    theReqList = SystemResourceManager.parseRequirements(theReqResList);
                                    for (Long theDiskVal : theReqList) {
                                        theResValue = theResValue + theDiskVal;
                                    }
                                    LOGGER.log(Level.FINER, "Disk space required=" + theResValue);
                                    theRequiredResources.add(new SystemResources(theResType, theResValue));
                                    break;
                                }
                                case CPU: 
                                case RAM: 
                                case SWAP: 
                                case TOTAL_MEMORY: {
                                    ArrayList theResValueList = new ArrayList();
                                    try {
                                        theReqList = SystemResourceManager.parseRequirements(theReqResList);
                                        LOGGER.log(Level.FINER, "List length=" + theReqList.size());
                                        theResValue = Collections.max(theReqList);
                                    }
                                    catch (NumberFormatException theNFEx) {
                                        LOGGER.log(Level.FINE, "Cannot convert String to Long");
                                    }
                                    catch (ClassCastException theCCEx) {
                                        LOGGER.log(Level.FINE, "Cannot sort the Resource value array");
                                    }
                                    catch (UnsupportedOperationException theUOEx) {
                                        LOGGER.log(Level.FINE, "Operation is not supported on list");
                                    }
                                    theRequiredResources.add(new SystemResources(theResType, theResValue));
                                    break;
                                }
                                case INSTALL_REQ_PATCHES: 
                                case EXECUTION_REQ_PATCHES: {
                                    theRequiredResources.add(new SystemResources(theResType, theReqEntry.getValue()));
                                }
                            }
                            continue block11;
                        }
                    }
                    break block16;
                }
                LOGGER.log(Level.INFO, "COULD_NOT_GET_SYSTEM_REQUIREMENTS");
            }
            catch (EnhancedException theEE) {
                LOGGER.log(Level.FINE, "BUS_REQUEST_FAILED", theEE);
            }
        }
        return theRequiredResources;
    }

    public static Long getSystemTotalMemory() {
        return SystemResourceManager.getSystemMemory() + SystemResourceManager.getSystemSwapSpace();
    }

    public static Long getSystemProcessor() {
        Long theSystemCPU;
        block12: {
            theSystemCPU = 0L;
            BusResponse theResponse = null;
            PlatformCommand theCPUCmd = new PlatformCommand(PlatformCommand.COMMAND.GET_PROCESSOR, null);
            try {
                BusRequest theCPURequest = new BusRequest("Processor Request", (Object)theCPUCmd);
                theResponse = ControlBus.getInstance().publishRequest(theCPURequest, "svc://platform/systeminterface");
            }
            catch (InvalidArgumentException theIAEx) {
                LOGGER.log(Level.FINE, "BUS_REQUEST_FAILED", theIAEx);
            }
            catch (NoSuchMemberException theNSMEx) {
                LOGGER.log(Level.FINE, "BUS_REQUEST_FAILED", theNSMEx);
            }
            catch (EnhancedException theEEx) {
                LOGGER.log(Level.FINE, "CANNOT_GET_CPU_SPEED", theEEx);
            }
            if (null != theResponse && null == theResponse.getException()) {
                Object theResult = theResponse.getResult();
                if (null != theResult) {
                    try {
                        String[] theCPUStr = (String[])theResult;
                        if (theCPUStr.length < 0) {
                            LOGGER.log(Level.FINE, "Could not retrieve CPU info");
                            break block12;
                        }
                        if (theCPUStr.length > 1) {
                            ArrayList<Long> theCPUList = new ArrayList<Long>();
                            for (String theCPU : theCPUStr) {
                                LOGGER.log(Level.FINEST, "CPU Value = " + theCPU);
                                theCPUList.add(new Double(theCPU.trim()).longValue());
                            }
                            theSystemCPU = (Long)Collections.min(theCPUList);
                            break block12;
                        }
                        LOGGER.log(Level.FINEST, "CPU Value = " + theCPUStr[0]);
                        theSystemCPU = new Double(theCPUStr[0].trim()).longValue();
                    }
                    catch (NumberFormatException theNFEx) {
                        LOGGER.log(Level.FINE, "Could not convert CPU String value to Long ", theNFEx);
                    }
                } else {
                    LOGGER.log(Level.FINE, "CPU information is not available");
                }
            }
        }
        return theSystemCPU;
    }

    public static Long getSystemMemory() {
        Long theSystemMemory = 0L;
        BusResponse theResponse = null;
        PlatformCommand theMemCmd = new PlatformCommand(PlatformCommand.COMMAND.GET_PHYSMEM, null);
        try {
            BusRequest theMemRequest = new BusRequest("Memory Request", (Object)theMemCmd);
            theResponse = ControlBus.getInstance().publishRequest(theMemRequest, "svc://platform/systeminterface");
        }
        catch (InvalidArgumentException theIAEx) {
            LOGGER.log(Level.FINE, "BUS_REQUEST_FAILED", theIAEx);
        }
        catch (NoSuchMemberException theNSMEx) {
            LOGGER.log(Level.FINE, "BUS_REQUEST_FAILED", theNSMEx);
        }
        catch (EnhancedException theEEx) {
            LOGGER.log(Level.FINE, "CANNOT_GET_PHY_MEM", theEEx);
        }
        if (null != theResponse && null == theResponse.getException()) {
            Object theResult = theResponse.getResult();
            if (null != theResult) {
                theSystemMemory = (Long)theResult;
            } else {
                LOGGER.fine("Could not retrieve system memory.");
            }
        } else {
            LOGGER.fine("No response received for system memory from SystemInterface");
        }
        return theSystemMemory;
    }

    public static List<String> getInstalledPatches() {
        Object theResult;
        List<String> thePatchList = new ArrayList<String>();
        BusResponse theResponse = null;
        PlatformCommand theMemCmd = new PlatformCommand(PlatformCommand.COMMAND.GET_PATCHLIST, null);
        try {
            BusRequest theMemReq = new BusRequest("OS Patch level Request", (Object)theMemCmd);
            theResponse = ControlBus.getInstance().publishRequest(theMemReq, "svc://platform/systeminterface");
        }
        catch (InvalidArgumentException theIAEx) {
            LOGGER.log(Level.FINE, "BUS_REQUEST_FAILED", theIAEx);
        }
        catch (NoSuchMemberException theNSMEx) {
            LOGGER.log(Level.FINE, "BUS_REQUEST_FAILED", theNSMEx);
        }
        catch (EnhancedException theEEx) {
            LOGGER.log(Level.FINE, "CANNOT_GET_INSTALLED_PATCHES", theEEx);
        }
        if (null != theResponse && null == theResponse.getException() && null != (theResult = theResponse.getResult())) {
            thePatchList = (List)theResult;
        }
        return thePatchList;
    }

    public static Long getSystemSwapSpace() {
        Object theResult;
        Long theSystemSwapSpace = 0L;
        BusResponse theResponse = null;
        PlatformCommand theSwapCmd = new PlatformCommand(PlatformCommand.COMMAND.GET_SWAP_SPACE, null);
        try {
            BusRequest theSwapReq = new BusRequest("SwapSpace Request", (Object)theSwapCmd);
            theResponse = ControlBus.getInstance().publishRequest(theSwapReq, "svc://platform/systeminterface");
        }
        catch (InvalidArgumentException theIAEx) {
            LOGGER.log(Level.FINE, "BUS_REQUEST_FAILED", theIAEx);
        }
        catch (NoSuchMemberException theNSMEx) {
            LOGGER.log(Level.FINE, "BUS_REQUEST_FAILED", theNSMEx);
        }
        catch (EnhancedException theEEx) {
            LOGGER.log(Level.FINE, "CANNOT_GET_SWAP_SPACE", theEEx);
        }
        if (null != theResponse && null == theResponse.getException() && null != (theResult = theResponse.getResult())) {
            theSystemSwapSpace = (Long)theResult;
        }
        return theSystemSwapSpace;
    }

    public static long getUsableDiskSpace(String aPath) {
        Object theResult;
        Long theUsableSpace = 0L;
        BusResponse theResponse = null;
        PlatformCommand theDiskSpaceCmd = new PlatformCommand(PlatformCommand.COMMAND.GET_USABLE_SPACE, aPath);
        try {
            BusRequest theDiskSpaceReq = new BusRequest("Usable Space Request", (Object)theDiskSpaceCmd);
            theResponse = ControlBus.getInstance().publishRequest(theDiskSpaceReq, "svc://platform/systeminterface");
        }
        catch (InvalidArgumentException theIAEx) {
            LOGGER.log(Level.FINE, "BUS_REQUEST_FAILED", theIAEx);
        }
        catch (NoSuchMemberException theNSMEx) {
            LOGGER.log(Level.FINE, "BUS_REQUEST_FAILED", theNSMEx);
        }
        catch (EnhancedException theEEx) {
            LOGGER.log(Level.FINE, "CANNOT_GET_USABLE_SPACE", theEEx);
        }
        if (null != theResponse && null == theResponse.getException() && null != (theResult = theResponse.getResult())) {
            theUsableSpace = (Long)theResult;
        }
        LOGGER.log(Level.FINE, "Usable Disk Space = [" + theUsableSpace + "] kilo bytes");
        return Math.round(theUsableSpace / 1024L);
    }

    private static String getInstallHome() {
        String theInstallHome = "";
        try {
            BusRequest theRequest = new BusRequest("TaskRequest", (Object)new TaskControl(TaskControl.TaskCommand.GET_INSTALL_HOME, null));
            BusResponse theResponse = ControlBus.getInstance().publishRequest(theRequest, "svc://general/task");
            if (null != theResponse && null == theResponse.getException()) {
                theInstallHome = (String)theResponse.getResult();
            }
        }
        catch (NoSuchMemberException theNSMEx) {
            LOGGER.log(Level.WARNING, "CANNOT_GET_ALT_ROOT", theNSMEx.getMessage());
        }
        catch (EnhancedException theEEx) {
            LOGGER.log(Level.WARNING, "CANNOT_GET_INSTALL_LOC");
        }
        return theInstallHome;
    }

    public static Map<String, String> unknownResourceStatus() {
        HashMap<String, String> theUnknownStatusMap = new HashMap<String, String>();
        for (SystemResources.ResourceType theResType : SystemResources.ResourceType.values()) {
            theUnknownStatusMap.put(Msg.get((String)theResType.name(), (Object[])new Object[0]), Msg.get((String)"na", (Object[])new Object[0]));
        }
        return theUnknownStatusMap;
    }

    public static List<Long> parseRequirements(List<String> aRawList) {
        ArrayList<Long> theParsedValues = new ArrayList<Long>();
        for (String theRawValue : aRawList) {
            theParsedValues.add(SystemUtils.parseSystemProperties(theRawValue));
        }
        return theParsedValues;
    }
}

