/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.system.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openinstaller.util.ClassUtils;

public class SystemUtils {
    private static List<Pattern> gPatternList = new ArrayList<Pattern>();
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    private SystemUtils() {
    }

    public static Long parseSystemProperties(String aRawValue) {
        Long theParsedValue = 0L;
        Pattern theOnlyDigitPat = Pattern.compile("[\\d\\.]+");
        Matcher theDigitMatcher = theOnlyDigitPat.matcher(aRawValue);
        if (theDigitMatcher.matches()) {
            return Long.parseLong(theDigitMatcher.group());
        }
        try {
            gPatternList.add(Pattern.compile("mhz$", 2));
            gPatternList.add(Pattern.compile("ghz$", 2));
            gPatternList.add(Pattern.compile("gb$", 2));
            gPatternList.add(Pattern.compile("mb$", 2));
            for (Pattern thePattern : gPatternList) {
                Matcher theMatcher = thePattern.matcher(aRawValue);
                if (!theMatcher.find()) continue;
                String theValueStr = aRawValue.substring(0, theMatcher.start());
                if (aRawValue.substring(theMatcher.start(), theMatcher.end()).equalsIgnoreCase("ghz")) {
                    theParsedValue = Long.parseLong(theValueStr) * 1000L;
                    continue;
                }
                if (aRawValue.substring(theMatcher.start(), theMatcher.end()).equalsIgnoreCase("gb")) {
                    theParsedValue = Long.parseLong(theValueStr) * 1024L;
                    continue;
                }
                theParsedValue = Long.parseLong(theValueStr);
            }
        }
        catch (PatternSyntaxException thePSEx) {
            LOGGER.log(Level.FINE, "Error compiling a pattern", thePSEx);
        }
        catch (NumberFormatException theNFEx) {
            LOGGER.log(Level.FINE, "Cannot convert string to long", theNFEx);
        }
        return theParsedValue;
    }
}

