/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.task;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.NoSuchMemberException;
import org.openinstaller.provider.conf.ConfigControl;
import org.openinstaller.provider.conf.ResultReport;
import org.openinstaller.provider.task.Task;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.InvalidArgumentException;

public final class InstallImageConfigTask
extends Task {
    private final String gComponentName;
    private ResultReport gResultReport;
    private Throwable gException;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public boolean perform(ProgressListener aListener) {
        LOGGER.finest(ClassUtils.getClassName() + ".perform() creating INSTALL_IMAGE_CONFIG request");
        ConfigControl theConfigCtrl = new ConfigControl(ConfigControl.ConfigCommand.INSTALL_IMAGE_CONFIG, this.gComponentName);
        try {
            BusResponse theConfigResp = ControlBus.getInstance().publishRequest(new BusRequest("Install Image Configuration request", (Object)theConfigCtrl), "svc://general/conf");
            this.setConfigReport((ResultReport)theConfigResp.getResult());
            this.gException = theConfigResp.getException();
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.WARNING, "BUS_REQUEST_FAILED", theEIAEx);
            this.gException = theEIAEx;
            return false;
        }
        catch (NoSuchMemberException theNSMEx) {
            LOGGER.log(Level.WARNING, "CANNOT_PERFORM_INSTALL_IMAGE_CONFIGURE_TASK", theNSMEx);
            this.gException = theNSMEx;
            return false;
        }
        return true;
    }

    public void setConfigReport(ResultReport aResultReport) {
        this.gResultReport = aResultReport;
    }

    public ResultReport getConfigReport() {
        return this.gResultReport;
    }

    public InstallImageConfigTask(String aComponentName) {
        this.gComponentName = aComponentName;
    }

    public Throwable getException() {
        return this.gException;
    }
}

