/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.task;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.NoSuchMemberException;
import org.openinstaller.core.EngineConfigCommand;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.pkg.MSIPackageUtils;
import org.openinstaller.pkg.PackageException;
import org.openinstaller.pkg.RPMPackageUtils;
import org.openinstaller.pkg.SVR4PackageUtils;
import org.openinstaller.pkg.ZIPPackageUtils;
import org.openinstaller.provider.task.Task;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.sims.backends.rpm.RPMUtils;
import org.openinstaller.sims.util.SimsUtils;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstallTask
extends Task {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private final Package gPackage;
    private final String gProdName;
    private final Platform gPlatform;
    private final Map<String, String> gParams;

    @Override
    boolean perform(ProgressListener aListener) {
        String theInstallHome;
        URL theSrcURL;
        String thePkgFormat;
        boolean theCurrZoneOnly = false;
        try {
            thePkgFormat = InstallTask.getPackageFormat();
        }
        catch (EnhancedException aException) {
            LOGGER.log(Level.SEVERE, "CANNOT_DETERMINE_PACKAGEFORMAT", "os=" + this.gPlatform.toString());
            return false;
        }
        String thePkgName = this.gPackage.getName();
        String theAltRootPath = null;
        try {
            theSrcURL = InstallTask.getContentPath(this.gPackage, this.gPlatform);
        }
        catch (EnhancedException theEx) {
            LOGGER.log(Level.SEVERE, "CANNOT_FIND_SRC_PKG", new Object[]{"pkg=" + this.gPackage.getName(), "platform=" + this.gPlatform.toString()});
            return false;
        }
        if (theSrcURL == null) {
            LOGGER.log(Level.SEVERE, "CANNOT_FIND_SRC_PKG", new Object[]{"pkg=" + this.gPackage.getName(), "platform=" + this.gPlatform.toString()});
            return false;
        }
        try {
            theInstallHome = InstallTask.getInstallLocation();
        }
        catch (EnhancedException theEx) {
            LOGGER.log(Level.SEVERE, "CANNOT_DETERMINE_INSTALL_HOME");
            return false;
        }
        if (theInstallHome == null) {
            LOGGER.log(Level.SEVERE, "CANNOT_DETERMINE_INSTALL_HOME");
            return false;
        }
        String theDomain = InstallTask.getDomain();
        try {
            BusRequest theReq = new BusRequest("ConfigRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.ALTERNATE_ROOT));
            BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
            Object theAltRootObj = theResp.getResult();
            if (theAltRootObj != null) {
                theAltRootPath = (String)theAltRootObj;
            }
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.SEVERE, "BUS_REQUEST_FAILED", theEIAEx);
            return false;
        }
        catch (NoSuchMemberException theEx) {
            LOGGER.log(Level.SEVERE, "CANNOT_DETERMINE_ALT_ROOT");
            return false;
        }
        String theAltRoot = theAltRootPath == null || theInstallHome == null ? (theAltRootPath == null && theInstallHome != null ? theInstallHome : theAltRootPath) : theAltRootPath + File.separator + theInstallHome;
        if (thePkgFormat.equalsIgnoreCase("svr4")) {
            try {
                if (InstallTask.isDryRun()) {
                    LOGGER.log(Level.FINE, "DRY_RUN_MODE", new String[]{"URL=" + theSrcURL.toExternalForm(), "pkg=" + thePkgName, "domain=" + theDomain, "root=" + theAltRoot, "dir=" + theInstallHome});
                }
                SVR4PackageUtils.installPkg((URL)theSrcURL, (String)thePkgName, (String)theDomain, (String)theAltRoot, this.gParams, (boolean)false);
            }
            catch (PackageException thePEx) {
                thePEx.addContext("CANT_PERFORM_INSTALL_TASK", new String[]{"package=" + thePkgName});
                LOGGER.log(Level.SEVERE, "CANT_INSTALL_PACKAGE", thePEx);
                return false;
            }
        } else if (thePkgFormat.equalsIgnoreCase("rpm")) {
            try {
                this.gPackage.setID(RPMUtils.getRpmName((String)thePkgName, (URL)theSrcURL));
                RPMPackageUtils.installPkg((URL)theSrcURL, (String)this.gProdName, (String)theAltRootPath, (String)theDomain, (File)SimsUtils.getFinalAltRoot((String)theAltRootPath, (String)theDomain), this.gParams, (boolean)InstallTask.isDryRun());
            }
            catch (PackageException thePEx) {
                thePEx.addContext("CANT_PERFORM_INSTALL_TASK", new String[]{"package=" + thePkgName});
                LOGGER.log(Level.SEVERE, "CANT_INSTALL_PACKAGE", thePEx);
                return false;
            }
            catch (EnhancedException theEx) {
                theEx.addContext("CANT_PERFORM_INSTALL_TASK", new String[]{"package=" + thePkgName});
                LOGGER.log(Level.SEVERE, "CANT_INSTALL_PACKAGE", theEx);
                return false;
            }
        } else if (thePkgFormat.equalsIgnoreCase("msi")) {
            try {
                File theMSIPath = new File(theSrcURL.getFile());
                MSIPackageUtils.installPkg((File)theMSIPath, (String)this.gPackage.getName(), (String)theInstallHome);
            }
            catch (PackageException thePEx) {
                LOGGER.log(Level.SEVERE, "CANT_INSTALL_MSI", thePEx);
                return false;
            }
        } else if (thePkgFormat.equalsIgnoreCase("zip")) {
            if (InstallTask.isDryRun()) {
                LOGGER.log(Level.FINE, "DRY_RUN_MODE", new String[]{"URL=" + theSrcURL.toExternalForm(), "pkg=" + thePkgName, "domain=" + theDomain, "root=" + theAltRoot, "dir=" + theInstallHome});
            } else {
                try {
                    File theZIPPath = new File(theSrcURL.getFile());
                    ZIPPackageUtils.installPkg((File)theZIPPath, (String)this.gPackage.getName(), (String)theInstallHome, (ProgressListener)aListener);
                }
                catch (PackageException thePEx) {
                    LOGGER.log(Level.SEVERE, "CANT_INSTALL_ZIP", thePEx);
                    return false;
                }
            }
        } else {
            if (thePkgFormat.equalsIgnoreCase("depot")) {
                return false;
            }
            LOGGER.log(Level.SEVERE, "UNKNOWN_PACKAGE_TYPE", "type=" + thePkgFormat);
            return false;
        }
        return true;
    }

    public InstallTask(Package aPackage, String aProdName, Map<String, String> aParams, Platform aTargetPlatform) {
        this.gParams = aParams;
        this.gPackage = aPackage;
        this.gProdName = aProdName;
        this.gPlatform = aTargetPlatform;
    }
}

