/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.task;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.NoSuchMemberException;
import org.openinstaller.core.EngineConfigCommand;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.sims.SIMSControl;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Platform;

abstract class Task {
    private static final Logger LOGGER;
    private static boolean gDryRun;
    static final String INSTALLHOME_DATAPATH = "InstallHome.directory.INSTALL_HOME";

    Task() {
    }

    abstract boolean perform(ProgressListener var1);

    public static URL getContentPath(Package aMediaPackage, Platform aPlatform) throws EnhancedException {
        BusResponse theResp;
        BusRequest theReq = new BusRequest("ConfigRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.INSTALLABLE_UNIT_PATH));
        try {
            theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
        }
        catch (NoSuchMemberException theNSEx) {
            LOGGER.log(Level.SEVERE, "CANT_GET_CONTENT_PATH");
            throw theNSEx;
        }
        Object theResult = theResp.getResult();
        if (theResult == null) {
            throw new EnhancedException("CANT_GET_CONTENT_PATH", new String[0]);
        }
        String theURLPathString = (String)theResult;
        for (String theURL : theURLPathString.split(",")) {
            ArrayList<URL> theSearchURLs = new ArrayList<URL>();
            try {
                URL theInstallUnitURL = new URL(theURL + "/");
                URL theTypePath = new URL(theInstallUnitURL, aPlatform.retrievePlatformType().getValue().toUpperCase() + "/");
                URL theNamePath = new URL(theTypePath, aPlatform.retrievePlatformName().getValue().toUpperCase() + "/");
                URL theArchPath = new URL(theNamePath, aPlatform.retrievePlatformArch().getValue().toUpperCase() + "/");
                URL theVerPath = new URL(theArchPath, aPlatform.retrievePlatformVersion().getLow().toString().toUpperCase() + "/");
                URL theVerFile = new URL(new URL(theVerPath, "Packages/"), aMediaPackage.getName());
                theSearchURLs.add(theVerFile);
                URL theArchFile = new URL(new URL(theArchPath, "Packages/"), aMediaPackage.getName());
                theSearchURLs.add(theArchFile);
                URL theNameFile = new URL(new URL(theNamePath, "Packages/"), aMediaPackage.getName());
                theSearchURLs.add(theNameFile);
                URL theTypeFile = new URL(new URL(theTypePath, "Packages/"), aMediaPackage.getName());
                theSearchURLs.add(theTypeFile);
                URL theIndFile = new URL(new URL(theInstallUnitURL, "Packages/"), aMediaPackage.getName());
                theSearchURLs.add(theIndFile);
                for (URL theSearchURL : theSearchURLs) {
                    try {
                        InputStream theConn = theSearchURL.openStream();
                        if (theConn == null) continue;
                        theConn.close();
                        return theSearchURL;
                    }
                    catch (IOException theEx) {
                        LOGGER.log(Level.FINE, "Cannot locate package " + aMediaPackage + " at " + theSearchURL + ": " + theEx.getMessage());
                    }
                }
            }
            catch (MalformedURLException theMUEx) {
                LOGGER.log(Level.SEVERE, "CANNOT_FORM_MEDIA_URL", theMUEx);
                throw new EnhancedException("CANNOT_FORM_MEDIA_URL", (Throwable)theMUEx, new String[]{"path=" + theURL});
            }
        }
        LOGGER.log(Level.WARNING, "CANNOT_FIND_PKG", new Object[]{"package=" + aMediaPackage.getName(), "platform=" + aPlatform.toString() + "search-path=" + theURLPathString});
        return null;
    }

    public static String getPackageFormat() throws EnhancedException {
        BusRequest theReq = new BusRequest("ModeRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.PKG_FORMAT));
        BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
        return theResp.getResult().toString();
    }

    public static String getDomain() {
        String theDomain = null;
        try {
            SIMSControl theSimsCmd = new SIMSControl(SIMSControl.SIMSCommand.GET_DOMAIN, null);
            BusResponse theResp = ControlBus.getInstance().publishRequest(new BusRequest("SIMSRequest", (Object)theSimsCmd), "svc://general/sims");
            theDomain = (String)theResp.getResult();
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.WARNING, "BUS_REQUEST_FAILED", theEIAEx);
        }
        catch (NoSuchMemberException theNSEx) {
            LOGGER.log(Level.WARNING, "CANT_GET_SIMS_DOMAIN");
        }
        return theDomain;
    }

    public static String getInstallLocation() throws EnhancedException {
        String theInstallHome = (String)ConfigHelper.getValue(INSTALLHOME_DATAPATH);
        if (theInstallHome != null && "".equals(theInstallHome)) {
            File theInstallHomeDir = new File(theInstallHome);
            if (theInstallHomeDir.exists() && theInstallHomeDir.isDirectory()) {
                if (!theInstallHomeDir.canWrite()) {
                    throw new EnhancedException("INSTALL_HOME_NOT_WRITEABLE", new String[]{"install-home=", theInstallHome});
                }
            } else if (!theInstallHomeDir.mkdirs()) {
                throw new EnhancedException("CANNOT_CREATE_INSTALLHOME_DIRECTORY", new String[]{"install-home=", theInstallHome});
            }
        }
        return theInstallHome;
    }

    public static void setDryRun(boolean aMode) {
        gDryRun = aMode;
    }

    public static boolean isDryRun() {
        return gDryRun;
    }

    public static String getInstallPath() {
        StringBuilder theInstallPath = new StringBuilder();
        String theInstallHome = "";
        try {
            theInstallHome = Task.getInstallLocation();
            BusRequest theReq = new BusRequest("ConfigRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.ALTERNATE_ROOT));
            BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
            Object theAltRootObj = theResp.getResult();
            if (theAltRootObj != null) {
                theInstallPath.append(theAltRootObj);
            }
        }
        catch (NoSuchMemberException theNSMEx) {
            LOGGER.log(Level.WARNING, "CANNOT_GET_ALT_ROOT", theNSMEx);
        }
        catch (EnhancedException theEEx) {
            LOGGER.log(Level.WARNING, "CANNOT_GET_INSTALL_LOC", theEEx);
        }
        if ("".equals(theInstallPath.toString())) {
            theInstallPath = new StringBuilder(theInstallHome);
        } else {
            theInstallPath.append(File.separator);
            theInstallPath.append(theInstallHome);
        }
        return theInstallPath.toString();
    }

    static {
        gDryRun = false;
        LOGGER = Logger.getLogger(ClassUtils.getClassName());
    }
}

