/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.task;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.operation.Operation;
import org.openinstaller.provider.operation.OpsControl;
import org.openinstaller.provider.operation.ProductMap;
import org.openinstaller.provider.task.Task;
import org.openinstaller.provider.task.TaskControl;
import org.openinstaller.provider.task.TaskDriver;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskProvider
implements ServiceProvider {
    public static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private TaskDriver gTaskDriver;

    public void init(ControlBus aBus) {
        this.gTaskDriver = new TaskDriver();
    }

    public void shutdown() {
    }

    public void receiveEvent(ControlBus aBus, BusEvent aEvent) {
    }

    public void receiveRequest(ControlBus aBus, BusRequest aReq, BusResponse aResp) {
        if (!TaskControl.class.isInstance(aReq.getData())) {
            aResp.setException((Exception)((Object)new EnhancedException("INVALID_TASK", new String[]{"task=" + aReq})));
            return;
        }
        switch (((TaskControl)aReq.getData()).getCommand()) {
            case EXECUTE: {
                try {
                    List<Operation> theOpList = this.setupOperations();
                    this.gTaskDriver.initialize(theOpList, aResp);
                    this.gTaskDriver.executeTask();
                }
                catch (EnhancedException theEEx) {
                    LOGGER.log(Level.SEVERE, "CANT_PERFORM_TASK", theEEx.getMessage());
                    aResp.setException((Exception)((Object)theEEx));
                }
                break;
            }
            case GET_INSTALL_HOME: {
                aResp.setFinalResult((Object)Task.getInstallPath());
                break;
            }
            case GET_SUMMARY: {
                aResp.setFinalResult(this.gTaskDriver.getSummary());
                break;
            }
            case GET_SUMMARY_FILE: {
                aResp.setFinalResult((Object)this.gTaskDriver.getSummaryFile());
                break;
            }
            case GET_LOG_FILE: {
                aResp.setFinalResult((Object)this.gTaskDriver.getLogFile());
                break;
            }
            default: {
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_TASK", new String[]{"request=" + aReq})));
                aResp.setFinalResult(null);
            }
        }
    }

    private List<Operation> setupOperations() throws EnhancedException {
        OpsControl theOpsCmd;
        String INSTALLHOME_DATAPATH = "InstallHome.directory.INSTALL_HOME";
        String theInstallHome = (String)ConfigHelper.getValue("InstallHome.directory.INSTALL_HOME");
        ControlBus theBus = ControlBus.getInstance();
        BusResponse theBR = theBus.publishRequest(new BusRequest("OperationRequest", (Object)(theOpsCmd = new OpsControl(OpsControl.OpsCommand.GET_PRODUCT_MAP, theInstallHome))), "svc://general/operation");
        if (theBR == null) {
            throw new EnhancedException("CANNOT_CREATE_PRODUCT_MAP", new String[0]);
        }
        if (theBR.getException() != null) {
            throw new EnhancedException("CANNOT_CREATE_PRODUCT_MAP", (Throwable)theBR.getException(), new String[0]);
        }
        ProductMap theProdMap = (ProductMap)theBR.getResult();
        Operation.OPTYPE theOp = theProdMap.getOperation();
        LOGGER.finest("Task Provider Operation = " + theOp.toString());
        OpsControl theOpsCtrl = new OpsControl(OpsControl.OpsCommand.PERFORM, theProdMap);
        theBR = theBus.publishRequest(new BusRequest("OperationRequest", (Object)theOpsCtrl), "svc://general/operation");
        List theOps = (List)theBR.getResult();
        if (theOps.size() == 0) {
            LOGGER.log(Level.WARNING, "NO_OPERATIONS_TO_EXECUTE");
        } else {
            LOGGER.log(Level.FINE, "OPERATIONS_FOUND");
        }
        return theOps;
    }

    public String getName() {
        return "svc://general/task";
    }
}

