/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.custom;

import charvax.swing.JTextArea;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.openinstaller.util.ClassUtils;

public class ChaxHTMLPanel
extends JTextArea {
    public static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static final int COLUMN_GAP = 3;
    private int[] gColWidth = null;

    public ChaxHTMLPanel() {
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    public ChaxHTMLPanel(String aStr) {
        this();
        this.setText(aStr);
    }

    public final synchronized void setText(String aText) {
        this._document = new StringBuffer(this.convertHtml2Ascii(aText));
        String theText = this.getText();
        int theRows = 0;
        char[] theChars = theText.toCharArray();
        for (int theLoopVariable = 0; theLoopVariable < theChars.length; ++theLoopVariable) {
            if (theChars[theLoopVariable] != '\n') continue;
            ++theRows;
        }
        this.setRows(theRows + 2);
    }

    protected void calculateColumnWidth() {
        float theRatioNumber = (float)(this.getColumns() - (this.gColumnCount - 1) * 3) / (float)this.gTotalWidth;
        this.gColWidth = new int[this.gColumnCount];
        for (int aCol = 0; aCol < this.gColumnCount; ++aCol) {
            this.gColWidth[aCol] = Math.round((float)Integer.parseInt((String)this.gTableData.get(String.valueOf(aCol))) * theRatioNumber);
        }
    }

    protected void arrangeText() {
        String theHTMLContent = this.getText().trim();
        String theResult = "";
        StringReader theReader = new StringReader(theHTMLContent);
        try {
            while (theHTMLContent.length() != 0) {
                theResult = theResult + theHTMLContent.substring(0, theHTMLContent.indexOf("<TABLE>")) + "\n\n";
                theReader = new StringReader(theHTMLContent.substring(theHTMLContent.indexOf("<TABLE>") + 7, theHTMLContent.indexOf("</TABLE>")));
                theHTMLContent = theHTMLContent.substring(theHTMLContent.indexOf("</TABLE>") + 8, theHTMLContent.length());
                HTMLHandler theHandler = new HTMLHandler();
                try {
                    new ParserDelegator().parse(theReader, theHandler, true);
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, "Could not parse the HTML content", ioe);
                }
                theResult = theResult + theHandler.getBuffer().trim().toString();
            }
        }
        catch (Exception theException) {
            LOGGER.log(Level.WARNING, "Could not parse the HTML content", theException);
        }
        this._document = new StringBuffer(theResult);
    }

    public final void draw() {
        this.setColumns(this.getParent().getSize().width - 2);
        this.setRows(this.gRowCount - 4);
        if (this.isHTMLTable) {
            this.isHTMLTable = false;
            this.calculateColumnWidth();
            this.arrangeText();
        }
        super.draw();
    }

    public void setInternalFlag(boolean aFlag) {
    }

    protected class HTMLHandler
    extends HTMLEditorKit.ParserCallback {
        private final StringBuffer gBuffer = new StringBuffer();
        private StringBuffer gRemainingText = new StringBuffer();
        private HTML.Tag gLastTag = null;
        private int gColumnNumber = 0;

        private void processText(char[] aData) {
            if (HTML.Tag.TD == this.gLastTag) {
                if (aData.length < ChaxHTMLPanel.this.gColWidth[this.gColumnNumber]) {
                    this.gBuffer.append(aData);
                    for (int theSpace = 0; theSpace < ChaxHTMLPanel.this.gColWidth[this.gColumnNumber] - aData.length; ++theSpace) {
                        this.gBuffer.append(" ");
                    }
                    this.gRemainingText.append(" <TD>");
                } else if (aData.length == ChaxHTMLPanel.this.gColWidth[this.gColumnNumber]) {
                    this.gBuffer.append(aData);
                    this.gRemainingText.append(" <TD>");
                } else {
                    this.gBuffer.append(String.copyValueOf(aData, 0, ChaxHTMLPanel.this.gColWidth[this.gColumnNumber]));
                    this.gRemainingText.append(String.copyValueOf(aData, ChaxHTMLPanel.this.gColWidth[this.gColumnNumber], aData.length - ChaxHTMLPanel.this.gColWidth[this.gColumnNumber])).append(" <TD>");
                }
                if (ChaxHTMLPanel.this.gColWidth.length != this.gColumnNumber + 1) {
                    this.gBuffer.append("   ");
                } else {
                    this.gBuffer.append(" ");
                }
            }
        }

        public final void handleText(char[] aData, int aPos) {
            this.processText(aData);
        }

        private void appendSpace() {
            for (int theSpace = 0; theSpace < ChaxHTMLPanel.this.gColWidth[this.gColumnNumber] + 3; ++theSpace) {
                this.gBuffer.append(" ");
            }
            this.gRemainingText.append(" <TD>");
        }

        public final void handleStartTag(HTML.Tag aTag, MutableAttributeSet aAttr, int aPos) {
            if (HTML.Tag.TD == aTag) {
                this.gLastTag = HTML.Tag.TD;
            }
        }

        public final void handleEndTag(HTML.Tag aTag, int aPos) {
            if (HTML.Tag.TR == aTag) {
                this.gColumnNumber = 0;
                while (this.gRemainingText.length() > 0 && this.gRemainingText.toString().replace(" <TD>", "").trim().length() > 0) {
                    StringTokenizer theTokens = new StringTokenizer(this.gRemainingText.toString(), "<TD>");
                    this.gRemainingText = new StringBuffer();
                    while (theTokens.hasMoreTokens()) {
                        String theTemp = theTokens.nextToken();
                        if (theTemp.trim().length() > 0) {
                            this.processText(theTemp.toCharArray());
                        } else {
                            this.appendSpace();
                        }
                        ++this.gColumnNumber;
                    }
                    this.gColumnNumber = 0;
                }
                this.gRemainingText.setLength(0);
                this.gBuffer.append("\n");
            }
            if (HTML.Tag.TD == aTag) {
                ++this.gColumnNumber;
            }
        }

        public final String getBuffer() {
            return this.gBuffer.toString();
        }
    }
}

