/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.custom;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;
import org.openinstaller.provider.ui.custom.CompositeIcon;
import org.openinstaller.provider.ui.custom.RoundIcon;
import org.openinstaller.provider.ui.custom.TextIcon;

public class JHorizontalRadioButton
extends JRadioButton {
    private transient Icon disabledIcon;
    private transient Icon disabledSelIcon;
    private transient Icon pressedIcon;
    private transient Icon selectedIcon;
    private transient Icon rollOverIcon;
    private transient Icon rollOverSelIcon;
    private transient Icon normalIcon;
    private Color gColor;
    private Color gSelectedColor;
    private Color gPressedColor;
    private Color gRolloverColor;
    private Color gRolloverSelColor;
    private Color gDisabledColor;
    private Color gDisabledSelColor;
    private Color gBackColor;
    private transient Icon gTextIcon;
    private transient Icon gImgIcon;
    private String gBulletType = BULLET_NONE;
    private String gTxt;
    private String gUpperTxt;
    private static String BULLET_ROUND = "ROUND";
    private static String BULLET_IMAGE = "IMAGE";
    private static String BULLET_NONE = "NONE";

    public JHorizontalRadioButton() {
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setDoubleBuffered(true);
    }

    public final void setBgColor(Color c) {
        this.gBackColor = c;
    }

    public final void setButtonColor(Color c) {
        if (this.gTextIcon == null) {
            return;
        }
        this.gColor = c;
        this.normalIcon = new CompositeIcon(this.gTextIcon, new RoundIcon(this.gTextIcon.getIconHeight() - 2, this.gColor), 4);
        this.setIcon(this.normalIcon);
        this.setBackground(c);
    }

    public final void setSelectedColor(Color c) {
        if (this.gTextIcon == null) {
            return;
        }
        this.gSelectedColor = c;
        this.selectedIcon = new CompositeIcon(this.gTextIcon, new RoundIcon(this.gTextIcon.getIconHeight() - 2, this.gSelectedColor), 4);
        this.setSelectedIcon(this.selectedIcon);
        this.setBackground(c);
    }

    public final void setPressedColor(Color c) {
        if (this.gTextIcon == null) {
            return;
        }
        this.gPressedColor = c;
        this.pressedIcon = new CompositeIcon(this.gTextIcon, new RoundIcon(this.gTextIcon.getIconHeight() - 2, this.gPressedColor), 4);
        this.setPressedIcon(this.pressedIcon);
        this.setBackground(c);
    }

    public final void setRolloverColor(Color c) {
        if (this.gTextIcon == null) {
            return;
        }
        this.gColor = this.gRolloverColor = c;
        this.rollOverIcon = new CompositeIcon(this.gTextIcon, new RoundIcon(this.gTextIcon.getIconHeight() - 2, this.gRolloverColor), 4);
        this.setRolloverIcon(this.rollOverIcon);
        this.setBackground(c);
    }

    public final void setRolloverSelectedColor(Color c) {
        if (this.gTextIcon == null) {
            return;
        }
        this.gRolloverSelColor = c;
        this.rollOverSelIcon = new CompositeIcon(this.gTextIcon, new RoundIcon(this.gTextIcon.getIconHeight() - 2, this.gRolloverSelColor), 4);
        this.setRolloverSelectedIcon(this.rollOverSelIcon);
        this.setBackground(c);
    }

    public final void setDisabledColor(Color c) {
        if (this.gTextIcon == null) {
            return;
        }
        this.gDisabledColor = c;
        this.disabledIcon = new CompositeIcon(this.gTextIcon, new RoundIcon(this.gTextIcon.getIconHeight() - 2, this.gDisabledColor), 4);
        this.setDisabledIcon(this.disabledIcon);
        this.setBackground(c);
    }

    public final void setDisabledSelectedColor(Color c) {
        if (this.gTextIcon == null) {
            return;
        }
        this.gDisabledSelColor = c;
        this.disabledSelIcon = new CompositeIcon(this.gTextIcon, new RoundIcon(this.gTextIcon.getIconHeight() - 2, this.gDisabledSelColor), 4);
        this.setDisabledSelectedIcon(this.disabledSelIcon);
        this.setBackground(c);
    }

    public final void setTextColor(Color c) {
        TextIcon ti = (TextIcon)this.gTextIcon;
        ti.setTextColor(c);
        this.gTextIcon = ti;
        this.createIcons();
    }

    public final void setTextIcon(TextIcon ti) {
        this.gTextIcon = ti;
        this.createIcons();
    }

    public final void setImageIcon(String url) {
        this.gImgIcon = new ImageIcon(url);
        this.createIcons();
    }

    public final void setText(String aText) {
        super.setText(aText);
        this.gTextIcon = new TextIcon(this, aText);
        this.gTxt = aText;
        this.gUpperTxt = aText.toUpperCase();
        this.createIcons();
    }

    public final void setFont(Font aFont) {
        super.setFont(aFont);
        this.createIcons();
    }

    public final void setBulletType(String strBulletType) {
        this.gBulletType = strBulletType;
    }

    private void createIcons() {
        if (this.gTextIcon == null) {
            return;
        }
        if (BULLET_NONE.equalsIgnoreCase(this.gBulletType)) {
            TextIcon tempIcon = (TextIcon)this.gTextIcon;
            TextIcon newNormalTI = new TextIcon(this, this.gTxt);
            newNormalTI.setTextColor(tempIcon.getTextColor());
            TextIcon newSelectedTI = new TextIcon(this, this.gUpperTxt);
            newSelectedTI.setTextColor(tempIcon.getTextColor());
            TextIcon newRolloverTI = new TextIcon(this, this.gUpperTxt);
            newRolloverTI.setTextColor(tempIcon.getTextColor());
            this.normalIcon = newNormalTI;
            this.selectedIcon = newSelectedTI;
            this.rollOverIcon = newRolloverTI;
        } else if (BULLET_ROUND.equalsIgnoreCase(this.gBulletType) || BULLET_IMAGE.equalsIgnoreCase(this.gBulletType)) {
            // empty if block
        }
        this.setIcon(this.normalIcon);
        this.setSelectedIcon(this.selectedIcon);
    }

    public final void paintComponent(Graphics aGraphics) {
        Color c = aGraphics.getColor();
        aGraphics.setColor(new Color(c.getRed(), c.getBlue(), c.getGreen(), 0));
        aGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Icon theIcon = this.isSelected() ? this.getSelectedIcon() : this.getIcon();
        Insets theInsets = this.getInsets();
        theIcon.paintIcon(this, aGraphics, theInsets.left, theInsets.top);
    }
}

