/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.custom;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class OpenInstallerDirectoryChooser
extends JPanel
implements ActionListener {
    private final JTextField gField;
    private final JButton gButton;
    private final JFileChooser gChooser;

    public OpenInstallerDirectoryChooser() {
        this.setDoubleBuffered(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints theConstraints = new GridBagConstraints();
        theConstraints.gridx = 0;
        theConstraints.gridy = 0;
        theConstraints.weightx = 1.0;
        theConstraints.gridwidth = 1;
        theConstraints.gridheight = 1;
        theConstraints.fill = 2;
        theConstraints.anchor = 17;
        theConstraints.insets = new Insets(0, 0, 0, 5);
        this.setOpaque(false);
        this.gField = new JTextField();
        this.gButton = new JButton(" ... ");
        this.gField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.gButton.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.gChooser = new JFileChooser();
        this.gChooser.setFileSelectionMode(1);
        this.gButton.addActionListener(this);
        this.gButton.setActionCommand("AC_NONE");
        this.add((Component)this.gField, theConstraints);
        theConstraints.gridx = 1;
        theConstraints.weightx = 0.0;
        theConstraints.fill = 0;
        theConstraints.insets = new Insets(0, 0, 0, 0);
        theConstraints.ipadx = 3;
        this.add((Component)this.gButton, theConstraints);
    }

    public final void setFileSelector(boolean aValue) {
        if (aValue) {
            this.gChooser.setFileSelectionMode(0);
        } else {
            this.gChooser.setFileSelectionMode(1);
        }
    }

    public final void setText(String aPath) {
        this.gField.setText(aPath);
    }

    public final String getText() {
        return this.gField.getText();
    }

    public final void setToolTipText(String aText) {
        this.gField.setToolTipText(aText);
        this.gButton.setToolTipText(aText);
    }

    public final void setTextFieldFont(Font aFont) {
        this.gField.setFont(aFont);
    }

    public final Font getTextFieldFont() {
        return this.gField.getFont();
    }

    public final void setTextFieldForeground(Color aColor) {
        this.gField.setForeground(aColor);
    }

    public final Color getTextFieldForeground() {
        return this.gField.getForeground();
    }

    public final void setTextFieldBorder(Border aBorder) {
        this.gField.setBorder(aBorder);
    }

    public final Border getTextFieldBorder() {
        return this.gField.getBorder();
    }

    public final JTextField getTextField() {
        return this.gField;
    }

    public final void setActionCommand(String aCommand) {
        this.gField.setActionCommand(aCommand);
    }

    public final void setName(String aName) {
        this.gField.setName(aName);
    }

    public final String getName() {
        return this.gField.getName();
    }

    public final void setColumns(int aCols) {
        this.remove(this.gField);
        this.remove(this.gButton);
        this.gField.setColumns(aCols);
        GridBagConstraints theConstraints = new GridBagConstraints();
        theConstraints.gridx = 0;
        theConstraints.gridy = 0;
        theConstraints.weightx = 0.0;
        theConstraints.gridwidth = 1;
        theConstraints.gridheight = 1;
        theConstraints.fill = 0;
        theConstraints.anchor = 17;
        theConstraints.insets = new Insets(0, 0, 0, 11);
        this.add((Component)this.gField, theConstraints);
        theConstraints.gridx = 1;
        theConstraints.weightx = 1.0;
        theConstraints.gridwidth = 1;
        theConstraints.gridheight = 1;
        theConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.gButton, theConstraints);
    }

    public final void setEnabled(boolean aEnabled) {
        this.gField.setEnabled(aEnabled);
        this.gButton.setEnabled(aEnabled);
    }

    public final void actionPerformed(ActionEvent aEvent) {
        if (aEvent.getSource() == this.gButton) {
            File theFile = null;
            theFile = this.gChooser.getFileSelectionMode() == 1 ? new File(this.getText()) : new File(this.getText()).getParentFile();
            if (theFile != null && theFile.isDirectory()) {
                this.gChooser.setCurrentDirectory(theFile);
            }
            this.gChooser.showOpenDialog(this);
            File theSelectedFile = this.gChooser.getSelectedFile();
            if (theSelectedFile != null) {
                this.gField.setText(theSelectedFile.getAbsolutePath());
            }
        }
    }
}

