/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.custom;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.openinstaller.util.ClassUtils;

public final class SlideShow
extends JPanel
implements Runnable {
    private final List<Integer> gImageTimes;
    private final List<Image> gImages;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private int gImageIndex = -1;
    public static final int DEFAULT_TIME_PER_SLIDE = 5;
    private int gDefaultTimePerSlide = 5;

    public SlideShow() {
        this.setDoubleBuffered(true);
        this.gImageTimes = new ArrayList<Integer>();
        this.gImages = new ArrayList<Image>();
        Thread theThread = new Thread(this);
        theThread.start();
    }

    private void addImage(final String aPathOfImage, final Integer aTime) {
        LOGGER.finest(ClassUtils.getFQMethodName() + " " + aPathOfImage + ", " + aTime + ")");
        Runnable theImageLoadRunnable = new Runnable(){

            public void run() {
                InputStream theImageStream = this.getClass().getResourceAsStream(aPathOfImage);
                if (theImageStream == null) {
                    LOGGER.finest(ClassUtils.getFQMethodName() + " Slide image stream could not be found");
                    return;
                }
                try {
                    BufferedImage theImage = ImageIO.read(theImageStream);
                    try {
                        theImageStream.close();
                    }
                    catch (Throwable theThrowable) {
                        LOGGER.finest(ClassUtils.getFQMethodName() + " Could not close image read stream");
                    }
                    if (theImage == null) {
                        LOGGER.log(Level.SEVERE, "### Not able to create image for slideshow. No IOException occured.");
                        return;
                    }
                    Dimension theCurrentDimension = SlideShow.this.getSize();
                    LOGGER.finest(ClassUtils.getFQMethodName() + " Current dimension " + theCurrentDimension);
                    int theImageWidth = theImage.getWidth();
                    int theImageHeight = theImage.getHeight();
                    LOGGER.finest(ClassUtils.getFQMethodName() + " Image dimension " + theImageWidth + "x" + theImageHeight);
                    Dimension theNewDimension = new Dimension(Math.max((int)theCurrentDimension.getWidth(), theImageWidth), Math.max((int)theCurrentDimension.getHeight(), theImageHeight));
                    LOGGER.finest(ClassUtils.getFQMethodName() + " New dimension " + theNewDimension);
                    SlideShow.this.setPreferredSize(theNewDimension);
                    SlideShow.this.setMinimumSize(theNewDimension);
                    SlideShow.this.updateLists(aPathOfImage, aTime, theImage);
                    Container theContainer = SlideShow.this.getParent();
                    if (theContainer != null) {
                        theContainer.repaint();
                    }
                }
                catch (IOException theEx) {
                    LOGGER.log(Level.SEVERE, "### Not able to create image for slideshow. IOException occured.", theEx);
                }
            }
        };
        Thread theImageLoadThread = new Thread(theImageLoadRunnable);
        theImageLoadThread.start();
    }

    private synchronized void updateLists(String aPathOfImage, Integer aTime, BufferedImage aImage) {
        this.gImageTimes.add(aTime);
        this.gImages.add(aImage);
    }

    public final void setDefaultTimePerSlide(int aSeconds) {
        this.gDefaultTimePerSlide = aSeconds;
        if (1 > this.gDefaultTimePerSlide) {
            this.gDefaultTimePerSlide = 5;
        }
    }

    public final int getDefaultTimePerSlide() {
        return this.gDefaultTimePerSlide;
    }

    public void setResources(String aResources) {
        StringTokenizer theTokenizer = new StringTokenizer(aResources, ",", false);
        if (theTokenizer.countTokens() % 2 != 0) {
            LOGGER.finest("### Invalid slideshow definition. Ignorning.");
            return;
        }
        while (theTokenizer.hasMoreTokens()) {
            String theImageResource = theTokenizer.nextToken();
            if (!theTokenizer.hasMoreTokens()) continue;
            String theTime = theTokenizer.nextToken();
            Integer theTimeInteger = Integer.valueOf(theTime);
            if (0 > theTimeInteger) {
                this.addImage(theImageResource, 0);
                continue;
            }
            this.addImage(theImageResource, theTimeInteger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paintComponent(Graphics aGraphics) {
        if (!this.isVisible()) {
            return;
        }
        SlideShow slideShow = this;
        synchronized (slideShow) {
            Image theImage;
            if (this.gImageIndex != -1 && null != (theImage = this.gImages.get(this.gImageIndex))) {
                aGraphics.drawImage(theImage, 0, 0, this.getWidth(), this.getHeight(), this);
                return;
            }
        }
        aGraphics.setColor(this.getParent().getBackground());
        aGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            int theTimeForThisSlide = 0;
            SlideShow slideShow = this;
            synchronized (slideShow) {
                int count = this.gImages.size();
                if (0 < count) {
                    ++this.gImageIndex;
                    this.gImageIndex %= count;
                    theTimeForThisSlide = this.gImageTimes.get(this.gImageIndex);
                    if (1 > theTimeForThisSlide) {
                        theTimeForThisSlide = this.getDefaultTimePerSlide();
                    }
                } else {
                    this.gImageIndex = -1;
                }
            }
            this.repaint();
            try {
                if (-1 == this.gImageIndex) {
                    Thread.yield();
                    continue;
                }
                Thread.sleep(theTimeForThisSlide * 1000);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

