/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.custom;

import charvax.swing.JComboBox;
import charvax.swing.JLabel;
import charvax.swing.JPanel;
import java.util.logging.Logger;
import org.chaxml.SwingEngine;
import org.openinstaller.provider.ui.custom.ChaxButton;
import org.openinstaller.provider.ui.custom.ChaxCheckBox;
import org.openinstaller.provider.ui.custom.ChaxDirectoryChooser;
import org.openinstaller.provider.ui.custom.ChaxHTMLPanel;
import org.openinstaller.provider.ui.custom.ChaxLabel;
import org.openinstaller.provider.ui.custom.ChaxPasswordField;
import org.openinstaller.provider.ui.custom.ChaxRadioButton;
import org.openinstaller.provider.ui.custom.ChaxScrollablePanel;
import org.openinstaller.provider.ui.custom.ChaxShadowPanel;
import org.openinstaller.provider.ui.custom.ChaxSlideShow;
import org.openinstaller.provider.ui.custom.ChaxTextArea;
import org.openinstaller.provider.ui.custom.ChaxTextField;
import org.openinstaller.provider.ui.custom.HTMLPanel;
import org.openinstaller.provider.ui.custom.JHorizontalRadioButton;
import org.openinstaller.provider.ui.custom.OIComboBox;
import org.openinstaller.provider.ui.custom.OITabbedPane;
import org.openinstaller.provider.ui.custom.OpenInstallerDirectoryChooser;
import org.openinstaller.provider.ui.custom.ScrollablePanel;
import org.openinstaller.provider.ui.custom.ShadowBorderPanel;
import org.openinstaller.provider.ui.custom.SlideShow;
import org.openinstaller.provider.ui.custom.SmoothButton;
import org.openinstaller.provider.ui.custom.SmoothLabel;
import org.openinstaller.provider.ui.custom.TextIcon;
import org.openinstaller.provider.ui.custom.psp.CUIProductSelectionPage;
import org.openinstaller.provider.ui.custom.psp.GUIProductSelectionPage;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ui.BgImagePanel;

public final class TagRegisterer {
    private static boolean gIsRegistered = false;
    private static Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    private TagRegisterer() {
    }

    public static void register(Object aSwix) throws EnhancedException {
        if (gIsRegistered) {
            throw new EnhancedException("TAGS_ALREADY_REGISTERED", new String[0]);
        }
        if (aSwix instanceof org.swixml.SwingEngine) {
            LOGGER.fine("Registering custom tags for SwiXML");
            org.swixml.SwingEngine theSwix = (org.swixml.SwingEngine)aSwix;
            theSwix.getTaglib().registerTag("hradiobutton", JHorizontalRadioButton.class);
            theSwix.getTaglib().registerTag("texticon", TextIcon.class);
            theSwix.getTaglib().registerTag("bgimagepanel", BgImagePanel.class);
            theSwix.getTaglib().registerTag("scrpanel", ScrollablePanel.class);
            theSwix.getTaglib().registerTag("shadowborderpanel", ShadowBorderPanel.class);
            theSwix.getTaglib().registerTag("smoothlabel", SmoothLabel.class);
            theSwix.getTaglib().registerTag("smoothbutton", SmoothButton.class);
            theSwix.getTaglib().registerTag("htmlpanel", HTMLPanel.class);
            theSwix.getTaglib().registerTag("directoryselector", OpenInstallerDirectoryChooser.class);
            theSwix.getTaglib().registerTag("slideshow", SlideShow.class);
            theSwix.getTaglib().registerTag("oicombobox", OIComboBox.class);
            theSwix.getTaglib().registerTag("tabbedpane", OITabbedPane.class);
            theSwix.getTaglib().registerTag("psp", GUIProductSelectionPage.class);
            gIsRegistered = true;
        } else if (aSwix instanceof SwingEngine) {
            LOGGER.fine("Registering custom tags for ChaXML");
            SwingEngine theSwix = (SwingEngine)aSwix;
            theSwix.getTaglib().registerTag("hradiobutton", ChaxLabel.class);
            theSwix.getTaglib().registerTag("bgimagepanel", JPanel.class);
            theSwix.getTaglib().registerTag("scrpanel", ChaxScrollablePanel.class);
            theSwix.getTaglib().registerTag("shadowborderpanel", ChaxShadowPanel.class);
            theSwix.getTaglib().registerTag("smoothlabel", JLabel.class);
            theSwix.getTaglib().registerTag("smoothbutton", ChaxButton.class);
            theSwix.getTaglib().registerTag("htmlpanel", ChaxHTMLPanel.class);
            theSwix.getTaglib().registerTag("directoryselector", ChaxDirectoryChooser.class);
            theSwix.getTaglib().registerTag("textarea", ChaxTextArea.class);
            theSwix.getTaglib().registerTag("textfield", ChaxTextField.class);
            theSwix.getTaglib().registerTag("passwordfield", ChaxPasswordField.class);
            theSwix.getTaglib().registerTag("radiobutton", ChaxRadioButton.class);
            theSwix.getTaglib().registerTag("checkbox", ChaxCheckBox.class);
            theSwix.getTaglib().registerTag("slideshow", ChaxSlideShow.class);
            theSwix.getTaglib().registerTag("oicombobox", JComboBox.class);
            theSwix.getTaglib().registerTag("psp", CUIProductSelectionPage.class);
            gIsRegistered = true;
        } else {
            throw new EnhancedException("INVALID_UI_MODE", new String[0]);
        }
    }
}

