/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.custom;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public class TextIcon
implements Icon,
PropertyChangeListener {
    private String gLabel;
    private int gWidth;
    private int gHeight;
    private int gCharHeight;
    private int gDescent;
    private Component gComponent;
    private Color gTxtColor;
    static final String sDrawsInTopRight = "\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30ee\u30f5\u30f6";
    static final String sDrawsInFarTopRight = "\u3001\u3002";
    static final double NINETY_DEGREES = Math.toRadians(90.0);
    static final int kBufferSpace = 4;

    public TextIcon(Component aComponent, String aLabel) {
        this.gComponent = aComponent;
        this.gTxtColor = new Color(0, 0, 0);
        this.gLabel = aLabel;
        this.calcDimensions();
        this.gComponent.addPropertyChangeListener(this);
    }

    public void setLabel(String aLabel) {
        this.gLabel = aLabel;
        this.recalcDimensions();
    }

    public String getLabel() {
        return this.gLabel;
    }

    public void setTextColor(Color c) {
        this.gTxtColor = c;
    }

    public Color getTextColor() {
        return this.gTxtColor;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("font".equals(prop)) {
            this.recalcDimensions();
        }
    }

    void recalcDimensions() {
        int wOld = this.getIconWidth();
        int hOld = this.getIconHeight();
        this.calcDimensions();
        if (wOld != this.getIconWidth() || hOld != this.getIconHeight()) {
            this.gComponent.invalidate();
        }
    }

    void calcDimensions() {
        FontMetrics fm = this.gComponent.getFontMetrics(this.gComponent.getFont());
        this.gCharHeight = fm.getAscent() + fm.getDescent();
        this.gDescent = fm.getDescent();
        this.gHeight = this.gCharHeight;
        this.gWidth = fm.stringWidth(this.gLabel) + 8;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.gTxtColor);
        g.drawString(this.gLabel, x, y + this.gHeight - this.gDescent);
    }

    public int getIconWidth() {
        return this.gWidth;
    }

    public int getIconHeight() {
        return this.gHeight;
    }
}

