/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.custom.psp;

import charva.awt.Color;
import charva.awt.Component;
import charva.awt.GridBagConstraints;
import charva.awt.GridBagLayout;
import charva.awt.Insets;
import charva.awt.LayoutManager;
import charva.awt.event.ActionEvent;
import charva.awt.event.ActionListener;
import charvax.swing.BorderFactory;
import charvax.swing.DefaultListModel;
import charvax.swing.JButton;
import charvax.swing.JList;
import charvax.swing.JPanel;
import charvax.swing.JScrollPane;
import charvax.swing.JTextArea;
import charvax.swing.ListModel;
import charvax.swing.ListSelectionModel;
import charvax.swing.event.ListSelectionEvent;
import charvax.swing.event.ListSelectionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.contracts.product.PSPBusRequestType;
import org.openinstaller.contracts.product.PSPControl;
import org.openinstaller.contracts.product.ProductNodeInterface;
import org.openinstaller.provider.ui.ProductSelector;
import org.openinstaller.provider.ui.custom.ChaxHTMLPanel;
import org.openinstaller.provider.ui.custom.psp.PSP_ACTIONS;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Msg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUIProductSelectionPage
extends JPanel
implements ProductSelector {
    static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    public static final String AVAILABLE_LIST_NAME = "AVAILABLE";
    JList gAvailablesList;
    JList gSelectedsList;
    JTextArea gDescription;
    JButton gAddButton;
    private JButton gAddAllButton;
    JButton gRemoveButton;
    private JButton gRemoveAllButton;
    boolean gShowDependencies = true;
    boolean gShowFeatures = true;
    boolean gUnselectDependencies = true;
    private boolean gUnselectFeatures = true;
    private boolean gRootIsAContainer = false;
    private boolean gInitDone = false;

    @Override
    public void addAvailable(ProductNodeInterface aProduct) {
        this.addProduct(aProduct, (DefaultListModel)this.gAvailablesList.getModel());
    }

    @Override
    public void addSelected(ProductNodeInterface aProduct) {
        this.addProduct(aProduct, (DefaultListModel)this.gSelectedsList.getModel());
    }

    public void selectItem(List<String> aSelectedList, JList aSrc) {
        ArrayList<Integer> theIndicesList = new ArrayList<Integer>();
        for (String theSelectedProd : aSelectedList) {
            for (int theListIndex = 0; theListIndex < aSrc.getModel().getSize(); ++theListIndex) {
                ProductNodeInterface theListedProd = (ProductNodeInterface)((DefaultListModel)aSrc.getModel()).getElementAt(theListIndex);
                if (!theListedProd.getID().equalsIgnoreCase(theSelectedProd)) continue;
                LOGGER.finest(" List Index = " + theListIndex + "Listed Prod = " + theListedProd);
                theIndicesList.add(new Integer(theListIndex));
            }
        }
        int[] theSelectedIndices = new int[theIndicesList.size()];
        for (int theIndex = 0; theIndex < theIndicesList.size(); ++theIndex) {
            theSelectedIndices[theIndex] = (Integer)theIndicesList.get(theIndex);
        }
        this.setSelectedIndices(theSelectedIndices);
    }

    public void setSelectedIndices(int[] indices) {
        ListSelectionModel theSelectionModel = this.gAvailablesList.getSelectionModel();
        theSelectionModel.clearSelection();
        int size = this.gAvailablesList.getModel().getSize();
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] >= size) continue;
            theSelectionModel.addSelectionInterval(indices[i], indices[i]);
        }
    }

    public CUIProductSelectionPage() {
        super((LayoutManager)new GridBagLayout());
        GridBagConstraints theGridConst = new GridBagConstraints();
        JPanel theButtonPanel = new JPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints theButtonConst = new GridBagConstraints();
        theButtonConst.gridx = 0;
        theButtonConst.gridy = 0;
        theButtonConst.weightx = 1.0;
        theButtonConst.insets = new Insets(0, 1, 1, 1);
        theButtonConst.fill = 201;
        this.gAddButton = new JButton(Msg.get((String)"ADD_BUTTON_LABEL", (Object[])new Object[0]));
        this.gAddButton.setEnabled(false);
        theButtonPanel.add((Component)this.gAddButton, (Object)theButtonConst);
        theButtonConst.gridy = 1;
        this.gAddAllButton = new JButton(Msg.get((String)"ADD_ALL_BUTTON_LABEL", (Object[])new Object[0]));
        this.gAddAllButton.setEnabled(false);
        theButtonPanel.add((Component)this.gAddAllButton, (Object)theButtonConst);
        theButtonConst.gridy = 2;
        this.gRemoveButton = new JButton(Msg.get((String)"REMOVE_BUTTON_LABEL", (Object[])new Object[0]));
        this.gRemoveButton.setEnabled(false);
        theButtonPanel.add((Component)this.gRemoveButton, (Object)theButtonConst);
        theButtonConst.gridy = 3;
        this.gRemoveAllButton = new JButton(Msg.get((String)"REMOVE_ALL_BUTTON_LABEL", (Object[])new Object[0]));
        this.gRemoveAllButton.setEnabled(false);
        theButtonPanel.add((Component)this.gRemoveAllButton, (Object)theButtonConst);
        theGridConst.gridx = 0;
        theGridConst.gridy = 0;
        theGridConst.gridwidth = 3;
        theGridConst.gridheight = 1;
        theGridConst.weightx = 1.0;
        theGridConst.fill = 201;
        theGridConst.anchor = 108;
        theGridConst.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new ChaxHTMLPanel(Msg.get((String)"PSP_INTRO_TEXT", (Object[])new Object[0])), theGridConst);
        this.gAvailablesList = new JList((ListModel)new DefaultListModel());
        this.gAvailablesList.addListSelectionListener((ListSelectionListener)new PSPAvailableListListener());
        this.gAvailablesList.setName(AVAILABLE_LIST_NAME);
        this.gAvailablesList.setVisibleColumnCount(15);
        this.gAvailablesList.setVisibleRowCount(7);
        JScrollPane theSelectablesScrollPane = new JScrollPane((Component)this.gAvailablesList);
        theGridConst.fill = 203;
        theGridConst.weighty = 1.0;
        theGridConst.gridy = 1;
        theGridConst.weightx = 1.0;
        theGridConst.gridwidth = 1;
        theGridConst.insets = new Insets(0, 0, 0, 0);
        theSelectablesScrollPane.setViewportBorder(BorderFactory.createLineBorder((Color)Color.black, (int)1));
        this.add((Component)theSelectablesScrollPane, theGridConst);
        theGridConst.gridx = 1;
        theGridConst.weightx = 0.0;
        theGridConst.fill = 200;
        theGridConst.insets = new Insets(0, 0, 0, 0);
        theGridConst.anchor = 100;
        this.add((Component)theButtonPanel, theGridConst);
        this.gSelectedsList = new JList((ListModel)new DefaultListModel());
        this.gSelectedsList.setVisibleColumnCount(15);
        this.gSelectedsList.setVisibleRowCount(7);
        this.gSelectedsList.addListSelectionListener((ListSelectionListener)new PSPSelectedListListener());
        JScrollPane theSelectedsScroll = new JScrollPane((Component)this.gSelectedsList);
        theGridConst.fill = 203;
        theGridConst.weightx = 1.0;
        theGridConst.gridx = 2;
        theGridConst.insets = new Insets(0, 0, 0, 0);
        theSelectedsScroll.setViewportBorder(BorderFactory.createLineBorder((Color)Color.black, (int)1));
        this.add((Component)theSelectedsScroll, theGridConst);
        this.gDescription = new JTextArea();
        JScrollPane theTextScroll = new JScrollPane((Component)this.gDescription);
        theGridConst.gridx = 0;
        theGridConst.gridy = 2;
        theGridConst.gridwidth = 3;
        theGridConst.insets = new Insets(0, 0, 0, 0);
        this.gDescription.setColumns(48);
        this.gDescription.setRows(3);
        theTextScroll.setViewportBorder(BorderFactory.createLineBorder((Color)Color.black, (int)1));
        this.add((Component)theTextScroll, theGridConst);
        this.gAddButton.setActionCommand("AC_NONE");
        this.gAddAllButton.setActionCommand("AC_NONE");
        this.gRemoveButton.setActionCommand("AC_NONE");
        this.gRemoveAllButton.setActionCommand("AC_NONE");
        this.gAddButton.setName(PSP_ACTIONS.ADD_COMMAND.name());
        this.gAddAllButton.setName(PSP_ACTIONS.ADD_ALL_COMMAND.name());
        this.gRemoveButton.setName(PSP_ACTIONS.REMOVE_COMMAND.name());
        this.gRemoveAllButton.setName(PSP_ACTIONS.REMOVE_ALL_COMMAND.name());
        PSPButtonsListener theButtonListener = new PSPButtonsListener();
        this.gAddButton.addActionListener((ActionListener)theButtonListener);
        this.gAddAllButton.addActionListener((ActionListener)theButtonListener);
        this.gRemoveButton.addActionListener((ActionListener)theButtonListener);
        this.gRemoveAllButton.addActionListener((ActionListener)theButtonListener);
    }

    private void init() {
        if (this.gInitDone) {
            return;
        }
        ListSelectionModel theSelectionModel = this.gAvailablesList.getSelectionModel();
        theSelectionModel.clearSelection();
        ControlBus theBus = ControlBus.getInstance();
        try {
            PSPControl thePSPCtrl = new PSPControl(PSPControl.PSPCommand.GET_AVAILABLE_PRODUCTS, (Object)new PSPBusRequestType(this.gShowFeatures, this.gShowDependencies, this.gRootIsAContainer));
            BusResponse theProdSelResp = theBus.publishRequest(new BusRequest("ProductSelectionRequest", (Object)thePSPCtrl), "svc://general/product");
            if (theProdSelResp == null) {
                throw new EnhancedException("CANNOT_GET_PRODUCT_SELECTION_MAP", new String[0]);
            }
            if (theProdSelResp.getException() != null) {
                throw new EnhancedException("CANNOT_GET_PRODUCT_SELECTION_MAP", (Throwable)theProdSelResp.getException(), new String[0]);
            }
            Set theProductList = (Set)theProdSelResp.getResult();
            if (theProductList == null) {
                throw new EnhancedException("CANNOT_GET_PRODUCT_SELECTION_MAP", new String[0]);
            }
            for (ProductNodeInterface theProduct : theProductList) {
                this.addAvailable(theProduct);
            }
            PSPControl thePSPControl = new PSPControl(PSPControl.PSPCommand.GET_SELECTED_PRODUCTS, null);
            BusResponse theSelectedResp = theBus.publishRequest(new BusRequest("SelectedProducts Request", (Object)thePSPControl), "svc://general/product");
            if (null != theSelectedResp && theSelectedResp.getException() == null) {
                List theSelectedList = (List)theSelectedResp.getResult();
                if (null != theSelectedList) {
                    this.selectItem(theSelectedList, this.gAvailablesList);
                    this.moveSelected(this.gAvailablesList, this.gSelectedsList, false, false);
                }
            } else {
                LOGGER.fine("Could not retrieve the selected product list");
            }
        }
        catch (EnhancedException theEE) {
            LOGGER.fine(theEE.getMessage());
        }
        this.updateAvailableButtons();
        this.gInitDone = true;
    }

    public void setShowFeatures(boolean aValue) {
        this.gShowFeatures = aValue;
    }

    public void setShowDependencies(boolean aValue) {
        this.gShowDependencies = aValue;
    }

    public void setUnselectDependencies(boolean aValue) {
        this.gUnselectDependencies = aValue;
    }

    public void setUnselectFeatures(boolean aValue) {
        this.gUnselectFeatures = aValue;
    }

    public void setRootIsAContainer(boolean aValue) {
        this.gRootIsAContainer = aValue;
    }

    public void setName(String aName) {
        this.gSelectedsList.setName(aName);
    }

    void updateDescription() {
        if (-1 != this.gSelectedsList.getSelectedIndex() && -1 != this.gAvailablesList.getSelectedIndex()) {
            if (this.gSelectedsList.getSelectedValue() != null) {
                this.gDescription.setText(((ProductNodeInterface)this.gSelectedsList.getSelectedValue()).getDescription(Locale.getDefault()));
            } else if (this.gAvailablesList.getSelectedValue() != null) {
                this.gDescription.setText(((ProductNodeInterface)this.gAvailablesList.getSelectedValue()).getDescription(Locale.getDefault()));
            }
        }
    }

    final void updateAvailableButtons() {
        this.gAddAllButton.setEnabled(0 < this.gAvailablesList.getModel().getSize());
        this.gRemoveAllButton.setEnabled(0 < this.gSelectedsList.getModel().getSize());
        this.gAddButton.setEnabled(-1 != this.gAvailablesList.getSelectedIndex());
        this.gRemoveButton.setEnabled(-1 != this.gSelectedsList.getSelectedIndex());
    }

    void moveSelected(JList aSrc, JList aDest, boolean aMoveProvides, boolean aMoveRequires) {
        DefaultListModel theAlist = (DefaultListModel)aSrc.getModel();
        DefaultListModel theBlist = (DefaultListModel)aDest.getModel();
        if (-1 != aSrc.getSelectedIndex()) {
            for (Object theElement : aSrc.getSelectedValues()) {
                if (this.removeProduct(theElement, theAlist)) {
                    this.addProduct(theElement, theBlist);
                }
                if (!aMoveProvides) continue;
                ArrayList<ProductNodeInterface> theFeaturesList = new ArrayList<ProductNodeInterface>();
                this.getFeatures(theElement, theFeaturesList);
                for (ProductNodeInterface theFeature : theFeaturesList) {
                    if (!this.removeProduct(theFeature, theAlist)) continue;
                    this.addProduct(theFeature, theBlist);
                }
            }
        }
        if (aMoveRequires) {
            for (Object theProduct : theBlist.toArray()) {
                ArrayList<ProductNodeInterface> theDepenList = new ArrayList<ProductNodeInterface>();
                this.getDependencies(theProduct, theDepenList);
                for (ProductNodeInterface theDepen : theDepenList) {
                    if (!this.removeProduct(theDepen, theAlist)) continue;
                    this.addProduct(theDepen, theBlist);
                }
            }
        }
        this.updateDescription();
        this.updateAvailableButtons();
    }

    private void getDependencies(Object aElement, List<ProductNodeInterface> aDepenList) {
        for (ProductNodeInterface theDepen : ((ProductNodeInterface)aElement).getDependencies()) {
            if (null != theDepen.getDependencies() && 0 < theDepen.getDependencies().size()) {
                this.getDependencies(theDepen, aDepenList);
            }
            aDepenList.add(theDepen);
        }
    }

    private void getFeatures(Object aElement, List<ProductNodeInterface> aFeaturesList) {
        for (ProductNodeInterface theFeature : ((ProductNodeInterface)aElement).getFeatures()) {
            if (null != theFeature.getFeatures() && 0 < theFeature.getFeatures().size()) {
                this.getFeatures(theFeature, aFeaturesList);
            }
            aFeaturesList.add(theFeature);
        }
    }

    void moveAll(DefaultListModel aSrcList, DefaultListModel aDestList) {
        int size = aSrcList.getSize();
        for (int i = 0; i < size; ++i) {
            aDestList.addElement(aSrcList.getElementAt(i));
        }
        aSrcList.clear();
        this.updateDescription();
        this.updateAvailableButtons();
    }

    private void addProduct(Object aProduct, DefaultListModel aModel) {
        for (Object theProduct : aModel.toArray()) {
            if (!((ProductNodeInterface)aProduct).getID().equals(((ProductNodeInterface)theProduct).getID())) continue;
            return;
        }
        aModel.addElement(aProduct);
        this.updateDescription();
        this.updateAvailableButtons();
    }

    private boolean removeProduct(Object aProduct, DefaultListModel aModel) {
        boolean theValueIsDeleted = false;
        for (Object theProduct : aModel.toArray()) {
            if (!((ProductNodeInterface)aProduct).getID().equals(((ProductNodeInterface)theProduct).getID())) continue;
            theValueIsDeleted = aModel.removeElement(theProduct);
        }
        return theValueIsDeleted;
    }

    public void draw() {
        super.draw();
        LOGGER.finest("PSP: " + ClassUtils.getFQMethodName() + " called");
        this.init();
    }

    public class PSPSelectedListListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent aListSelectionEvent) {
            if (-1 != CUIProductSelectionPage.this.gAvailablesList.getSelectedIndex() && !CUIProductSelectionPage.this.gRemoveButton.isEnabled()) {
                CUIProductSelectionPage.this.gAvailablesList.clearSelection();
            }
            if (-1 != CUIProductSelectionPage.this.gSelectedsList.getSelectedIndex() && 1 >= CUIProductSelectionPage.this.gSelectedsList.getSelectedIndices().length) {
                CUIProductSelectionPage.this.updateDescription();
            } else {
                CUIProductSelectionPage.this.gDescription.setText("");
            }
            CUIProductSelectionPage.this.updateAvailableButtons();
        }
    }

    public class PSPAvailableListListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent aListSelectionEvent) {
            if (-1 != CUIProductSelectionPage.this.gSelectedsList.getSelectedIndex() && !CUIProductSelectionPage.this.gAddButton.isEnabled()) {
                CUIProductSelectionPage.this.gSelectedsList.clearSelection();
            }
            if (-1 != CUIProductSelectionPage.this.gAvailablesList.getSelectedIndex() && 1 >= CUIProductSelectionPage.this.gAvailablesList.getSelectedIndices().length) {
                CUIProductSelectionPage.this.updateDescription();
            } else {
                CUIProductSelectionPage.this.gDescription.setText("");
            }
            CUIProductSelectionPage.this.updateAvailableButtons();
        }
    }

    class PSPButtonsListener
    implements ActionListener {
        PSPButtonsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String theCommand = ((Component)e.getSource()).getName();
            if (PSP_ACTIONS.ADD_COMMAND.name().equals(theCommand)) {
                CUIProductSelectionPage.this.moveSelected(CUIProductSelectionPage.this.gAvailablesList, CUIProductSelectionPage.this.gSelectedsList, CUIProductSelectionPage.this.gShowFeatures, CUIProductSelectionPage.this.gShowDependencies);
            } else if (PSP_ACTIONS.ADD_ALL_COMMAND.name().equals(theCommand)) {
                CUIProductSelectionPage.this.moveAll((DefaultListModel)CUIProductSelectionPage.this.gAvailablesList.getModel(), (DefaultListModel)CUIProductSelectionPage.this.gSelectedsList.getModel());
            } else if (PSP_ACTIONS.REMOVE_COMMAND.name().equals(theCommand)) {
                CUIProductSelectionPage.this.moveSelected(CUIProductSelectionPage.this.gSelectedsList, CUIProductSelectionPage.this.gAvailablesList, !CUIProductSelectionPage.this.gUnselectFeatures, !CUIProductSelectionPage.this.gUnselectDependencies);
            } else if (PSP_ACTIONS.REMOVE_ALL_COMMAND.name().equals(theCommand)) {
                CUIProductSelectionPage.this.moveAll((DefaultListModel)CUIProductSelectionPage.this.gSelectedsList.getModel(), (DefaultListModel)CUIProductSelectionPage.this.gAvailablesList.getModel());
            } else {
                LOGGER.finest("PSPButtonsListener received an unexpected event: [" + theCommand + "]");
            }
        }
    }
}

