/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.swixgen;

import java.util.logging.Logger;
import org.openinstaller.provider.ui.ViewMode;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.DataModel;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.TemplateProcessor;

public final class SwiXMLBuilder {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private final TemplateProcessor gTemplateProcessor = new TemplateProcessor(new DataModel());
    private static final String FRAME_TEMPLATE = "/templates/ui.ftl";
    private static final String PANEL_TEMPLATE = "/templates/components.ftl";

    public SwiXMLBuilder(ViewMode aViewMode) {
        this.gTemplateProcessor.setSingletonInstance();
        this.loadDefaultValues(aViewMode);
    }

    private void loadDefaultValues(ViewMode aViewMode) {
        this.gTemplateProcessor.clearModel().loadModelFromResource("templates/ui.prefs");
        switch (aViewMode) {
            case GUI: {
                this.gTemplateProcessor.loadModelFromResource("templates/gui.prefs");
                break;
            }
            case CUI: {
                this.gTemplateProcessor.loadModelFromResource("templates/cui.prefs");
                break;
            }
        }
    }

    public String getFrameContent() throws EnhancedException {
        return this.gTemplateProcessor.processTemplate(FRAME_TEMPLATE);
    }

    public String getDynamicContent() throws EnhancedException {
        return this.gTemplateProcessor.processTemplate(PANEL_TEMPLATE);
    }

    public void putIntoDataModel(String aKey, Object aValue) throws EnhancedException {
        this.gTemplateProcessor.putIntoDataModel(aKey, aValue);
    }

    public Object getFromDataModel(String aKey) {
        return this.gTemplateProcessor.getFromDataModel(aKey);
    }

    public void replaceInDataModel(String aKey, Object aValue) throws EnhancedException {
        this.gTemplateProcessor.removeFromDataModel(aKey);
        this.gTemplateProcessor.putIntoDataModel(aKey, aValue);
    }
}

