/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.swixgen;

import java.util.List;
import java.util.StringTokenizer;
import org.openinstaller.provider.conf.apoc.APOCPropValue;
import org.openinstaller.provider.ui.swixgen.SwiXMLVisual;
import org.openinstaller.util.EnhancedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwiXMLHTMLPanel
extends SwiXMLVisual {
    private SwiXMLHTMLPanel() {
        this.gStartTag = "<htmlpanel background=\"${dynamic_component_background}\" horizontalAlignment=\"2\" horizontalTextPosition=\"2\" font=\"${dynamic_content_font}\" foreground=\"${dynamic_component_foreground}\"";
        this.gEndTag = "</htmlpanel> ";
    }

    public SwiXMLHTMLPanel(String aName, String aActionCommand, List<APOCPropValue> aValue) throws EnhancedException {
        this();
        this.setName(aName);
        this.setActionCommand(aActionCommand);
        this.setValue(aValue);
    }

    @Override
    public void setValue(List<APOCPropValue> aValue) throws EnhancedException {
        String theOORValue = this.getOORValue(aValue);
        StringBuffer theValue = new StringBuffer();
        if (null == theOORValue || theOORValue.length() == 0) {
            if (1 == aValue.size()) {
                theValue.append(this.convertAPOCVarToFreemarkerVar(aValue.get(0).getValue()));
            }
        } else {
            StringTokenizer theTokens = new StringTokenizer(theOORValue, ";");
            theValue.append("<HTML><BODY>");
            while (theTokens.hasMoreTokens()) {
                theValue.append("<BR>").append(this.convertAPOCVarToFreemarkerVar(theTokens.nextToken()));
            }
            theValue.append("</HTML></BODY>");
        }
        theOORValue = theValue.toString();
        theOORValue = theOORValue.replaceAll("&", "&amp;");
        theOORValue = theOORValue.replaceAll("<", "&lt;");
        theOORValue = theOORValue.replaceAll(">", "&gt;");
        theOORValue = theOORValue.replaceAll("\"", "&quot;");
        theOORValue = theOORValue.replaceAll("'", "&apos;");
        this.gAttributes.append(" text=\"").append(theOORValue).append("\"");
    }
}

