/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.swixgen;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openinstaller.provider.conf.apoc.APOCButton;
import org.openinstaller.provider.conf.apoc.APOCCheckBox;
import org.openinstaller.provider.conf.apoc.APOCComboBox;
import org.openinstaller.provider.conf.apoc.APOCConstraints;
import org.openinstaller.provider.conf.apoc.APOCDirectorySelector;
import org.openinstaller.provider.conf.apoc.APOCEnumerationConstraint;
import org.openinstaller.provider.conf.apoc.APOCHtmlPanel;
import org.openinstaller.provider.conf.apoc.APOCPassword;
import org.openinstaller.provider.conf.apoc.APOCProductsSelector;
import org.openinstaller.provider.conf.apoc.APOCProgressBar;
import org.openinstaller.provider.conf.apoc.APOCPropValue;
import org.openinstaller.provider.conf.apoc.APOCProperty;
import org.openinstaller.provider.conf.apoc.APOCRadioButton;
import org.openinstaller.provider.conf.apoc.APOCSlideShow;
import org.openinstaller.provider.conf.apoc.APOCStringList;
import org.openinstaller.provider.conf.apoc.APOCTextArea;
import org.openinstaller.provider.conf.apoc.APOCTextField;
import org.openinstaller.provider.conf.apoc.APOCTextPanel;
import org.openinstaller.provider.ui.swixgen.SwiXMLButton;
import org.openinstaller.provider.ui.swixgen.SwiXMLCheckBox;
import org.openinstaller.provider.ui.swixgen.SwiXMLComboBox;
import org.openinstaller.provider.ui.swixgen.SwiXMLDirectorySelector;
import org.openinstaller.provider.ui.swixgen.SwiXMLGridBagConstraints;
import org.openinstaller.provider.ui.swixgen.SwiXMLHTMLPanel;
import org.openinstaller.provider.ui.swixgen.SwiXMLLabel;
import org.openinstaller.provider.ui.swixgen.SwiXMLPasswordField;
import org.openinstaller.provider.ui.swixgen.SwiXMLProductsSelector;
import org.openinstaller.provider.ui.swixgen.SwiXMLProgressBar;
import org.openinstaller.provider.ui.swixgen.SwiXMLRadioButton;
import org.openinstaller.provider.ui.swixgen.SwiXMLSlideShow;
import org.openinstaller.provider.ui.swixgen.SwiXMLStringList;
import org.openinstaller.provider.ui.swixgen.SwiXMLTextArea;
import org.openinstaller.provider.ui.swixgen.SwiXMLTextField;
import org.openinstaller.provider.ui.swixgen.SwiXMLTextPanel;
import org.openinstaller.provider.ui.swixgen.XMLContent;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

public final class SwiXMLProperty {
    private APOCProperty gProperty;
    private String gProductName;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public SwiXMLProperty(APOCProperty aProperty, String aProductName) {
        this.gProperty = aProperty;
        this.gProductName = aProductName;
    }

    public int processProperty(int aGridY) throws EnhancedException {
        SwiXMLGridBagConstraints theConstraints = new SwiXMLGridBagConstraints();
        theConstraints.setGridY(aGridY);
        List<APOCPropValue> thePropValues = this.gProperty.getPropValues();
        String theName = this.gProperty.getName();
        if (null != this.gProperty.getLabel() && !"".equalsIgnoreCase(this.gProperty.getLabel())) {
            SwiXMLLabel theLabel = new SwiXMLLabel(theName, this.gProperty.getLabel());
            theConstraints.setAnchor("GridBagConstraints.WEST");
            theConstraints.setLabelInsets(true);
            theLabel.setGridBagConstraints(theConstraints);
            XMLContent.setDynamicContent(theLabel.getSwiXML());
            theConstraints.incrementGridX();
        } else {
            theConstraints.setGridWidth(2);
        }
        if (null != this.gProperty.getVisual()) {
            theConstraints.setLabelInsets(false);
            Object theVisual = null;
            theVisual = this.gProperty.getVisual().getType();
            theConstraints.setWeightX(1);
            theConstraints.setAnchor("GridBagConstraints.NORTHWEST");
            boolean theEnabled = true;
            if (APOCTextField.class.isInstance(theVisual)) {
                SwiXMLTextField theTextField = new SwiXMLTextField(theName, this.getActionCommand(this.gProductName, this.gProperty.getDataPath()), thePropValues);
                this.setTheValues(theVisual, theTextField);
                if (0 != theTextField.getColumns()) {
                    theConstraints.setFill("GridBagConstraints.NONE");
                }
                theTextField.setEnabled(theEnabled);
                theTextField.setGridBagConstraints(theConstraints);
                XMLContent.setDynamicContent(theTextField.getSwiXML());
            } else if (APOCTextArea.class.isInstance(theVisual)) {
                SwiXMLTextArea theTextArea = new SwiXMLTextArea(theName, this.getActionCommand(this.gProductName, this.gProperty.getDataPath()), thePropValues);
                this.setTheValues(theVisual, theTextArea);
                theConstraints.setFill("GridBagConstraints.BOTH");
                theConstraints.setWeightY(1);
                theTextArea.setEnabled(theEnabled);
                theTextArea.setGridBagConstraints(theConstraints);
                XMLContent.setDynamicContent(theTextArea.getSwiXML());
            } else if (APOCCheckBox.class.isInstance(theVisual)) {
                SwiXMLCheckBox theCheckBox = new SwiXMLCheckBox(theName, this.getActionCommand(this.gProductName, this.gProperty.getDataPath()), thePropValues);
                this.setTheValues(theVisual, theCheckBox);
                theCheckBox.setEnabled(theEnabled);
                theCheckBox.setGridBagConstraints(theConstraints);
                XMLContent.setDynamicContent(theCheckBox.getSwiXML());
            } else if (APOCComboBox.class.isInstance(theVisual)) {
                SwiXMLComboBox theComboBox = new SwiXMLComboBox(theName, this.getActionCommand(this.gProductName, this.gProperty.getDataPath()), thePropValues);
                this.setTheValues(theVisual, theComboBox);
                theComboBox.setEnabled(theEnabled);
                theComboBox.setGridBagConstraints(theConstraints);
                XMLContent.setDynamicContent(theComboBox.getSwiXML());
            } else if (APOCRadioButton.class.isInstance(theVisual)) {
                List<APOCConstraints> theAPOCConstraints = this.gProperty.getConstraints();
                for (APOCConstraints theCons : theAPOCConstraints) {
                    if (!(theCons instanceof APOCEnumerationConstraint)) continue;
                    Map<Object, Object> theEnumMap = ((APOCEnumerationConstraint)theCons).getEnumeration();
                    Map<String, String> theToolTipMap = ((APOCEnumerationConstraint)theCons).getToolTipMap();
                    XMLContent.setDynamicContent("<buttongroup id=\"" + theName + "\" >");
                    int theEnumCount = 0;
                    for (Object theKey : theEnumMap.keySet()) {
                        SwiXMLRadioButton theRadioButton = new SwiXMLRadioButton(theName + theEnumCount++, this.getActionCommand(this.gProductName, this.gProperty.getDataPath()), thePropValues, (String)theEnumMap.get(theKey), (String)theKey);
                        this.setTheValues(theVisual, theRadioButton);
                        theConstraints.setButtonGroupInsets();
                        theRadioButton.setEnabled(theEnabled);
                        theRadioButton.setToolTip(theToolTipMap.get(theKey));
                        theRadioButton.setGridBagConstraints(theConstraints);
                        XMLContent.setDynamicContent(theRadioButton.getSwiXML());
                        if (0 == theEnumCount) continue;
                        theConstraints.incrementGridY();
                    }
                    XMLContent.setDynamicContent("</buttongroup>");
                }
            } else if (APOCPassword.class.isInstance(theVisual)) {
                SwiXMLPasswordField thePasswordField = new SwiXMLPasswordField(theName, this.getActionCommand(this.gProductName, this.gProperty.getDataPath()), thePropValues);
                this.setTheValues(theVisual, thePasswordField);
                if (0 != thePasswordField.getColumns()) {
                    theConstraints.setFill("GridBagConstraints.NONE");
                }
                thePasswordField.setEnabled(theEnabled);
                thePasswordField.setGridBagConstraints(theConstraints);
                XMLContent.setDynamicContent(thePasswordField.getSwiXML());
            } else if (APOCDirectorySelector.class.isInstance(theVisual)) {
                SwiXMLDirectorySelector theDirectorySelector = new SwiXMLDirectorySelector(theName, this.getActionCommand(this.gProductName, this.gProperty.getDataPath()), thePropValues);
                this.setTheValues(theVisual, theDirectorySelector);
                theDirectorySelector.setEnabled(theEnabled);
                theDirectorySelector.setGridBagConstraints(theConstraints);
                theDirectorySelector.setFileSelector(((APOCDirectorySelector)theVisual).isFileSelector());
                XMLContent.setDynamicContent(theDirectorySelector.getSwiXML());
            } else if (APOCProgressBar.class.isInstance(theVisual)) {
                SwiXMLProgressBar theProgressBar = new SwiXMLProgressBar(theName, this.getActionCommand(this.gProductName, this.gProperty.getDataPath()), thePropValues);
                this.setTheValues(theVisual, theProgressBar);
                theProgressBar.setEnabled(theEnabled);
                theProgressBar.setGridBagConstraints(theConstraints);
                XMLContent.setDynamicContent(theProgressBar.getSwiXML());
            } else if (APOCTextPanel.class.isInstance(theVisual)) {
                SwiXMLTextPanel theTextPanel = new SwiXMLTextPanel(theName, this.getActionCommand(this.gProductName, this.gProperty.getDataPath()), thePropValues);
                this.setTheValues(theVisual, theTextPanel);
                theTextPanel.setEnabled(theEnabled);
                theConstraints.setGridWidth(3);
                theTextPanel.setGridBagConstraints(theConstraints);
                XMLContent.setDynamicContent(theTextPanel.getSwiXML());
            } else if (APOCHtmlPanel.class.isInstance(theVisual)) {
                SwiXMLHTMLPanel theHTMLPanel = new SwiXMLHTMLPanel(theName, this.getActionCommand(this.gProductName, this.gProperty.getDataPath()), thePropValues);
                this.setTheValues(theVisual, theHTMLPanel);
                theConstraints.setGridWidth(3);
                theHTMLPanel.setEnabled(theEnabled);
                theHTMLPanel.setGridBagConstraints(theConstraints);
                XMLContent.setDynamicContent(theHTMLPanel.getSwiXML());
            } else if (APOCButton.class.isInstance(theVisual)) {
                SwiXMLButton theButton = new SwiXMLButton(theName, this.getActionCommand(this.gProductName, this.gProperty.getDataPath()), thePropValues);
                this.setTheValues(theVisual, theButton);
                theButton.setEnabled(theEnabled);
                theConstraints.setAnchor(theButton.getHAlignment());
                theConstraints.setFill("GridBagConstraints.NONE");
                theButton.setGridBagConstraints(theConstraints);
                XMLContent.setDynamicContent(theButton.getSwiXML());
            } else if (APOCStringList.class.isInstance(theVisual)) {
                SwiXMLStringList theStringList = new SwiXMLStringList(theName, this.getActionCommand(this.gProductName, this.gProperty.getDataPath()), thePropValues);
                this.setTheValues(theVisual, theStringList);
                theStringList.setEnabled(theEnabled);
                theStringList.setGridBagConstraints(theConstraints);
                XMLContent.setDynamicContent(theStringList.getSwiXML());
            } else if (APOCSlideShow.class.isInstance(theVisual)) {
                SwiXMLSlideShow theStringList = new SwiXMLSlideShow(theName);
                this.setTheValues(theVisual, theStringList);
                theStringList.setEnabled(theEnabled);
                theConstraints.setWeightX(1);
                theConstraints.setWeightY(1);
                theConstraints.setFill("GridBagConstraints.NONE");
                theConstraints.setAnchor("GridBagConstraints.NORTH");
                theConstraints.removeLabelInsets();
                theStringList.setGridBagConstraints(theConstraints);
                XMLContent.setDynamicContent(theStringList.getSwiXML());
            } else if (APOCProductsSelector.class.isInstance(theVisual)) {
                SwiXMLProductsSelector thePsp = new SwiXMLProductsSelector(theName);
                this.setTheValues(theVisual, thePsp);
                theConstraints.setWeightX(1);
                theConstraints.setWeightY(1);
                theConstraints.setFill("GridBagConstraints.BOTH");
                theConstraints.setAnchor("GridBagConstraints.NORTH");
                theConstraints.removeLabelInsets();
                thePsp.setGridBagConstraints(theConstraints);
                XMLContent.setDynamicContent(thePsp.getSwiXML());
            } else assert (false) : "Visual type " + theVisual.toString() + " is not implemented";
        }
        return theConstraints.getGridY();
    }

    private void setTheValues(Object aAPOCObject, Object aSwiXMLObject) {
        Class<?> theAPOCClass = aAPOCObject.getClass();
        Class<?> theSwiXMLClass = aSwiXMLObject.getClass();
        Method[] theAPOCMethods = theAPOCClass.getMethods();
        for (int theAPOCCount = 0; theAPOCCount < theAPOCMethods.length; ++theAPOCCount) {
            LogRecord theRec;
            String theAPOCMethodName = theAPOCMethods[theAPOCCount].getName();
            Class<?> theAPOCReturnType = theAPOCMethods[theAPOCCount].getReturnType();
            if (!theAPOCMethodName.startsWith("get") || theAPOCMethodName.equalsIgnoreCase("getclass")) continue;
            String theSwiXMLMethodname = theAPOCMethodName.replaceFirst("get", "set");
            try {
                Method theAPOCMethod = theAPOCClass.getMethod(theAPOCMethodName, null);
                Object theResult = theAPOCMethod.invoke(aAPOCObject, (Object[])null);
                Method theSwiXMLMethod = theSwiXMLClass.getMethod(theSwiXMLMethodname, theAPOCReturnType);
                theSwiXMLMethod.invoke(aSwiXMLObject, theResult);
                continue;
            }
            catch (IllegalArgumentException theException) {
                theRec = new LogRecord(Level.WARNING, "INCONSISTENT_UI");
                theRec.setParameters(new String[]{"MISMATCHING_METHOD=" + theAPOCMethodName});
                theRec.setThrown(theException);
                continue;
            }
            catch (IllegalAccessException theException) {
                theRec = new LogRecord(Level.WARNING, "INCONSISTENT_UI");
                theRec.setParameters(new String[]{"MISMATCHING_METHOD=" + theAPOCMethodName});
                theRec.setThrown(theException);
                continue;
            }
            catch (InvocationTargetException theException) {
                theRec = new LogRecord(Level.WARNING, "INCONSISTENT_UI");
                theRec.setParameters(new String[]{"MISMATCHING_METHOD=" + theAPOCMethodName});
                theRec.setThrown(theException);
                continue;
            }
            catch (SecurityException theException) {
                theRec = new LogRecord(Level.WARNING, "INCONSISTENT_UI");
                theRec.setParameters(new String[]{"MISMATCHING_METHOD=" + theAPOCMethodName});
                theRec.setThrown(theException);
                continue;
            }
            catch (NoSuchMethodException theException) {
                theRec = new LogRecord(Level.WARNING, "INCONSISTENT_UI");
                theRec.setParameters(new String[]{"MISMATCHING_METHOD=" + theAPOCMethodName});
                theRec.setThrown(theException);
            }
        }
    }

    private String getActionCommand(String aProductName, String aDataPath) {
        return aProductName + "." + aDataPath;
    }
}

