/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.wizard;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jdom.Attribute;
import org.openinstaller.bindings.ui.pagesequence.Page;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.contracts.product.ProductNodeInterface;
import org.openinstaller.provider.conf.ConfigControl;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.conf.apoc.APOCCategory;
import org.openinstaller.provider.conf.apoc.APOCConstraints;
import org.openinstaller.provider.conf.apoc.APOCEnumerationConstraint;
import org.openinstaller.provider.conf.apoc.APOCPage;
import org.openinstaller.provider.conf.apoc.APOCProperty;
import org.openinstaller.provider.conf.apoc.APOCRadioButton;
import org.openinstaller.provider.conf.apoc.APOCScriptHandler;
import org.openinstaller.provider.conf.apoc.APOCSection;
import org.openinstaller.provider.conf.apoc.APOCTemplate;
import org.openinstaller.provider.conf.oor.Constraint;
import org.openinstaller.provider.ui.UserInterfaceWizard;
import org.openinstaller.provider.ui.ViewMode;
import org.openinstaller.provider.ui.custom.OpenInstallerDirectoryChooser;
import org.openinstaller.provider.ui.custom.TagRegisterer;
import org.openinstaller.provider.ui.sequencer.GlobalPageSequence;
import org.openinstaller.provider.ui.swixgen.SwiXMLBuilder;
import org.openinstaller.provider.ui.swixgen.SwiXMLProperty;
import org.openinstaller.provider.ui.swixgen.XMLContent;
import org.openinstaller.provider.ui.wizard.AbstractWizard;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Msg;
import org.openinstaller.util.Scripting;
import org.openinstaller.util.StringUtils;
import org.openinstaller.util.logging.LogUtils;
import org.swixml.SwingEngine;
import org.swixml.converters.ColorConverter;

public class GUIWizard
extends AbstractWizard
implements ActionListener,
WindowListener {
    public JFrame gFrame;
    public Component gLeftPanel;
    public JPanel gLeftPanelHolder;
    public ButtonGroup gBtnGroup;
    public Component gContentComponent;
    public JPanel gContentComponentHolder;
    public JPanel gNavButtonsPanelHolder;
    public Component gNavButtonsPanel;
    public Component gMainPanel;
    public JButton gBtnExit;
    public JButton gBtnCancel;
    public JButton gBtnHelp;
    public JButton gBtnNext;
    public JButton gBtnBack;
    public JTabbedPane gTabPane;
    public SwingEngine gSwix;
    private Thread gOnloadThread;
    private static Properties gAnswerfileProps;
    private static UserInterfaceWizard gWizard;

    private GUIWizard() {
    }

    public static UserInterfaceWizard getInstance(URL[] aAnswerFileURLs) throws EnhancedException {
        if (null != gWizard) {
            return gWizard;
        }
        if (aAnswerFileURLs != null) {
            gAnswerfileProps = new Properties();
            for (URL theURL : aAnswerFileURLs) {
                try {
                    gAnswerfileProps.load(theURL.openStream());
                }
                catch (IOException theException) {
                    throw new EnhancedException("COULD_NOT_LOAD_ANSWER_FILE", (Throwable)theException, new String[0]);
                }
            }
        }
        gWizard = new GUIWizard();
        return gWizard;
    }

    public void start() throws EnhancedException {
        this.gSwix = new SwingEngine((Object)this);
        TagRegisterer.register(this.gSwix);
        this.gSwiXMLBuilder = new SwiXMLBuilder(this.getViewMode());
        if (gAnswerfileProps != null) {
            try {
                GUIWizard.setInitialProperties(gAnswerfileProps);
            }
            catch (EnhancedException theEx) {
                String theMsg = Msg.get((String)"CANT_SET_INIT_PROPERTIES", (Object[])new Object[]{EnhancedException.getLastCause((Throwable)theEx).getLocalizedMessage()});
                JOptionPane.showMessageDialog(null, StringUtils.wrap((String)theMsg, (int)75), Msg.get((String)"ERROR", (Object[])new Object[0]), 0);
                try {
                    this.gBus.publishEvent(new BusEvent("shutdown"));
                    return;
                }
                catch (InvalidArgumentException theEIAEx) {
                    LOGGER.log(Level.SEVERE, "BUS_EVENT_REQ_FAILED", theEIAEx);
                }
            }
        }
        this.goToNextUnskippedPage();
    }

    public void clickNext() throws EnhancedException {
        if (this.gBtnNext != null) {
            this.gBtnNext.doClick();
        } else {
            LOGGER.fine("*** WARNING: \"Next\" button click requested when the button is not present on the page");
        }
    }

    public void clickBack() throws EnhancedException {
        if (this.gBtnBack != null) {
            this.gBtnBack.doClick();
        } else {
            LOGGER.fine("*** WARNING: \"Back\" button click requested when the button is not present on the page");
        }
    }

    public void setNextButtonText(String aText) {
        if (this.gBtnNext != null) {
            this.gBtnNext.setText(aText);
            this.gBtnNext.setActionCommand("AC_NEXT");
        }
    }

    public void setBackButtonText(String aText) {
        if (this.gBtnBack != null) {
            this.gBtnBack.setText(aText);
            this.gBtnBack.setActionCommand("AC_BACK");
        }
    }

    public void setCancelButtonText(String aText) {
        if (this.gBtnCancel != null) {
            this.gBtnCancel.setText(aText);
            this.gBtnCancel.setActionCommand("AC_CANCEL");
        }
    }

    public void setHelpButtonText(String aText) {
        if (this.gBtnHelp != null) {
            this.gBtnHelp.setText(aText);
            this.gBtnHelp.setActionCommand("AC_HELP");
        }
    }

    public ViewMode getViewMode() {
        return ViewMode.GUI;
    }

    public void actionPerformed(ActionEvent e) {
        block19: {
            LOGGER.fine("Received an ActionEvent " + e.toString());
            String theActionCommand = e.getActionCommand();
            try {
                if (theActionCommand == null) {
                    throw new EnhancedException("NULL_ACTION_COMMAND_RECEIVED", new String[]{"ACTION_COMMAND=(null)"});
                }
                if ("AC_NEXT".equals(theActionCommand) || "AC_BACK".equals(theActionCommand) || "AC_EXIT".equals(theActionCommand) || "AC_CANCEL".equals(theActionCommand) || "AC_HELP".equals(theActionCommand)) {
                    this.processNavEvent(theActionCommand);
                    break block19;
                }
                Object theSource = e.getSource();
                String theName = theActionCommand.substring(theActionCommand.lastIndexOf(".") + 1);
                APOCScriptHandler theScriptHandler = this.gAPOCTemplate.getHandlerForProperty(theName);
                if (null != theScriptHandler) {
                    String theScriptLanguage = theScriptHandler.getScriptLanguage();
                    if (!"beanshell".equals(theScriptLanguage)) {
                        LOGGER.severe("Scripting language " + theScriptLanguage + " is not supported");
                        return;
                    }
                    String theScript = theScriptHandler.getScriptCode();
                    LOGGER.fine("Loading the bsh script");
                    Throwable theBshError = null;
                    try {
                        try {
                            Interpreter theInterpreter = this.getInterpreter();
                            ActionListener theActionListener = (ActionListener)theInterpreter.eval(theScript);
                            theActionListener.actionPerformed(e);
                            break block19;
                        }
                        catch (TargetError theTargetError) {
                            Throwable theCause = theTargetError.getTarget();
                            theBshError = theCause;
                            throw new EnhancedException("SCRIPT_FAILED", theCause, new String[]{"error=" + theTargetError.getErrorText(), "errorline=" + theTargetError.getErrorLineNumber(), "file=" + theTargetError.getErrorSourceFile()});
                        }
                        catch (ParseException theParseException) {
                            theBshError = theParseException;
                            theParseException.printStackTrace();
                            throw new EnhancedException("SCRIPT_UNPARSEABLE", (Throwable)theParseException, new String[]{"error=" + theParseException.getErrorText(), "errorline=" + theParseException.getErrorLineNumber(), "file=" + theParseException.getErrorSourceFile()});
                        }
                        catch (EvalError theEvalError) {
                            theBshError = theEvalError;
                            throw new EnhancedException("SCRIPT_NOT_INVOKEABLE", theEvalError.getCause(), new String[]{"error=" + theEvalError.getErrorText(), "errorline=" + theEvalError.getErrorLineNumber(), "file=" + theEvalError.getErrorSourceFile()});
                        }
                    }
                    catch (Exception theEx) {
                        throw new EnhancedException("SCRIPT_NOT_INVOKEABLE", theBshError, new String[]{"component=" + theName});
                    }
                }
                if (null == theActionCommand || "".equals(theActionCommand) || "AC_NONE".equals(theActionCommand)) break block19;
                if (theSource instanceof JPasswordField) {
                    ConfigHelper.setValue(theActionCommand, new String(((JPasswordField)theSource).getPassword()));
                    break block19;
                }
                if (theSource instanceof JTextField) {
                    ConfigHelper.setValue(theActionCommand, ((JTextField)theSource).getText());
                    break block19;
                }
                if (theSource instanceof JButton) {
                    ConfigHelper.setValue(theActionCommand, ((JButton)theSource).getText());
                    break block19;
                }
                if (theSource instanceof JToggleButton) {
                    ConfigHelper.setValue(theActionCommand, ((JToggleButton)theSource).getName());
                    break block19;
                }
                if (theSource instanceof JList) {
                    JList theList = (JList)theSource;
                    ConfigHelper.setValue(theActionCommand, Arrays.asList(theList.getSelectedValues()));
                    break block19;
                }
                throw new EnhancedException("UNIMPLEMENTED_FIELD_ACTION ", new String[]{"source=" + theSource});
            }
            catch (EnhancedException theException) {
                LOGGER.log(Level.SEVERE, "INTERNAL_ERROR_OCCURED", theException);
                JOptionPane.showMessageDialog(this.gFrame, StringUtils.wrap((String)Msg.get((String)"INTERNAL_FATAL_ERROR", (Object[])new Object[]{EnhancedException.getLastCause((Throwable)theException).getLocalizedMessage()}), (int)75), Msg.get((String)"ERROR", (Object[])new Object[0]), 0);
                try {
                    this.gBus.publishEvent(new BusEvent("shutdown"));
                }
                catch (InvalidArgumentException theEIAEx) {
                    LOGGER.log(Level.SEVERE, "BUS_EVENT_REQ_FAILED", theEIAEx);
                }
            }
        }
    }

    private void processNavEvent(String aActionCommand) {
        try {
            if ("AC_NEXT".equalsIgnoreCase(aActionCommand)) {
                Constraint theConstraint = null;
                String theViewName = GlobalPageSequence.getCurrentPageName();
                List<APOCProperty> theUIProperties = ConfigHelper.getUIProperties(theViewName);
                boolean theNextPage = true;
                for (APOCProperty theVar : theUIProperties) {
                    String theVarName = theVar.getName();
                    String theDataPath = theVar.getDataPath();
                    if ("".equals(theDataPath)) {
                        LOGGER.fine("Skipping variable with no datapath.");
                        continue;
                    }
                    String theSettableVarName = theViewName + "." + theDataPath;
                    if (APOCRadioButton.class.isInstance(theVar.getVisual().getType())) {
                        List<APOCConstraints> theAPOCConstraints = theVar.getConstraints();
                        block11: for (APOCConstraints theCons : theAPOCConstraints) {
                            if (!(theCons instanceof APOCEnumerationConstraint)) continue;
                            Map<Object, Object> theEnumMap = ((APOCEnumerationConstraint)theCons).getEnumeration();
                            for (Object theKey : theEnumMap.keySet()) {
                                if (!((JRadioButton)GUIWizard.getComponentByName((Container)this.gContentComponent, (String)theKey)).isSelected()) continue;
                                theVarName = (String)theKey;
                                continue block11;
                            }
                        }
                    }
                    LOGGER.fine("About to deal with variable " + theVarName);
                    Component theComponent = GUIWizard.getComponentByName((Container)this.gContentComponent, theVarName);
                    Attribute theAttr = new Attribute("colorcode", (String)this.gSwiXMLBuilder.getFromDataModel("error_background_color"));
                    try {
                        JList theList;
                        if (theVarName.equals("PRODUCT_SELECTION")) {
                            theList = (JList)theComponent;
                            StringBuffer theBuffer = new StringBuffer();
                            Enumeration theEnum = ((DefaultListModel)theList.getModel()).elements();
                            while (theEnum.hasMoreElements()) {
                                theBuffer.append(((ProductNodeInterface)theEnum.nextElement()).getID());
                                if (!theEnum.hasMoreElements()) continue;
                                theBuffer.append(",");
                            }
                            LOGGER.finest("Setting value from ProductSelectionPage to [" + theBuffer.toString() + "]");
                            theConstraint = ConfigHelper.setValue(theSettableVarName, ConfigHelper.thaw(theBuffer.toString(), ConfigHelper.getType(theSettableVarName)));
                        } else if (theComponent instanceof JPasswordField) {
                            theConstraint = ConfigHelper.setValue(theSettableVarName, ConfigHelper.thaw(new String(((JPasswordField)theComponent).getPassword()), ConfigHelper.getType(theSettableVarName)));
                        } else if (theComponent instanceof JTextField) {
                            theConstraint = ConfigHelper.setValue(theSettableVarName, ConfigHelper.thaw(((JTextField)theComponent).getText(), ConfigHelper.getType(theSettableVarName)));
                        } else if (theComponent instanceof JTextArea) {
                            theConstraint = ConfigHelper.setValue(theSettableVarName, ConfigHelper.thaw(((JTextArea)theComponent).getText(), ConfigHelper.getType(theSettableVarName)));
                        } else if (theComponent instanceof JComboBox) {
                            theConstraint = ConfigHelper.setValue(theSettableVarName, ConfigHelper.thaw((String)((JComboBox)theComponent).getSelectedItem(), ConfigHelper.getType(theSettableVarName)));
                        } else if (theComponent instanceof JButton) {
                            theConstraint = ConfigHelper.setValue(theSettableVarName, ConfigHelper.thaw(((JButton)theComponent).getText(), ConfigHelper.getType(theSettableVarName)));
                        } else if (theComponent instanceof JCheckBox) {
                            theConstraint = ConfigHelper.setValue(theSettableVarName, ((JCheckBox)theComponent).isSelected());
                        } else if (theComponent instanceof JList) {
                            theList = (JList)theComponent;
                            theConstraint = ConfigHelper.setValue(theSettableVarName, Arrays.asList(theList.getSelectedValues()));
                        } else if (theComponent instanceof OpenInstallerDirectoryChooser) {
                            theConstraint = ConfigHelper.setValue(theSettableVarName, ((OpenInstallerDirectoryChooser)theComponent).getText());
                        } else if (theComponent instanceof JRadioButton) {
                            theConstraint = ConfigHelper.setValue(theSettableVarName, ((JRadioButton)theComponent).getName());
                        } else {
                            throw new EnhancedException("UNIMPLEMENTED_FIELD_TYPE", new String[]{"component=" + theComponent, "variable=" + theSettableVarName});
                        }
                        if (null != theConstraint) {
                            theNextPage = false;
                            String theVarDesc = theVar.getLabel();
                            if (null == theVarDesc) {
                                theVarDesc = theVar.getName();
                            }
                            String theLocalizedVarDesc = Msg.get((String)theVarDesc, (Object[])new Object[0]);
                            String theMsg = Msg.get((String)"INVALID_CONFIG_SETTING", (Object[])new Object[]{theLocalizedVarDesc, theConstraint.getLastViolation()});
                            LOGGER.log(Level.FINE, theMsg);
                            JOptionPane.showMessageDialog(this.gFrame, StringUtils.wrap((String)theMsg, (int)75));
                            if (theComponent instanceof OpenInstallerDirectoryChooser) {
                                ((OpenInstallerDirectoryChooser)theComponent).getTextField().setBackground((Color)ColorConverter.conv(Color.class, (Attribute)theAttr));
                            } else {
                                theComponent.setBackground((Color)ColorConverter.conv(Color.class, (Attribute)theAttr));
                            }
                            this.gMainPanel.repaint();
                        }
                        this.gMainPanel.repaint();
                    }
                    catch (EnhancedException theException) {
                        Throwable theCause;
                        theNextPage = false;
                        String theVarDesc = theVar.getLabel();
                        if (null == theVarDesc) {
                            theVarDesc = theVar.getName();
                        }
                        if (null == (theCause = theException.getCause())) {
                            theCause = theException;
                        }
                        String theLocalizedVarDesc = Msg.get((String)theVarDesc, (Object[])new Object[0]);
                        String theMsg = Msg.get((String)"INVALID_CONFIG_SETTING", (Object[])new Object[]{theLocalizedVarDesc, EnhancedException.getLastCause((Throwable)theCause).getLocalizedMessage()});
                        LOGGER.log(Level.FINE, "Could not set config value", theCause);
                        JOptionPane.showMessageDialog(this.gFrame, StringUtils.wrap((String)theMsg, (int)75));
                        if (theComponent instanceof OpenInstallerDirectoryChooser) {
                            ((OpenInstallerDirectoryChooser)theComponent).getTextField().setBackground((Color)ColorConverter.conv(Color.class, (Attribute)theAttr));
                        } else {
                            theComponent.setBackground((Color)ColorConverter.conv(Color.class, (Attribute)theAttr));
                        }
                        this.gMainPanel.repaint();
                    }
                }
                if (null == theConstraint && theNextPage) {
                    this.goToNextUnskippedPage();
                }
            } else if ("AC_BACK".equals(aActionCommand)) {
                this.goToPreviousUnskippedPage();
            } else if ("AC_EXIT".equals(aActionCommand)) {
                LOGGER.fine("User requested shutdown");
                this.gFrame.dispose();
                try {
                    this.gBus.publishEvent(new BusEvent("shutdown"));
                }
                catch (InvalidArgumentException theEIAEx) {
                    LOGGER.log(Level.SEVERE, "BUS_EVENT_REQ_FAILED", theEIAEx);
                }
            } else if ("AC_CANCEL".equals(aActionCommand)) {
                String theMessage = Msg.get((String)"CONFIRM_EXIT_MESSAGE", (Object[])new Object[0]);
                int theOption = JOptionPane.showConfirmDialog(this.gFrame, StringUtils.wrap((String)theMessage, (int)75), Msg.get((String)"CONFIRM_EXIT_TITLE", (Object[])new Object[0]), 0);
                if (0 == theOption) {
                    LOGGER.fine("User requested shutdown");
                    this.gFrame.dispose();
                    try {
                        this.gBus.publishEvent(new BusEvent("shutdown"));
                    }
                    catch (InvalidArgumentException theEIAEx) {
                        LOGGER.log(Level.SEVERE, "BUS_EVENT_REQ_FAILED", theEIAEx);
                    }
                }
            } else if ("AC_HELP".equals(aActionCommand)) {
                JOptionPane.showMessageDialog(this.gFrame, "Help not available", "Installer", 1);
            }
        }
        catch (EnhancedException theEx) {
            theEx.addContext("command=" + aActionCommand, new String[0]);
            LogUtils.log((Logger)LOGGER, (Level)Level.WARNING, (String)"CANNOT_PARSE_NAV_EVENT", (Throwable)theEx, (String[])new String[]{"command=" + aActionCommand, "error=" + EnhancedException.getLastCause((Throwable)theEx).getLocalizedMessage()});
            JOptionPane.showMessageDialog(this.gFrame, StringUtils.wrap((String)Msg.get((String)"INTERNAL_FATAL_ERROR", (Object[])new Object[]{EnhancedException.getLastCause((Throwable)theEx).getLocalizedMessage()}), (int)75), Msg.get((String)"ERROR", (Object[])new Object[0]), 0);
            this.gFrame.dispose();
            try {
                this.gBus.publishEvent(new BusEvent("shutdown"));
            }
            catch (InvalidArgumentException theEIAEx) {
                LOGGER.log(Level.SEVERE, "BUS_EVENT_REQ_FAILED", theEIAEx);
            }
        }
    }

    private void flipGroup() throws EnhancedException {
        Component[] theComp;
        if (null != this.gFrame) {
            this.gFrame.setCursor(new Cursor(3));
        }
        if (null != this.gOnloadThread) {
            try {
                this.gOnloadThread.join(1000L);
            }
            catch (InterruptedException theException) {
                LOGGER.log(Level.FINE, "Caught exception during onLoad", theException);
            }
        }
        this.gOnloadThread = null;
        String thePageName = GlobalPageSequence.getCurrentPageName();
        LOGGER.fine("About to change to " + thePageName);
        BusRequest theGetAPOCTemplateRequest = new BusRequest("First Request", (Object)new ConfigControl(ConfigControl.ConfigCommand.GET_CONFIG_UI_MODEL, thePageName));
        BusResponse theBusResponse = this.gBus.publishRequest(theGetAPOCTemplateRequest, "svc://general/conf");
        this.gAPOCTemplate = (APOCTemplate)theBusResponse.getResult();
        if (null == this.gAPOCTemplate) {
            throw new EnhancedException("APOC_TEMPLATE_NULL", new String[]{"page=" + thePageName});
        }
        this.populateDataModel();
        if (null == this.gFrame) {
            String theString = this.gSwiXMLBuilder.getFrameContent();
            try {
                LOGGER.fine("About to render main frame\n" + theString);
                this.gFrame = (JFrame)this.gSwix.render((Reader)new StringReader(theString));
                this.gFrame.setLocationRelativeTo(null);
                this.gFrame.addWindowListener(this);
            }
            catch (Exception theException) {
                throw new EnhancedException("SWIXML_RENDERING_ERROR", (Throwable)theException, new String[]{"frame=main frame"});
            }
        } else if (null != this.gMainPanel) {
            this.gFrame.remove(this.gMainPanel);
        }
        this.gMainPanel = this.generateContentComponent(this.gAPOCTemplate);
        for (Component theOuterComp : theComp = ((Container)this.gMainPanel).getComponents()) {
            Component[] theCompHolder;
            if (!"gContentComponentHolder".equals(theOuterComp.getName())) continue;
            for (Component theContentComponent : theCompHolder = ((Container)theOuterComp).getComponents()) {
                if (!"gContentComponent".equals(theContentComponent.getName())) continue;
                this.gContentComponent = theContentComponent;
            }
            break;
        }
        this.disableAllButtons();
        this.gFrame.add(this.gMainPanel);
        this.gFrame.repaint();
        this.gFrame.getContentPane().validate();
        this.gSwix.setActionListener((Component)this.gFrame, (ActionListener)this);
        this.gFrame.setVisible(true);
        this.gFrame.setCursor(new Cursor(0));
        try {
            this.runLoop(this.gAPOCTemplate);
        }
        catch (EnhancedException theEx) {
            this.gFrame.setCursor(new Cursor(0));
            LOGGER.log(Level.SEVERE, "ERROR", theEx);
            String theMsg = Msg.get((String)"SEVERE_USER_ERROR", (Object[])new Object[]{EnhancedException.getLastCause((Throwable)theEx).getLocalizedMessage()});
            JOptionPane.showMessageDialog(this.gFrame, StringUtils.wrap((String)theMsg, (int)75), Msg.get((String)"ERROR", (Object[])new Object[0]), 0);
            try {
                this.gBus.publishEvent(new BusEvent("shutdown"));
            }
            catch (InvalidArgumentException theEIAEx) {
                LOGGER.log(Level.SEVERE, "BUS_EVENT_REQ_FAILED", theEIAEx);
            }
        }
        this.gFrame.setCursor(new Cursor(0));
    }

    private void runLoop(APOCTemplate aAPOCTemplate) throws EnhancedException {
        APOCScriptHandler theScriptHandler = aAPOCTemplate.getCategory().getPage().getScriptHandler();
        if (null != theScriptHandler) {
            String theProductName = GlobalPageSequence.getCurrentPageName();
            ConfigHelper.doTrigger(theProductName);
            String theScriptLanguage = theScriptHandler.getScriptLanguage();
            if (!"beanshell".equals(theScriptLanguage)) {
                throw new EnhancedException("SCRIPTING_LANGUAGE_NOT_SUPPORTED", new String[]{"method=" + ClassUtils.getMethodName(), "script-language=" + theScriptLanguage});
            }
            String theScript = theScriptHandler.getScriptCode();
            Throwable theBshError = null;
            try {
                try {
                    Interpreter theInterpreter = this.getInterpreter();
                    Runnable theRunnable = (Runnable)theInterpreter.eval(theScript);
                    this.gOnloadThread = new Thread(theRunnable);
                    this.gOnloadThread.start();
                }
                catch (TargetError theTargetError) {
                    Throwable theCause = theTargetError.getTarget();
                    theBshError = theCause;
                    throw new EnhancedException("SCRIPT_FAILED", theCause, new String[]{"error=" + theTargetError.getErrorText(), "errorline=" + theTargetError.getErrorLineNumber(), "file=" + theTargetError.getErrorSourceFile()});
                }
                catch (ParseException theParseException) {
                    theBshError = theParseException;
                    throw new EnhancedException("SCRIPT_UNPARSEABLE", (Throwable)theParseException, new String[]{"error=" + theParseException.getErrorText(), "errorline=" + theParseException.getErrorLineNumber(), "file=" + theParseException.getErrorSourceFile()});
                }
                catch (EvalError theEvalError) {
                    theBshError = theEvalError;
                    throw new EnhancedException("SCRIPT_NOT_INVOKEABLE", theEvalError.getCause(), new String[]{"error=" + theEvalError.getErrorText(), "errorline=" + theEvalError.getErrorLineNumber(), "file=" + theEvalError.getErrorSourceFile()});
                }
            }
            catch (Exception theEx) {
                throw new EnhancedException("SCRIPT_NOT_INVOKEABLE", theBshError, new String[]{"component=" + aAPOCTemplate.getName()});
            }
        }
    }

    private String generateConfigUI(APOCSection aSection) throws EnhancedException {
        XMLContent.flush();
        int theCount = aSection.getProperties().size();
        int theGridIncrementor = 0;
        for (int theIndex = 0; theIndex < theCount; ++theIndex) {
            APOCProperty theAPOCProperty = aSection.getProperties().get(theIndex);
            theGridIncrementor = new SwiXMLProperty(theAPOCProperty, this.gAPOCTemplate.getName()).processProperty(theIndex + theGridIncrementor);
        }
        return XMLContent.getDynamicContent();
    }

    private Component generateContentComponent(APOCTemplate aTemplate) throws EnhancedException {
        try {
            APOCCategory theCategory = aTemplate.getCategory();
            APOCPage thePage = theCategory.getPage();
            List<APOCSection> theSections = thePage.getSections();
            ArrayList<String> theSectionNames = new ArrayList<String>();
            ArrayList<String> theDynamicContents = new ArrayList<String>();
            for (APOCSection theSection : theSections) {
                theSectionNames.add(theSection.getName());
                theDynamicContents.add(this.generateConfigUI(theSection));
            }
            this.gSwiXMLBuilder.replaceInDataModel("sections", theSectionNames);
            for (int theIndex = 0; theIndex < theSectionNames.size(); ++theIndex) {
                this.gSwiXMLBuilder.replaceInDataModel((String)theSectionNames.get(theIndex), theDynamicContents.get(theIndex));
            }
            String theString = this.gSwiXMLBuilder.getDynamicContent();
            LOGGER.fine("About to render content area\n" + theString);
            return this.gSwix.render((Reader)new StringReader(theString));
        }
        catch (Exception theException) {
            throw new EnhancedException("SWIXML_RENDERING_ERROR", (Throwable)theException, new String[]{"frame=content area"});
        }
    }

    public void windowOpened(WindowEvent e) {
        LOGGER.finest("Attempting to load EDT debugger");
        this.startEventQueueWatchdog();
    }

    public void windowClosing(WindowEvent e) {
        this.processNavEvent("Exit");
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void enableNext(boolean aEnabled) {
        if (this.gBtnNext != null) {
            this.gBtnNext.setEnabled(aEnabled);
        }
    }

    public void enableBack(boolean aEnabled) {
        if (this.gBtnBack != null) {
            this.gBtnBack.setEnabled(aEnabled);
        }
    }

    public void enableCancel(boolean aEnabled) {
        if (this.gBtnCancel != null) {
            this.gBtnCancel.setEnabled(aEnabled);
        }
    }

    public void enableHelp(boolean aEnabled) {
        if (this.gBtnHelp != null) {
            this.gBtnHelp.setEnabled(aEnabled);
        }
    }

    public void enableExit(boolean aEnabled) {
        if (this.gBtnExit != null) {
            this.gBtnExit.setEnabled(aEnabled);
        }
    }

    public void disableAllButtons() {
        if (null != this.gBtnBack) {
            this.enableBack(false);
        }
        if (null != this.gBtnNext) {
            this.enableNext(false);
        }
        if (null != this.gBtnCancel) {
            this.enableCancel(false);
        }
        if (null != this.gBtnHelp) {
            this.enableHelp(false);
        }
        if (null != this.gBtnExit) {
            this.enableExit(false);
        }
    }

    public static Component getComponentByName(Container aParent, String aName) {
        Component[] theComponents;
        if (null == aParent) {
            LOGGER.fine("Returning null component for " + aName + "because parent container is null");
            return null;
        }
        LOGGER.finer(aParent.getComponentCount() + " components in " + aParent);
        LOGGER.finer("Looking for a child component named " + aName + " in it.");
        for (Component theComp : theComponents = aParent.getComponents()) {
            if (!aName.equals(theComp.getName())) continue;
            LOGGER.finer("Returning " + theComp);
            return theComp;
        }
        for (Component theComp : theComponents) {
            Component theCompt;
            if (!(theComp instanceof Container) || null == (theCompt = GUIWizard.getComponentByName((Container)theComp, aName))) continue;
            LOGGER.finer("Returning stage 2 " + theComp);
            return theCompt;
        }
        LOGGER.finer("Nothing found. Returning null.");
        return null;
    }

    private Interpreter getInterpreter() throws EnhancedException {
        Interpreter theInterpreter;
        try {
            theInterpreter = Scripting.getInterpreter();
            theInterpreter.set("wizard", (Object)this);
            theInterpreter.set("frame", (Object)this.gFrame);
            theInterpreter.set("nav", (Object)this.gNavButtonsPanel);
            theInterpreter.set("content", (Object)this.gContentComponent);
            theInterpreter.eval("import java.awt.*");
            theInterpreter.eval("import javax.*");
            theInterpreter.eval("import javax.swing.*");
        }
        catch (EvalError theException) {
            EnhancedException theRethrown = new EnhancedException("INTERPRETER_INIT_FAILED", (Throwable)theException, new String[]{"class=" + ClassUtils.getClassName()});
            LOGGER.throwing(ClassUtils.getClassName(), ClassUtils.getMethodName(), theRethrown);
            throw theRethrown;
        }
        catch (Exception theException) {
            EnhancedException theRethrown = new EnhancedException("INTERPRETER_INIT_FAILED", (Throwable)theException, new String[]{"class=" + ClassUtils.getClassName()});
            LOGGER.throwing(ClassUtils.getClassName(), ClassUtils.getMethodName(), theRethrown);
            throw theRethrown;
        }
        return theInterpreter;
    }

    private void goToNextUnskippedPage() throws EnhancedException {
        int theIndex = GlobalPageSequence.getPageIndex();
        LOGGER.fine(ClassUtils.getMethodName() + ": current index is " + theIndex);
        if (theIndex < GlobalPageSequence.getPageCount() - 1) {
            GlobalPageSequence.setPageIndex(theIndex + 1);
            LOGGER.fine(ClassUtils.getMethodName() + ": index flipped to " + GlobalPageSequence.getPageIndex());
            GlobalPageSequence.reanalyzePageSequence(GlobalPageSequence.getCurrentPageName());
            Page thePage = GlobalPageSequence.getPageAtIndex(GlobalPageSequence.getPageIndex());
            if (!this.isSkippable(thePage)) {
                this.flipGroup();
            } else {
                LOGGER.fine("Skipping group " + thePage.getName());
                this.goToNextUnskippedPage();
            }
        } else {
            try {
                this.gBus.publishEvent(new BusEvent("shutdown"));
            }
            catch (InvalidArgumentException theEIAEx) {
                LOGGER.log(Level.SEVERE, "BUS_EVENT_REQ_FAILED", theEIAEx);
            }
        }
    }

    private void goToPreviousUnskippedPage() throws EnhancedException {
        int theIndex = GlobalPageSequence.getPageIndex();
        if (0 < theIndex) {
            GlobalPageSequence.setPageIndex(theIndex - 1);
            GlobalPageSequence.reanalyzePageSequence(GlobalPageSequence.getCurrentPageName());
            Page thePage = GlobalPageSequence.getPageAtIndex(GlobalPageSequence.getPageIndex());
            if (!this.isSkippable(thePage)) {
                this.flipGroup();
            } else {
                LOGGER.fine("Skipping group " + thePage.getName());
                this.goToPreviousUnskippedPage();
            }
        }
    }
}

