/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration;

import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.RegistrationService;
import com.sun.enterprise.registration.ServiceTag;
import com.sun.enterprise.registration.StringManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryManager {
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private static final String REGISTRATION_REMINDER_TAG = "registration_reminder";
    private static final String REGISTRY_TAG = "registry";
    private static final RegistrationService.RegistrationReminder REGISTRATION_REMINDER_DEFAULT_VALUE = RegistrationService.RegistrationReminder.ASK_FOR_REGISTRATION;
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final DocumentBuilder documentBuilder;
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private final Transformer transformer;
    private File registrationFile = null;
    private Document document = null;
    private Element registryElement = null;

    public RepositoryManager(File registrationFile) throws RegistrationException {
        this.registrationFile = registrationFile;
        try {
            this.logger.fine("RepositoryManager created for file " + registrationFile.getCanonicalPath());
            this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            this.transformer = this.transformerFactory.newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            this.loadOrCreateDocument();
        }
        catch (Exception e) {
            throw new RegistrationException((Throwable)e);
        }
    }

    public List<ServiceTag> getServiceTags() {
        NodeList nodes = this.document.getElementsByTagName("service_tag");
        ArrayList<ServiceTag> serviceTags = new ArrayList<ServiceTag>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elem = (Element)nodes.item(i);
            serviceTags.add(new ServiceTag(elem));
        }
        return serviceTags;
    }

    public RegistrationService.RegistrationStatus getRegistrationStatus() {
        NodeList nodes = this.document.getElementsByTagName("service_tag");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elem = (Element)nodes.item(i);
            RegistrationService.RegistrationStatus rs = RegistrationService.RegistrationStatus.valueOf((String)this.getSubElementValue(elem, "registration_status"));
            if (!rs.equals((Object)RegistrationService.RegistrationStatus.REGISTERED)) continue;
            return rs;
        }
        return RegistrationService.RegistrationStatus.NOT_REGISTERED;
    }

    public void setRegistrationStatus(RegistrationService.RegistrationStatus status) throws RegistrationException {
        NodeList nodes = this.document.getElementsByTagName("service_tag");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elem = (Element)nodes.item(i);
            this.setSubElementValue(elem, "registration_status", status.toString());
        }
        this.writeToFile();
    }

    public RegistrationService.RegistrationReminder getRegistrationReminder() {
        Element regElement = this.findRegistrationReminderElement();
        return RegistrationService.RegistrationReminder.valueOf((String)regElement.getTextContent());
    }

    public void setRegistrationReminder(RegistrationService.RegistrationReminder reminder) throws RegistrationException {
        this.findRegistrationReminderElement().setTextContent(reminder.toString());
        this.writeToFile();
    }

    public void add(ServiceTag serviceTag) throws RegistrationException {
        Element st = this.findServiceTag(serviceTag);
        if (st != null) {
            throw new RegistrationException(StringManager.getString("rpmgr.svrTagExists", new Object[0]));
        }
        st = serviceTag.getElement(this.document);
        Element registrationReminderElement = this.findRegistrationReminderElement();
        if (registrationReminderElement != null) {
            this.registryElement.insertBefore(st, registrationReminderElement);
        } else {
            this.registryElement.appendChild(st);
        }
        this.writeToFile();
    }

    public void remove(ServiceTag serviceTag) throws RegistrationException {
        Element st = this.findServiceTag(serviceTag);
        if (st == null) {
            throw new RegistrationException(StringManager.getString("rpmgr.noSuchSrvTag", new Object[0]));
        }
        this.registryElement.removeChild(st);
        this.writeToFile();
    }

    public void setRegistrationStatus(ServiceTag serviceTag, ServiceTag.RegistrationStatus status) throws RegistrationException {
        Element st = this.findServiceTag(serviceTag);
        if (st == null) {
            throw new RegistrationException(StringManager.getString("rpmgr.noSuchSrvTag", new Object[0]));
        }
        this.setSubElementValue(st, "registration_status", status.toString());
        this.writeToFile();
    }

    public ServiceTag.RegistrationStatus getRegistrationStatus(ServiceTag serviceTag) throws RegistrationException {
        Element st = this.findServiceTag(serviceTag);
        if (st == null) {
            throw new RegistrationException(StringManager.getString("rpmgr.noSuchSrvTag", new Object[0]));
        }
        return ServiceTag.RegistrationStatus.valueOf(this.getSubElementValue(st, "registration_status"));
    }

    public void setStatus(ServiceTag serviceTag, ServiceTag.Status status) throws RegistrationException {
        Element st = this.findServiceTag(serviceTag);
        if (st == null) {
            throw new RegistrationException(StringManager.getString("rpmgr.noSuchSrvTag", new Object[0]));
        }
        this.setSubElementValue(st, "status", status.toString());
        this.writeToFile();
    }

    public ServiceTag.Status getStatus(ServiceTag serviceTag) throws RegistrationException {
        Element st = this.findServiceTag(serviceTag);
        if (st == null) {
            throw new RegistrationException(StringManager.getString("rpmgr.noSuchSrvTag", new Object[0]));
        }
        return ServiceTag.Status.valueOf(this.getSubElementValue(st, "status"));
    }

    public void updateRuntimeValues() throws RegistrationException {
        NodeList nodes = this.document.getElementsByTagName("service_tag");
        ArrayList serviceTags = new ArrayList();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String product_defined_inst_id;
            String platformArch;
            Element elem = (Element)nodes.item(i);
            String instanceURN = this.getSubElementValue(elem, "instance_urn");
            if (instanceURN == null || instanceURN.length() == 0) {
                instanceURN = ServiceTag.getNewInstanceURN();
                this.setSubElementValue(elem, "instance_urn", instanceURN, true);
            }
            if ((platformArch = this.getSubElementValue(elem, "platform_arch")) == null || platformArch.length() == 0) {
                platformArch = System.getProperty("os.arch");
                this.setSubElementValue(elem, "platform_arch", platformArch, true);
            }
            if ((product_defined_inst_id = this.getSubElementValue(elem, "product_defined_inst_id")) != null && product_defined_inst_id.length() != 0) continue;
            product_defined_inst_id = ServiceTag.getDefaultProductDefinedInstID();
            this.setSubElementValue(elem, "product_defined_inst_id", product_defined_inst_id, true);
        }
        this.writeToFile();
    }

    void write(Node node, OutputStream stream) throws RegistrationException {
        try {
            this.transformer.transform(new DOMSource(node), new StreamResult(stream));
        }
        catch (Exception e) {
            throw new RegistrationException((Throwable)e);
        }
    }

    void write(OutputStream stream) throws RegistrationException {
        this.write(this.document, stream);
    }

    private Element findRegistrationReminderElement() {
        Element result = null;
        NodeList nodes = this.document.getElementsByTagName(REGISTRATION_REMINDER_TAG);
        if (nodes.getLength() > 0) {
            result = (Element)nodes.item(0);
        }
        return result;
    }

    private Element findServiceTag(ServiceTag serviceTag) {
        Element result = null;
        NodeList nodes = this.document.getElementsByTagName("service_tag");
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!this.isSameServiceTag(serviceTag, nodes.item(i))) continue;
            result = (Element)nodes.item(i);
            break;
        }
        return result;
    }

    private boolean isSameServiceTag(ServiceTag serviceTag, Node candidateNode) {
        boolean result = false;
        if (candidateNode instanceof Element) {
            Element candidateElement = (Element)candidateNode;
            String productURN = this.getSubElementValue(candidateElement, "product_urn");
            String instanceURN = this.getSubElementValue(candidateElement, "instance_urn");
            if (productURN != null && instanceURN != null) {
                result = productURN.equals(serviceTag.getSvcTag().getProductURN()) && instanceURN.equals(serviceTag.getSvcTag().getInstanceURN());
            }
        }
        return result;
    }

    private String getSubElementValue(Element rootElement, String subElementName) {
        NodeList nodes = rootElement.getElementsByTagName(subElementName);
        if (nodes.getLength() > 0) {
            return ((Element)nodes.item(0)).getTextContent();
        }
        return null;
    }

    private void setSubElementValue(Element rootElement, String subElementName, String value) throws RegistrationException {
        this.setSubElementValue(rootElement, subElementName, value, false);
    }

    private void setSubElementValue(Element rootElement, String subElementName, String value, boolean force) throws RegistrationException {
        NodeList nodes = rootElement.getElementsByTagName(subElementName);
        if (nodes.getLength() > 0) {
            Element subElement = (Element)nodes.item(0);
            subElement.setTextContent(value);
        } else if (force) {
            Element element = this.document.createElement(subElementName);
            element.setTextContent(value);
            rootElement.appendChild(element);
        } else {
            throw new RegistrationException(StringManager.getString("rpmgr.noSuchElement", new Object[0]));
        }
    }

    private synchronized void loadOrCreateDocument() throws RegistrationException {
        if (this.document == null) {
            if (this.registrationFile.exists()) {
                try {
                    this.document = this.documentBuilder.parse(this.registrationFile);
                    this.registryElement = this.findRegistryElement();
                }
                catch (Exception e) {
                    throw new RegistrationException((Throwable)e);
                }
            } else {
                this.document = this.documentBuilder.newDocument();
                this.registryElement = this.document.createElement(REGISTRY_TAG);
                this.document.appendChild(this.registryElement);
                Element registrationStatusElement = this.document.createElement(REGISTRATION_REMINDER_TAG);
                registrationStatusElement.setTextContent(REGISTRATION_REMINDER_DEFAULT_VALUE.toString());
                this.registryElement.appendChild(registrationStatusElement);
            }
        }
    }

    private void writeToFile() throws RegistrationException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.registrationFile);
            this.write(os);
        }
        catch (Exception e) {
            throw new RegistrationException((Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException ex) {
                    throw new RegistrationException(StringManager.getString("rpmgr.errClosingRepos", new Object[0]), (Throwable)ex);
                }
            }
        }
    }

    private Element findRegistryElement() {
        Element result = null;
        NodeList nodes = this.document.getElementsByTagName(REGISTRY_TAG);
        if (nodes.getLength() > 0) {
            result = (Element)nodes.item(0);
        }
        return result;
    }
}

