/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.sims.Backend;
import org.openinstaller.sims.BackendFactory;
import org.openinstaller.sims.FractionalProgressListener;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.sims.RepositoryCache;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SIMSContext {
    private final RepositoryCache gRepositoryCache;
    private final Backend gBackend = BackendFactory.getBackend(new File(System.getProperty("java.io.tmpdir")).getAbsolutePath());
    private boolean gIsCacheValid = false;
    private boolean gDryRun;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public SIMSContext(boolean aMode) throws SIMSException {
        this.gDryRun = aMode;
        this.gBackend.initialize();
        this.gBackend.setDryRun(this.gDryRun);
        this.gRepositoryCache = new RepositoryCache();
    }

    public SIMSContext() throws SIMSException {
        this(false);
    }

    private void refreshProdState(SystemProduct aProduct) throws SIMSException, InvalidArgumentException {
        Set<SystemProduct> theProductsThatRequireNewProduct;
        if (aProduct.getState() == Backend.EntityState.INACTIVE) {
            return;
        }
        int theMissingPkgsCount = this.countPackages(aProduct, Backend.EntityState.NOT_INSTALLED);
        int theDamagedPkgsCount = this.countPackages(aProduct, Backend.EntityState.DAMAGED);
        LOGGER.log(Level.FINER, "Product:" + aProduct.getName() + " Missing Pkg Count: " + theMissingPkgsCount + " Damaged Pkg Count: " + theDamagedPkgsCount);
        if (theMissingPkgsCount > 0 || theDamagedPkgsCount > 0) {
            aProduct.setState(Backend.EntityState.DAMAGED);
        } else {
            aProduct.setState(Backend.EntityState.INSTALLED);
        }
        Set<SystemProduct> theProductsThatContainNewProduct = this.gRepositoryCache.getProductContainers(aProduct);
        if (theProductsThatContainNewProduct != null) {
            for (SystemProduct theContainer : theProductsThatContainNewProduct) {
                this.refreshProdState(theContainer);
            }
        }
        if ((theProductsThatRequireNewProduct = this.gRepositoryCache.getDependentProducts(aProduct)) != null) {
            for (SystemProduct theDependent : theProductsThatRequireNewProduct) {
                this.refreshProdState(theDependent);
            }
        }
    }

    private int countContainedProducts(SystemProduct aProduct, Backend.EntityState aState) throws SIMSException, InvalidArgumentException {
        int theMatchCount = 0;
        for (SystemProduct theContainedProd : aProduct.getContainedProducts()) {
            SystemProduct theContainedInstalledProd = this.getProductInstance(theContainedProd);
            if (theContainedInstalledProd != null) {
                if (theContainedInstalledProd.getState() != aState) continue;
                ++theMatchCount;
                continue;
            }
            if (theContainedProd.getState() != aState) continue;
            ++theMatchCount;
        }
        return theMatchCount;
    }

    private int countRequiredProducts(SystemProduct aProduct, Backend.EntityState aState) throws SIMSException, InvalidArgumentException {
        int theMatchCount = 0;
        for (SystemProduct theReqdProduct : aProduct.getRequiredProducts()) {
            SystemProduct theReqdInstalledProduct = this.getProductInstance(theReqdProduct);
            if (theReqdInstalledProduct != null) {
                if (theReqdInstalledProduct.getState() != aState) continue;
                ++theMatchCount;
                continue;
            }
            if (theReqdProduct.getState() != aState) continue;
            ++theMatchCount;
        }
        return theMatchCount;
    }

    private int countPackages(SystemProduct aProduct, Backend.EntityState aState) throws SIMSException, InvalidArgumentException {
        int theMatchCount = 0;
        for (Package theContainedPkg : aProduct.getContainedPackages()) {
            Package theContainedInstalledPackage = this.getPackageInstance(theContainedPkg);
            if (theContainedInstalledPackage == null) {
                if (aState != Backend.EntityState.NOT_INSTALLED) continue;
                ++theMatchCount;
                continue;
            }
            if (theContainedInstalledPackage.getState() != aState) continue;
            ++theMatchCount;
        }
        return theMatchCount;
    }

    private void refreshPkgState(Package aPackage) throws SIMSException, InvalidArgumentException {
        Set<Package> thePackagesThatRequireNewPkg;
        Iterator<Package> theRequiredPkgs = aPackage.getRequiredPackages();
        Backend.EntityState theResultState = Backend.EntityState.INSTALLED;
        if (theRequiredPkgs.hasNext()) {
            while (theRequiredPkgs.hasNext()) {
                Package theRequiredPackage = theRequiredPkgs.next();
                Package theRequiredInstalledPkg = this.getPackageInstance(theRequiredPackage);
                if (theRequiredInstalledPkg == null) {
                    theResultState = Backend.EntityState.DAMAGED;
                    break;
                }
                if (theRequiredInstalledPkg.getState() != Backend.EntityState.DAMAGED && theRequiredInstalledPkg.getState() != Backend.EntityState.INACTIVE) continue;
                aPackage.setState(Backend.EntityState.DAMAGED);
                theResultState = Backend.EntityState.DAMAGED;
                break;
            }
        }
        aPackage.setState(theResultState);
        Set<SystemProduct> theProductsThatContainNewPackage = this.gRepositoryCache.getPackageContainers(aPackage);
        if (theProductsThatContainNewPackage != null) {
            for (SystemProduct theContainer : theProductsThatContainNewPackage) {
                this.refreshProdState(theContainer);
            }
        }
        if ((thePackagesThatRequireNewPkg = this.gRepositoryCache.getDependentPackages(aPackage)) != null) {
            for (Package theDependent : thePackagesThatRequireNewPkg) {
                this.refreshPkgState(theDependent);
            }
        }
    }

    public void initialize(ProgressListener aListener) throws SIMSException {
        if (this.gIsCacheValid) {
            throw new SIMSException("UNNECESSARY_SIMS_INIT", new String[0]);
        }
        try {
            this.gBackend.initialize();
            List<Package> theAllPackagesList = this.gBackend.getAllPackages(new FractionalProgressListener(aListener, 0, 30));
            List<SystemProduct> theAllProductsList = this.gBackend.getAllProducts(theAllPackagesList, new FractionalProgressListener(aListener, 30, 60));
            FractionalProgressListener thePkgListener = new FractionalProgressListener(aListener, 60, 80);
            FractionalProgressListener theProductListener = new FractionalProgressListener(aListener, 80, 100);
            int theTotalPackagesCount = theAllPackagesList.size();
            int thePackagesProcessedCount = 0;
            for (Package thePackage : theAllPackagesList) {
                LOGGER.finer("@ About to cache " + thePackage.toString() + " state = " + thePackage.getState().toString() + " critical = " + thePackage.isCritical());
                this.gRepositoryCache.addPackageToCache(thePackage);
                thePkgListener.updateProgress((int)(100.0 * ((double)(++thePackagesProcessedCount) / (double)theTotalPackagesCount)));
            }
            int theTotalProductsCount = theAllProductsList.size();
            int theProductsProcessedCount = 0;
            for (SystemProduct theProduct : theAllProductsList) {
                LOGGER.finer("@ About to cache " + theProduct.toString() + " state = " + theProduct.getState().toString() + " critical = " + theProduct.isCritical());
                this.gRepositoryCache.addProductToCache(theProduct);
                theProductListener.updateProgress((int)(100.0 * ((double)(++theProductsProcessedCount) / (double)theTotalProductsCount)));
            }
            this.gIsCacheValid = true;
            for (Package thePackage : theAllPackagesList) {
                this.updatePkgDependenciesState(thePackage);
            }
            for (SystemProduct theProduct : theAllProductsList) {
                this.updateProdDependenciesState(theProduct);
            }
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.WARNING, "INVALID_PROGRESS_VALUE", theEIAEx);
        }
        catch (SIMSException theEx) {
            theEx.addContext("CANNOT_INIT_REPOSITORY", new String[0]);
            this.gRepositoryCache.clear();
            this.gIsCacheValid = false;
            throw theEx;
        }
    }

    public void setAlternateRoot(String aAlternateRoot) throws SIMSException {
        if (!aAlternateRoot.equals(this.gBackend.getAttribute(Backend.Attribute.ALTERNATE_ROOT))) {
            LOGGER.finest(ClassUtils.getFQMethodName() + " Repository cache cleared");
            this.gRepositoryCache.clear();
            this.gIsCacheValid = false;
            this.gBackend.setAttribute(Backend.Attribute.ALTERNATE_ROOT, aAlternateRoot);
        }
    }

    public String getAlternateRoot() {
        return this.gBackend.getAttribute(Backend.Attribute.ALTERNATE_ROOT);
    }

    public void setDomain(String aDomain) throws SIMSException {
        if (aDomain != null && !"".equals(aDomain)) {
            if (!aDomain.equals(this.gBackend.getAttribute(Backend.Attribute.DOMAIN))) {
                LOGGER.finest(ClassUtils.getFQMethodName() + " Repository cache cleared");
                this.gRepositoryCache.clear();
                this.gIsCacheValid = false;
                this.gBackend.setAttribute(Backend.Attribute.DOMAIN, aDomain);
            }
        } else {
            throw new SIMSException("DOMAIN_NAME_TO_SET_IS_NULL_OR_EMPTY", new String[0]);
        }
    }

    public String getDomain() {
        return this.gBackend.getAttribute(Backend.Attribute.DOMAIN);
    }

    public boolean canRead() {
        String thePerms = this.gBackend.getAttribute(Backend.Attribute.PERMISSIONS);
        return thePerms.contains("r");
    }

    public boolean canWrite() {
        String thePerms = this.gBackend.getAttribute(Backend.Attribute.PERMISSIONS);
        return thePerms.contains("w");
    }

    public void registerAll(boolean aIsLegacyProduct, SystemProduct aNewProduct, ProgressListener aListener) throws SIMSException {
        LOGGER.log(Level.FINE, "REGISTERING ALL", aNewProduct);
        this.checkRepositoryValid();
        this.checkCanWriteRepository();
        SIMSContext.checkCircularContainment(aNewProduct);
        Set<SystemProduct> theContainedProducts = aNewProduct.getContainedProducts();
        Set<Package> theContainedPackages = aNewProduct.getContainedPackages();
        int theTotalToRegister = aNewProduct.getContainedProductCount() + aNewProduct.getContainedPackageCount();
        int theTotalRegisteredCount = 0;
        double theProgressPointsForRecursion = 100.0 * ((double)theTotalToRegister / (double)(theTotalToRegister + 1));
        try {
            int theEnd;
            int theStart;
            for (SystemProduct theContainedProduct : theContainedProducts) {
                theStart = (int)(theProgressPointsForRecursion * ((double)theTotalRegisteredCount / (double)theTotalToRegister));
                theEnd = (int)(theProgressPointsForRecursion * ((double)(theTotalRegisteredCount + 1) / (double)theTotalToRegister));
                this.registerAll(aIsLegacyProduct, theContainedProduct, new FractionalProgressListener(aListener, theStart, theEnd));
                ++theTotalRegisteredCount;
            }
            for (Package thePkgToRegister : theContainedPackages) {
                theStart = (int)(theProgressPointsForRecursion * ((double)theTotalRegisteredCount / (double)theTotalToRegister));
                theEnd = (int)(theProgressPointsForRecursion * ((double)(theTotalRegisteredCount + 1) / (double)theTotalToRegister));
                LOGGER.finer(" @ About to register package " + thePkgToRegister + " state = " + thePkgToRegister.getState().toString());
                if (!aIsLegacyProduct || thePkgToRegister.getState() != Backend.EntityState.NOT_INSTALLED) {
                    LOGGER.finer("Registering package = " + thePkgToRegister.getName());
                    this.registerPackage(aIsLegacyProduct, thePkgToRegister, new FractionalProgressListener(aListener, theStart, theEnd));
                }
                ++theTotalRegisteredCount;
            }
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.WARNING, "INVALID_PROGRESS_VALUE", theEIAEx);
        }
        catch (SIMSException theEx) {
            theEx.addContext("REGISTRATION_FAILED_FOR_PROD_OR_PKG", new String[0]);
            theEx.addContext("CANNOT_REGISTER_PRODUCT", new String[]{"product=" + aNewProduct.getName()});
            throw theEx;
        }
        try {
            this.registerProduct(aIsLegacyProduct, aNewProduct, new FractionalProgressListener(aListener, (int)theProgressPointsForRecursion, 100));
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.WARNING, "INVALID_PROGRESS_VALUE", theEIAEx);
        }
    }

    public void registerProduct(boolean aIsLegacyProduct, SystemProduct aNewProduct, ProgressListener aListener) throws SIMSException, InvalidArgumentException {
        this.checkRepositoryValid();
        this.checkCanWriteRepository();
        LOGGER.log(Level.FINE, "REGISTERING", aNewProduct);
        if (!aIsLegacyProduct) {
            this.gBackend.registerProduct(aNewProduct, aListener);
        }
        if (aNewProduct.getState() == Backend.EntityState.NOT_INSTALLED) {
            aNewProduct.setState(Backend.EntityState.INSTALLED);
        }
        LOGGER.finer("@ Registered  " + aNewProduct.toString() + " State = " + aNewProduct.getState().toString() + " Critical = " + aNewProduct.isCritical());
        this.refreshProdState(aNewProduct);
        this.gRepositoryCache.addProductToCache(aNewProduct);
        this.updateProdDependenciesState(aNewProduct);
        LOGGER.finer("! After updating product dependencies, " + aNewProduct.toString() + " state = " + aNewProduct.getState().toString());
    }

    private void updateProdDependenciesState(SystemProduct aNewProduct) throws SIMSException, InvalidArgumentException {
        Set<SystemProduct> theDependentProducts;
        LOGGER.finer("@ Updating Product dependency state for : " + aNewProduct.toString());
        SystemProduct theInstalledProduct = this.getProductInstance(aNewProduct);
        Set<SystemProduct> theProductsThatContainOldProduct = this.gRepositoryCache.getProductContainers(theInstalledProduct);
        LOGGER.log(Level.FINE, "PRODUCT_STATE", new Object[]{theInstalledProduct, theProductsThatContainOldProduct});
        if (theProductsThatContainOldProduct != null) {
            for (SystemProduct theContainer : theProductsThatContainOldProduct) {
                LOGGER.log(Level.FINE, "REFRESHING_PRODUCT", new Object[]{theContainer, theContainer.getState()});
                this.refreshProdState(theContainer);
                LOGGER.log(Level.FINE, "REFRESH_STATE", new Object[]{theContainer, theContainer.getState()});
            }
        }
        if ((theDependentProducts = this.getProductDependents(aNewProduct)) != null) {
            for (SystemProduct theDep : theDependentProducts) {
                LOGGER.log(Level.FINE, "REFRESHING_PRODUCT", new Object[]{theDep, theDep.getState()});
                this.refreshProdState(theDep);
                LOGGER.log(Level.FINE, "REFRESH_STATE", new Object[]{theDep, theDep.getState()});
                LOGGER.finer("Refreshing product : " + theDep.toString() + " state = " + theDep.getState().toString());
            }
        }
    }

    public void registerPackage(boolean aIsLegacyProduct, Package aNewPackage, ProgressListener aListener) throws SIMSException, InvalidArgumentException {
        this.checkRepositoryValid();
        this.checkCanWriteRepository();
        LOGGER.log(Level.FINE, "REGISTERING " + aNewPackage);
        if (!aIsLegacyProduct) {
            try {
                this.gBackend.registerPackage(aNewPackage, aListener);
            }
            catch (SIMSException theEx) {
                theEx.addContext("CANNOT_REGISTER_PACKAGE", new String[]{"package=" + aNewPackage.getName()});
                throw theEx;
            }
        }
        if (aNewPackage.getState() == Backend.EntityState.NOT_INSTALLED) {
            aNewPackage.setState(Backend.EntityState.INSTALLED);
            LOGGER.finer("Registered  " + aNewPackage.toString() + " State is = " + aNewPackage.getState().toString());
        }
        this.refreshPkgState(aNewPackage);
        this.gRepositoryCache.addPackageToCache(aNewPackage);
        this.updatePkgDependenciesState(aNewPackage);
    }

    private void updatePkgDependenciesState(Package aNewPackage) throws SIMSException, InvalidArgumentException {
        Set<SystemProduct> theProductsThatContainNewPkg;
        Set<Package> thePackagesThatRequireNewPackage = this.gRepositoryCache.getDependentPackages(aNewPackage);
        if (thePackagesThatRequireNewPackage != null) {
            for (Package theDependent : thePackagesThatRequireNewPackage) {
                this.refreshPkgState(theDependent);
            }
        }
        if ((theProductsThatContainNewPkg = this.gRepositoryCache.getPackageContainers(aNewPackage)) != null) {
            for (SystemProduct theContainer : theProductsThatContainNewPkg) {
                this.refreshProdState(theContainer);
            }
        }
    }

    public void unregisterAll(SystemProduct aOldProduct, ProgressListener aListener) throws SIMSException, InvalidArgumentException {
        this.checkRepositoryValid();
        this.checkCanWriteRepository();
        SystemProduct theInstalledProduct = this.getProductInstance(aOldProduct);
        if (theInstalledProduct == null) {
            throw new SIMSException(aOldProduct.getName() + " is not installed, cannot unregister", new String[0]);
        }
        Set<SystemProduct> theContainedProducts = theInstalledProduct.getContainedProducts();
        Set<Package> theContainedPackages = theInstalledProduct.getContainedPackages();
        int theTotalToUnRegisterCount = theInstalledProduct.getContainedProductCount() + theInstalledProduct.getContainedPackageCount();
        int theTotalUnregisteredCount = 0;
        double theProgressPointsForRecursion = 100.0 * ((double)theTotalToUnRegisterCount / (double)(theTotalToUnRegisterCount + 1));
        try {
            int theEnd;
            int theStart;
            for (SystemProduct theContainedProduct : theContainedProducts) {
                theStart = (int)(theProgressPointsForRecursion * ((double)theTotalUnregisteredCount / (double)theTotalToUnRegisterCount));
                theEnd = (int)(theProgressPointsForRecursion * ((double)(theTotalUnregisteredCount + 1) / (double)theTotalToUnRegisterCount));
                SystemProduct theContainedInstalledProduct = this.getProductInstance(theContainedProduct);
                if (theContainedInstalledProduct != null) {
                    this.unregisterAll(theContainedInstalledProduct, new FractionalProgressListener(aListener, theStart, theEnd));
                }
                ++theTotalUnregisteredCount;
            }
            for (Package theContainedPkg : theContainedPackages) {
                theStart = (int)(theProgressPointsForRecursion * ((double)theTotalUnregisteredCount / (double)theTotalToUnRegisterCount));
                theEnd = (int)(theProgressPointsForRecursion * ((double)(theTotalUnregisteredCount + 1) / (double)theTotalToUnRegisterCount));
                Package theContainedInstalledPkg = this.getPackageInstance(theContainedPkg);
                if (theContainedInstalledPkg != null) {
                    this.unregisterPackage(theContainedInstalledPkg, new FractionalProgressListener(aListener, theStart, theEnd));
                }
                ++theTotalUnregisteredCount;
            }
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.WARNING, "INVALID_PROGRESS_VALUE", theEIAEx);
        }
        catch (SIMSException theEx) {
            theEx.addContext("CANNOT_UNREGISTER_PRODUCT", new String[]{"product=" + theInstalledProduct.getName()});
            theEx.addContext("UNREGISTRATION_FAILED_FOR_PROD_OR_PKG", new String[0]);
            throw theEx;
        }
        try {
            this.unregisterProduct(theInstalledProduct, new FractionalProgressListener(aListener, (int)theProgressPointsForRecursion, 100));
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.WARNING, "INVALID_PROGRESS_VALUE", theEIAEx);
        }
    }

    public void unregisterProduct(SystemProduct aOldProduct, ProgressListener aListener) throws SIMSException, InvalidArgumentException {
        this.checkRepositoryValid();
        this.checkCanWriteRepository();
        LOGGER.log(Level.FINE, "UNREGISTERING", aOldProduct);
        SystemProduct theInstalledProduct = this.getProductInstance(aOldProduct);
        if (theInstalledProduct == null) {
            throw new SIMSException(aOldProduct.getName() + " is not installed, cannot unregister", new String[0]);
        }
        this.gBackend.unregisterProduct(theInstalledProduct, aListener);
        theInstalledProduct.setState(Backend.EntityState.NOT_INSTALLED);
        LOGGER.log(Level.FINE, "REMOVE_FROM_CACHE", theInstalledProduct);
        this.gRepositoryCache.removeProductFromCache(theInstalledProduct);
        Set<SystemProduct> theProductsThatContainOldProduct = this.gRepositoryCache.getProductContainers(theInstalledProduct);
        LOGGER.log(Level.FINE, "PRODUCT_STATE", new Object[]{theInstalledProduct, theProductsThatContainOldProduct});
        if (theProductsThatContainOldProduct != null) {
            for (SystemProduct theContainer : theProductsThatContainOldProduct) {
                LOGGER.log(Level.FINE, "REFRESHING_PRODUCT", new Object[]{theContainer, theContainer.getState()});
                this.refreshProdState(theContainer);
                LOGGER.log(Level.FINE, "REFRESH_STATE", new Object[]{theContainer, theContainer.getState()});
            }
        }
    }

    public void unregisterPackage(Package aOldPackage, ProgressListener aListener) throws SIMSException, InvalidArgumentException {
        Set<SystemProduct> theProductsThatContainThisPkg;
        this.checkRepositoryValid();
        this.checkCanWriteRepository();
        if (aOldPackage.getState() == Backend.EntityState.NOT_INSTALLED) {
            try {
                this.gBackend.unregisterPackage(aOldPackage, aListener);
            }
            catch (SIMSException theEx) {
                theEx.addContext("CANNOT_UNREGISTER_PACKAGE", new String[]{"package=" + aOldPackage.getName()});
                throw theEx;
            }
        }
        LOGGER.log(Level.FINE, "UNREGISTERING", aOldPackage);
        Package theInstalledPkg = this.getPackageInstance(aOldPackage);
        if (theInstalledPkg == null) {
            throw new SIMSException(aOldPackage.getName() + " not registered. cannot unregister", new String[0]);
        }
        try {
            this.gBackend.unregisterPackage(theInstalledPkg, aListener);
            aOldPackage.setState(Backend.EntityState.NOT_INSTALLED);
        }
        catch (SIMSException theEx) {
            theEx.addContext("CANNOT_UNREGISTER_PACKAGE", new String[]{"package=" + aOldPackage.getName()});
            throw theEx;
        }
        this.gRepositoryCache.removePackageFromCache(aOldPackage);
        Set<Package> thePackagesThatRequireThisPkg = this.gRepositoryCache.getDependentPackages(aOldPackage);
        if (thePackagesThatRequireThisPkg != null) {
            for (Package theDependent : thePackagesThatRequireThisPkg) {
                this.refreshPkgState(theDependent);
            }
        }
        if ((theProductsThatContainThisPkg = this.gRepositoryCache.getPackageContainers(aOldPackage)) != null) {
            for (SystemProduct theDependent : theProductsThatContainThisPkg) {
                this.refreshProdState(theDependent);
            }
        }
    }

    public Set<SystemProduct> getAllProducts() throws SIMSException, InvalidArgumentException {
        this.checkRepositoryValid();
        this.checkCanReadRepository();
        return this.gRepositoryCache.getAllProducts();
    }

    private void checkRepositoryValid() throws SIMSException {
        if (!this.gIsCacheValid) {
            throw new SIMSException("MUST_CALL_INIT", new String[0]);
        }
    }

    private void checkCanReadRepository() throws SIMSException {
        if (!this.canRead()) {
            throw new SIMSException("Repository is unreadable", new String[0]);
        }
    }

    private void checkCanWriteRepository() throws SIMSException {
        if (!this.canWrite()) {
            throw new SIMSException("UNREADABLE_REPOSITORY", new String[0]);
        }
    }

    public Set<Package> getAllPackages() throws SIMSException, InvalidArgumentException {
        this.checkRepositoryValid();
        this.checkCanReadRepository();
        return this.gRepositoryCache.getAllPackages();
    }

    public Set<SystemProduct> getProductInstances(String aProductName, Version aVersion) throws SIMSException, InvalidArgumentException {
        LOGGER.finest(ClassUtils.getFQMethodName() + "(" + aProductName + ", " + aVersion + ")");
        this.checkRepositoryValid();
        this.checkCanReadRepository();
        if (aProductName == null) {
            LOGGER.finest(ClassUtils.getFQMethodName() + " product name is null");
            throw new InvalidArgumentException("PROD_NAME_CANNOT_BE_NULL", new String[0]);
        }
        return this.gRepositoryCache.getProductInstances(aProductName, aVersion);
    }

    public Set<Package> getPackageInstances(String aPackageName, Version aVersion) throws SIMSException, InvalidArgumentException {
        this.checkRepositoryValid();
        this.checkCanReadRepository();
        if (aPackageName == null) {
            LOGGER.finest(ClassUtils.getFQMethodName() + " package name is null");
            throw new InvalidArgumentException("PKG_NAME_CANNOT_BE_NULL", new String[0]);
        }
        return this.gRepositoryCache.getPackageInstances(aPackageName, aVersion);
    }

    public Package getPackageInstance(Package aPackage) throws SIMSException, InvalidArgumentException {
        this.checkRepositoryValid();
        this.checkCanReadRepository();
        Set<Package> theInstanceSet = this.getPackageInstances(aPackage.getName(), aPackage.getVersion());
        if (theInstanceSet == null) {
            return null;
        }
        for (Package theInstalledPkg : theInstanceSet) {
            if (!theInstalledPkg.equals(aPackage)) continue;
            return theInstalledPkg;
        }
        return null;
    }

    public SystemProduct getProductInstance(SystemProduct aProduct) throws SIMSException, InvalidArgumentException {
        this.checkRepositoryValid();
        this.checkCanReadRepository();
        Set<SystemProduct> theInstanceSet = this.getProductInstances(aProduct.getName(), aProduct.getVersion());
        if (theInstanceSet == null) {
            return null;
        }
        Iterator<SystemProduct> theInstancesIterator = theInstanceSet.iterator();
        LOGGER.finer("@ Getting Product Instance for : " + aProduct.toString());
        while (theInstancesIterator.hasNext()) {
            SystemProduct theInstalledProduct = theInstancesIterator.next();
            LOGGER.finer("@ Installed Product = " + theInstalledProduct.toString() + " its STATE = " + theInstalledProduct.getState().toString() + " its critical state = " + theInstalledProduct.isCritical());
            if (!theInstalledProduct.equals(aProduct)) continue;
            return theInstalledProduct;
        }
        return null;
    }

    public Set<SystemProduct> getProductDependents(SystemProduct aProduct) throws SIMSException {
        this.checkRepositoryValid();
        this.checkCanReadRepository();
        return this.gRepositoryCache.getDependentProducts(aProduct);
    }

    private static void checkCircularContainment(SystemProduct aProduct) throws SIMSException {
        SIMSContext.checkCircularContainment(aProduct, new ArrayList<SystemProduct>());
    }

    private static void checkCircularContainment(SystemProduct aProduct, List<SystemProduct> aRecursionContext) throws SIMSException {
        if (aRecursionContext == null) {
            aRecursionContext = new ArrayList<SystemProduct>();
        }
        if (aRecursionContext.contains(aProduct)) {
            StringBuffer theErrorMessage = new StringBuffer("Circular containment detected: ");
            for (SystemProduct theProduct : aRecursionContext) {
                theErrorMessage.append(theProduct.getName());
                theErrorMessage.append(" - > ");
            }
            theErrorMessage.append(aProduct.getName());
            throw new SIMSException(theErrorMessage.toString(), new String[0]);
        }
        aRecursionContext.add(aProduct);
        for (SystemProduct theContainedProduct : aProduct.getContainedProducts()) {
            SIMSContext.checkCircularContainment(theContainedProduct, aRecursionContext);
        }
    }
}

