/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims.backends.rpm;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.sims.Backend;
import org.openinstaller.sims.FractionalProgressListener;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.sims.backends.rpm.RPMUtils;
import org.openinstaller.sims.util.Encoders;
import org.openinstaller.sims.util.SimsUtils;
import org.openinstaller.sims.util.TempFileManager;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Version;
import org.openinstaller.util.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SIMSBackend
extends Backend {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static final String SUNW_LICENSE = "Copyright " + Calendar.getInstance().get(1) + " Sun Microsystems, Inc.  All rights reserved.  Use is subject to license terms.";

    @Override
    public void initialize() throws SIMSException {
        RPMUtils.checkUtils();
        this.setPermissions();
    }

    private void setPermissions() throws SIMSException {
        File thePkgDB;
        File theInstallHome;
        StringBuffer thePerms = new StringBuffer();
        String theAltRoot = this.getAttribute(Backend.Attribute.ALTERNATE_ROOT);
        String theDomain = this.getAttribute(Backend.Attribute.DOMAIN);
        try {
            theInstallHome = SimsUtils.getFinalAltRoot(theAltRoot, theDomain);
        }
        catch (EnhancedException e) {
            throw new SIMSException(e, "CANNOT_SET_DIRECTORY_PERMISSIONS", new String[0]);
        }
        LOGGER.fine("Checking DB at " + thePkgDB);
        for (thePkgDB = new File(theInstallHome, "var/lib/rpm"); thePkgDB != null && !thePkgDB.exists(); thePkgDB = thePkgDB.getParentFile()) {
            LOGGER.fine("Checking DB at " + thePkgDB);
        }
        if (thePkgDB == null) {
            throw new SIMSException("PACKAGE_DB_NO_ACCESS", "path=" + theInstallHome, "file=var/lib/rpm");
        }
        if (thePkgDB.canWrite()) {
            LOGGER.fine("DB at " + thePkgDB + " is WRITABLE");
            thePerms.append('w');
        }
        if (thePkgDB.canRead()) {
            LOGGER.fine("DB at " + thePkgDB + " is READABLE");
            thePerms.append('r');
        }
        LOGGER.fine("Setting permissions to " + thePerms.toString() + " for DB " + thePkgDB);
        this.setAttribute(Backend.Attribute.PERMISSIONS, thePerms.toString());
    }

    @Override
    public void registerProduct(SystemProduct aProduct, ProgressListener aListener) throws SIMSException {
        String thePkgName = RPMUtils.createSIMSPkgName("sun-sims-product", aProduct.getName(), aProduct.getVersion(), aProduct.getInstance());
        HashMap<RPMUtils.RPMTag, String> theRPMEntries = new HashMap<RPMUtils.RPMTag, String>();
        HashMap<RPMUtils.SIMSRPMTag, String> theSIMSEntries = new HashMap<RPMUtils.SIMSRPMTag, String>();
        theRPMEntries.put(RPMUtils.RPMTag.GROUP, "System Environment/sun-sims-product");
        theRPMEntries.put(RPMUtils.RPMTag.SUMMARY, "openInstaller Product Tracking Package for " + aProduct.getName());
        theRPMEntries.put(RPMUtils.RPMTag.NAME, thePkgName);
        theRPMEntries.put(RPMUtils.RPMTag.VERSION, Version.encode((Version)aProduct.getVersion()));
        theRPMEntries.put(RPMUtils.RPMTag.RELEASE, "1");
        if (aProduct.getRelease() != null) {
            theSIMSEntries.put(RPMUtils.SIMSRPMTag.SIMS_RELEASE, Version.encode((Version)aProduct.getRelease()));
        }
        theRPMEntries.put(RPMUtils.RPMTag.LICENSE, SUNW_LICENSE);
        theSIMSEntries.put(RPMUtils.SIMSRPMTag.SIMS_CRITICAL, String.valueOf(aProduct.isCritical()));
        theSIMSEntries.put(RPMUtils.SIMSRPMTag.SIMS_PRODUCT_NAME, aProduct.getName());
        theSIMSEntries.put(RPMUtils.SIMSRPMTag.SIMS_PRODUCT_READABLE_NAME, aProduct.getShortDescription());
        theSIMSEntries.put(RPMUtils.SIMSRPMTag.SIMS_INSTANCE_ID, aProduct.getInstance());
        theSIMSEntries.put(RPMUtils.SIMSRPMTag.SIMS_PRODUCT_BASEDIR, aProduct.getLocation());
        theSIMSEntries.put(RPMUtils.SIMSRPMTag.SIMS_PRODUCT_DESC, aProduct.getDescription());
        Set<SystemProduct> theContainedProducts = aProduct.getContainedProducts();
        Set<SystemProduct> theRequiredProducts = aProduct.getRequiredProducts();
        Set<Package> theContainedPackages = aProduct.getContainedPackages();
        Set<VersionRange> theCompatibleVersions = aProduct.getCompatibleVersions();
        if (!theContainedProducts.isEmpty()) {
            theSIMSEntries.put(RPMUtils.SIMSRPMTag.SIMS_CONTAINED_PRODUCTS, Encoders.encodeProducts(theContainedProducts));
        }
        if (!theRequiredProducts.isEmpty()) {
            theSIMSEntries.put(RPMUtils.SIMSRPMTag.SIMS_REQUIRED_PRODUCTS, Encoders.encodeProducts(theRequiredProducts));
        }
        if (!theContainedPackages.isEmpty()) {
            theSIMSEntries.put(RPMUtils.SIMSRPMTag.SIMS_CONTAINED_PACKAGES, Encoders.encodePackages(theContainedPackages));
        }
        if (!theCompatibleVersions.isEmpty()) {
            theSIMSEntries.put(RPMUtils.SIMSRPMTag.SIMS_COMPATIBLE_VERSIONS, VersionRange.encodeVersionRanges(theCompatibleVersions));
        }
        try {
            if (this.isDryRun()) {
                LOGGER.log(Level.INFO, "SIMS_DRY_RUN", aProduct.getName());
            } else {
                FractionalProgressListener theFPL = new FractionalProgressListener(aListener, 0, 40);
                File theMetaRPM = RPMUtils.createMetaPkg(thePkgName, theFPL, theRPMEntries, theSIMSEntries, null);
                RPMUtils.installPkg(theMetaRPM, thePkgName, this.getAttribute(Backend.Attribute.DOMAIN), this.getAttribute(Backend.Attribute.ALTERNATE_ROOT));
            }
        }
        catch (EnhancedException theEx) {
            theEx.logFatal();
            throw new SIMSException(theEx, "CANNOT_INSTALL_PACKAGE", "package=" + thePkgName);
        }
        TempFileManager.deleteTempFiles();
        if (aListener != null) {
            aListener.updateProgress(100);
        }
    }

    @Override
    public void registerPackage(Package aPkg, ProgressListener aListener) {
    }

    @Override
    public void unregisterProduct(SystemProduct aProduct, ProgressListener aListener) throws SIMSException {
        if (aListener != null) {
            aListener.updateProgress(50);
        }
        try {
            if (this.isDryRun()) {
                LOGGER.log(Level.INFO, "SIMS_DRY_RUN", aProduct.getName());
            } else {
                String thePkgName = RPMUtils.findProduct(aProduct.getName(), aProduct.getVersion(), aProduct.getInstance(), this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN));
                RPMUtils.removePkg(thePkgName, this.getAttribute(Backend.Attribute.DOMAIN), this.getAttribute(Backend.Attribute.ALTERNATE_ROOT));
            }
        }
        catch (EnhancedException theEe) {
            throw new SIMSException(theEe, "CANNOT_UNREGISTER_PRODUCT", "product=" + aProduct.getName());
        }
        if (aListener != null) {
            aListener.updateProgress(100);
        }
    }

    @Override
    public void unregisterPackage(Package aPkg, ProgressListener aListener) {
    }

    @Override
    public List<SystemProduct> getAllProducts(List<Package> aPkgList, ProgressListener aListener) throws SIMSException {
        List<SystemProduct> theProducts = new ArrayList<SystemProduct>();
        List<String> theMetaPkgNames = RPMUtils.getAllPackageNames(this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN), "System Environment/sun-sims-product");
        ArrayList<SystemProduct> theProductsWithContainedOrRequiredProducts = new ArrayList<SystemProduct>();
        Hashtable<SystemProduct, SystemProduct[]> theContainedProductsMap = new Hashtable<SystemProduct, SystemProduct[]>();
        Hashtable<SystemProduct, SystemProduct[]> theRequiredProductsMap = new Hashtable<SystemProduct, SystemProduct[]>();
        try {
            FractionalProgressListener theIndexListener = new FractionalProgressListener(aListener, 20, 80);
            FractionalProgressListener theCrossLinkListener = new FractionalProgressListener(aListener, 80, 100);
            theProducts = this.buildProductIndex(theMetaPkgNames, theProductsWithContainedOrRequiredProducts, theContainedProductsMap, theRequiredProductsMap, aPkgList, theIndexListener);
            this.crossLinkProducts(theProducts, theProductsWithContainedOrRequiredProducts, theContainedProductsMap, theRequiredProductsMap, theCrossLinkListener);
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.WARNING, "INVALID_PROGRESS_VALUE", theEIAEx);
        }
        return theProducts;
    }

    private void crossLinkProducts(List<SystemProduct> aCompleteProductList, List<SystemProduct> aFilteredProductsList, Map<SystemProduct, SystemProduct[]> aContainedProductsMap, Map<SystemProduct, SystemProduct[]> aRequiredProductsMap, ProgressListener aListener) {
        int theTotalPkgCount = aFilteredProductsList.size();
        int theCountOfProcessedPkgs = 0;
        for (SystemProduct theNextProduct : aFilteredProductsList) {
            int theIndex;
            SystemProduct[] theContainedProducts = aContainedProductsMap.get(theNextProduct);
            SystemProduct[] theRequiredProducts = aRequiredProductsMap.get(theNextProduct);
            if (theContainedProducts != null) {
                for (SystemProduct theTmpProduct : theContainedProducts) {
                    theIndex = aCompleteProductList.indexOf(theTmpProduct);
                    try {
                        if (theIndex == -1) {
                            theTmpProduct.setState(Backend.EntityState.NOT_INSTALLED);
                            theNextProduct.addContainedProduct(theTmpProduct);
                            LOGGER.log(Level.FINE, "Product " + theNextProduct.getName() + " contains product " + theTmpProduct + ", but " + theTmpProduct + " is not installed");
                            continue;
                        }
                        theNextProduct.addContainedProduct(aCompleteProductList.get(theIndex));
                    }
                    catch (InvalidArgumentException theEIAEx) {
                        LOGGER.log(Level.WARNING, "CANNOT_CROSS_LINK_PRODUCTS", theEIAEx);
                    }
                }
            }
            if (theRequiredProducts != null) {
                for (SystemProduct theTmpProduct : theRequiredProducts) {
                    theIndex = aCompleteProductList.indexOf(theTmpProduct);
                    try {
                        if (theIndex == -1) {
                            theNextProduct.setState(Backend.EntityState.DAMAGED);
                            theTmpProduct.setState(Backend.EntityState.NOT_INSTALLED);
                            theNextProduct.addRequiredProduct(theTmpProduct);
                            LOGGER.log(Level.FINE, "Product " + theNextProduct.getName() + " requires product " + theTmpProduct + ", but " + theTmpProduct + " is not installed.  Product is now broken.");
                            continue;
                        }
                        theNextProduct.addRequiredProduct(aCompleteProductList.get(theIndex));
                    }
                    catch (InvalidArgumentException theEIAEx) {
                        LOGGER.log(Level.WARNING, "CANNOT_CROSS_LINK_PRODUCTS", theEIAEx);
                    }
                }
            }
            aListener.updateProgress((int)(100.0 * (double)(++theCountOfProcessedPkgs) / (double)theTotalPkgCount));
        }
    }

    private List<SystemProduct> buildProductIndex(List<String> aMetaPkgNameSet, List<SystemProduct> aFilteredProductList, Map<SystemProduct, SystemProduct[]> aContainedProductsMap, Map<SystemProduct, SystemProduct[]> aRequiredProductsMap, List<Package> aCompletePkgList, ProgressListener aIndexListener) throws SIMSException {
        ArrayList<SystemProduct> theProducts = new ArrayList<SystemProduct>();
        int theCountOfProcessedPkgs = 0;
        int theTotalPkgCount = aMetaPkgNameSet.size();
        for (String thePkgName : aMetaPkgNameSet) {
            Map<RPMUtils.RPMTag, String> theRPMInfo = RPMUtils.getRPMInfo(thePkgName, this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN));
            Map<RPMUtils.SIMSRPMTag, String> theSIMSInfo = RPMUtils.getSIMSRPMInfo(thePkgName, this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN));
            String theName = theSIMSInfo.get((Object)RPMUtils.SIMSRPMTag.SIMS_PRODUCT_NAME);
            String theShortDesc = theSIMSInfo.get((Object)RPMUtils.SIMSRPMTag.SIMS_PRODUCT_READABLE_NAME);
            String theVersion = theRPMInfo.get((Object)RPMUtils.RPMTag.VERSION);
            String theInstance = theSIMSInfo.get((Object)RPMUtils.SIMSRPMTag.SIMS_INSTANCE_ID);
            String theCriticalFlag = theSIMSInfo.get((Object)RPMUtils.SIMSRPMTag.SIMS_CRITICAL);
            String theRelease = theSIMSInfo.get((Object)RPMUtils.SIMSRPMTag.SIMS_RELEASE);
            if (theName == null || theVersion == null || theInstance == null) {
                LOGGER.log(Level.SEVERE, "CORRUPT_PKG_INFO", thePkgName);
                continue;
            }
            try {
                String theCompatibleVersionInfo;
                String theContainedPackageInfo;
                SystemProduct theNewProduct = new SystemProduct(theName, new Version(theVersion), theInstance, theShortDesc);
                if ("true".equalsIgnoreCase(theCriticalFlag)) {
                    theNewProduct.setCritical(true);
                }
                if (theRelease != null) {
                    theNewProduct.setRelease(new Version(theRelease));
                }
                theNewProduct.setLocation(theSIMSInfo.get((Object)RPMUtils.SIMSRPMTag.SIMS_PRODUCT_BASEDIR));
                theNewProduct.setDescription(theSIMSInfo.get((Object)RPMUtils.SIMSRPMTag.SIMS_PRODUCT_DESC), new Locale("en"));
                theNewProduct.setState(Backend.EntityState.INSTALLED);
                theProducts.add(theNewProduct);
                String theContainedProductInfo = theSIMSInfo.get((Object)RPMUtils.SIMSRPMTag.SIMS_CONTAINED_PRODUCTS);
                String theRequiredProductInfo = theSIMSInfo.get((Object)RPMUtils.SIMSRPMTag.SIMS_REQUIRED_PRODUCTS);
                if (theContainedProductInfo != null) {
                    SystemProduct[] theContainedProductNames = Encoders.decodeProducts(theContainedProductInfo);
                    aContainedProductsMap.put(theNewProduct, theContainedProductNames);
                    aFilteredProductList.add(theNewProduct);
                }
                if (theRequiredProductInfo != null) {
                    SystemProduct[] theRequiredProductNames = Encoders.decodeProducts(theRequiredProductInfo);
                    aRequiredProductsMap.put(theNewProduct, theRequiredProductNames);
                    aFilteredProductList.add(theNewProduct);
                }
                if ((theContainedPackageInfo = theSIMSInfo.get((Object)RPMUtils.SIMSRPMTag.SIMS_CONTAINED_PACKAGES)) != null) {
                    Package[] theContainedPackages;
                    for (Package theTmpPkg : theContainedPackages = Encoders.decodePackages(theContainedPackageInfo)) {
                        int theIndex = aCompletePkgList.indexOf(theTmpPkg);
                        if (theIndex == -1) {
                            theTmpPkg.setState(Backend.EntityState.NOT_INSTALLED);
                            theNewProduct.addContainedPackage(theTmpPkg);
                            LOGGER.log(Level.FINE, "PRODUCT_PKG_CONTAINMENT", new String[]{theName, theTmpPkg.getName()});
                            continue;
                        }
                        theNewProduct.addContainedPackage(aCompletePkgList.get(theIndex));
                    }
                }
                if ((theCompatibleVersionInfo = theSIMSInfo.get((Object)RPMUtils.SIMSRPMTag.SIMS_COMPATIBLE_VERSIONS)) != null) {
                    VersionRange[] theCompatibleSpecs;
                    for (VersionRange theSpec : theCompatibleSpecs = VersionRange.decodeVersionRanges((String)theCompatibleVersionInfo)) {
                        theNewProduct.addCompatibleVersion(theSpec);
                    }
                }
                aIndexListener.updateProgress((int)(100.0 * (double)(++theCountOfProcessedPkgs) / (double)theTotalPkgCount));
            }
            catch (InvalidArgumentException theEIAEx) {
                theEIAEx.addContext("CANNOT_INSTANTIATE_PRODCUT", new String[]{"product=" + theName});
                LOGGER.log(Level.WARNING, "CANNOT_BUILD_PRODUCT_INDEX", theEIAEx);
            }
        }
        return theProducts;
    }

    @Override
    public List<Package> getAllPackages(ProgressListener aListener) throws SIMSException, InvalidArgumentException {
        ArrayList<Package> thePackages = new ArrayList<Package>();
        List<String> theUniverse = RPMUtils.getAllPackageNames(this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN), null);
        List<String> theProdPkgNames = RPMUtils.getAllPackageNames(this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN), "System Environment/sun-sims-product");
        ArrayList<Package> thePackagesWithRequires = new ArrayList<Package>();
        int theCountOfProcessedPkgs = 0;
        int theTotalPkgCount = theProdPkgNames.size();
        for (String thePkgName : theProdPkgNames) {
            try {
                Map<RPMUtils.SIMSRPMTag, String> theRpmInfo = RPMUtils.getSIMSRPMInfo(thePkgName, this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN));
                if (theRpmInfo.containsKey((Object)RPMUtils.SIMSRPMTag.SIMS_CONTAINED_PACKAGES)) {
                    Package[] theContainedPkgs = Encoders.decodePackages(theRpmInfo.get((Object)RPMUtils.SIMSRPMTag.SIMS_CONTAINED_PACKAGES));
                    List<Package> theEncodedPkgs = Arrays.asList(theContainedPkgs);
                    for (Package thePotentialPkg : theEncodedPkgs) {
                        if (!theUniverse.contains(thePotentialPkg.getName())) continue;
                        thePotentialPkg.setState(Backend.EntityState.INSTALLED);
                        thePackages.add(thePotentialPkg);
                    }
                    for (Package thePackage : theContainedPkgs) {
                        if (thePackage.getRequiredPackageCount() <= 0) continue;
                        thePackagesWithRequires.add(thePackage);
                    }
                }
            }
            catch (SIMSException theEx) {
                theEx.addContext("CORRUPT_PKG_INFO", new String[]{"package=" + thePkgName});
                throw theEx;
            }
            aListener.updateProgress((int)(100.0 * (double)(++theCountOfProcessedPkgs) / (double)theTotalPkgCount));
        }
        for (Package thePackageWithRequires : thePackagesWithRequires) {
            Iterator<Package> theReqdIt = thePackageWithRequires.getRequiredPackages();
            while (theReqdIt.hasNext()) {
                Package thePackage = theReqdIt.next();
                int theIndex = thePackages.indexOf(thePackage);
                if (theIndex == -1) {
                    LOGGER.log(Level.WARNING, "PACKAGE_DEPENDENCY_WARNING", new Object[]{thePackageWithRequires.getName(), thePackage});
                    thePackageWithRequires.setState(Backend.EntityState.DAMAGED);
                    thePackage.setState(Backend.EntityState.NOT_INSTALLED);
                    thePackageWithRequires.addRequiredPackage(thePackage);
                    continue;
                }
                Package theRequiredPkg = (Package)thePackages.get(theIndex);
                theRequiredPkg.setState(Backend.EntityState.INSTALLED);
                thePackageWithRequires.addRequiredPackage(theRequiredPkg);
            }
        }
        return thePackages;
    }
}

