/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims.backends.svr4;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.sims.util.SimsUtils;
import org.openinstaller.sims.util.TempFileManager;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.StringUtils;
import org.openinstaller.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SolarisPackageUtils {
    private static final String[][] DEFAULT_ADMIN_SETTINGS = new String[][]{{"mail", ""}, {"instance", "overwrite"}, {"partial", "nocheck "}, {"runlevel", "nocheck"}, {"idepend", "nocheck"}, {"rdepend", "nocheck "}, {"space", "nocheck"}, {"setuid", "nocheck"}, {"conflict", "nocheck"}, {"action", "nocheck"}, {"basedir", "default"}};
    private static final int MS_IN_SEC = 1000;
    private static final String OPTION_ALTROOT = "-R";
    public static final String CONTENTS_DB_PATH = "var/sadm/install/contents";
    public static final String PACKAGE_CATEGORY = "sims-package";
    public static final String PRODUCT_CATEGORY = "sims-product";
    private static final String PFEXEC_CMD = "/usr/bin/pfexec";
    private static final String SIMS_PKGNAME_PREFIX = "OIsims";
    private static final int PKGNAME_MAX = 31;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static final int KBYTE = 1024;
    private static final long SHORTMASK = 255L;
    private static final long MASK = 65535L;
    private static final long MASKWIDTH = 16L;

    private SolarisPackageUtils() {
    }

    public static void checkUtils() throws SIMSException {
        for (PkgCommand theCmd : PkgCommand.values()) {
            if (new File(theCmd.getPath()).exists()) continue;
            throw new SIMSException("Required packaging tool " + theCmd.getPath() + " not present", new String[0]);
        }
    }

    public static List<String> getAllPackageNames(String aAltRoot, String aDomain, String aCategory) throws SIMSException {
        ArrayList<String> thePackageNames = new ArrayList<String>();
        try {
            ArrayList<String> theCommandLine = new ArrayList<String>();
            theCommandLine.add(PkgCommand.PKGINFO.getPath());
            if (aCategory != null && !"".equals(aCategory)) {
                theCommandLine.add("-c");
                theCommandLine.add(aCategory);
            }
            if (aAltRoot != null || aDomain != null) {
                theCommandLine.add(OPTION_ALTROOT);
                try {
                    theCommandLine.add(SimsUtils.getFinalAltRoot(aAltRoot, aDomain).getAbsolutePath());
                }
                catch (EnhancedException theEx) {
                    throw new SIMSException(theEx, "CANNOT_GET_ALL_PKGS", "Category=" + aCategory + "root=" + aAltRoot, "domain=" + aDomain);
                }
            }
            Process theProcess = Runtime.getRuntime().exec(theCommandLine.toArray(new String[0]));
            BufferedReader theProcessStdin = new BufferedReader(new InputStreamReader(theProcess.getInputStream()));
            Pattern thePattern = Pattern.compile("^\\s*(\\S+)\\s+(\\S+).*");
            String theNextLine = theProcessStdin.readLine();
            while (theNextLine != null) {
                LOGGER.fine("PkgInfo = [" + theNextLine + "]");
                try {
                    Matcher thePkginfoMatcher = thePattern.matcher(theNextLine);
                    if (thePkginfoMatcher.matches()) {
                        String thePkgName = thePkginfoMatcher.group(2);
                        LOGGER.finest(" PKG  = " + thePkgName);
                        thePackageNames.add(thePkgName);
                    } else {
                        LOGGER.log(Level.WARNING, "INVALID_LINE", theNextLine);
                    }
                }
                catch (IllegalStateException theIse) {
                    LOGGER.log(Level.WARNING, "MATCH_OPERATION_FAILED");
                }
                theNextLine = theProcessStdin.readLine();
            }
            theProcessStdin.close();
            try {
                theProcess.waitFor();
                if (theProcess.exitValue() != 0) {
                    LOGGER.log(Level.FINE, "CMDLINE_EXIT_VAL", new Object[]{theCommandLine, theProcess.exitValue()});
                }
            }
            catch (InterruptedException theEx) {
                LOGGER.log(Level.WARNING, "INTERRUPTED_WHILE_WAITING", theCommandLine);
            }
        }
        catch (IOException theEx) {
            throw new SIMSException(theEx, "cannot get all packages", new String[0]);
        }
        return thePackageNames;
    }

    public static Map<PkgInfoEntry, String> getInfo(String aPkgName, String aAltRoot, String aDomain) throws SIMSException {
        HashMap<PkgInfoEntry, String> theValues = new HashMap<PkgInfoEntry, String>();
        try {
            ArrayList<String> theCommandLine = new ArrayList<String>();
            theCommandLine.add(PkgCommand.PKGPARAM.getPath());
            theCommandLine.add("-v");
            if (aAltRoot != null || aDomain != null) {
                theCommandLine.add(OPTION_ALTROOT);
                try {
                    theCommandLine.add(SimsUtils.getFinalAltRoot(aAltRoot, aDomain).getAbsolutePath());
                }
                catch (EnhancedException theEx) {
                    throw new SIMSException(theEx, "CANNOT_GET_PKG_INFO", "pkg=" + aPkgName + "root=" + aAltRoot, "domain=" + aDomain);
                }
            }
            theCommandLine.add(aPkgName);
            Process theProcess = Runtime.getRuntime().exec(theCommandLine.toArray(new String[0]));
            BufferedReader theProcessStdin = new BufferedReader(new InputStreamReader(theProcess.getInputStream()));
            Pattern thePattern = Pattern.compile("^\\s*(\\S[^=]*)='(.*)'\\s*$");
            String theNextLine = theProcessStdin.readLine();
            while (theNextLine != null) {
                try {
                    Matcher thePkginfoMatcher = thePattern.matcher(theNextLine);
                    if (thePkginfoMatcher.matches() && thePkginfoMatcher.groupCount() == 2) {
                        String theKey = thePkginfoMatcher.group(1);
                        String theValue = thePkginfoMatcher.group(2);
                        try {
                            theValues.put(PkgInfoEntry.valueOf(theKey), theValue);
                        }
                        catch (IllegalArgumentException theEx) {
                            LOGGER.log(Level.FINEST, "Unknown parameter [" + theKey + "] found in package [" + aPkgName + "]");
                        }
                    } else {
                        LOGGER.log(Level.WARNING, "Corrupted line in package [" + aPkgName + "]: \"" + theNextLine + "\"");
                    }
                }
                catch (IllegalStateException theIse) {
                    LOGGER.log(Level.WARNING, "MATCH_OPERATION_FAILED");
                }
                theNextLine = theProcessStdin.readLine();
            }
            theProcessStdin.close();
            try {
                theProcess.waitFor();
                if (theProcess.exitValue() != 0) {
                    throw new SIMSException("pkgparam command failed (non-zero exit status) for package " + aPkgName, new String[0]);
                }
            }
            catch (InterruptedException theEx) {
                LOGGER.log(Level.WARNING, "INTERRUPTED_WHILE_WAITING", theCommandLine);
            }
            return theValues;
        }
        catch (IOException theEx) {
            throw new SIMSException(theEx, "CANNOT_GET_PKG_INFO", "pkg=" + aPkgName + "root=" + aAltRoot, "domain=" + aDomain);
        }
    }

    public static String createSIMSPkgName(String aName, Version aVersion, String aInstanceID) {
        String thePostfix;
        try {
            MessageDigest theDigester = MessageDigest.getInstance("MD5");
            theDigester.update(aName.getBytes());
            theDigester.update(Version.encode((Version)aVersion).getBytes());
            theDigester.update(aInstanceID.getBytes());
            byte[] theDigest = theDigester.digest();
            thePostfix = StringUtils.encodeData((byte[])theDigest);
        }
        catch (NoSuchAlgorithmException theEx) {
            LOGGER.log(Level.WARNING, "CANT_CREATE_UNIQUE_PKGNAME", aName);
            thePostfix = aName + " - " + Version.encode((Version)aVersion) + " - " + aInstanceID;
            thePostfix = StringUtils.encodeData((byte[])thePostfix.getBytes());
        }
        StringBuffer theName = new StringBuffer(SIMS_PKGNAME_PREFIX);
        theName.append('-');
        theName.append(thePostfix);
        int theNameLength = theName.length();
        for (int theNameIndex = 0; theNameIndex < theNameLength; ++theNameIndex) {
            char theChar = theName.charAt(theNameIndex);
            if (theChar == '+' || theChar == '-' || Character.isLetterOrDigit(theChar)) continue;
            theName.setCharAt(theNameIndex, '-');
        }
        if (theName.length() > 31) {
            theName.setLength(31);
        }
        return theName.toString();
    }

    public static File createMetaPkg(String aPkgName, ProgressListener aListener, Map<PkgInfoEntry, String> aPkginfoEntryMap, List<Package> aDependList) throws EnhancedException {
        FileWriter theMapOut;
        FileWriter theInfoOut;
        File theTempDirFile = TempFileManager.findTempDir(aPkgName + "-simsmeta");
        File thePkgDir = new File(theTempDirFile, aPkgName);
        File thePkgInfoFile = new File(thePkgDir, "pkginfo");
        File thePkgmapFile = new File(thePkgDir, "pkgmap");
        File theInstallDir = new File(thePkgDir, "install");
        File theDependFile = new File(theInstallDir, "depend");
        if (aListener != null) {
            aListener.updateProgress(20);
        }
        try {
            if (!theTempDirFile.mkdir()) {
                throw new SIMSException("cannot make temp directory " + theTempDirFile, new String[0]);
            }
            TempFileManager.registerTempFile(theTempDirFile);
            if (!thePkgDir.mkdirs()) {
                throw new SIMSException("cannot make temp package directory " + thePkgDir, new String[0]);
            }
            TempFileManager.registerTempFile(thePkgDir);
            theInfoOut = new FileWriter(thePkgInfoFile);
            TempFileManager.registerTempFile(thePkgInfoFile);
            theMapOut = new FileWriter(thePkgmapFile);
            TempFileManager.registerTempFile(thePkgmapFile);
        }
        catch (IOException theEx) {
            throw new SIMSException(theEx, "cannot initialize directories " + thePkgDir + " and " + theInstallDir + " to create metapackage", new String[0]);
        }
        if (aListener != null) {
            aListener.updateProgress(50);
        }
        try {
            for (Map.Entry<PkgInfoEntry, String> theEntry : aPkginfoEntryMap.entrySet()) {
                String theKey = theEntry.getKey().name();
                String theValue = theEntry.getValue();
                theInfoOut.write(theKey + "=" + theValue + " \n");
            }
            theInfoOut.close();
        }
        catch (IOException theIoe) {
            throw new SIMSException(theIoe, "Cannot create pkginfo file " + thePkgInfoFile, new String[0]);
        }
        try {
            theMapOut.write(": 1 0\n");
            long theTimeOfDay = new Date().getTime() / 1000L;
            theMapOut.write("1 i pkginfo " + thePkgInfoFile.length() + " " + SolarisPackageUtils.cksum(thePkgInfoFile) + " " + Long.toString(theTimeOfDay) + "\n");
            theMapOut.close();
        }
        catch (IOException theEx) {
            throw new SIMSException(theEx, "Cannot create pkgmap file " + thePkgmapFile, new String[0]);
        }
        if (aListener != null) {
            aListener.updateProgress(80);
        }
        if (aDependList != null && !aDependList.isEmpty()) {
            try {
                if (!theInstallDir.mkdirs()) {
                    throw new SIMSException("cannot make temp directory " + theInstallDir, new String[0]);
                }
                TempFileManager.registerTempFile(theInstallDir);
                FileWriter theDependOut = new FileWriter(theDependFile);
                TempFileManager.registerTempFile(theDependFile);
                for (Package theEntry : aDependList) {
                    theDependOut.write("P " + theEntry.getName() + " " + theEntry.getDescription() + "\n");
                    theDependOut.write(" " + theEntry.getVersion() + "\n");
                }
                ((Writer)theDependOut).close();
            }
            catch (IOException theEx) {
                throw new SIMSException(theEx, "Cannot create depend file " + theDependFile, new String[0]);
            }
        }
        return theTempDirFile;
    }

    public static String cksum(File aFile) throws IOException {
        long theValue = 0L;
        byte[] theBuf = new byte[1024];
        BufferedInputStream theIn = new BufferedInputStream(new FileInputStream(aFile));
        int theAmtRead = ((InputStream)theIn).read(theBuf);
        while (theAmtRead != -1) {
            for (int theIndex = 0; theIndex < theAmtRead; ++theIndex) {
                theValue += (long)theBuf[theIndex] & 0xFFL;
            }
            theAmtRead = ((InputStream)theIn).read(theBuf);
        }
        ((InputStream)theIn).close();
        long theTempValue = (theValue & 0xFFFFL) + (theValue >> 16 & 0xFFL);
        theValue = (theTempValue & 0xFFFFL) + (theTempValue >> 16);
        return Long.toString(theValue);
    }

    public static void installPkg(File aSrcDir, String aPkgName, String aDomain, String aAltRoot) throws EnhancedException {
        File theTmpDirFile;
        File theAltPkgadd;
        boolean theAltToolFlag = false;
        ArrayList<String> theInstallCommand = new ArrayList<String>();
        theInstallCommand.add(PkgCommand.PKGADD.getPath());
        String theAltToolPath = System.getenv("INSTALL_OSTOOLS");
        if (theAltToolPath != null && (theAltPkgadd = new File(new File(theAltToolPath), PkgCommand.PKGADD.getPath())).exists()) {
            theInstallCommand.clear();
            theInstallCommand.add(theAltPkgadd.getAbsolutePath());
            File theAltBinPath = new File(new File(theAltToolPath), "usr/sadm/install/bin");
            theInstallCommand.add("-b");
            theInstallCommand.add(theAltBinPath.getAbsolutePath());
            theAltToolFlag = true;
        }
        if (!(theTmpDirFile = TempFileManager.findTempDir(aPkgName + "-admin")).mkdir()) {
            throw new EnhancedException("cannot make directory " + theTmpDirFile, new String[0]);
        }
        File theAdminFile = SolarisPackageUtils.writeAdminFile(theTmpDirFile, aPkgName);
        theInstallCommand.add("-n");
        theInstallCommand.add("-a");
        theInstallCommand.add(theAdminFile.getAbsolutePath());
        if (aAltRoot != null || aDomain != null) {
            theInstallCommand.add(OPTION_ALTROOT);
            theInstallCommand.add(SimsUtils.getFinalAltRoot(aAltRoot, aDomain).getAbsolutePath());
        }
        theInstallCommand.add("-d");
        theInstallCommand.add(aSrcDir.getAbsolutePath());
        theInstallCommand.add(aPkgName);
        if (!theAltToolFlag) {
            theInstallCommand.add(0, PFEXEC_CMD);
        }
        ExecuteCommand theCmd = new ExecuteCommand(theInstallCommand.toArray(new String[0]));
        theCmd.setCollectOutput(true);
        theCmd.setOutputType(3);
        if (theAltToolFlag) {
            File theAltLibDir = new File(new File(theAltToolPath), "usr/lib");
            File theAltLibSfwDir = new File(new File(theAltToolPath), "usr/sfw/lib");
            theCmd.putEnvironmentSetting("LD_LIBRARY_PATH", theAltLibDir.getAbsolutePath() + ":" + theAltLibSfwDir.getAbsolutePath());
            theCmd.putEnvironmentSetting("INSTALL_OSTOOLS", theAltToolPath);
        }
        theCmd.execute();
        int theResult = theCmd.getResult();
        if (theResult != 0) {
            throw new EnhancedException("pkgadd of " + aPkgName + " failed: exit code: " + theResult + " All Output: " + theCmd.getAllOutput(), new String[0]);
        }
        theAdminFile.delete();
        theTmpDirFile.delete();
    }

    public static void removePkg(String aPkgName, String aDomain, String aAltRoot) throws EnhancedException {
        File theTmpDirFile;
        File theAltPkgrm;
        boolean theAltToolFlag = false;
        ArrayList<String> theUninstallCommand = new ArrayList<String>();
        theUninstallCommand.add(PkgCommand.PKGRM.getPath());
        String theAltToolPath = System.getenv("INSTALL_OSTOOLS");
        if (theAltToolPath != null && (theAltPkgrm = new File(new File(theAltToolPath), PkgCommand.PKGRM.getPath())).exists()) {
            theUninstallCommand.clear();
            theUninstallCommand.add(theAltPkgrm.getAbsolutePath());
            File theAltBinPath = new File(new File(theAltToolPath), "usr/sadm/install/bin");
            theUninstallCommand.add("-b");
            theUninstallCommand.add(theAltBinPath.getAbsolutePath());
            theAltToolFlag = true;
        }
        if (!(theTmpDirFile = TempFileManager.findTempDir(aPkgName + "-remove-admin")).mkdir()) {
            throw new EnhancedException("cannot make directory " + theTmpDirFile, new String[0]);
        }
        File theAdminFile = SolarisPackageUtils.writeAdminFile(theTmpDirFile, aPkgName);
        theUninstallCommand.add("-n");
        theUninstallCommand.add("-a");
        theUninstallCommand.add(theAdminFile.getAbsolutePath());
        if (aAltRoot != null || aDomain != null) {
            theUninstallCommand.add(OPTION_ALTROOT);
            theUninstallCommand.add(SimsUtils.getFinalAltRoot(aAltRoot, aDomain).getAbsolutePath());
        }
        theUninstallCommand.add(aPkgName);
        if (!theAltToolFlag) {
            theUninstallCommand.add(0, PFEXEC_CMD);
        }
        ExecuteCommand theCmd = new ExecuteCommand(theUninstallCommand.toArray(new String[0]));
        theCmd.setCollectOutput(true);
        theCmd.setOutputType(3);
        if (theAltToolFlag) {
            File theAltLibDir = new File(new File(theAltToolPath), "usr/lib");
            File theAltLibSfwDir = new File(new File(theAltToolPath), "usr/sfw/lib");
            theCmd.putEnvironmentSetting("LD_LIBRARY_PATH", theAltLibDir.getAbsolutePath() + ":" + theAltLibSfwDir.getAbsolutePath());
            theCmd.putEnvironmentSetting("INSTALL_OSTOOLS", theAltToolPath);
        }
        theCmd.execute();
        int theResult = theCmd.getResult();
        if (theResult != 0) {
            throw new EnhancedException("pkgrm of " + aPkgName + " failed: exit code: " + theResult, new String[0]);
        }
        theAdminFile.delete();
        theTmpDirFile.delete();
    }

    public static File writeAdminFile(File aTmpDir, String aPrefix) throws EnhancedException {
        File theNewAdmin = new File(aTmpDir, aPrefix + "." + Math.random() + ".admin");
        try {
            BufferedWriter theBW = new BufferedWriter(new FileWriter(theNewAdmin));
            for (String[] theSetting : DEFAULT_ADMIN_SETTINGS) {
                theBW.write(theSetting[0] + "=" + theSetting[1]);
                theBW.newLine();
            }
            theBW.close();
            return theNewAdmin;
        }
        catch (IOException theIoe) {
            throw new EnhancedException("ERROR_WRITING_ADMIN_FILE", (Throwable)theIoe, new String[]{"file=" + theNewAdmin});
        }
    }

    protected static String findProduct(String aName, Version aVersion, String aInstance, String aAltRoot, String aDomain) throws EnhancedException {
        if (aName == null || aVersion == null || aInstance == null) {
            throw new IllegalArgumentException("findPackage: name, version, and instance must be non-null");
        }
        String theEncodedName = SolarisPackageUtils.createSIMSPkgName(PRODUCT_CATEGORY + aName, aVersion, aInstance);
        Map<PkgInfoEntry, String> theInfo = SolarisPackageUtils.getInfo(theEncodedName, aAltRoot, aDomain);
        if (aInstance.equals(theInfo.get((Object)PkgInfoEntry.SIMS_INSTANCE_ID)) && aVersion.equals((Object)new Version(theInfo.get((Object)PkgInfoEntry.VERSION))) && aName.equals(theInfo.get((Object)PkgInfoEntry.SIMS_PRODUCT_NAME))) {
            return theEncodedName;
        }
        List<String> theCompletePkgList = SolarisPackageUtils.getAllPackageNames(aAltRoot, aDomain, PRODUCT_CATEGORY);
        for (String thePkgName : theCompletePkgList) {
            Map<PkgInfoEntry, String> thePkgInfo = SolarisPackageUtils.getInfo(thePkgName, aAltRoot, aDomain);
            if (!aInstance.equals(thePkgInfo.get((Object)PkgInfoEntry.SIMS_INSTANCE_ID)) || !aVersion.equals((Object)new Version(thePkgInfo.get((Object)PkgInfoEntry.VERSION))) || !aName.equals(thePkgInfo.get((Object)PkgInfoEntry.SIMS_PRODUCT_NAME))) continue;
            return thePkgName;
        }
        return null;
    }

    public static boolean isSVR4Installed(String aPkgName, String aInstallHome) throws EnhancedException {
        ExecuteCommand theCmd;
        if (aPkgName == null) {
            throw new EnhancedException("NO_PACKAGE_NAME_FOUND_TO_DETECT", new String[0]);
        }
        ArrayList<String> theCommand = new ArrayList<String>();
        theCommand.add(PkgCommand.PKGINFO.getPath());
        if (aInstallHome != null && !"".equals(aInstallHome)) {
            theCommand.add(OPTION_ALTROOT);
            theCommand.add(aInstallHome);
        }
        theCommand.add("-q");
        theCommand.add(aPkgName);
        try {
            LOGGER.finest("Detection Command = " + ((Object)theCommand).toString());
            theCmd = new ExecuteCommand(theCommand.toArray(new String[0]));
            theCmd.execute();
        }
        catch (InvalidArgumentException theEx) {
            theEx.addContext("CANT_EXEC_PKG_CMD pkg=" + aPkgName, new String[0]);
            throw theEx;
        }
        catch (EnhancedException theEnX) {
            theEnX.addContext("CANT_EXEC_PKG_CMD command=" + ((Object)theCommand).toString(), new String[0]);
            throw theEnX;
        }
        return theCmd.getResult() == 0;
    }

    public static Version getPkgVersion(String aPkgName, String aInstallHome) throws SIMSException {
        Version theFoundVersion = null;
        Map<PkgInfoEntry, String> thePkgInfoMap = SolarisPackageUtils.getInfo(aPkgName, aInstallHome, null);
        if (thePkgInfoMap.containsKey((Object)PkgInfoEntry.VERSION)) {
            String theVersion = thePkgInfoMap.get((Object)PkgInfoEntry.valueOf(PkgInfoEntry.VERSION.toString()));
            LOGGER.finest(" Getting Pkg Ver from " + theVersion);
            if (theVersion.indexOf(",") != -1) {
                String[] theVerRevStr = theVersion.split(",");
                LOGGER.finest("Actual version is " + theVerRevStr[0]);
                theFoundVersion = new Version(theVerRevStr[0].trim());
            } else {
                theFoundVersion = new Version(theVersion.trim());
            }
            LOGGER.finest("@Detected Package : " + aPkgName + " with Version : " + theFoundVersion.toString());
        }
        return theFoundVersion;
    }

    public static String getPkgParam(String aPkgName, String aInstallHome, PkgInfoEntry aPkgParam) throws SIMSException {
        Map<PkgInfoEntry, String> thePkgInfoMap = SolarisPackageUtils.getInfo(aPkgName, aInstallHome, null);
        if (thePkgInfoMap.containsKey((Object)aPkgParam)) {
            return thePkgInfoMap.get((Object)aPkgParam);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PkgCommand {
        PKGADD("/usr/sbin/pkgadd"),
        PKGRM("/usr/sbin/pkgrm"),
        PKGPARAM("/usr/bin/pkgparam"),
        PKGINFO("/usr/bin/pkginfo");

        private String gCmd;

        private PkgCommand(String aCmd) {
            this.gCmd = aCmd;
        }

        public String getPath() {
            return this.gCmd;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PkgInfoEntry {
        ARCH,
        CATEGORY,
        NAME,
        PKG,
        VERSION,
        BASEDIR,
        CLASSES,
        DESC,
        EMAIL,
        HOTLINE,
        INTONLY,
        ISTATES,
        MAXINST,
        ORDER,
        PSTAMP,
        RSTATES,
        SUNW_ISA,
        SUNW_LOC,
        SUNW_PKG_DIR,
        SUNW_PKG_ALLZONES,
        SUNW_PKG_HOLLOW,
        SUNW_PKG_THISZONE,
        SUNW_PKGLIST,
        SUNW_PKGTYPE,
        SUNW_PKGVERS,
        SUNW_PRODNAME,
        SUNW_PRODVERS,
        ULIMIT,
        VENDOR,
        VSTOCK,
        PKGINST,
        PKGSAV,
        LANG,
        TZ,
        PATH,
        OAMBASE,
        INSTDATE,
        UPDATE,
        SUNW_PKGCOND_GLOBAL_DATA,
        SIMS_PRODUCT_NAME,
        SIMS_PRODUCT_READABLE_NAME,
        SIMS_INSTANCE_ID,
        SIMS_PRODUCT_BASEDIR,
        SIMS_CONTAINED_PRODUCTS,
        SIMS_REQUIRED_PRODUCTS,
        SIMS_CONTAINED_PACKAGES,
        SIMS_COMPATIBLE_VERSIONS,
        SIMS_BASE_PKG,
        SIMS_BASE_PKG_BASEDIR,
        SIMS_CRITICAL,
        SIMS_REQUIRED_PACKAGES;

    }
}

