/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims.backends.zip;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.sims.util.SimsUtils;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PkgDBUtils {
    public static final String CONTENTS_DB_PATH = "var/install/pkgdb";
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    private PkgDBUtils() {
    }

    public static List<Map<ZIPInfoEntry, String>> getAllPackageData(String aAltRoot, String aDomain, String aCategory) throws SIMSException {
        File theRoot;
        ArrayList<Map<ZIPInfoEntry, String>> thePkgs = new ArrayList<Map<ZIPInfoEntry, String>>();
        try {
            theRoot = SimsUtils.getFinalAltRoot(aAltRoot, aDomain);
        }
        catch (EnhancedException theEx) {
            throw new SIMSException(theEx, "CANT_FIND_ROOT", "root=" + aAltRoot, "domain=" + aDomain, "category=" + aCategory);
        }
        File theDbDir = new File(theRoot, CONTENTS_DB_PATH);
        if (!theDbDir.exists()) {
            return thePkgs;
        }
        if (aCategory != null && !(theDbDir = new File(theDbDir, aCategory)).exists()) {
            return thePkgs;
        }
        try {
            return PkgDBUtils.readAllEntries(theDbDir);
        }
        catch (IOException theEx) {
            throw new SIMSException(theEx, "CANT_READ_DB", "path=" + theDbDir, "category=" + aCategory);
        }
    }

    private static List<Map<ZIPInfoEntry, String>> readAllEntries(File aDbDir) throws IOException {
        ArrayList<Map<ZIPInfoEntry, String>> theEntries = new ArrayList<Map<ZIPInfoEntry, String>>();
        block2: for (File theFile : aDbDir.listFiles()) {
            if (theFile.isDirectory()) {
                theEntries.addAll(PkgDBUtils.readAllEntries(theFile));
                continue;
            }
            Properties theProps = new Properties();
            BufferedInputStream thePkgReader = new BufferedInputStream(new FileInputStream(theFile));
            LOGGER.fine("Loading install properties from " + theFile);
            theProps.load(thePkgReader);
            ((InputStream)thePkgReader).close();
            HashMap<ZIPInfoEntry, String> thePropMap = new HashMap<ZIPInfoEntry, String>();
            for (Map.Entry<Object, Object> theProp : theProps.entrySet()) {
                try {
                    thePropMap.put(ZIPInfoEntry.valueOf((String)theProp.getKey()), (String)theProp.getValue());
                }
                catch (IllegalArgumentException theEx) {
                    LOGGER.log(Level.WARNING, "CORRUPT_PKG_INFO", new String[]{"key=" + theProp, "file=" + theFile});
                    continue block2;
                }
            }
            theEntries.add(thePropMap);
        }
        return theEntries;
    }

    public static String createSIMSPkgName(String aName, Version aVersion, String aInstanceID) {
        return aName + "-" + Version.encode((Version)aVersion) + "-" + aInstanceID;
    }

    public static void registerInstalledPkg(Map<ZIPInfoEntry, String> aPkgData, String aDomain, String aAltRoot, String aCategory) throws EnhancedException {
        File theAltRoot;
        try {
            theAltRoot = SimsUtils.getFinalAltRoot(aAltRoot, aDomain);
        }
        catch (EnhancedException theEx) {
            throw new SIMSException(theEx, "CANNOT_REGISTER_PKG", "data=" + aPkgData, "domain=" + aDomain, "root=" + aAltRoot);
        }
        File thePkgDb = new File(theAltRoot, CONTENTS_DB_PATH);
        File theCatDir = new File(thePkgDb, aCategory);
        String theFileName = PkgDBUtils.createSIMSPkgName(aPkgData.get((Object)ZIPInfoEntry.SIMS_NAME), new Version(aPkgData.get((Object)ZIPInfoEntry.SIMS_VERSION)), aPkgData.get((Object)ZIPInfoEntry.SIMS_INSTANCE_ID));
        File theDbFile = new File(theCatDir, theFileName);
        if (!theDbFile.getParentFile().exists()) {
            theDbFile.getParentFile().mkdirs();
        }
        try {
            BufferedWriter theWriter = new BufferedWriter(new FileWriter(theDbFile, false));
            for (Map.Entry<ZIPInfoEntry, String> theEntry : aPkgData.entrySet()) {
                theWriter.write(theEntry.getKey().name() + "=" + theEntry.getValue());
                theWriter.newLine();
            }
            theWriter.close();
        }
        catch (IOException theEx) {
            throw new SIMSException(theEx, "CANNOT_REGISTER_PKG", "data=" + aPkgData, "domain=" + aDomain, "root=" + aAltRoot);
        }
    }

    public static void unregisterInstalledPkg(String aName, Version aVersion, String aInstanceId, String aCategory, String aDomain, String aAltRoot) throws EnhancedException {
        File theAltRoot;
        try {
            theAltRoot = SimsUtils.getFinalAltRoot(aAltRoot, aDomain);
        }
        catch (EnhancedException theEx) {
            throw new SIMSException(theEx, "CANNOT_UNREGISTER_PKG", "name=" + aName, "domain=" + aDomain, "root=" + aAltRoot);
        }
        File thePkgDb = new File(theAltRoot, CONTENTS_DB_PATH);
        File theCatDir = new File(thePkgDb, aCategory);
        String theFileName = PkgDBUtils.createSIMSPkgName(aName, aVersion, aInstanceId);
        File theDbFile = new File(theCatDir, theFileName);
        if (theDbFile.exists() && !theDbFile.delete()) {
            throw new SIMSException("CANT_DELETE_FILE", "file=" + theDbFile);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZIPInfoEntry {
        SIMS_DESC,
        SIMS_PRODUCT_READABLE_NAME,
        SIMS_VERSION,
        SIMS_NAME,
        SIMS_INSTANCE_ID,
        SIMS_PRODUCT_BASEDIR,
        SIMS_CONTAINED_PRODUCTS,
        SIMS_REQUIRED_PRODUCTS,
        SIMS_CONTAINED_PACKAGES,
        SIMS_COMPATIBLE_VERSIONS,
        SIMS_BASE_PKG,
        SIMS_BASE_PKG_BASEDIR,
        SIMS_REQUIRED_PACKAGES;

    }
}

