/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims.backends.zip;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.sims.Backend;
import org.openinstaller.sims.FractionalProgressListener;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.sims.backends.zip.PkgDBUtils;
import org.openinstaller.sims.util.Encoders;
import org.openinstaller.sims.util.SimsUtils;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Version;
import org.openinstaller.util.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SIMSBackend
extends Backend {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    @Override
    public void initialize() throws SIMSException {
        this.setPermissions();
    }

    private void setPermissions() throws SIMSException {
        File theDB;
        File theInstallHome;
        StringBuffer thePerms = new StringBuffer();
        String theAltRoot = this.getAttribute(Backend.Attribute.ALTERNATE_ROOT);
        String theDomain = this.getAttribute(Backend.Attribute.DOMAIN);
        try {
            theInstallHome = SimsUtils.getFinalAltRoot(theAltRoot, theDomain);
        }
        catch (EnhancedException theEx) {
            throw new SIMSException(theEx, "CANT_SET_PERMS", "root=" + theAltRoot, "domain=" + theDomain);
        }
        LOGGER.fine("Checking DB at " + theDB);
        for (theDB = new File(theInstallHome, "var/install/pkgdb"); theDB != null && !theDB.exists(); theDB = theDB.getParentFile()) {
            LOGGER.fine("Checking DB at " + theDB);
        }
        if (theDB == null) {
            throw new SIMSException("PACKAGE_DB_NO_ACCESS", "path=" + theInstallHome, "file=var/install/pkgdb");
        }
        if (theDB.canWrite()) {
            LOGGER.fine("DB at " + theDB + " is WRITABLE");
            thePerms.append('w');
        }
        if (theDB.canRead()) {
            LOGGER.fine("DB at " + theDB + " is READABLE");
            thePerms.append('r');
        }
        LOGGER.fine("Setting permissions to " + thePerms.toString() + " for DB" + theDB);
        this.setAttribute(Backend.Attribute.PERMISSIONS, thePerms.toString());
    }

    @Override
    public void registerProduct(SystemProduct aProduct, ProgressListener aListener) throws SIMSException {
        String thePkgName = PkgDBUtils.createSIMSPkgName(aProduct.getName(), aProduct.getVersion(), aProduct.getInstance());
        HashMap<PkgDBUtils.ZIPInfoEntry, String> theEntries = new HashMap<PkgDBUtils.ZIPInfoEntry, String>();
        theEntries.put(PkgDBUtils.ZIPInfoEntry.SIMS_NAME, aProduct.getName());
        theEntries.put(PkgDBUtils.ZIPInfoEntry.SIMS_PRODUCT_READABLE_NAME, aProduct.getShortDescription());
        theEntries.put(PkgDBUtils.ZIPInfoEntry.SIMS_INSTANCE_ID, aProduct.getInstance());
        theEntries.put(PkgDBUtils.ZIPInfoEntry.SIMS_PRODUCT_BASEDIR, aProduct.getLocation());
        theEntries.put(PkgDBUtils.ZIPInfoEntry.SIMS_VERSION, Version.encode((Version)aProduct.getVersion()));
        theEntries.put(PkgDBUtils.ZIPInfoEntry.SIMS_DESC, aProduct.getDescription());
        Set<SystemProduct> theContainedProducts = aProduct.getContainedProducts();
        Set<SystemProduct> theRequiredProducts = aProduct.getRequiredProducts();
        Set<Package> theContainedPackages = aProduct.getContainedPackages();
        Set<VersionRange> theCompatibleVersions = aProduct.getCompatibleVersions();
        if (!theContainedProducts.isEmpty()) {
            theEntries.put(PkgDBUtils.ZIPInfoEntry.SIMS_CONTAINED_PRODUCTS, Encoders.encodeProducts(theContainedProducts));
        }
        if (!theRequiredProducts.isEmpty()) {
            theEntries.put(PkgDBUtils.ZIPInfoEntry.SIMS_REQUIRED_PRODUCTS, Encoders.encodeProducts(theRequiredProducts));
        }
        if (!theContainedPackages.isEmpty()) {
            theEntries.put(PkgDBUtils.ZIPInfoEntry.SIMS_CONTAINED_PACKAGES, Encoders.encodePackages(theContainedPackages));
        }
        if (!theCompatibleVersions.isEmpty()) {
            theEntries.put(PkgDBUtils.ZIPInfoEntry.SIMS_COMPATIBLE_VERSIONS, VersionRange.encodeVersionRanges(theCompatibleVersions));
        }
        try {
            if (this.isDryRun()) {
                LOGGER.log(Level.INFO, "SIMS_DRY_RUN", aProduct.getName());
            } else {
                PkgDBUtils.registerInstalledPkg(theEntries, this.getAttribute(Backend.Attribute.DOMAIN), this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), "sims-product");
            }
        }
        catch (EnhancedException theEx) {
            theEx.logFatal();
            throw new SIMSException(theEx, "CANNOT_INSTALL_PACKAGE", "package=" + thePkgName);
        }
        if (aListener != null) {
            aListener.updateProgress(100);
        }
    }

    @Override
    public void registerPackage(Package aPkg, ProgressListener aListener) {
    }

    @Override
    public void unregisterProduct(SystemProduct aProduct, ProgressListener aListener) throws SIMSException {
        if (aListener != null) {
            aListener.updateProgress(50);
        }
        try {
            if (this.isDryRun()) {
                LOGGER.log(Level.INFO, "SIMS_DRY_RUN", new String[]{"product=", aProduct.getName()});
            } else {
                PkgDBUtils.unregisterInstalledPkg(aProduct.getName(), aProduct.getVersion(), aProduct.getInstance(), "sims-product", this.getAttribute(Backend.Attribute.DOMAIN), this.getAttribute(Backend.Attribute.ALTERNATE_ROOT));
            }
        }
        catch (EnhancedException theEe) {
            throw new SIMSException(theEe, "CANNOT_REGISTER_PACKAGE", "product=" + aProduct.getName());
        }
        if (aListener != null) {
            aListener.updateProgress(100);
        }
    }

    @Override
    public void unregisterPackage(Package aPkg, ProgressListener aListener) {
    }

    @Override
    public List<SystemProduct> getAllProducts(List<Package> aPkgList, ProgressListener aListener) throws SIMSException {
        List<Map<PkgDBUtils.ZIPInfoEntry, String>> theMetaPkgs = PkgDBUtils.getAllPackageData(this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN), "sims-product");
        ArrayList<SystemProduct> theProdsWithContainedOrRequiredProds = new ArrayList<SystemProduct>();
        Hashtable<SystemProduct, SystemProduct[]> theContainedProductsMap = new Hashtable<SystemProduct, SystemProduct[]>();
        Hashtable<SystemProduct, SystemProduct[]> theRequiredProductsMap = new Hashtable<SystemProduct, SystemProduct[]>();
        FractionalProgressListener theIndexListener = null;
        FractionalProgressListener theCrossLinkListener = null;
        try {
            theIndexListener = new FractionalProgressListener(aListener, 20, 80);
            theCrossLinkListener = new FractionalProgressListener(aListener, 80, 100);
        }
        catch (InvalidArgumentException theEx) {
            LOGGER.log(Level.FINE, "Cannot create progress listener", theEx);
        }
        List<SystemProduct> theProducts = this.buildProductIndex(theMetaPkgs, theProdsWithContainedOrRequiredProds, theContainedProductsMap, theRequiredProductsMap, aPkgList, theIndexListener);
        this.crossLinkProducts(theProducts, theProdsWithContainedOrRequiredProds, theContainedProductsMap, theRequiredProductsMap, theCrossLinkListener);
        return theProducts;
    }

    private void crossLinkProducts(List<SystemProduct> aCompleteProductList, List<SystemProduct> aFilteredProductsList, Map<SystemProduct, SystemProduct[]> aContainedProductsMap, Map<SystemProduct, SystemProduct[]> aRequiredProductsMap, ProgressListener aListener) {
        int theTotalPkgCount = aFilteredProductsList.size();
        int theCountOfProcessedPkgs = 0;
        for (SystemProduct theNextProduct : aFilteredProductsList) {
            int theIndex;
            SystemProduct[] theContainedProducts = aContainedProductsMap.get(theNextProduct);
            SystemProduct[] theRequiredProducts = aRequiredProductsMap.get(theNextProduct);
            if (theContainedProducts != null) {
                for (SystemProduct theTmpProduct : theContainedProducts) {
                    theIndex = aCompleteProductList.indexOf(theTmpProduct);
                    try {
                        if (theIndex == -1) {
                            theTmpProduct.setState(Backend.EntityState.NOT_INSTALLED);
                            theNextProduct.addContainedProduct(theTmpProduct);
                            LOGGER.log(Level.FINE, "PRODUCT_CONTAINMENT", new Object[]{theNextProduct.getName(), theTmpProduct, theTmpProduct});
                            continue;
                        }
                        theNextProduct.addContainedProduct(aCompleteProductList.get(theIndex));
                    }
                    catch (InvalidArgumentException theEIAEx) {
                        LOGGER.log(Level.WARNING, "CANNOT_CROSS_LINK_PRODUCTS", theEIAEx);
                    }
                }
            }
            if (theRequiredProducts != null) {
                for (SystemProduct theTmpProduct : theRequiredProducts) {
                    theIndex = aCompleteProductList.indexOf(theTmpProduct);
                    try {
                        if (theIndex == -1) {
                            theNextProduct.setState(Backend.EntityState.DAMAGED);
                            theTmpProduct.setState(Backend.EntityState.NOT_INSTALLED);
                            theNextProduct.addRequiredProduct(theTmpProduct);
                            LOGGER.log(Level.FINE, "PRODUCT_REQUIRES", new Object[]{theNextProduct.getName(), theTmpProduct, theTmpProduct});
                            continue;
                        }
                        theNextProduct.addRequiredProduct(aCompleteProductList.get(theIndex));
                    }
                    catch (InvalidArgumentException theEIAEx) {
                        LOGGER.log(Level.WARNING, "CANNOT_CROSS_LINK_PRODUCTS", theEIAEx);
                    }
                }
            }
            aListener.updateProgress((int)(100.0 * (double)(++theCountOfProcessedPkgs) / (double)theTotalPkgCount));
        }
    }

    private List<SystemProduct> buildProductIndex(List<Map<PkgDBUtils.ZIPInfoEntry, String>> aMetaPkgNameSet, List<SystemProduct> aFilteredProductList, Map<SystemProduct, SystemProduct[]> aContainedProductsMap, Map<SystemProduct, SystemProduct[]> aRequiredProductsMap, List<Package> aCompletePkgList, ProgressListener aIndexListener) throws SIMSException {
        ArrayList<SystemProduct> theProducts = new ArrayList<SystemProduct>();
        int theCountOfProcessedPkgs = 0;
        int theTotalPkgCount = aMetaPkgNameSet.size();
        for (Map<PkgDBUtils.ZIPInfoEntry, String> thePkgInfo : aMetaPkgNameSet) {
            String theName = thePkgInfo.get((Object)PkgDBUtils.ZIPInfoEntry.SIMS_NAME);
            String theShortDesc = thePkgInfo.get((Object)PkgDBUtils.ZIPInfoEntry.SIMS_PRODUCT_READABLE_NAME);
            String theVersion = thePkgInfo.get((Object)PkgDBUtils.ZIPInfoEntry.SIMS_VERSION);
            String theInstance = thePkgInfo.get((Object)PkgDBUtils.ZIPInfoEntry.SIMS_INSTANCE_ID);
            if (theName == null || theVersion == null || theInstance == null) {
                LOGGER.log(Level.SEVERE, "CORRUPT_PKGINFO", thePkgInfo);
                continue;
            }
            try {
                String theCompatibleVersionInfo;
                String theContainedPackageInfo;
                SystemProduct theNewProduct = new SystemProduct(theName, new Version(theVersion), theInstance, theShortDesc);
                theNewProduct.setLocation(thePkgInfo.get((Object)PkgDBUtils.ZIPInfoEntry.SIMS_PRODUCT_BASEDIR));
                theNewProduct.setState(Backend.EntityState.INSTALLED);
                theProducts.add(theNewProduct);
                String theContainedProductInfo = thePkgInfo.get((Object)PkgDBUtils.ZIPInfoEntry.SIMS_CONTAINED_PRODUCTS);
                String theRequiredProductInfo = thePkgInfo.get((Object)PkgDBUtils.ZIPInfoEntry.SIMS_REQUIRED_PRODUCTS);
                if (theContainedProductInfo != null) {
                    SystemProduct[] theContainedProducts = Encoders.decodeProducts(theContainedProductInfo);
                    aContainedProductsMap.put(theNewProduct, theContainedProducts);
                    aFilteredProductList.add(theNewProduct);
                }
                if (theRequiredProductInfo != null) {
                    SystemProduct[] theRequiredProducts = Encoders.decodeProducts(theRequiredProductInfo);
                    aRequiredProductsMap.put(theNewProduct, theRequiredProducts);
                    aFilteredProductList.add(theNewProduct);
                }
                if ((theContainedPackageInfo = thePkgInfo.get((Object)PkgDBUtils.ZIPInfoEntry.SIMS_CONTAINED_PACKAGES)) != null) {
                    Package[] theContainedPackageSpecs;
                    for (Package theTmpPkg : theContainedPackageSpecs = Encoders.decodePackages(theContainedPackageInfo)) {
                        int theIndex = aCompletePkgList.indexOf(theTmpPkg);
                        if (theIndex == -1) {
                            theTmpPkg.setState(Backend.EntityState.NOT_INSTALLED);
                            theNewProduct.addContainedPackage(theTmpPkg);
                            LOGGER.log(Level.FINE, "PRODUCT_PKG_CONTAINMENT", new String[]{theName, theTmpPkg.getName()});
                            continue;
                        }
                        theNewProduct.addContainedPackage(aCompletePkgList.get(theIndex));
                    }
                }
                if ((theCompatibleVersionInfo = thePkgInfo.get((Object)PkgDBUtils.ZIPInfoEntry.SIMS_COMPATIBLE_VERSIONS)) != null) {
                    VersionRange[] theCompatibleRanges;
                    for (VersionRange theRange : theCompatibleRanges = VersionRange.decodeVersionRanges((String)theCompatibleVersionInfo)) {
                        theNewProduct.addCompatibleVersion(theRange);
                    }
                }
                ++theCountOfProcessedPkgs;
                if (aIndexListener == null) continue;
                aIndexListener.updateProgress((int)(100.0 * (double)theCountOfProcessedPkgs / (double)theTotalPkgCount));
            }
            catch (InvalidArgumentException theEIAEx) {
                theEIAEx.addContext("CANNOT_INSTANTIATE_PRODCUT", new String[]{"product=" + theName});
                LOGGER.log(Level.WARNING, "CANNOT_BUILD_PRODUCT_INDEX", theEIAEx);
            }
        }
        return theProducts;
    }

    @Override
    public List<Package> getAllPackages(ProgressListener aListener) throws SIMSException {
        ArrayList<Package> thePackages = new ArrayList<Package>();
        List<Map<PkgDBUtils.ZIPInfoEntry, String>> theProdPkgData = PkgDBUtils.getAllPackageData(this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN), "sims-product");
        ArrayList<Package> thePackagesWithRequires = new ArrayList<Package>();
        int theCountOfProcessedPkgs = 0;
        int theTotalPkgCount = theProdPkgData.size();
        for (Map<PkgDBUtils.ZIPInfoEntry, String> thePkgData : theProdPkgData) {
            try {
                if (thePkgData.containsKey((Object)PkgDBUtils.ZIPInfoEntry.SIMS_CONTAINED_PACKAGES)) {
                    Package[] theContainedPkgs = Encoders.decodePackages(thePkgData.get((Object)PkgDBUtils.ZIPInfoEntry.SIMS_CONTAINED_PACKAGES));
                    thePackages.addAll(Arrays.asList(theContainedPkgs));
                    for (Package thePackage : theContainedPkgs) {
                        thePackage.setState(Backend.EntityState.INSTALLED);
                        if (thePackage.getRequiredPackageCount() <= 0) continue;
                        thePackagesWithRequires.add(thePackage);
                    }
                }
            }
            catch (SIMSException theEx) {
                theEx.addContext("CORRUPT_PKG_INFO", new String[]{"package=" + thePkgData});
                throw theEx;
            }
            aListener.updateProgress((int)(100.0 * (double)(++theCountOfProcessedPkgs) / (double)theTotalPkgCount));
        }
        for (Package thePackageWithRequires : thePackagesWithRequires) {
            Iterator<Package> theReqdIt = thePackageWithRequires.getRequiredPackages();
            while (theReqdIt.hasNext()) {
                Package thePackage = theReqdIt.next();
                int theIndex = thePackages.indexOf(thePackage);
                if (theIndex == -1) {
                    LOGGER.log(Level.WARNING, "PACKAGE_DEPENDENCY_WARNING", new Object[]{thePackageWithRequires.getName(), thePackage});
                    thePackageWithRequires.setState(Backend.EntityState.DAMAGED);
                    thePackage.setState(Backend.EntityState.NOT_INSTALLED);
                    try {
                        thePackageWithRequires.addRequiredPackage(thePackage);
                    }
                    catch (InvalidArgumentException theEx) {
                        LOGGER.log(Level.WARNING, "PACKAGE_SELF_DEPEND", thePackageWithRequires);
                    }
                    continue;
                }
                try {
                    thePackageWithRequires.addRequiredPackage((Package)thePackages.get(theIndex));
                }
                catch (InvalidArgumentException theEx) {
                    LOGGER.log(Level.WARNING, "PACKAGE_SELF_DEPEND", thePackageWithRequires);
                }
            }
        }
        return thePackages;
    }
}

