/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims.backends.zip;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;
import org.openinstaller.util.InvalidArgumentException;

public class WindowsUtils {
    private static final String WINDOWS_REG_COMMAND = "reg";
    private static final String WINDOWS_REG_OPTION = "query";
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    private WindowsUtils() {
    }

    public static boolean found(String aKey, String aValue) throws EnhancedException {
        ExecuteCommand theCmd;
        if (aKey == null) {
            throw new IllegalArgumentException("REG_KEY_NULL");
        }
        ArrayList<String> theCommand = new ArrayList<String>();
        theCommand.add(WINDOWS_REG_COMMAND);
        theCommand.add(WINDOWS_REG_OPTION);
        theCommand.add(aKey);
        theCommand.add("/v");
        theCommand.add(aValue);
        try {
            theCmd = new ExecuteCommand(theCommand.toArray(new String[0]));
            theCmd.execute();
        }
        catch (InvalidArgumentException theEx) {
            throw new EnhancedException("CANT_EXEC_REG_CMD key=" + aKey, (Throwable)theEx, new String[0]);
        }
        catch (EnhancedException theEnX) {
            throw new EnhancedException("CANT_EXEC_REG_CMD command=" + ((Object)theCommand).toString(), (Throwable)theEnX, new String[0]);
        }
        return theCmd.getResult() == 0;
    }
}

