/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims.util;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public final class TempFileManager {
    private static final Set<File> FILES = Collections.synchronizedSortedSet(new TreeSet<File>(new Comparator<File>(){

        @Override
        public int compare(File aFile, File aDifferentFile) {
            if (aDifferentFile.getAbsolutePath().length() == aFile.getAbsolutePath().length()) {
                if (aDifferentFile.getAbsolutePath().equals(aFile.getAbsolutePath())) {
                    return 0;
                }
                return 1;
            }
            return aDifferentFile.getAbsolutePath().length() - aFile.getAbsolutePath().length();
        }
    }));

    private TempFileManager() {
    }

    public static void registerTempFile(File aFile) {
        FILES.add(aFile);
    }

    public static boolean deleteTempFiles() {
        boolean theAllDeletedFlag = true;
        for (File theFile : FILES) {
            if (theFile.isFile() && theFile.exists()) {
                if (theFile.delete()) continue;
                theAllDeletedFlag = false;
                continue;
            }
            if (!theFile.isDirectory() || !theFile.exists() || theFile.list().length != 0 || theFile.delete()) continue;
            theAllDeletedFlag = false;
        }
        FILES.clear();
        return theAllDeletedFlag;
    }

    public static File findTempDir(String aPrefix) {
        String theTempDirName = System.getProperty("java.io.tmpdir");
        if (theTempDirName == null) {
            theTempDirName = "/tmp";
        }
        File theNewTmpDir = new File(theTempDirName);
        while ((theNewTmpDir = new File(theNewTmpDir, aPrefix + "-" + Math.random())).exists()) {
        }
        return theNewTmpDir;
    }
}

