/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.core;

import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusException;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.core.EngineBootstrap;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.core.EngineConfigManager;
import org.openinstaller.core.IllegalConfigException;
import org.openinstaller.core.OrchestratorCommand;
import org.openinstaller.core.PROCESSING_MODE;
import org.openinstaller.core.ReturnValue;
import org.openinstaller.core.TempFileProvider;
import org.openinstaller.provider.conf.ConfigControl;
import org.openinstaller.provider.dependency.DependencyControl;
import org.openinstaller.provider.sims.SIMSControl;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.GetOpt;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.LocaleUtils;
import org.openinstaller.util.Msg;
import org.openinstaller.util.Platform;
import org.openinstaller.util.StringUtils;
import org.openinstaller.util.WebStartUtils;
import org.openinstaller.util.logging.LogUtils;
import org.openinstaller.util.logging.OpenInstallerLoggerAdapter;
import org.openinstaller.util.logging.UniformLogFormatter;
import org.openinstaller.util.ui.ChaxStandaloneSplash;
import org.openinstaller.util.ui.StandaloneSplash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Orchestrator
implements ServiceProvider,
Runnable {
    private ControlBus gBus;
    private EngineConfigManager gConfigManager;
    private final EngineBootstrap gBootstrap;
    private static final String PARENT_LOGGER = "org.openinstaller";
    private File gTempLogLocation;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private Level gLevel;

    @Override
    public void run() {
        if (this.gBus != null) {
            this.gBus.shutdown();
        }
    }

    public void main(String[] aArgSet) {
        block66: {
            try {
                try {
                    BusResponse theUIResp;
                    String theDefaultProductID;
                    Object[] theDescArray;
                    DependencyControl theDPCntrl;
                    BusRequest theDPReq;
                    BusResponse theDPResp;
                    int theOption;
                    Handler[] theHandlers = Logger.getLogger("").getHandlers();
                    Handler theConsoleHandler = null;
                    for (Handler theHandler : theHandlers) {
                        if (!ConsoleHandler.class.isInstance(theHandler)) continue;
                        theConsoleHandler = theHandler;
                        theConsoleHandler.setFormatter(new SimpleLocalizedFormatter());
                    }
                    if (theConsoleHandler == null) {
                        theConsoleHandler = new ConsoleHandler();
                        theConsoleHandler.setFormatter(new SimpleLocalizedFormatter());
                        Logger.getLogger("").addHandler(theConsoleHandler);
                    }
                    this.gBus = ControlBus.getInstance();
                    Runtime.getRuntime().addShutdownHook(new Thread(this));
                    this.gConfigManager = new EngineConfigManager();
                    LOGGER.log(Level.FINE, "INIT_BUS");
                    this.gBus.register(this.gConfigManager);
                    this.gBus.register(new TempFileProvider());
                    LOGGER.log(Level.FINE, "READ_DEF_CONFIG");
                    this.gConfigManager.loadDefaultConfig();
                    GetOpt theOptionParser = new GetOpt(aArgSet, "c:p:");
                    HashMap<EngineConfigItem, String> theUsedCLIOptions = new HashMap<EngineConfigItem, String>();
                    block29: while ((theOption = theOptionParser.getNextOption()) != -1) {
                        switch (theOption) {
                            case 99: {
                                try {
                                    this.gConfigManager.mergeConfig(new URL(theOptionParser.getOptionArg()));
                                    continue block29;
                                }
                                catch (MalformedURLException theEx) {
                                    throw new EnhancedException("BAD_PATH", (Throwable)theEx, "path=" + theOptionParser.getOptionArg());
                                }
                                catch (IOException theEx) {
                                    throw new EnhancedException("CANT_READ", (Throwable)theEx, "path=" + theOptionParser.getOptionArg());
                                }
                            }
                            case 112: {
                                String[] theComps = theOptionParser.getOptionArg().split("=", 2);
                                if (theComps.length != 2) {
                                    LOGGER.log(Level.WARNING, "IS_NOT_NAME_EQUALS_VALUE_FORM", "option=" + theOptionParser.getOptionArg());
                                    continue block29;
                                }
                                try {
                                    EngineConfigItem theConfigItem = EngineConfigItem.getConfigItem(theComps[0]);
                                    String thePrevOption = (String)theUsedCLIOptions.get((Object)theConfigItem);
                                    if (thePrevOption != null) {
                                        LOGGER.log(Level.WARNING, "DUPLICATE_CONFIG", new String[]{"option=" + theConfigItem.getString(), "prev-val=" + thePrevOption});
                                    }
                                    this.gConfigManager.setConfig(theConfigItem, theComps[1]);
                                    theUsedCLIOptions.put(theConfigItem, theComps[1]);
                                }
                                catch (IllegalConfigException theEx) {
                                    LOGGER.log(Level.WARNING, "NOT_CONFIG_SET", "option=" + theComps[0]);
                                }
                                continue block29;
                            }
                        }
                        LOGGER.log(Level.WARNING, "UNKNOWN_OPT", "option=" + aArgSet[theOption]);
                    }
                    String theDisplayMode = this.gConfigManager.getConfig(EngineConfigItem.DISPLAY_MODE);
                    if ("GUI".equalsIgnoreCase(theDisplayMode) && GraphicsEnvironment.isHeadless()) {
                        this.gConfigManager.setConfig(EngineConfigItem.DISPLAY_MODE, "CUI");
                    }
                    this.setupLogging();
                    this.gBus.register(this);
                    String theInstallableUnitPath = null;
                    String theAnswerFiles = this.gConfigManager.getConfig(EngineConfigItem.ANSWER_FILES);
                    if (theAnswerFiles != null) {
                        ArrayList<URL> theFinalFiles = new ArrayList<URL>();
                        for (String theAnswerFile : theAnswerFiles.split(",")) {
                            if (theAnswerFile.trim().equals("")) {
                                LOGGER.finest("Ignoring blank answer file or syntax error in " + theAnswerFiles);
                                continue;
                            }
                            File theAnswerFileTest = new File(theAnswerFile);
                            try {
                                if (theAnswerFileTest.exists()) {
                                    theFinalFiles.add(theAnswerFileTest.toURI().toURL());
                                    continue;
                                }
                                theFinalFiles.add(new URL(theAnswerFile));
                            }
                            catch (MalformedURLException theMalformedURLException) {
                                throw new BusException("INVALID_ANSWER_FILE_URL", (Throwable)theMalformedURLException, "url=" + theAnswerFiles);
                            }
                        }
                        this.gConfigManager.setConfig(EngineConfigItem.ANSWER_FILES, StringUtils.join(theFinalFiles, ","));
                    }
                    try {
                        theInstallableUnitPath = this.gConfigManager.getConfig(EngineConfigItem.INSTALLABLE_UNIT_PATH);
                    }
                    catch (Throwable theEx) {
                        LOGGER.log(Level.WARNING, "Ignoring unresolvable INSTALLABLE_UNIT_PATH", theEx);
                    }
                    if (theInstallableUnitPath != null) {
                        if (!theInstallableUnitPath.endsWith("/")) {
                            theInstallableUnitPath = theInstallableUnitPath + "/";
                            this.gConfigManager.setConfig(EngineConfigItem.INSTALLABLE_UNIT_PATH, theInstallableUnitPath);
                        }
                        this.gConfigManager.setConfig(EngineConfigItem.PROCESSING_MODE, PROCESSING_MODE.INSTALL.name());
                    } else {
                        this.gConfigManager.setConfig(EngineConfigItem.PROCESSING_MODE, PROCESSING_MODE.REMOVE.name());
                    }
                    String theMediaPath = null;
                    try {
                        theMediaPath = this.gConfigManager.getConfig(EngineConfigItem.MEDIA_LOCATION);
                    }
                    catch (Throwable theEx) {
                        LOGGER.log(Level.WARNING, "Ignoring unresolvable INSTALLABLE_UNIT_PATH", theEx);
                    }
                    if (theMediaPath != null && !theMediaPath.endsWith("/")) {
                        theMediaPath = theMediaPath + "/";
                        this.gConfigManager.setConfig(EngineConfigItem.MEDIA_LOCATION, theMediaPath);
                    }
                    String theAltRoot = this.gConfigManager.getConfig(EngineConfigItem.ALTERNATE_ROOT);
                    String theDynamicTextPath = System.getenv("SPLASH_NAME");
                    File theDynamicSplashTextFile = null;
                    if (theDynamicTextPath != null) {
                        theDynamicSplashTextFile = new File(System.getenv("SPLASH_NAME"));
                    }
                    Object theSplash = null;
                    if (this.gConfigManager.getConfig(EngineConfigItem.DISPLAY_MODE).equalsIgnoreCase("CUI")) {
                        Properties theCUIProperties = new Properties();
                        for (String theCandidate : LocaleUtils.getCandidateResourceNames("/templates/Splash.properties", Locale.getDefault())) {
                            try {
                                LOGGER.fine("Looking for " + theCandidate);
                                InputStream theIn = this.getClass().getResourceAsStream(theCandidate);
                                if (theIn == null) continue;
                                LOGGER.fine("Will attempt to load " + theIn);
                                theCUIProperties.load(theIn);
                                theIn.close();
                                break;
                            }
                            catch (IOException theEx) {
                                LOGGER.fine("Attempt to load " + theCandidate + " failed");
                            }
                        }
                        if (theCUIProperties.isEmpty()) {
                            LOGGER.log(Level.FINE, "Missing Splash.properties");
                        }
                        Logger.getLogger("").removeHandler(theConsoleHandler);
                        theSplash = new ChaxStandaloneSplash(theDynamicSplashTextFile, theCUIProperties);
                        if (theDynamicSplashTextFile == null || !theDynamicSplashTextFile.exists()) {
                            ((ChaxStandaloneSplash)((Object)theSplash)).setDynamicText("Initializing...");
                        }
                    } else if (this.gConfigManager.getConfig(EngineConfigItem.DISPLAY_MODE).equalsIgnoreCase("GUI")) {
                        URL theURL = WebStartUtils.IS_WEBSTART ? WebStartUtils.getURL("/templates/Splash.jpg") : this.getClass().getResource("/templates/Splash.jpg");
                        BufferedImage theImage = ImageIO.read(theURL);
                        theSplash = new StandaloneSplash(theDynamicSplashTextFile, theImage);
                        if (theDynamicSplashTextFile == null || !theDynamicSplashTextFile.exists()) {
                            ((StandaloneSplash)theSplash).setDynamicText("Initializing...");
                        }
                    }
                    LOGGER.log(Level.FINE, "DISCOVERING_SERVICE_PROVIDERS");
                    ServiceProvider[] theDiscoveredServiceProviders = this.findServiceProviders(this.gConfigManager.getConfig(EngineConfigItem.PROVIDER_PATH));
                    LOGGER.log(Level.FINE, "DISCOVERED_SERVICE_PROVIDERS", theDiscoveredServiceProviders.length);
                    int theLength = theDiscoveredServiceProviders.length;
                    for (int theIndex = 0; theIndex < theLength; ++theIndex) {
                        try {
                            this.gBus.register(theDiscoveredServiceProviders[theIndex]);
                            continue;
                        }
                        catch (BusException theBe) {
                            throw new EnhancedException("ENGINE_PREMATURELY_SHUTDOWN", (Throwable)theBe, new String[0]);
                        }
                    }
                    while (!this.gBus.isInitComplete()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception theEx) {
                            LOGGER.log(Level.FINEST, "INTERRUPTED_AT_INIT");
                        }
                    }
                    ConfigControl theCC = new ConfigControl(ConfigControl.ConfigCommand.SET_ALL_CONFIGURATION, null);
                    BusRequest theCCReq = new BusRequest("SetAllConfigRequest", theCC);
                    BusResponse theCCResp = this.gBus.publishRequest(theCCReq, "svc://general/conf");
                    if (theCCResp.getException() != null) {
                        LogUtils.log(LOGGER, Level.WARNING, "CANNOT_PREFILL", theCCResp.getException(), "error=" + EnhancedException.getLastCause(theCCResp.getException()).getLocalizedMessage());
                    }
                    if (theAltRoot != null) {
                        SIMSControl theSIMSCtrl = new SIMSControl(SIMSControl.SIMSCommand.SET_ALTROOT, (Object)theAltRoot);
                        BusRequest theSIMSReq = new BusRequest("SIMSReq", theSIMSCtrl);
                        BusResponse theSIMSResp = this.gBus.publishRequest(theSIMSReq, "svc://general/sims");
                        if (theSIMSResp.getException() != null) {
                            throw theSIMSResp.getException();
                        }
                        theSIMSCtrl = new SIMSControl(SIMSControl.SIMSCommand.INITIALIZE, null);
                        theSIMSReq = new BusRequest("SIMSReq", theSIMSCtrl);
                        theSIMSResp = this.gBus.publishRequest(theSIMSReq, "svc://general/sims");
                        if (theSIMSResp.getException() != null) {
                            throw theSIMSResp.getException();
                        }
                    }
                    if ((theDPResp = this.gBus.publishRequest(theDPReq = new BusRequest("DependencyReq", theDPCntrl = new DependencyControl(DependencyControl.COMMAND.SET_DESCRIPTORS_LOCATION, (Object)(theDescArray = new URL[]{new URL(theMediaPath + "/dependency/index.txt"), this.getClass().getResource("/dependency/Engine.xml")}))), "svc://general/Dependency")).getException() != null) {
                        LogUtils.log(LOGGER, Level.WARNING, "CANNOT_INIT_DESCRIPTORS", theDPResp.getException(), "urls=" + Arrays.toString(theDescArray));
                    }
                    if ((theDefaultProductID = this.gConfigManager.getConfig(EngineConfigItem.DEFAULT_PRODUCT_ID)) == null) {
                        throw new EnhancedException("MUST_PROVIDE_DEF_PRODUCT_ID", new String[0]);
                    }
                    theDPCntrl = new DependencyControl(DependencyControl.COMMAND.SET_HIERARCHY_ROOT, (Object)theDefaultProductID);
                    theDPReq = new BusRequest("DependencyReq", theDPCntrl);
                    theDPResp = this.gBus.publishRequest(theDPReq, "svc://general/Dependency");
                    if (theDPResp.getException() != null) {
                        LogUtils.log(LOGGER, Level.WARNING, "CANNOT_INIT_DESCRIPTORS", theDPResp.getException(), "urls=" + Arrays.toString(theDescArray));
                    }
                    if ((theDPResp = this.gBus.publishRequest(theDPReq = new BusRequest("DependencyReq", theDPCntrl = new DependencyControl(DependencyControl.COMMAND.BOOT_UP, null)), "svc://general/Dependency")).getException() != null) {
                        Exception theUnderneathException = theDPResp.getException();
                        LogUtils.log(LOGGER, Level.SEVERE, "CANNOT_INIT_DESCRIPTORS", theUnderneathException, "urls=" + Arrays.toString(theDescArray));
                        throw new EnhancedException("CANNOT_INIT_DESCRIPTORS", (Throwable)theUnderneathException, "urls=" + Arrays.toString(theDescArray));
                    }
                    if (!this.gConfigManager.getConfig(EngineConfigItem.PROCESSING_MODE).equals(PROCESSING_MODE.REMOVE.name()) && (theDPResp = this.gBus.publishRequest(theDPReq = new BusRequest("DependencyReq", theDPCntrl = new DependencyControl(DependencyControl.COMMAND.FORCE_SELECT_ELEMENT, (Object)"Engine")), "svc://general/Dependency")).getException() != null) {
                        LogUtils.log(LOGGER, Level.WARNING, "CANNOT_INIT_DESCRIPTORS", theDPResp.getException(), "urls=" + Arrays.toString(theDescArray));
                    }
                    if ((theDPResp = this.gBus.publishRequest(theDPReq = new BusRequest("DependencyReq", theDPCntrl = new DependencyControl(DependencyControl.COMMAND.FORCE_SELECT_ELEMENT, (Object)theDefaultProductID)), "svc://general/Dependency")).getException() != null) {
                        LogUtils.log(LOGGER, Level.WARNING, "CANNOT_INIT_DESCRIPTORS", theDPResp.getException(), "urls=" + Arrays.toString(theDescArray));
                    }
                    LOGGER.log(Level.FINE, "BEGIN_EXEC");
                    if (theSplash != null && !(theSplash instanceof StandaloneSplash)) {
                        ((ChaxStandaloneSplash)((Object)theSplash)).setIndeterminateProgress(false);
                        ((ChaxStandaloneSplash)((Object)theSplash)).hide();
                    }
                    if ((theUIResp = this.gBus.publishRequest(new BusRequest("START", Boolean.TRUE), "svc://general/ui")).getException() != null) {
                        throw theUIResp.getException();
                    }
                    if (theSplash == null) break block66;
                    if (theSplash instanceof StandaloneSplash) {
                        ((StandaloneSplash)theSplash).dispose();
                    }
                    try {
                        if (theDynamicSplashTextFile != null) {
                            theDynamicSplashTextFile.delete();
                        }
                    }
                    catch (Throwable theIgnored) {
                        LOGGER.finest("IGNOREABLE: Could not deleted temporary splash text file");
                    }
                }
                catch (Exception theEx) {
                    throw new EnhancedException("FATAL", (Throwable)theEx, "arguments=" + Arrays.toString(aArgSet));
                }
            }
            catch (EnhancedException theEe) {
                theEe.addContext("INIT_ORCHESTRATOR", new String[0]);
                theEe.logFatal();
                System.exit(ReturnValue.FATAL.getValue());
            }
            catch (Throwable theRuntimeError) {
                theRuntimeError.printStackTrace();
                System.err.println("SEVERE INTERNAL ERROR: " + theRuntimeError.getMessage());
                System.exit(ReturnValue.FATAL.getValue());
            }
        }
    }

    public Orchestrator(EngineBootstrap aBootstrapper) {
        this.gBootstrap = aBootstrapper;
    }

    @Override
    public void init(ControlBus aBus) {
        this.gBus = aBus;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getName() {
        return "svc://general/orchestrator";
    }

    @Override
    public void receiveRequest(ControlBus aBus, BusRequest aReq, BusResponse aResp) {
        if (!OrchestratorCommand.class.isInstance(aReq.getData())) {
            aResp.setException(new InvalidArgumentException(Msg.get(this.getClass(), "NOT_ORCHESTRATOR_CMD", aReq.getData()), new String[0]));
            return;
        }
        OrchestratorCommand theCommand = (OrchestratorCommand)aReq.getData();
        switch (theCommand.getCommand()) {
            case ADD_CLASS_URL: {
                if (!URL.class.isInstance(theCommand.getData())) {
                    aResp.setException(new InvalidArgumentException("NOT_A_URL", "url=" + theCommand.getData()));
                    return;
                }
                try {
                    this.gBootstrap.addURLToPath((URL)theCommand.getData());
                }
                catch (Exception theEx) {
                    EnhancedException theEe = new EnhancedException("ORCHESTRATOR_CMD", (Throwable)theEx, theCommand.getData().toString());
                    aResp.setException(theEe);
                    return;
                }
                return;
            }
            case GET_TEMP_LOG_LOCATION: {
                aResp.setFinalResult(this.gTempLogLocation);
                break;
            }
            default: {
                aResp.setException(new InvalidArgumentException("NOT_VALID_CMD", "cmd=" + theCommand));
            }
        }
    }

    @Override
    public void receiveEvent(ControlBus aBus, BusEvent aEvent) {
        if (aEvent.getName().equals("shutdown")) {
            this.shutdownAndExit(aBus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownAndExit(ControlBus aBus) {
        try {
            aBus.shutdown();
        }
        catch (Exception theEx) {
            LOGGER.log(Level.INFO, "INTERRUPTED_AT_SHUTDOWN", theEx.getMessage());
        }
        finally {
            System.exit(ReturnValue.SUCCESS.getValue());
        }
    }

    private ServiceProvider[] findServiceProviders(String aSearchPath) {
        String theProviderClasses = System.getProperty("provider.classes");
        ArrayList<ServiceProvider> theDiscoveredServiceProviders = new ArrayList<ServiceProvider>();
        if (theProviderClasses == null || theProviderClasses.trim().equalsIgnoreCase("")) {
            StringTokenizer theJarParser = new StringTokenizer(aSearchPath, File.pathSeparator);
            FilenameFilter theJarFilenameFilter = new FilenameFilter(){

                public boolean accept(File aDir, String aName) {
                    return aName.endsWith(".jar");
                }
            };
            while (theJarParser.hasMoreTokens()) {
                String[] theJars;
                String theNextToken = theJarParser.nextToken();
                File theDir = new File(theNextToken);
                if (!theDir.exists() || !theDir.isDirectory()) {
                    LOGGER.log(Level.FINE, "DOES_NOT_EXIST", theDir.getName());
                    continue;
                }
                for (String thePath : theJars = theDir.list(theJarFilenameFilter)) {
                    Attributes theMainfestMainAttrs;
                    Manifest theJarsManifest;
                    File theJarName = new File(theDir, thePath);
                    if (!theJarName.exists() || !theJarName.isFile()) {
                        LOGGER.log(Level.WARNING, "CANT_READ", theJarName);
                        continue;
                    }
                    try {
                        JarFile theJarFile = new JarFile(theJarName);
                        theJarsManifest = theJarFile.getManifest();
                    }
                    catch (IOException theEx) {
                        LOGGER.log(Level.WARNING, "CANT_READ", theJarName);
                        continue;
                    }
                    if (theJarsManifest == null || (theMainfestMainAttrs = theJarsManifest.getMainAttributes()) == null || (theProviderClasses = theProviderClasses + "," + theMainfestMainAttrs.getValue("Provider-Classes")) == null) continue;
                    try {
                        this.gBootstrap.addURLToPath(theJarName.toURI().toURL());
                    }
                    catch (MalformedURLException ex) {
                        LOGGER.log(Level.WARNING, "CANNOT_CONVERT_TO_URL", theJarName);
                    }
                }
            }
        }
        List<String> theDiscoveredClassNames = this.parseProvidersList(theProviderClasses);
        for (String theClassName : theDiscoveredClassNames) {
            try {
                Class<?> theServiceProviderClass = Class.forName(theClassName);
                if (!ServiceProvider.class.isAssignableFrom(theServiceProviderClass)) continue;
                ServiceProvider theServiceProvider = (ServiceProvider)theServiceProviderClass.newInstance();
                LOGGER.log(Level.FINE, "FOUND_SERVICE_PROVIDER", theServiceProvider.getName());
                theDiscoveredServiceProviders.add(theServiceProvider);
            }
            catch (ClassNotFoundException theEx) {
                LOGGER.log(Level.FINE, "Not instantiating " + theClassName + " - not a ServiceProvider", theEx);
            }
            catch (IllegalAccessException theEx) {
                LOGGER.log(Level.FINE, "Not instantiating " + theClassName + " - not a ServiceProvider", theEx);
            }
            catch (InstantiationException theEx) {
                LOGGER.log(Level.FINE, "Not instantiating " + theClassName + " - not a ServiceProvider", theEx);
            }
        }
        return theDiscoveredServiceProviders.toArray(new ServiceProvider[0]);
    }

    private List<String> parseProvidersList(String aProvidersList) {
        ArrayList<String> theDiscoveredClassNames = new ArrayList<String>();
        StringTokenizer theProviderClassParser = new StringTokenizer(aProvidersList, ",");
        for (String theProvider : aProvidersList.split(",")) {
            Platform theSupportedPlatform;
            String theClassName;
            String theProviderClassName = theProvider.trim();
            StringTokenizer theProviderSpecParser = new StringTokenizer(theProviderClassName, ":");
            if (theProviderSpecParser.countTokens() == 1) {
                theClassName = theProviderSpecParser.nextToken();
                theSupportedPlatform = new Platform(Platform.OSType.UNDEFINED, Platform.OSName.UNDEFINED, Platform.Arch.UNDEFINED);
            } else if (theProviderSpecParser.countTokens() == 2) {
                theClassName = theProviderSpecParser.nextToken();
                String theOsName = theProviderSpecParser.nextToken();
                theSupportedPlatform = new Platform(Platform.getOSTypeForString(theOsName), Platform.getOSNameForString(theOsName), Platform.Arch.UNDEFINED);
            } else {
                LOGGER.log(Level.WARNING, "MALFORMED_PLATFORM_SPEC", theProviderClassName);
                if (theProviderSpecParser.countTokens() < 1) continue;
                theClassName = theProviderSpecParser.nextToken();
                theSupportedPlatform = new Platform(Platform.OSType.UNDEFINED, Platform.OSName.UNDEFINED, Platform.Arch.UNDEFINED);
            }
            if (!theSupportedPlatform.isCompatible()) {
                LOGGER.log(Level.FINE, "SKIPPING_PLATFORM", new Object[]{theClassName, theSupportedPlatform});
                continue;
            }
            theDiscoveredClassNames.add(theClassName);
        }
        return theDiscoveredClassNames;
    }

    private void setupLogging() throws EnhancedException {
        FileHandler theUnlocalizedFh;
        FileHandler theLocalizedFh;
        FileHandler theEnglishFh;
        File theLocalizedLogFile;
        Handler[] theHandlers;
        Logger theParentLogger = Logger.getLogger(PARENT_LOGGER);
        EnhancedException.setLoggerAdapter(new OpenInstallerLoggerAdapter());
        String theLevelStr = this.gConfigManager.getConfig(EngineConfigItem.LOG_LEVEL);
        try {
            this.gLevel = Level.parse(theLevelStr);
        }
        catch (IllegalArgumentException theEx) {
            Logger.getAnonymousLogger().log(Level.WARNING, Msg.get("INVALID_LOG_LEVEL", theLevelStr));
            this.gLevel = Level.INFO;
        }
        theParentLogger.setLevel(this.gLevel);
        for (Handler theHandler : theHandlers = Logger.getLogger("").getHandlers()) {
            if (!ConsoleHandler.class.isInstance(theHandler)) continue;
            if (this.gLevel == Level.INFO) {
                theHandler.setLevel(Level.WARNING);
                continue;
            }
            theHandler.setLevel(this.gLevel);
        }
        String theTempLogsLocation = System.getProperty("java.io.tmpdir");
        try {
            File theUnlocalizedLogFile;
            File theEnglishLogFile;
            try {
                theEnglishLogFile = File.createTempFile(Locale.ENGLISH.toString() + "_install", ".log", new File(theTempLogsLocation));
                theLocalizedLogFile = File.createTempFile(Locale.getDefault().toString() + "_install", ".log", new File(theTempLogsLocation));
                theUnlocalizedLogFile = File.createTempFile("install", ".log", new File(theTempLogsLocation));
            }
            catch (IOException theEx) {
                Logger.getAnonymousLogger().log(Level.WARNING, Msg.get("INVALID_LOG_LOC", theTempLogsLocation), theEx);
                theEnglishLogFile = File.createTempFile(Locale.ENGLISH.toString() + "_install", ".log");
                theLocalizedLogFile = File.createTempFile(Locale.getDefault().toString() + "_install", ".log");
                theUnlocalizedLogFile = File.createTempFile("install", ".log");
            }
            if (!(theEnglishLogFile.canWrite() && theLocalizedLogFile.canWrite() && theUnlocalizedLogFile.canWrite())) {
                Logger.getAnonymousLogger().log(Level.WARNING, Msg.get("NO_LOGGING", theTempLogsLocation));
                return;
            }
            theEnglishFh = new FileHandler(theEnglishLogFile.getAbsolutePath());
            theLocalizedFh = new FileHandler(theLocalizedLogFile.getAbsolutePath());
            theUnlocalizedFh = new FileHandler(theUnlocalizedLogFile.getAbsolutePath());
            theEnglishFh.setFormatter(new UniformLogFormatter(Locale.ENGLISH));
            theLocalizedFh.setFormatter(new UniformLogFormatter(Locale.getDefault()));
            theUnlocalizedFh.setFormatter(new UniformLogFormatter());
        }
        catch (IOException theEx) {
            Logger.getAnonymousLogger().log(Level.WARNING, Msg.get("NO_LOGGING", theTempLogsLocation), theEx);
            return;
        }
        if (!Locale.getDefault().equals(Locale.ENGLISH)) {
            theParentLogger.addHandler(theEnglishFh);
        }
        theParentLogger.addHandler(theLocalizedFh);
        theParentLogger.addHandler(theUnlocalizedFh);
        this.gTempLogLocation = theLocalizedLogFile;
    }

    private class SimpleLocalizedFormatter
    extends Formatter {
        private static final String DEFAULT_BUNDLE_NAME = "org.openinstaller.resources.ResourceMsgs";

        private SimpleLocalizedFormatter() {
        }

        public String format(LogRecord aRecord) {
            String theSEP = System.getProperty("line.separator");
            StringBuffer theMsg = new StringBuffer();
            theMsg.append(aRecord.getLevel().getName());
            theMsg.append(": ");
            if (aRecord.getLevel().intValue() >= Level.INFO.intValue()) {
                String theBundleName = aRecord.getResourceBundleName();
                if (theBundleName == null) {
                    theBundleName = DEFAULT_BUNDLE_NAME;
                }
                if (aRecord.getMessage() != null && aRecord.getMessage().length() > 0) {
                    theMsg.append(Msg.getWithLocaleName(theBundleName, aRecord.getMessage(), Locale.getDefault(), aRecord.getParameters()));
                    if (aRecord.getParameters() != null && aRecord.getParameters().length > 0 && new MessageFormat(aRecord.getMessage()).getFormats().length == 0) {
                        theMsg.append(" [");
                        for (Object theParam : aRecord.getParameters()) {
                            if (!(theParam instanceof String)) continue;
                            String[] theParts = ((String)theParam).split("=", 2);
                            if (theParts.length == 1) {
                                theMsg.append(Msg.getWithLocaleName(theBundleName, theParts[0], Locale.getDefault(), new Object[0]));
                            } else {
                                theMsg.append(Msg.getWithLocaleName(theBundleName, theParts[0], Locale.getDefault(), new Object[0]));
                                theMsg.append('=');
                                theMsg.append(theParts[1]);
                            }
                            theMsg.append(' ');
                        }
                        theMsg.append(']');
                    }
                }
                if (aRecord.getThrown() != null && aRecord.getLevel().intValue() > Level.WARNING.intValue()) {
                    theMsg.append(theSEP);
                    theMsg.append(aRecord.getThrown().getLocalizedMessage());
                }
            } else {
                theMsg.append(aRecord.getMessage());
            }
            theMsg.append(theSEP);
            if (aRecord.getThrown() != null && (Orchestrator.this.gLevel == null || Orchestrator.this.gLevel.intValue() < Level.INFO.intValue())) {
                Throwable theThrowable = aRecord.getThrown();
                if (EnhancedException.class.isInstance(theThrowable)) {
                    theMsg.append(aRecord.getThrown().toString());
                } else {
                    theMsg.append(EnhancedException.getCompleteStack(aRecord.getThrown()));
                }
                theMsg.append(theSEP);
            }
            return theMsg.toString();
        }
    }
}

