/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.pkg;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.pkg.PackageException;
import org.openinstaller.pkg.RebootRequired;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;
import org.openinstaller.util.InvalidArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SVR4PackageUtils {
    private static final String ZONE_CMD = "/usr/sbin/zonename";
    private static final String PFEXEC_CMD = "/usr/bin/pfexec";
    private static final String ALTROOT_OPTION = "-R";
    private static final String CURR_ZONE_ONLY_OPTION = "-G";
    private static Map<String, String> gAdminSettings = Collections.synchronizedMap(new LinkedHashMap());
    private static final String[][] DEFAULT_ADMIN_SETTINGS = new String[][]{{"mail", ""}, {"instance", "overwrite"}, {"partial", "nocheck"}, {"runlevel", "nocheck"}, {"idepend", "nocheck"}, {"rdepend", "nocheck"}, {"space", "nocheck"}, {"setuid", "nocheck"}, {"conflict", "nocheck"}, {"action", "nocheck"}, {"basedir", "default"}};
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public static void checkUtils() throws PackageException {
        for (PkgCommand theCmd : PkgCommand.values()) {
            if (new File(theCmd.getPkgCmd()).exists()) continue;
            throw new PackageException("MISSING_PKG_TOOL", "tool=" + theCmd.getPkgCmd());
        }
    }

    public static void installPkg(URL aSrcPath, String aPkgName, String aDomain, String aAltRoot, Map<String, String> aResponseMap, boolean aCurrZoneOnly) throws PackageException {
        ExecuteCommand theCmd;
        String theLine;
        BufferedReader theReader;
        File theAltPkgadd;
        boolean theAltToolFlag = false;
        ArrayList<String> theInstallCommand = new ArrayList<String>();
        theInstallCommand.add(PkgCommand.PKGADD.getPkgCmd());
        String theAltToolPath = System.getenv("INSTALL_OSTOOLS");
        if (theAltToolPath != null && (theAltPkgadd = new File(new File(theAltToolPath), PkgCommand.PKGADD.getPkgCmd())).exists()) {
            theInstallCommand.clear();
            theInstallCommand.add(theAltPkgadd.getAbsolutePath());
            File theAltBinPath = new File(new File(theAltToolPath), "usr/sadm/install/bin");
            theInstallCommand.add("-b");
            theInstallCommand.add(theAltBinPath.getAbsolutePath());
            theAltToolFlag = true;
        }
        File theResponseFile = null;
        File theTmpDirFile = new File(System.getProperty("java.io.tmpdir"));
        if (!theTmpDirFile.exists() && !theTmpDirFile.mkdir()) {
            throw new PackageException("CANT_CREATE_TMP_DIR", "dir=" + theTmpDirFile.getName());
        }
        File theAdminFile = SVR4PackageUtils.writeAdminFile(theTmpDirFile, aPkgName);
        theInstallCommand.add("-n");
        theInstallCommand.add("-a");
        theInstallCommand.add(theAdminFile.getAbsolutePath());
        if (aResponseMap != null && !aResponseMap.isEmpty()) {
            theResponseFile = SVR4PackageUtils.writeResponseFile(aResponseMap, theTmpDirFile, aPkgName);
            theInstallCommand.add("-r");
            theInstallCommand.add(theResponseFile.getAbsolutePath());
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Dumping response file [" + theResponseFile.getAbsolutePath() + "]");
                try {
                    theReader = new BufferedReader(new FileReader(theResponseFile));
                    theLine = theReader.readLine();
                    while (theLine != null) {
                        LOGGER.finer("[" + theLine + "]");
                        theLine = theReader.readLine();
                    }
                    theReader.close();
                }
                catch (FileNotFoundException theEx) {
                    throw new PackageException("Admin file [" + theResponseFile.getAbsolutePath() + "] not found. " + theEx.getMessage(), new String[0]);
                }
                catch (IOException theEx) {
                    throw new PackageException("Could not close response file [" + theResponseFile.getAbsolutePath() + "] " + theEx.getMessage(), new String[0]);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Dumping admin file [" + theAdminFile.getAbsolutePath() + "]");
            try {
                theReader = new BufferedReader(new FileReader(theAdminFile));
                theLine = theReader.readLine();
                while (theLine != null) {
                    LOGGER.finer("[" + theLine + "]");
                    theLine = theReader.readLine();
                }
                theReader.close();
            }
            catch (FileNotFoundException theEx) {
                throw new PackageException("Admin file [" + theAdminFile.getAbsolutePath() + "] not found. " + theEx.getMessage(), new String[0]);
            }
            catch (IOException theEx) {
                throw new PackageException("Could not close Admin file [" + theAdminFile.getAbsolutePath() + "] " + theEx.getMessage(), new String[0]);
            }
        }
        if (aAltRoot != null && !"".equals(aAltRoot) && new File(aAltRoot).getAbsolutePath() != "/") {
            theInstallCommand.add(ALTROOT_OPTION);
            theInstallCommand.add(aAltRoot);
            theInstallCommand.add("-O");
            theInstallCommand.add("nozones");
        }
        if (aCurrZoneOnly) {
            theInstallCommand.add(CURR_ZONE_ONLY_OPTION);
        }
        try {
            if (aSrcPath.getProtocol().equals("file")) {
                File theSrcFile = new File(aSrcPath.toURI());
                if (theSrcFile.isDirectory()) {
                    theSrcFile = theSrcFile.getParentFile();
                    URL theParentDir = theSrcFile.toURI().toURL();
                    theInstallCommand.add("-d");
                    theInstallCommand.add(theParentDir.getPath());
                    LOGGER.log(Level.FINE, "Package: " + aPkgName + ": is a directory-format package");
                } else {
                    theInstallCommand.add("-d");
                    theInstallCommand.add(theSrcFile.getPath());
                    LOGGER.log(Level.FINE, "Package: " + aPkgName + ": is a stream format package at " + aSrcPath.toExternalForm());
                }
            } else {
                theInstallCommand.add("-d");
                theInstallCommand.add(aSrcPath.toExternalForm());
                LOGGER.log(Level.FINE, "Package: " + aPkgName + ": is a remote, presumably stream format package at " + aSrcPath.toExternalForm());
            }
        }
        catch (MalformedURLException theEx) {
            throw new PackageException(theEx, "CANT_RESOLVE_PKG_SRC", "url= " + aSrcPath);
        }
        catch (URISyntaxException theEx) {
            throw new PackageException(theEx, "CANT_EXEC_PKG_CMD", "url= " + aSrcPath);
        }
        theInstallCommand.add(aPkgName);
        if (!theAltToolFlag) {
            theInstallCommand.add(0, PFEXEC_CMD);
        }
        try {
            theCmd = new ExecuteCommand(theInstallCommand.toArray(new String[0]));
        }
        catch (InvalidArgumentException theEx) {
            throw new PackageException(theEx, "CANT_EXEC_PKG_CMD", "pkg=" + aPkgName);
        }
        theCmd.setCollectOutput(true);
        theCmd.setOutputType(3);
        try {
            if (theAltToolFlag) {
                File theAltLibDir = new File(new File(theAltToolPath), "usr/lib");
                File theAltLibSfwDir = new File(new File(theAltToolPath), "usr/sfw/lib");
                theCmd.putEnvironmentSetting("LD_LIBRARY_PATH", theAltLibDir.getAbsolutePath() + ":" + theAltLibSfwDir.getAbsolutePath());
                theCmd.putEnvironmentSetting("INSTALL_OSTOOLS", theAltToolPath);
            }
            LOGGER.log(Level.INFO, "INSTALLING_SVR4_PKG", new String[]{"pkg=" + aPkgName, "command=" + Arrays.toString(theCmd.getCommand())});
            theCmd.execute();
        }
        catch (EnhancedException theEEx) {
            throw new PackageException(theEEx, "CANT_EXEC_PKG_CMD", "command=" + theCmd.toString());
        }
        int theResult = theCmd.getResult();
        switch (theResult) {
            case 0: {
                LOGGER.log(Level.INFO, "PACKAGE_INSTALL_SUCCESSFUL", "pkg=" + aPkgName);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                throw new PackageException("PKG_ADD_FAILED", "pkg=" + aPkgName, "exit-code=" + theResult, "output=" + theCmd.getAllOutput());
            }
            case 10: {
                LOGGER.log(Level.INFO, "PACKAGE_INSTALL_SUCCESSFUL", "pkg=" + aPkgName);
                RebootRequired theRR = RebootRequired.REBOOT_INSTANCE;
                if (theRR.getRebootFlag()) break;
                RebootRequired.setRebootFlag(true);
                break;
            }
            case 20: {
                LOGGER.log(Level.INFO, "PACKAGE_INSTALL_SUCCESSFUL", "pkg=" + aPkgName);
                break;
            }
            default: {
                throw new PackageException("PKG_ADD_FAILED", "pkg=" + aPkgName, "exit-code=" + theResult, "output=" + theCmd.getAllOutput());
            }
        }
        theAdminFile.delete();
        if (theResponseFile != null) {
            theResponseFile.delete();
        }
    }

    public static void removePkg(String aPkgName, String aDomain, String aAltRoot) throws PackageException {
        ExecuteCommand theCmd;
        File theTmpDirFile;
        File theAltPkgrm;
        boolean theAltToolFlag = false;
        ArrayList<String> theUninstallCommand = new ArrayList<String>();
        theUninstallCommand.add(PkgCommand.PKGRM.getPkgCmd());
        String theAltToolPath = System.getenv("INSTALL_OSTOOLS");
        if (theAltToolPath != null && (theAltPkgrm = new File(new File(theAltToolPath), PkgCommand.PKGRM.getPkgCmd())).exists()) {
            theUninstallCommand.clear();
            theUninstallCommand.add(theAltPkgrm.getAbsolutePath());
            File theAltBinPath = new File(new File(theAltToolPath), "usr/sadm/install/bin");
            theUninstallCommand.add("-b");
            theUninstallCommand.add(theAltBinPath.getAbsolutePath());
            theAltToolFlag = true;
        }
        if (!(theTmpDirFile = new File(System.getProperty("java.io.tmpdir"))).exists() && !theTmpDirFile.mkdir()) {
            throw new PackageException("CANT_CREATE_TMP_DIR", "temp-dir=" + theTmpDirFile.getName());
        }
        File theAdminFile = SVR4PackageUtils.writeAdminFile(theTmpDirFile, aPkgName);
        theUninstallCommand.add("-n");
        theUninstallCommand.add("-a");
        theUninstallCommand.add(theAdminFile.getAbsolutePath());
        if (aAltRoot != null && !"".equals(aAltRoot) && new File(aAltRoot).getAbsolutePath() != "/") {
            theUninstallCommand.add(ALTROOT_OPTION);
            theUninstallCommand.add(aAltRoot);
            theUninstallCommand.add("-O");
            theUninstallCommand.add("nozones");
        }
        theUninstallCommand.add(aPkgName);
        if (!theAltToolFlag) {
            theUninstallCommand.add(0, PFEXEC_CMD);
        }
        LOGGER.log(Level.FINE, "REMOVE_CMD=[" + theUninstallCommand + "]");
        try {
            theCmd = new ExecuteCommand(theUninstallCommand.toArray(new String[0]));
        }
        catch (InvalidArgumentException theEx) {
            throw new PackageException(theEx, "CANT_EXEC_PKG_CMD", "pkg=" + aPkgName);
        }
        theCmd.setCollectOutput(true);
        theCmd.setOutputType(3);
        try {
            if (theAltToolFlag) {
                File theAltLibDir = new File(new File(theAltToolPath), "usr/lib");
                File theAltLibSfwDir = new File(new File(theAltToolPath), "usr/sfw/lib");
                theCmd.putEnvironmentSetting("LD_LIBRARY_PATH", theAltLibDir.getAbsolutePath() + ":" + theAltLibSfwDir.getAbsolutePath());
                theCmd.putEnvironmentSetting("INSTALL_OSTOOLS", theAltToolPath);
            }
            LOGGER.log(Level.INFO, "REMOVING_PKG", new String[]{"pkg=" + aPkgName, "command=" + Arrays.toString(theCmd.getCommand())});
            theCmd.execute();
        }
        catch (EnhancedException theEEx) {
            throw new PackageException(theEEx, "CANT_EXEC_PKG_CMD", "command=" + theCmd.toString());
        }
        int theResult = theCmd.getResult();
        switch (theResult) {
            case 0: {
                LOGGER.log(Level.INFO, "PACKAGE_UNINSTALL_SUCCESSFUL", "pkg=" + aPkgName);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                throw new PackageException("PKGRM_FAILED", "pkg=" + aPkgName, "output=" + theCmd.getAllOutput());
            }
            case 10: {
                LOGGER.log(Level.INFO, "PACKAGE_UNINSTALL_SUCCESSFUL", "pkg=" + aPkgName);
                break;
            }
            case 20: {
                LOGGER.log(Level.INFO, "PACKAGE_UNINSTALL_SUCCESSFUL", "pkg=" + aPkgName);
                break;
            }
            default: {
                throw new PackageException("PKGRM_FAILED", "pkg=" + aPkgName, "output=" + theCmd.getAllOutput());
            }
        }
        theAdminFile.delete();
    }

    public static File writeAdminFile(File aTmpDir, String aPrefix) throws PackageException {
        File theNewAdmin = new File(aTmpDir, aPrefix + "." + Math.random() + ".admin");
        LOGGER.finer("Writing to admin file " + theNewAdmin.getAbsolutePath());
        try {
            BufferedWriter theBW = new BufferedWriter(new FileWriter(theNewAdmin));
            for (Map.Entry<String, String> theEntry : gAdminSettings.entrySet()) {
                theBW.write(theEntry.getKey() + "=" + theEntry.getValue());
                LOGGER.finer(theEntry.getKey() + "=" + theEntry.getValue());
                theBW.newLine();
            }
            theBW.close();
            return theNewAdmin;
        }
        catch (IOException theIoe) {
            throw new PackageException(theIoe, "ERROR_WRITING_ADMIN_FILE", "file=" + theNewAdmin);
        }
    }

    public static File writeResponseFile(Map<String, String> aResponseMap, File aTmpDir, String aPrefix) throws PackageException {
        File theNewResp = new File(aTmpDir, aPrefix + "." + Math.random() + ".response");
        LOGGER.finer("Writing to response file " + theNewResp.getAbsolutePath());
        try {
            BufferedWriter theBW = new BufferedWriter(new FileWriter(theNewResp));
            for (Map.Entry<String, String> theEntry : aResponseMap.entrySet()) {
                LOGGER.finer(theEntry.getKey() + "=" + theEntry.getValue());
                theBW.write(theEntry.getKey() + "=" + theEntry.getValue());
                theBW.newLine();
            }
            theBW.close();
            return theNewResp;
        }
        catch (IOException theIoe) {
            throw new PackageException(theIoe, "ERROR_WRITING_RESPONSE_FILE", "file=" + theNewResp);
        }
    }

    public static void setInstallLocation(String aNewBasedir) {
        String theBasedirKey = "basedir";
        if (gAdminSettings.containsKey("basedir")) {
            gAdminSettings.remove("basedir");
            gAdminSettings.put("basedir", aNewBasedir);
        }
    }

    private SVR4PackageUtils() {
    }

    static {
        for (String[] theDefaultAdminSettings : DEFAULT_ADMIN_SETTINGS) {
            gAdminSettings.put(theDefaultAdminSettings[0], theDefaultAdminSettings[1]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PkgCommand {
        PKGASK("/usr/sbin/pkgask"),
        PKGADD("/usr/sbin/pkgadd"),
        PKGRM("/usr/sbin/pkgrm");

        private final String gCmd;

        private PkgCommand(String aCmd) {
            this.gCmd = aCmd;
        }

        private String getPkgCmd() {
            return this.gCmd;
        }
    }
}

