/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;
import org.openinstaller.util.Platform;

public final class FileUtils {
    public static boolean copyFile(File aSrc, File aDest) throws IOException {
        FileInputStream theSrcStream = new FileInputStream(aSrc);
        FileOutputStream theDestStream = new FileOutputStream(aDest);
        try {
            boolean bl = FileUtils.copyStream(theSrcStream, theDestStream);
            return bl;
        }
        catch (IOException theEx) {
            throw theEx;
        }
        finally {
            ((InputStream)theSrcStream).close();
            ((OutputStream)theDestStream).close();
        }
    }

    public static boolean copyStream(InputStream aIn, OutputStream aOut) throws IOException {
        int theReadCount;
        byte[] theCopyBuffer = new byte[4096];
        while ((theReadCount = aIn.read(theCopyBuffer)) > 0) {
            aOut.write(theCopyBuffer, 0, theReadCount);
        }
        return true;
    }

    public static void setExecutable(File aFile) throws EnhancedException {
        block12: {
            try {
                String[] theCmdStr = null;
                block1 : switch (Platform.getCurrentOsType()) {
                    case UNIX: {
                        switch (Platform.getCurrentOsName()) {
                            case SOLARIS: {
                                theCmdStr = new String[]{"/usr/bin/chmod", "755", aFile.getAbsolutePath()};
                                break block1;
                            }
                        }
                        theCmdStr = new String[]{"/bin/chmod", "755", aFile.getAbsolutePath()};
                        break;
                    }
                    case WINDOWS: 
                    case UNDEFINED: {
                        theCmdStr = new String[]{"cmd", "/c", "attrib", "+X", aFile.getAbsolutePath()};
                        break;
                    }
                    case BE: 
                    case MAC: {
                        throw new EnhancedException("CANNOT_MAKE_EXECUTABLE", "file=" + aFile.getAbsolutePath());
                    }
                }
                if (theCmdStr != null) {
                    ExecuteCommand theCmd = new ExecuteCommand(theCmdStr);
                    theCmd.setCollectOutput(true);
                    theCmd.setOutputType(3);
                    theCmd.execute();
                    if (theCmd.getResult() != 0) {
                        throw new EnhancedException("CANNOT_MAKE_EXECUTABLE", "file=" + aFile.getAbsolutePath());
                    }
                    break block12;
                }
                throw new EnhancedException("CANNOT_MAKE_EXECUTABLE", "file=" + aFile.getAbsolutePath());
            }
            catch (EnhancedException theEnhEx) {
                theEnhEx.addContext("CANNOT_MAKE_EXECUTABLE", "file=" + aFile.getAbsolutePath());
                throw theEnhEx;
            }
        }
    }

    private FileUtils() {
    }
}

