/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.JDKSelection.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.JDKSelection.utils.StreamUtils;
import org.openinstaller.util.JDKSelection.utils.StringUtils;
import org.openinstaller.util.JDKSelection.utils.SystemUtils;
import org.openinstaller.util.JDKSelection.utils.helper.FilesList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    public static final int BUFFER_SIZE = 4096;
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String METAINF_MASK = "META-INF.*";
    public static final String JAR_EXTENSION = ".jar";
    public static final String PROPERTIES_EXTENSION = ".properties";
    public static final String SUN_MICR_RSA = "META-INF/SUN_MICR.RSA";
    public static final String SUN_MICR_SF = "META-INF/SUN_MICR.SF";
    public static final String CURRENT = ".";
    public static final String PARENT = "..";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            int readLength;
            char[] buffer = new char[4096];
            StringBuilder stringBuilder = new StringBuilder();
            while ((readLength = reader.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, readLength);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException ignord) {}
        }
    }

    public static FilesList writeFile(File file, CharSequence string) throws IOException {
        return FileUtils.writeFile(file, string, Charset.defaultCharset().name(), false);
    }

    public static FilesList appendFile(File file, CharSequence string) throws IOException {
        return FileUtils.writeFile(file, string, Charset.defaultCharset().name(), true);
    }

    public static FilesList writeFile(File file, CharSequence string, String charset, boolean append) throws IOException {
        return FileUtils.writeFile(file, new ByteArrayInputStream(((Object)string).toString().getBytes(charset)), append);
    }

    public static FilesList writeFile(File file, InputStream input) throws IOException {
        return FileUtils.writeFile(file, input, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FilesList writeFile(File file, InputStream input, boolean append) throws IOException {
        FilesList list = new FilesList();
        if (!FileUtils.exists(file)) {
            if (!FileUtils.exists(file.getParentFile())) {
                list.add(FileUtils.mkdirs(file.getParentFile()));
            }
            file.createNewFile();
            list.add(file);
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(file, append);
            StreamUtils.transferData(input, output);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "" + e);
                }
            }
        }
        return list;
    }

    public static long getSize(File file) {
        long size = -1L;
        if (file != null && !file.isDirectory() && FileUtils.exists(file)) {
            try {
                size = file.length();
            }
            catch (SecurityException e) {
                LOGGER.log(Level.INFO, "" + e);
            }
        }
        return size;
    }

    public static String getMd5(File file) throws IOException {
        return StringUtils.asHexString(FileUtils.getMd5Bytes(file));
    }

    public static byte[] getMd5Bytes(File file) throws IOException {
        try {
            return FileUtils.getDigestBytes(file, "MD5");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, "This jvm does not support MD5", e);
            return null;
        }
    }

    public static byte[] getSha1Bytes(File file) throws IOException {
        try {
            return FileUtils.getDigestBytes(file, "SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, "This jvm does not support SHA1", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getDigestBytes(File file, String algorithm) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.reset();
        FileInputStream input = null;
        try {
            int readLength;
            input = new FileInputStream(file);
            byte[] buffer = new byte[4096];
            while ((readLength = ((InputStream)input).read(buffer)) != -1) {
                md.update(buffer, 0, readLength);
            }
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException ignord) {}
            }
        }
        return md.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFirstLine(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        try {
            String string = reader.readLine();
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static List<String> readStringList(File file) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        for (String line : FileUtils.readFile(file).split("(?:\r\n|\n|\r)")) {
            list.add(line);
        }
        return list;
    }

    public static FilesList writeStringList(File file, List<String> list) throws IOException {
        return FileUtils.writeStringList(file, list, Charset.defaultCharset().name(), false);
    }

    public static FilesList writeStringList(File file, List<String> list, String charset, boolean append) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (String string : list) {
            builder.append(string).append(SystemUtils.getLineSeparator());
        }
        return FileUtils.writeFile(file, builder, charset, append);
    }

    public static File createTempFile() throws IOException {
        return FileUtils.createTempFile(SystemUtils.getTempDirectory());
    }

    public static File createTempFile(File parent) throws IOException {
        return FileUtils.createTempFile(parent, true);
    }

    public static File createTempFile(File parent, boolean create) throws IOException {
        File file = File.createTempFile("nbi-", ".tmp", parent);
        if (!create) {
            file.delete();
        }
        file.deleteOnExit();
        return file;
    }

    public static void modifyFile(File file, String token, Object replacement) throws IOException {
        FileUtils.modifyFile(file, token, replacement, false);
    }

    public static void modifyFile(File file, String token, Object replacement, boolean regexp) throws IOException {
        HashMap<String, Object> replacementMap = new HashMap<String, Object>();
        replacementMap.put(token, replacement);
        FileUtils.modifyFile(file, replacementMap, regexp);
    }

    public static void modifyFile(File file, Map<String, Object> map, boolean regexp) throws IOException {
        if (!FileUtils.exists(file)) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                FileUtils.modifyFile(child, map, regexp);
            }
        } else {
            String originalContents;
            if (file.length() > 102400L) {
                return;
            }
            String modifiedContents = originalContents = FileUtils.readFile(file);
            for (String token : map.keySet()) {
                Object object = map.get(token);
                String replacement = object instanceof File ? ((File)object).getAbsolutePath() : object.toString();
                if (regexp) {
                    modifiedContents = Pattern.compile(token, 8).matcher(modifiedContents).replaceAll(replacement);
                    continue;
                }
                modifiedContents = modifiedContents.replace(token, replacement);
            }
            if (!modifiedContents.equals(originalContents)) {
                LOGGER.log(Level.FINER, "    modifying file: " + file.getAbsolutePath());
                FileUtils.writeFile(file, modifiedContents);
            }
        }
    }

    public static FilesList copyFile(File source, File target) throws IOException {
        return FileUtils.copyFile(source, target, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FilesList copyFile(File source, File target, boolean recurse) throws IOException {
        FilesList list = new FilesList();
        if (!FileUtils.exists(source)) {
            LOGGER.log(Level.FINER, "    ... " + source + " does not exist");
            return list;
        }
        if (source.isFile()) {
            LOGGER.log(Level.FINER, "    copying file: " + source + " to: " + target);
            if (!source.canRead()) {
                throw new IOException("source is not readable");
            }
            if (FileUtils.exists(target) && !target.isFile()) {
                throw new IOException("destination is not a file");
            }
            File parent = target.getParentFile();
            if (!FileUtils.exists(parent)) {
                list.add(FileUtils.mkdirs(parent));
            }
            if (!FileUtils.exists(target) && !target.createNewFile()) {
                throw new IOException("destination cannot be created");
            }
            if (!target.canWrite()) {
                throw new IOException("desctination is not writable");
            }
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(target);
            try {
                StreamUtils.transferData(in, out);
                list.add(target);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, "" + e);
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, "" + e);
                }
            }
        }
        LOGGER.log(Level.FINER, "    copying directory: " + source + " to: " + target + (recurse ? " with recursion" : ""));
        list.add(FileUtils.mkdirs(target));
        if (recurse) {
            for (File file : source.listFiles()) {
                FileUtils.copyFile(file, new File(target, file.getName()), recurse);
            }
        }
        return list;
    }

    public static boolean isEmpty(File file) {
        if (!FileUtils.exists(file)) {
            return true;
        }
        if (file.isDirectory()) {
            File[] list = file.listFiles();
            if (list != null) {
                for (File child : list) {
                    if (FileUtils.isEmpty(child)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJarFile(File file) {
        if (file.getName().endsWith(JAR_EXTENSION)) {
            JarFile jar = null;
            try {
                jar = new JarFile(file);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINER, "" + e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINER, "" + e);
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSigned(File file) throws IOException {
        JarFile jar = new JarFile(file);
        try {
            boolean bl = jar.getEntry(SUN_MICR_RSA) != null && jar.getEntry(SUN_MICR_SF) != null;
            return bl;
        }
        finally {
            jar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipEntryExists(File file, String entry) throws IOException {
        ZipFile zip = new ZipFile(file);
        try {
            boolean bl = zip.getEntry(entry) != null;
            return bl;
        }
        finally {
            zip.close();
        }
    }

    public static File extractJarEntry(String entry, File source) throws IOException {
        return FileUtils.extractJarEntry(entry, source, FileUtils.createTempFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractJarEntry(String entry, File source, File target) throws IOException {
        JarFile jar = new JarFile(source);
        FileOutputStream out = new FileOutputStream(target);
        try {
            StreamUtils.transferData(jar.getInputStream(jar.getEntry(entry)), out);
            File file = target;
            return file;
        }
        finally {
            jar.close();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJarAttribute(File file, String name) throws IOException {
        JarFile jar = new JarFile(file);
        try {
            String string = jar.getManifest().getMainAttributes().getValue(name);
            return string;
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Cannot close jar" + e);
            }
        }
    }

    public static FilesList mkdirs(File file) throws IOException {
        FilesList list = new FilesList();
        if (!FileUtils.exists(file.getParentFile())) {
            list.add(FileUtils.mkdirs(file.getParentFile()));
        }
        if (FileUtils.exists(file) && file.isFile()) {
            throw new IOException("Cannot create directory " + file + " it is an existing file");
        }
        if (!FileUtils.exists(file)) {
            if (file.mkdir()) {
                list.add(file);
            } else {
                throw new IOException("Cannot create directory " + file);
            }
        }
        return list;
    }

    public static String getRelativePath(File source, File target) {
        String path;
        if (source.equals(target)) {
            path = source.isDirectory() ? CURRENT : target.getName();
        } else if (FileUtils.isParent(source, target)) {
            String sourcePath = source.getAbsolutePath().replace(BACKSLASH, SLASH);
            String targetPath = target.getAbsolutePath().replace(BACKSLASH, SLASH);
            path = sourcePath.endsWith(SLASH) ? targetPath.substring(sourcePath.length()) : targetPath.substring(sourcePath.length() + 1);
        } else if (FileUtils.isParent(target, source)) {
            path = source.isDirectory() ? PARENT : CURRENT;
            File parent = source.getParentFile();
            while (!parent.equals(target)) {
                path = path + "/..";
                parent = parent.getParentFile();
            }
        } else {
            File parent;
            for (parent = source.getParentFile(); parent != null && !FileUtils.isParent(parent, target); parent = parent.getParentFile()) {
            }
            if (parent == null) {
                return null;
            }
            path = FileUtils.getRelativePath(source, parent) + SLASH + FileUtils.getRelativePath(parent, target);
        }
        if (path.startsWith("./")) {
            path = path.length() > 2 ? path.substring(2) : path.substring(0, 1);
        }
        path = path.replace("/./", SLASH);
        return path;
    }

    public static boolean isParent(File candidate, File file) {
        File parent;
        for (parent = file.getParentFile(); parent != null && !candidate.equals(parent); parent = parent.getParentFile()) {
        }
        return parent != null && candidate.equals(parent);
    }

    public static boolean exists(File file) {
        if (file.exists()) {
            return true;
        }
        if (!file.isFile() && !file.isDirectory()) {
            File parent = file.getParentFile();
            if (parent == null || !parent.exists()) {
                return false;
            }
            File[] children = parent.listFiles();
            if (children == null) {
                return false;
            }
            for (File child : children) {
                if (!child.equals(file)) continue;
                return true;
            }
        }
        return false;
    }

    public static File findFile(File directory, String filename) {
        if (directory.getName().equals(filename)) {
            return directory;
        }
        File[] children = directory.listFiles();
        if (children != null) {
            for (File child : children) {
                File match = FileUtils.findFile(child, filename);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    public static void zip(File file, ZipOutputStream output, File root, List<File> excludes) throws IOException {
        if (excludes.contains(file)) {
            return;
        }
        String entryName = file.getAbsolutePath().substring(root.getAbsolutePath().length() + 1);
        if (file.isDirectory()) {
            output.putNextEntry(new ZipEntry(entryName + SLASH));
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    FileUtils.zip(child, output, root, excludes);
                }
            }
        } else {
            output.putNextEntry(new ZipEntry(entryName));
            StreamUtils.transferFile(file, output);
        }
    }

    private FileUtils() {
    }

    private static class MaskFileFilter
    implements FileFilter {
        private String mask = ".*";

        public MaskFileFilter(String mask) {
            this.mask = mask;
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().matches(this.mask);
        }
    }
}

