/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.JDKSelection.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.openinstaller.util.JDKSelection.utils.StringUtils;

public abstract class ResourceUtils {
    private static Map<String, ResourceBundle> loadedBundles = new HashMap<String, ResourceBundle>();
    private static final int BUF_SIZE = 102400;

    private static ResourceBundle loadBundle(String baseName, Locale locale, ClassLoader loader) {
        String bundleId = loader.toString() + baseName;
        ResourceBundle bundle = loadedBundles.get(bundleId);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(baseName, locale, loader);
            loadedBundles.put(bundleId, bundle);
        }
        return bundle;
    }

    private static ResourceBundle loadBundle(Class clazz, Locale locale) {
        return ResourceUtils.loadBundle(clazz.getPackage().getName() + "." + "Bundle", locale, clazz.getClassLoader());
    }

    public static String getString(String baseName, String key) {
        return ResourceUtils.loadBundle(baseName, Locale.getDefault(), ResourceUtils.class.getClassLoader()).getString(key);
    }

    public static String getString(String baseName, String key, ClassLoader loader) {
        return ResourceUtils.loadBundle(baseName, Locale.getDefault(), loader).getString(key);
    }

    public static String getString(String baseName, String key, ClassLoader loader, Object ... arguments) {
        return StringUtils.format(ResourceUtils.getString(baseName, key, loader), arguments);
    }

    public static String getString(Class clazz, String key) {
        return ResourceUtils.loadBundle(clazz, Locale.getDefault()).getString(key);
    }

    public static String getString(Class clazz, String key, Object ... arguments) {
        return StringUtils.format(ResourceUtils.getString(clazz, key), arguments);
    }

    public static InputStream getResource(String name) {
        return ResourceUtils.getResource(name, ResourceUtils.class.getClassLoader());
    }

    public static InputStream getResource(String path, ClassLoader loader) {
        return loader.getResourceAsStream(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getResourceSize(String resource) {
        InputStream is = null;
        long size = 0L;
        try {
            is = ResourceUtils.getResource(resource);
            if (is == null) {
                long l = -1L;
                return l;
            }
            byte[] buf = new byte[102400];
            while (is.available() > 0) {
                size += (long)is.read(buf);
            }
        }
        catch (IOException ex) {
            size = -1L;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
        return size;
    }

    public static String getResourceFileName(String resource) {
        return resource.substring(resource.lastIndexOf("/") + 1);
    }
}

