/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.JDKSelection.utils.applications;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.JDKSelection.utils.FileProxy;
import org.openinstaller.util.JDKSelection.utils.SystemUtils;
import org.openinstaller.util.JDKSelection.utils.exceptions.DownloadException;
import org.openinstaller.util.JDKSelection.utils.helper.ExecutionResults;
import org.openinstaller.util.JDKSelection.utils.helper.Version;

public class JavaUtils {
    public static final String JDK_KEY = "SOFTWARE\\JavaSoft\\Java Development Kit";
    public static final String JAVAHOME_VALUE = "JavaHome";
    public static final String MICROVERSION_VALUE = "MicroVersion";
    public static final String CURRENT_VERSION_VALUE = "CurrentVersion";
    public static final String TEST_JDK_RESOURCE = "org/openinstaller/util/JDKSelection/utils/applications/TestJDK.class";
    public static final String TEST_JDK_URI = "resource:org/openinstaller/util/JDKSelection/utils/applications/TestJDK.class";
    public static final String TEST_JDK_CLASSNAME = "TestJDK";
    public static final String TEST_JDK_FILENAME = "TestJDK.class";
    public static final int TEST_JDK_OUTPUT_PARAMETERS = 5;
    private static Map<File, JavaInfo> knownJdks = new HashMap<File, JavaInfo>();
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public static boolean isJavaHome(File javaHome) {
        if (!javaHome.exists() || !javaHome.isDirectory()) {
            return false;
        }
        File probe = JavaUtils.getExecutable(javaHome);
        if (!probe.exists() || !probe.isFile()) {
            return false;
        }
        probe = new File(javaHome, "lib");
        if (!probe.exists() || !probe.isDirectory()) {
            return false;
        }
        probe = new File(javaHome, "jre");
        if (probe.exists()) {
            probe = new File(javaHome, "lib/dt.jar");
            if (!probe.exists() || !probe.isFile()) {
                return false;
            }
            probe = new File(javaHome, "jre/lib/jce.jar");
            if (!probe.exists() || !probe.isFile()) {
                return false;
            }
        } else {
            probe = new File(javaHome, "lib/charsets.jar");
            if (!(probe.exists() && probe.isFile() || (probe = new File(javaHome, "lib/jce.jar")).exists() && probe.isFile())) {
                return false;
            }
        }
        return true;
    }

    public static boolean isJdk(File javaHome) {
        if (!JavaUtils.isJavaHome(javaHome)) {
            return false;
        }
        if (!SystemUtils.isMacOS()) {
            File privateJRE = new File(javaHome, "jre");
            if (!privateJRE.exists()) {
                return false;
            }
            if (!privateJRE.isDirectory()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isJre(File javaHome) {
        if (!javaHome.exists() || !javaHome.isDirectory()) {
            return false;
        }
        File probe = JavaUtils.getExecutable(javaHome);
        if (!probe.exists() || !probe.isFile()) {
            return false;
        }
        probe = new File(javaHome, "lib");
        if (!probe.exists() || !probe.isDirectory()) {
            return false;
        }
        probe = new File(javaHome, "lib/charsets.jar");
        if (!(probe.exists() && probe.isFile() || (probe = new File(javaHome, "lib/jce.jar")).exists() && probe.isFile())) {
            return false;
        }
        probe = new File(javaHome, "jre");
        if (probe.exists() && probe.isDirectory()) {
            probe = new File(javaHome, "lib/dt.jar");
            if (probe.exists() && probe.isFile()) {
                return false;
            }
            probe = new File(javaHome, "jre/lib/jce.jar");
            if (probe.exists() && probe.isFile()) {
                return false;
            }
        }
        return true;
    }

    public static Version getVersion(File javaHome) {
        return JavaUtils.getInfo(javaHome).getVersion();
    }

    public static JavaInfo getInfo(File javaHome) {
        File testJdk;
        File location = javaHome;
        try {
            location = javaHome.getCanonicalFile();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Cannot canonize " + javaHome, e);
        }
        if (knownJdks.get(location) != null) {
            return knownJdks.get(location);
        }
        if (!JavaUtils.isJavaHome(location)) {
            return null;
        }
        File executable = JavaUtils.getExecutable(location);
        try {
            testJdk = FileProxy.getInstance().getFile(TEST_JDK_URI);
        }
        catch (DownloadException e) {
            LOGGER.log(Level.FINE, "Cannot download TestJDK.class", e);
            return null;
        }
        JavaInfo jdkInfo = null;
        try {
            ExecutionResults results = SystemUtils.executeCommand(executable.getAbsolutePath(), "-classpath", testJdk.getParentFile().getAbsolutePath(), TEST_JDK_CLASSNAME);
            jdkInfo = JavaInfo.getInfo(results.getStdOut());
            if (jdkInfo != null) {
                knownJdks.put(location, jdkInfo);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to execute the jdk verification procedure", e);
        }
        return jdkInfo;
    }

    public static File getExecutable(File javaHome) {
        if (SystemUtils.isWindows()) {
            return new File(javaHome, "bin/java.exe");
        }
        return new File(javaHome, "bin/java");
    }

    private JavaUtils() {
    }

    public static class JavaInfo {
        private Version version;
        private String vendor;

        public static JavaInfo getInfo(String string) {
            String[] lines = string.split(SystemUtils.getLineSeparator());
            Version version = null;
            String vendor = null;
            String osName = null;
            String osArch = null;
            if (lines.length == 5) {
                Matcher matcher;
                String javaVersion = lines[0];
                String vmVersion = lines[1];
                vendor = lines[2];
                osName = lines[3];
                osArch = lines[4];
                String versionString = vmVersion.indexOf(javaVersion) != -1 ? vmVersion.substring(vmVersion.indexOf(javaVersion)) : javaVersion;
                if (versionString.matches("[0-9]+\\.[0-9]+\\.[0-9]+-b[0-9]+")) {
                    versionString = versionString.replace("-b", ".0.");
                }
                if (versionString.matches("[0-9]+\\.[0-9]+\\.[0-9]+_[0-9]+-b[0-9]+")) {
                    versionString = versionString.replace("-b", ".");
                }
                if ((matcher = Pattern.compile("[0-9][0-9_\\.\\-]+[0-9]").matcher(versionString)).find()) {
                    version = Version.getVersion(matcher.group());
                }
                if (version != null) {
                    return new JavaInfo(version, vendor);
                }
            }
            return null;
        }

        public JavaInfo(Version version, String vendor) {
            this.version = version;
            this.vendor = vendor;
        }

        public Version getVersion() {
            return this.version;
        }

        public String getVendor() {
            return this.vendor;
        }
    }
}

