/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.JDKSelection.utils.helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.JDKSelection.utils.FileUtils;
import org.openinstaller.util.JDKSelection.utils.exceptions.XMLException;
import org.openinstaller.util.JDKSelection.utils.helper.FileEntry;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesList
implements Iterable<FileEntry> {
    private File listFile = null;
    private File tempFile = null;
    private List<FileEntry> entries = new ArrayList<FileEntry>(2500);
    private int size = 0;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    public static final int CACHE_SIZE = 2500;
    public static final String ENCODING = "UTF-8";

    public FilesList() {
    }

    public FilesList(File xml) throws IOException, XMLException {
        this();
        this.loadXml(xml);
    }

    public void add(File file) throws IOException {
        this.add(new FileEntry(file));
    }

    public void add(FileEntry entry) throws IOException {
        String current;
        int index;
        String name = entry.getName();
        for (index = 0; index < this.entries.size() && (current = this.entries.get(index).getName()).length() >= name.length(); ++index) {
            if (!current.equals(name)) continue;
            return;
        }
        this.entries.add(index, entry);
        ++this.size;
        if (this.entries.size() == 2500) {
            this.save();
        }
    }

    public void add(FilesList list) throws IOException {
        for (FileEntry entry : list) {
            this.add(entry);
        }
    }

    public int getSize() {
        return this.size;
    }

    public FilesList loadXml(File xml) throws XMLException {
        return this.loadXml(xml, null);
    }

    public FilesList loadXml(File xml, File root) throws XMLException {
        try {
            FileInputStream in = new FileInputStream(xml);
            this.loadXml(in, root);
            ((InputStream)in).close();
            return this;
        }
        catch (IOException e) {
            throw new XMLException("Cannot parse xml file", e);
        }
    }

    private void loadXml(InputStream in, File root) throws IOException, XMLException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(in), (DefaultHandler)new FilesListHandler(root));
        }
        catch (SAXException e) {
            throw new XMLException("Cannot load files list from xml", e);
        }
        catch (ParserConfigurationException e) {
            throw new XMLException("Cannot load files list from xml", e);
        }
    }

    public FilesList loadXmlGz(File xml) throws XMLException {
        return this.loadXmlGz(xml, null);
    }

    public FilesList loadXmlGz(File xml, File root) throws XMLException {
        try {
            GZIPInputStream in = new GZIPInputStream(new FileInputStream(xml));
            this.loadXml(in, root);
            ((InputStream)in).close();
            return this;
        }
        catch (IOException e) {
            throw new XMLException("Cannot parse xml file", e);
        }
    }

    @Override
    public Iterator<FileEntry> iterator() {
        return new FilesListIterator();
    }

    private void save() throws IOException {
        if (this.entries.size() > 0) {
            if (this.listFile == null) {
                this.listFile = FileUtils.createTempFile();
                this.tempFile = FileUtils.createTempFile();
            }
            BufferedReader reader = this.listFile.length() > 0L ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.listFile)))) : new BufferedReader(new FileReader(this.listFile));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(this.tempFile))));
            int index = 0;
            FileEntry saved = this.readEntry(reader);
            while (index < this.entries.size() && saved != null) {
                String unsavedName = this.entries.get(index).getName();
                String savedName = saved.getName();
                if (savedName.equals(unsavedName)) {
                    if (index < this.entries.size() - 1 && this.entries.get(index + 1).getName().equals(unsavedName)) {
                        ++index;
                    } else {
                        saved = this.readEntry(reader);
                    }
                    --this.size;
                    continue;
                }
                if (unsavedName.length() < savedName.length()) {
                    this.XXXwriteEntry(saved, writer);
                    saved = this.readEntry(reader);
                    continue;
                }
                this.XXXwriteEntry(this.entries.get(index), writer);
                ++index;
            }
            while (index < this.entries.size()) {
                this.XXXwriteEntry(this.entries.get(index), writer);
                ++index;
            }
            while (saved != null) {
                this.XXXwriteEntry(saved, writer);
                saved = this.readEntry(reader);
            }
            reader.close();
            writer.flush();
            writer.close();
            FileUtils.copyFile(this.tempFile, this.listFile);
            this.entries.clear();
        }
    }

    private FileEntry readEntry(BufferedReader reader) throws IOException {
        String name = reader.readLine();
        if (name != null) {
            File file = new File(name);
            boolean directory = Boolean.parseBoolean(reader.readLine());
            if (directory) {
                boolean empty = Boolean.parseBoolean(reader.readLine());
                long modified = Long.parseLong(reader.readLine());
                int permissions = Integer.parseInt(reader.readLine());
                return new FileEntry(file, empty, modified, permissions);
            }
            long size = Long.parseLong(reader.readLine());
            String md5 = reader.readLine();
            boolean jarFile = Boolean.parseBoolean(reader.readLine());
            boolean packed = Boolean.parseBoolean(reader.readLine());
            boolean signed = Boolean.parseBoolean(reader.readLine());
            long modified = Long.parseLong(reader.readLine());
            int permissions = Integer.parseInt(reader.readLine());
            return new FileEntry(file, size, md5, jarFile, packed, signed, modified, permissions);
        }
        return null;
    }

    private void XXXwriteEntry(FileEntry entry, Writer writer) throws IOException {
        if (entry.getFile().exists()) {
            if (!entry.isMetaDataReady()) {
                entry.calculateMetaData();
            }
            writer.write(entry.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilesListIterator
    implements Iterator<FileEntry> {
        private int sizeAtConstruction = 0;
        private boolean listInMemory = false;
        private int index = 0;
        private BufferedReader reader = null;
        private FileEntry next = null;

        public FilesListIterator() {
            if (FilesList.this.listFile != null) {
                try {
                    FilesList.this.save();
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Cannot save list", e);
                }
                this.listInMemory = false;
                try {
                    this.reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(FilesList.this.listFile))));
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Cannot open reader to the list file", e);
                }
            } else {
                this.listInMemory = true;
                this.index = 0;
            }
            this.sizeAtConstruction = FilesList.this.size;
        }

        @Override
        public boolean hasNext() {
            if (this.sizeAtConstruction != FilesList.this.size) {
                throw new ConcurrentModificationException("The list was changed, while iterating");
            }
            if (this.next == null) {
                this.next = this.next();
            }
            return this.next != null;
        }

        @Override
        public FileEntry next() {
            if (this.next != null) {
                FileEntry temp = this.next;
                this.next = null;
                return temp;
            }
            FileEntry entry = null;
            if (this.listInMemory) {
                if (this.index < FilesList.this.entries.size()) {
                    entry = (FileEntry)FilesList.this.entries.get(this.index++);
                }
            } else {
                try {
                    entry = FilesList.this.readEntry(this.reader);
                    if (entry == null) {
                        this.reader.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Cannot read next entry", e);
                }
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported for files list");
        }
    }

    private class FilesListHandler
    extends DefaultHandler {
        private File root = null;

        public FilesListHandler(File root) {
            this.root = root;
        }
    }
}

