/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.JDKSelection.utils.helper;

public class Version {
    private long major;
    private long minor;
    private long micro;
    private long update;
    private long build;

    public static Version getVersion(String string) {
        if (string.matches("([0-9]+[\\._\\-]+)*[0-9]+")) {
            return new Version(string);
        }
        return null;
    }

    private Version(String string) {
        String[] split = string.split("[\\._\\-]+");
        if (split.length > 0) {
            this.major = new Long(split[0]);
        }
        if (split.length > 1) {
            this.minor = new Long(split[1]);
        }
        if (split.length > 2) {
            this.micro = new Long(split[2]);
        }
        if (split.length > 3) {
            this.update = new Long(split[3]);
        }
        if (split.length > 4) {
            this.build = new Long(split[4]);
        }
    }

    public boolean newerThan(Version version) {
        if (this.major > version.getMajor()) {
            return true;
        }
        if (this.major == version.getMajor()) {
            if (this.minor > version.getMinor()) {
                return true;
            }
            if (this.minor == version.getMinor()) {
                if (this.micro > version.getMicro()) {
                    return true;
                }
                if (this.micro == version.getMicro()) {
                    if (this.update > version.getUpdate()) {
                        return true;
                    }
                    if (this.update == version.getBuild() && this.build > version.getBuild()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean newerOrEquals(Version version) {
        return this.newerThan(version) || this.equals(version);
    }

    public boolean olderThan(Version version) {
        return !this.newerOrEquals(version);
    }

    public boolean olderOrEquals(Version version) {
        return !this.newerThan(version);
    }

    public long getMajor() {
        return this.major;
    }

    public long getMinor() {
        return this.minor;
    }

    public long getMicro() {
        return this.micro;
    }

    public long getUpdate() {
        return this.update;
    }

    public long getBuild() {
        return this.build;
    }

    public String toMinor() {
        return "" + this.major + "." + this.minor;
    }

    public String toJdkStyle() {
        return "" + this.major + "." + this.minor + "." + this.micro + (this.update != 0L ? "_" + (this.update < 10L ? "0" + this.update : Long.valueOf(this.update)) : "");
    }
}

