/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.JDKSelection.utils.system.windows;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.JDKSelection.utils.FileUtils;
import org.openinstaller.util.JDKSelection.utils.SystemUtils;
import org.openinstaller.util.JDKSelection.utils.exceptions.NativeException;

public class WindowsRegistry {
    public static final String LIBRARY_PATH = "org/openinstaller/util/JDKSelection/utils/system/windows/native/windows.dll";
    public static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    public static final int HKEY_CLASSES_ROOT = 0;
    public static final int HKEY_CURRENT_USER = 1;
    public static final int HKEY_LOCAL_MACHINE = 2;
    public static final int HKEY_USERS = 3;
    public static final int HKEY_CURRENT_CONFIG = 4;
    public static final int HKEY_DYN_DATA = 5;
    public static final int HKEY_PERFORMANCE_DATA = 6;
    public static final int HKEY_PERFORMANCE_NLSTEXT = 7;
    public static final int HKEY_PERFORMANCE_TEXT = 8;
    public static final int HKCR = 0;
    public static final int HKCU = 1;
    public static final int HKLM = 2;
    public static final int REG_NONE = 0;
    public static final int REG_SZ = 1;
    public static final int REG_EXPAND_SZ = 2;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD_LITTLE_ENDIAN = 4;
    public static final int REG_DWORD = 4;
    public static final int REG_DWORD_BIG_ENDIAN = 5;
    public static final int REG_LINK = 6;
    public static final int REG_MULTI_SZ = 7;
    public static final int REG_RESOURCE_LIST = 8;
    public static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    public static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    public static final int REG_QWORD_LITTLE_ENDIAN = 11;
    public static final int REG_QWORD = 11;
    public static final String SEPARATOR = "\\";
    private static int KEY_READ_LEVEL = 0;
    private static int KEY_MODIFY_LEVEL = 1;

    public WindowsRegistry() {
        this.loadNativeLibrary(LIBRARY_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadNativeLibrary(String libraryPath) {
        if (libraryPath != null) {
            InputStream input = null;
            try {
                File file = FileUtils.createTempFile();
                input = this.getClass().getClassLoader().getResourceAsStream(libraryPath);
                FileUtils.writeFile(file, input);
                System.load(file.getAbsolutePath());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Cannot load native library from path: " + libraryPath, e);
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.log(Level.SEVERE, "Cannot load native library from path: " + libraryPath, e);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, "" + e);
                    }
                }
            }
        }
    }

    public static File getDefaultApplicationsLocation() {
        File theDefaultApplcationsLocation = SystemUtils.getUserHomeDirectory();
        String thePath = System.getenv("ProgramFiles");
        if (thePath != null) {
            theDefaultApplcationsLocation = new File(thePath).getAbsoluteFile();
        } else {
            LOGGER.log(Level.INFO, "Value of the environment variable ProgramFiles is not set");
        }
        return theDefaultApplcationsLocation;
    }

    public boolean keyExists(int section, String key) throws NativeException {
        this.validateSection(section);
        this.validateKey(key);
        try {
            return this.checkKeyAccess0(section, key, KEY_READ_LEVEL);
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeException("Cannot access native method", e);
        }
    }

    public boolean keyExists(int section, String parent, String child) throws NativeException {
        this.validateKey(parent);
        this.validateKeyName(child);
        this.validateParenthood(parent, child);
        try {
            return this.keyExists(section, parent + SEPARATOR + child);
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeException("Cannot access native method", e);
        }
    }

    public boolean valueExists(int section, String key, String name) throws NativeException {
        this.validateValueName(name);
        if (this.keyExists(section, key)) {
            try {
                return this.valueExists0(section, key, name);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException("Cannot access native method", e);
            }
        }
        throw new NativeException("Cannot check for value existance - key does not exist");
    }

    public boolean keyEmpty(int section, String key) throws NativeException {
        if (this.keyExists(section, key)) {
            try {
                return this.keyEmpty0(section, key);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException("Cannot access native method", e);
            }
        }
        throw new NativeException("Cannot check -- key does not exist");
    }

    public String[] getSubKeys(int section, String key) throws NativeException {
        String[] names = this.getSubKeyNames(section, key);
        String[] subkeys = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            subkeys[i] = this.constructKey(key, names[i]);
        }
        return subkeys;
    }

    public String[] getSubKeyNames(int section, String key) throws NativeException {
        if (this.keyExists(section, key)) {
            try {
                return this.getSubkeyNames0(section, key);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException("Cannot access native method", e);
            }
        }
        throw new NativeException("Cannot get subkey names -- key does not exist");
    }

    public String[] getValueNames(int section, String key) throws NativeException {
        if (this.keyExists(section, key)) {
            try {
                return this.getValueNames0(section, key);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException("Cannot access native method", e);
            }
        }
        throw new NativeException("Cannot list value names -- key does not exist");
    }

    public String getStringValue(int section, String key, String name) throws NativeException {
        return this.getStringValue(section, key, name, false);
    }

    public String getStringValue(int section, String key, String name, boolean expand) throws NativeException {
        if (this.keyExists(section, key)) {
            if (this.valueExists(section, key, name)) {
                try {
                    return this.getStringValue0(section, key, name, expand);
                }
                catch (UnsatisfiedLinkError e) {
                    throw new NativeException("Cannot access native method", e);
                }
            }
            throw new NativeException("Cannot get string value -- value does not exist");
        }
        throw new NativeException("Cannot get string value -- key does not exist");
    }

    public void setStringValue(int section, String key, String name, Object value) throws NativeException {
        this.setStringValue(section, key, name, value.toString());
    }

    public void set32BitValue(int section, String key, String name, int value) throws NativeException {
        this.validateValueName(name);
        if (this.keyExists(section, key)) {
            try {
                this.set32BitValue0(section, key, name, value);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException("Cannot access native method", e);
            }
        } else {
            throw new NativeException("Cannot set 32-bit value -- key does not exist");
        }
    }

    public void setMultiStringValue(int section, String key, String name, String[] value) throws NativeException {
        this.validateValueName(name);
        this.validateMultiStringValue(value);
        if (this.keyExists(section, key)) {
            try {
                this.setMultiStringValue0(section, key, name, value);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException("Cannot access native method", e);
            }
        } else {
            throw new NativeException("Cannot set multistring value -- key does not exist");
        }
    }

    public void setBinaryValue(int section, String key, String name, byte[] value) throws NativeException {
        this.validateValueName(name);
        this.validateBinaryValue(value);
        if (this.keyExists(section, key)) {
            try {
                this.setBinaryValue0(section, key, name, value);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException("Cannot access native method", e);
            }
        } else {
            throw new NativeException("Cannot set binary value -- key does not exist");
        }
    }

    public void setNoneValue(int section, String key, String name, byte ... bytes) throws NativeException {
        this.validateValueName(name);
        if (this.keyExists(section, key)) {
            try {
                this.setNoneValue0(section, key, name, bytes);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException("Cannot access native method", e);
            }
        } else {
            throw new NativeException("Cannot access value -- key does not exist");
        }
    }

    public boolean canModifyKey(int section, String key) throws NativeException {
        try {
            if (this.keyExists(section, key)) {
                return this.checkKeyAccess0(section, key, KEY_MODIFY_LEVEL);
            }
            return this.canModifyKey(section, this.getKeyParent(key));
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeException("Cannot access native method", e);
        }
    }

    public String constructKey(String parent, String child) {
        return parent + SEPARATOR + child;
    }

    public String getKeyParent(String key) {
        String temp = key;
        while (temp.endsWith(SEPARATOR)) {
            temp = temp.substring(0, temp.length() - 1);
        }
        int index = temp.lastIndexOf(SEPARATOR);
        if (index != -1) {
            return temp.substring(0, index);
        }
        return "";
    }

    public String getKeyName(String key) {
        String temp = key;
        while (temp.endsWith(SEPARATOR)) {
            temp = temp.substring(0, temp.length() - 1);
        }
        int index = temp.lastIndexOf(SEPARATOR);
        if (index != -1) {
            return temp.substring(index + 1);
        }
        return temp;
    }

    private void validateSection(int section) throws NativeException {
        if (section < 0 || section > 8) {
            throw new NativeException("Section \"" + section + "\" is " + "invalid, should be between " + 0 + " " + "and " + 8);
        }
    }

    private void validateKey(String key) throws NativeException {
        if (key == null) {
            throw new NativeException("Key cannot be null");
        }
    }

    private void validateKeyName(String name) throws NativeException {
        if (name == null) {
            throw new NativeException("Key name cannot be null");
        }
    }

    private void validateParenthood(String parent, String child) throws NativeException {
        if (parent.equals(child)) {
            throw new NativeException("Parent cannot be equal to child");
        }
    }

    private void validateValueName(String name) throws NativeException {
        if (name == null) {
            throw new NativeException("Value name cannot be null");
        }
    }

    private void validateMultiStringValue(String[] value) throws NativeException {
        if (value == null) {
            throw new NativeException("Multistring value cannot be null");
        }
    }

    private void validateBinaryValue(byte[] value) throws NativeException {
        if (value == null) {
            throw new NativeException("Binary value cannot be null");
        }
    }

    private native boolean valueExists0(int var1, String var2, String var3) throws NativeException;

    private native boolean keyEmpty0(int var1, String var2) throws NativeException;

    private native String[] getSubkeyNames0(int var1, String var2) throws NativeException;

    private native String[] getValueNames0(int var1, String var2) throws NativeException;

    private native String getStringValue0(int var1, String var2, String var3, boolean var4) throws NativeException;

    private native void set32BitValue0(int var1, String var2, String var3, int var4) throws NativeException;

    private native void setMultiStringValue0(int var1, String var2, String var3, String[] var4) throws NativeException;

    private native void setBinaryValue0(int var1, String var2, String var3, byte[] var4) throws NativeException;

    private native void setNoneValue0(int var1, String var2, String var3, Object var4) throws NativeException;

    private native boolean checkKeyAccess0(int var1, String var2, int var3) throws NativeException;
}

