/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Version;
import org.openinstaller.util.VersionRange;

public final class Platform
implements Serializable {
    public static final char SEPARATOR = '\n';
    private static final Map<OSName, String> DEFAULT_PKG_FORMAT;
    private transient VersionRange gDefinedPlatformOSVersion;
    private transient OSName gDefinedPlatformOSName;
    private transient OSType gDefinedPlatformOSType;
    private transient Arch gDefinedPlatformArch;
    private static transient OSType gCurrentPlatformType;
    private static transient OSName gCurrentPlatformName;
    private static transient Arch gCurrentPlatformArch;
    private static transient VersionRange gCurrentPlatformOSVersion;
    private static final transient Logger LOGGER;
    private static final transient Platform CURRENT_PLATFORM;

    public Platform(OSType aOsType, OSName aOsName, Arch aArch, VersionRange aVersion) {
        this.gDefinedPlatformOSType = aOsType;
        this.gDefinedPlatformOSName = aOsName;
        this.gDefinedPlatformArch = aArch;
        if (aVersion == null) {
            try {
                this.gDefinedPlatformOSVersion = new VersionRange(new Version("0"), true, Version.INFINITY, false);
            }
            catch (InvalidArgumentException theEIAEx) {
                LOGGER.log(Level.WARNING, "CANNOT_CREATE_VERSION_RANGE", theEIAEx);
            }
        } else {
            this.gDefinedPlatformOSVersion = aVersion;
        }
    }

    public Platform(OSType aOsType, OSName aOsName, Arch aArch) {
        this.gDefinedPlatformOSType = aOsType;
        this.gDefinedPlatformOSName = aOsName;
        this.gDefinedPlatformArch = aArch;
        try {
            this.gDefinedPlatformOSVersion = new VersionRange(new Version("0"), true, Version.INFINITY, false);
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.WARNING, "CANNOT_CREATE_VERSION_RANGE", theEIAEx);
        }
    }

    public boolean isIdentical(Platform aPlatform) {
        boolean theOSTypeEquals = aPlatform.retrievePlatformType().equals((Object)this.gDefinedPlatformOSType);
        boolean theOSNameEquals = aPlatform.retrievePlatformName().equals((Object)this.gDefinedPlatformOSName);
        boolean theArchEquals = aPlatform.retrievePlatformArch().equals((Object)this.gDefinedPlatformArch);
        boolean theOSVersionEquals = aPlatform.retrievePlatformVersion().equals(this.gDefinedPlatformOSVersion);
        return theOSTypeEquals && theOSNameEquals && theArchEquals && theOSVersionEquals;
    }

    public boolean isCompatible() {
        return this.isCompatible(CURRENT_PLATFORM);
    }

    public boolean isCompatible(Platform aPlatform) {
        boolean theOSTypeCompatible = aPlatform.retrievePlatformType().equals((Object)this.gDefinedPlatformOSType) || aPlatform.retrievePlatformType().equals((Object)OSType.UNDEFINED) || this.gDefinedPlatformOSType.equals((Object)OSType.UNDEFINED);
        boolean theOSNameCompatible = aPlatform.retrievePlatformName().equals((Object)this.gDefinedPlatformOSName) || aPlatform.retrievePlatformName().equals((Object)OSName.UNDEFINED) || this.gDefinedPlatformOSName.equals((Object)OSName.UNDEFINED);
        boolean theArchCompatible = aPlatform.retrievePlatformArch().equals((Object)this.gDefinedPlatformArch) || aPlatform.retrievePlatformArch().equals((Object)Arch.UNDEFINED) || this.gDefinedPlatformArch.equals((Object)Arch.UNDEFINED);
        boolean theOSVersionCompatible = aPlatform.retrievePlatformVersion().overlaps(this.gDefinedPlatformOSVersion);
        return theOSTypeCompatible && theOSNameCompatible && theArchCompatible && theOSVersionCompatible;
    }

    public boolean versionMatches() {
        return this.versionMatches(gCurrentPlatformOSVersion);
    }

    public static Platform getCurrentPlatform() {
        return CURRENT_PLATFORM;
    }

    public static OSType getCurrentOsType() {
        return gCurrentPlatformType;
    }

    public static OSName getCurrentOsName() {
        return gCurrentPlatformName;
    }

    public static Arch getCurrentOsArch() {
        return gCurrentPlatformArch;
    }

    public static VersionRange getCurrentPlatformVersion() {
        return gCurrentPlatformOSVersion;
    }

    public boolean versionMatches(VersionRange aVersion) {
        return aVersion.overlaps(this.gDefinedPlatformOSVersion);
    }

    public static OSType getOSTypeForString(String aOSTypeString) {
        if (aOSTypeString.equalsIgnoreCase("solaris") || aOSTypeString.equalsIgnoreCase("sunos") || aOSTypeString.equalsIgnoreCase("linux") || aOSTypeString.equalsIgnoreCase("hpux") || aOSTypeString.equalsIgnoreCase("aix") || aOSTypeString.equalsIgnoreCase("alpha") || aOSTypeString.equalsIgnoreCase("irix") || aOSTypeString.equalsIgnoreCase("hpux") || aOSTypeString.equalsIgnoreCase("hp-ux") || aOSTypeString.equalsIgnoreCase("sco") || aOSTypeString.equalsIgnoreCase("unix") || aOSTypeString.equalsIgnoreCase("osf1") || aOSTypeString.equalsIgnoreCase("digital unix") || aOSTypeString.equalsIgnoreCase("dec unix") || aOSTypeString.equalsIgnoreCase("dec") || aOSTypeString.equalsIgnoreCase("mac os x") || aOSTypeString.equalsIgnoreCase("macosx")) {
            return OSType.UNIX;
        }
        if (aOSTypeString.length() >= "windows".length() && aOSTypeString.substring(0, "windows".length()).equalsIgnoreCase("WINDOWS")) {
            return OSType.WINDOWS;
        }
        if (aOSTypeString.equalsIgnoreCase("beos") || aOSTypeString.equalsIgnoreCase("BE")) {
            return OSType.BE;
        }
        if (aOSTypeString.equalsIgnoreCase("macos") || aOSTypeString.equalsIgnoreCase("mac os") || aOSTypeString.equalsIgnoreCase("MAC")) {
            return OSType.MAC;
        }
        return OSType.UNDEFINED;
    }

    public static OSName getOSNameForString(String aOsName) {
        String theCookedOsName = aOsName.replace('_', ' ');
        if (theCookedOsName.equalsIgnoreCase("sunos") || theCookedOsName.equalsIgnoreCase("SOLARIS")) {
            return OSName.SOLARIS;
        }
        if (theCookedOsName.equalsIgnoreCase("LINUX")) {
            return OSName.LINUX;
        }
        if (theCookedOsName.equalsIgnoreCase("hp-ux") || theCookedOsName.equalsIgnoreCase("HPUX")) {
            return OSName.HPUX;
        }
        if (theCookedOsName.equalsIgnoreCase("AIX")) {
            return OSName.AIX;
        }
        if (theCookedOsName.equalsIgnoreCase("SCO")) {
            return OSName.SCO;
        }
        if (theCookedOsName.equalsIgnoreCase("windows 95") || theCookedOsName.equalsIgnoreCase("WIN95")) {
            return OSName.WIN95;
        }
        if (theCookedOsName.equalsIgnoreCase("windows 98") || theCookedOsName.equalsIgnoreCase("WIN98")) {
            return OSName.WIN98;
        }
        if (theCookedOsName.equalsIgnoreCase("windows 2000") || theCookedOsName.equalsIgnoreCase("WIN2000")) {
            return OSName.WIN2000;
        }
        if (theCookedOsName.equalsIgnoreCase("windows nt") || theCookedOsName.equalsIgnoreCase("WINNT")) {
            return OSName.WINNT;
        }
        if (theCookedOsName.equalsIgnoreCase("windows xp") || theCookedOsName.equalsIgnoreCase("WINXP")) {
            return OSName.WINXP;
        }
        if (theCookedOsName.equalsIgnoreCase("windows 2003") || theCookedOsName.equalsIgnoreCase("WIN2003")) {
            return OSName.WIN2003;
        }
        if (theCookedOsName.equalsIgnoreCase("MAC OS X") || theCookedOsName.equalsIgnoreCase("MACOSX")) {
            return OSName.MACOSX;
        }
        if (theCookedOsName.equalsIgnoreCase("mac os") || theCookedOsName.equalsIgnoreCase("MACOS")) {
            return OSName.MACOS;
        }
        if (theCookedOsName.equalsIgnoreCase("BEOS")) {
            return OSName.BEOS;
        }
        if (theCookedOsName.equalsIgnoreCase("IRIX")) {
            return OSName.IRIX;
        }
        if (theCookedOsName.equalsIgnoreCase("OSF1")) {
            return OSName.OSF1;
        }
        return OSName.UNDEFINED;
    }

    public static Arch getArchForString(String aArch) {
        if (aArch.equalsIgnoreCase("SPARC")) {
            return Arch.SPARC;
        }
        if (aArch.equalsIgnoreCase("SPARCv9")) {
            return Arch.SPARCV9;
        }
        if (aArch.equalsIgnoreCase("i386") || aArch.equalsIgnoreCase("i86pc") || aArch.equalsIgnoreCase("X86") || aArch.equalsIgnoreCase("32")) {
            return Arch.X86;
        }
        if (aArch.equalsIgnoreCase("i686") || aArch.equalsIgnoreCase("amd64") || aArch.equalsIgnoreCase("X86_64") || aArch.equalsIgnoreCase("X86-64") || aArch.equalsIgnoreCase("64")) {
            return Arch.X86_64;
        }
        if (aArch.equalsIgnoreCase("ALPHA")) {
            return Arch.ALPHA;
        }
        if (aArch.equalsIgnoreCase("power pc") || aArch.equalsIgnoreCase("power_pc") || aArch.equalsIgnoreCase("ppc") || aArch.equalsIgnoreCase("POWERPC")) {
            return Arch.POWERPC;
        }
        if (aArch.equalsIgnoreCase("MIPS")) {
            return Arch.MIPS;
        }
        if (aArch.equalsIgnoreCase("pa-risc") || aArch.equalsIgnoreCase("pa_risc") || aArch.startsWith("PA_RISC") || aArch.startsWith("PA-RISC") || aArch.equalsIgnoreCase("parisc")) {
            return Arch.PARISC;
        }
        LOGGER.fine(ClassUtils.getFQMethodName() + " called by " + ClassUtils.getFQCallingMethodName() + " canot determine arch based on " + aArch);
        return Arch.UNDEFINED;
    }

    public OSType retrievePlatformType() {
        return this.gDefinedPlatformOSType;
    }

    public OSName retrievePlatformName() {
        return this.gDefinedPlatformOSName;
    }

    public Arch retrievePlatformArch() {
        return this.gDefinedPlatformArch;
    }

    public VersionRange retrievePlatformVersion() {
        return this.gDefinedPlatformOSVersion;
    }

    public String toString() {
        StringBuffer theDescription = new StringBuffer();
        theDescription.append(this.gDefinedPlatformOSType.getValue());
        theDescription.append(' ');
        theDescription.append(this.gDefinedPlatformOSName.getValue());
        theDescription.append(' ');
        theDescription.append(this.gDefinedPlatformArch.getValue());
        theDescription.append(' ');
        theDescription.append(VersionRange.encode(this.gDefinedPlatformOSVersion));
        return theDescription.toString();
    }

    public String toStringSansVersion() {
        StringBuffer theDescription = new StringBuffer();
        theDescription.append(this.gDefinedPlatformOSType.getValue());
        theDescription.append(' ');
        theDescription.append(this.gDefinedPlatformOSName.getValue());
        theDescription.append(' ');
        theDescription.append(this.gDefinedPlatformArch.getValue());
        return theDescription.toString();
    }

    public static String encode(Platform aPlatform) {
        StringBuffer theEncoded = new StringBuffer();
        theEncoded.append(aPlatform.gDefinedPlatformOSType.toString());
        theEncoded.append('\n');
        theEncoded.append(aPlatform.gDefinedPlatformOSName.toString());
        theEncoded.append('\n');
        theEncoded.append(aPlatform.gDefinedPlatformArch.toString());
        theEncoded.append('\n');
        theEncoded.append(VersionRange.encode(aPlatform.gDefinedPlatformOSVersion));
        return theEncoded.toString();
    }

    public static String encodeSansVersion(Platform aPlatform) {
        StringBuffer theEncoded = new StringBuffer();
        theEncoded.append(aPlatform.gDefinedPlatformOSType.toString());
        theEncoded.append('\n');
        theEncoded.append(aPlatform.gDefinedPlatformOSName.toString());
        theEncoded.append('\n');
        theEncoded.append(aPlatform.gDefinedPlatformArch.toString());
        return theEncoded.toString();
    }

    public static Platform decode(String aInput) throws EnhancedException {
        Pattern thePattern = Pattern.compile(String.valueOf('\n'));
        String[] theItems = thePattern.split(aInput, -1);
        Platform theDecoded = new Platform(Platform.getOSTypeForString(theItems[0]), Platform.getOSNameForString(theItems[1]), Platform.getArchForString(theItems[2]), new VersionRange(theItems[3]));
        return theDecoded;
    }

    private static String getSystemArch(OSType aOsType, OSName aOs) throws IOException {
        switch (aOsType) {
            case UNIX: {
                switch (aOs) {
                    case SOLARIS: {
                        Process thePB = new ProcessBuilder("/bin/isainfo", "-k").start();
                        return new BufferedReader(new InputStreamReader(thePB.getInputStream())).readLine().trim();
                    }
                    case LINUX: {
                        Process thePB = new ProcessBuilder("/bin/uname", "-i").start();
                        String theArch = new BufferedReader(new InputStreamReader(thePB.getInputStream())).readLine().trim();
                        if (!theArch.equalsIgnoreCase("unknown")) {
                            return theArch;
                        }
                        return System.getProperty("os.arch");
                    }
                }
                return System.getProperty("os.arch");
            }
            case WINDOWS: {
                String theNextLine;
                Process thePB = new ProcessBuilder("wmic", "cpu", "get", "addresswidth", "/value").start();
                thePB.getOutputStream().close();
                BufferedReader theReader = new BufferedReader(new InputStreamReader(thePB.getInputStream()));
                while ((theNextLine = theReader.readLine()) != null) {
                    String[] theComps;
                    if ((theNextLine = theNextLine.trim()).length() <= 0 || (theComps = theNextLine.split("=", 2)).length != 2) continue;
                    return theComps[1].trim();
                }
                break;
            }
            case MAC: {
                return System.getProperty("os.arch");
            }
        }
        LOGGER.log(Level.WARNING, "WARN_COULDNT_DET_ARCH_STR", new String[]{"type=" + aOsType.getValue(), "name=" + aOs.getValue()});
        return System.getProperty("os.arch");
    }

    public static String getDefaultPackageFormat() {
        return Platform.getDefaultPackageFormat(Platform.getCurrentPlatform());
    }

    public static String getDefaultPackageFormat(Platform aPlatform) {
        String theFmt = DEFAULT_PKG_FORMAT.get((Object)aPlatform.retrievePlatformName());
        if (theFmt != null) {
            return theFmt;
        }
        return DEFAULT_PKG_FORMAT.get((Object)OSName.UNDEFINED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String theArch;
        DEFAULT_PKG_FORMAT = new HashMap<OSName, String>(){
            {
                this.put(OSName.UNDEFINED, "zip");
                this.put(OSName.LINUX, "rpm");
                this.put(OSName.SOLARIS, "svr4");
            }
        };
        gCurrentPlatformType = OSType.UNDEFINED;
        gCurrentPlatformName = OSName.UNDEFINED;
        gCurrentPlatformArch = Arch.UNDEFINED;
        gCurrentPlatformOSVersion = null;
        LOGGER = Logger.getLogger(ClassUtils.getClassName());
        String theOsName = System.getProperty("os.name");
        String theOSVer = System.getProperty("os.version");
        LOGGER.log(Level.FINE, "VM: osName=\"" + theOsName + "\"");
        LOGGER.log(Level.FINE, "VM: osVer=\"" + theOSVer + "\"");
        gCurrentPlatformType = Platform.getOSTypeForString(theOsName);
        gCurrentPlatformName = Platform.getOSNameForString(theOsName);
        try {
            theArch = Platform.getSystemArch(gCurrentPlatformType, gCurrentPlatformName);
        }
        catch (IOException theEx) {
            LOGGER.fine("Cannot determine architecture for platform OS type " + (Object)((Object)gCurrentPlatformType) + " and OS name " + (Object)((Object)gCurrentPlatformName) + ", falling back to os.arch");
            theArch = System.getProperty("os.arch");
        }
        LOGGER.log(Level.FINE, "VM: osArch=\"" + theArch + "\"");
        gCurrentPlatformArch = Platform.getArchForString(theArch);
        try {
            gCurrentPlatformOSVersion = new VersionRange(new Version(theOSVer));
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.WARNING, "CANNOT_CREATE_VERSION_RANGE", theEIAEx);
        }
        if (gCurrentPlatformType == OSType.UNDEFINED) {
            LOGGER.log(Level.WARNING, "WARN_COULDNT_DET_OSTYPE", "type=" + theOsName);
        }
        if (gCurrentPlatformName == OSName.UNDEFINED) {
            LOGGER.log(Level.WARNING, "WARN_COULDNT_DET_OSNAME", "name=" + theOsName);
        }
        if (gCurrentPlatformArch == Arch.UNDEFINED) {
            LOGGER.log(Level.WARNING, "WARN_COULDNT_DET_ARCH_STR", "arch=" + theArch);
        }
        if (gCurrentPlatformType == OSType.UNIX) {
            BufferedReader theProcessReader = null;
            try {
                Runtime theRuntime = Runtime.getRuntime();
                Process theProcess = theRuntime.exec("uname -r");
                InputStream theProcessInput = theProcess.getInputStream();
                theProcessReader = new BufferedReader(new InputStreamReader(theProcessInput));
                gCurrentPlatformOSVersion = new VersionRange(new Version(theProcessReader.readLine()));
            }
            catch (InvalidArgumentException theEIAEx) {
                LOGGER.log(Level.WARNING, "CANNOT_CREATE_VERSION_RANGE", theEIAEx);
            }
            catch (IOException theIoe) {
                try {
                    gCurrentPlatformOSVersion = new VersionRange(new Version(theOSVer));
                    LOGGER.log(Level.FINE, "Cannot run uname -r", theIoe);
                }
                catch (InvalidArgumentException theEIAEx) {
                    LOGGER.log(Level.WARNING, "CANNOT_CREATE_VERSION_RANGE", theEIAEx);
                }
            }
            finally {
                if (theProcessReader != null) {
                    try {
                        theProcessReader.close();
                    }
                    catch (IOException theEx) {
                        LOGGER.log(Level.FINE, "Cannot close stream after running uname -r", theEx);
                    }
                }
            }
        }
        LOGGER.log(Level.FINE, "osType=" + gCurrentPlatformType.getValue());
        LOGGER.log(Level.FINE, "osName=" + gCurrentPlatformName.getValue());
        LOGGER.log(Level.FINE, "arch=" + gCurrentPlatformArch.getValue());
        LOGGER.log(Level.FINE, "currentVersion is " + gCurrentPlatformOSVersion.toString());
        CURRENT_PLATFORM = new Platform(gCurrentPlatformType, gCurrentPlatformName, gCurrentPlatformArch, gCurrentPlatformOSVersion);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arch {
        UNDEFINED("UNDEFINED"),
        SPARC("Sparc"),
        SPARCV9("SparcV9"),
        X86("X86"),
        X86_64("X86"),
        ALPHA("alpha"),
        MIPS("Mips"),
        POWERPC("PowerPC"),
        PARISC("PA-Risc");

        private String gName;

        private Arch(String aName) {
            this.setValue(aName);
        }

        private void setValue(String aName) {
            this.gName = aName;
        }

        public String getValue() {
            return this.gName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OSName {
        UNDEFINED("UNDEFINED"),
        SOLARIS("Solaris"),
        LINUX("Linux"),
        HPUX("HPUX"),
        AIX("AIX"),
        SCO("SCO"),
        WIN95("Windows 95"),
        WIN2003("Windows 2003"),
        WINNT("Windows NT"),
        MACOS("MacOS"),
        MACOSX("MacOSX"),
        BEOS("BE OS"),
        IRIX("Irix"),
        OSF1("OSF1"),
        WINXP("Windows XP"),
        WIN2000("Windows 2000"),
        WIN98("Windows 98");

        private String gName;

        private OSName(String aName) {
            this.setValue(aName);
        }

        private void setValue(String aName) {
            this.gName = aName;
        }

        public String getValue() {
            return this.gName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OSType {
        UNDEFINED("UNDEFINED"),
        UNIX("Unix"),
        WINDOWS("Windows"),
        BE("BE"),
        MAC("Mac");

        private String gName;

        private OSType(String aName) {
            this.setValue(aName);
        }

        private void setValue(String aName) {
            this.gName = aName;
        }

        public String getValue() {
            return this.gName;
        }
    }
}

