/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openinstaller.provider.operation.Operation;
import org.openinstaller.util.DataModel;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.TemplateProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Summary {
    private String gProductIdentifier;
    private String gProductName;
    private String gProductVersion;
    private Operation.OPTYPE gOperation;
    private String gStatusMsg;
    private Boolean gStatus;
    private String gDocReference;
    private String gNextSteps;
    private String gPlatformError;
    private String gProductError;
    private final List<String> gOtherDetails = new ArrayList<String>();
    private static final String SUMMARY_TEMPLATE = "/templates/summary.ftl";

    public void setProductName(String aProductName) {
        this.gProductName = aProductName;
    }

    public String getProductName() {
        return this.gProductName;
    }

    public void setProductVersion(String aProductVersion) {
        this.gProductVersion = aProductVersion;
    }

    public String getProductVersion() {
        return this.gProductVersion;
    }

    public void setStatusMsg(String aStatusMsg) {
        this.gStatusMsg = aStatusMsg;
    }

    public String getStatusMsg() {
        return this.gStatusMsg;
    }

    public String getDocReference() {
        return this.gDocReference;
    }

    public void setDocReference(String aDocReference) {
        this.gDocReference = aDocReference;
    }

    public String getNextSteps() {
        return this.gNextSteps;
    }

    public void setNextSteps(String aNextSteps) {
        this.gNextSteps = aNextSteps;
    }

    public String getPlatformError() {
        return this.gPlatformError;
    }

    public void setPlatformError(String aPlatformError) {
        this.gPlatformError = aPlatformError;
    }

    public String getProductError() {
        return this.gProductError;
    }

    public void setProductError(String aProductError) {
        this.gProductError = aProductError;
    }

    public List<String> getOtherDetails() {
        return this.gOtherDetails;
    }

    public void addOtherDetail(String aOtherDetail) {
        this.gOtherDetails.add(aOtherDetail);
    }

    public Summary(String aProductName, String aProductVersion, boolean aStatus, String aStatusMsg, String aDocReference, String aNextSteps, String aPlatformError, String aProductError) {
        this.gStatus = aStatus;
        this.gProductName = aProductName;
        this.gProductVersion = aProductVersion;
        this.gStatusMsg = aStatusMsg;
        this.gDocReference = aDocReference;
        this.gNextSteps = aNextSteps;
        this.gPlatformError = aPlatformError;
        this.gProductError = aProductError;
    }

    public static void printHTMLSummary(String aProductName, String aFinalLog, List<Summary> aSummaries, PrintWriter aWriter) throws EnhancedException {
        aWriter.write(Summary.populateDataModel(aProductName, aFinalLog, aSummaries).processTemplate(SUMMARY_TEMPLATE));
    }

    private static TemplateProcessor populateDataModel(String aProductName, String aFinalLog, List<Summary> aSummaries) throws EnhancedException {
        TemplateProcessor theTP = new TemplateProcessor(new DataModel());
        theTP.replaceInDataModel("summary.date", new Date().toString());
        theTP.replaceInDataModel("summary.productname", aProductName);
        theTP.replaceInDataModel("summary.fullyinstalledcount", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.INSTALL, Boolean.TRUE).size());
        theTP.replaceInDataModel("summary.totalinstallcount", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.INSTALL, null).size());
        theTP.replaceInDataModel("summary.fullyrepairedcount", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.REPAIR, Boolean.TRUE).size());
        theTP.replaceInDataModel("summary.totalrepaircount", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.REPAIR, null).size());
        theTP.replaceInDataModel("summary.fullyuninstalledcount", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.REMOVE, Boolean.TRUE).size());
        theTP.replaceInDataModel("summary.totaluninstallcount", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.REMOVE, null).size());
        theTP.replaceInDataModel("summary.totalconfigcount", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.CONFIGURE, null).size());
        theTP.replaceInDataModel("summary.totalunconfigcount", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.UNCONFIGURE, null).size());
        theTP.replaceInDataModel("summary.fullyconfiguredcount", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.CONFIGURE, Boolean.TRUE).size());
        theTP.replaceInDataModel("summary.fullyunconfiguredcount", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.UNCONFIGURE, Boolean.TRUE).size());
        theTP.replaceInDataModel("summary.componentstoinstall", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.INSTALL, null));
        theTP.replaceInDataModel("summary.componentstorepair", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.REPAIR, null));
        theTP.replaceInDataModel("summary.componentstouninstall", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.REMOVE, null));
        theTP.replaceInDataModel("summary.componentstoconfigure", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.CONFIGURE, null));
        theTP.replaceInDataModel("summary.componentstounconfigure", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.UNCONFIGURE, null));
        theTP.replaceInDataModel("summary.installedcomponents", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.INSTALL, Boolean.TRUE));
        theTP.replaceInDataModel("summary.repairedcomponents", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.REPAIR, Boolean.TRUE));
        theTP.replaceInDataModel("summary.uninstalledcomponents", Summary.getProducts(aSummaries, aFinalLog, Operation.OPTYPE.REMOVE, Boolean.TRUE));
        theTP.replaceInDataModel("summary.failedcomponents", Summary.getProducts(aSummaries, aFinalLog, null, Boolean.FALSE));
        return theTP;
    }

    private static List<Object> getProducts(List<Summary> aSummaries, String aFinalLog, Operation.OPTYPE aOp, Boolean aSuccessFlag) {
        ArrayList<Object> theComps = new ArrayList<Object>();
        for (Summary theSum : aSummaries) {
            if (aOp != null && theSum.getOperation() != aOp || aSuccessFlag != null && !aSuccessFlag.equals(theSum.getStatus())) continue;
            theComps.add(Summary.getSummaryModel(theSum, aFinalLog));
        }
        return theComps;
    }

    private static Object getSummaryModel(Summary aSum, String aFinalLog) {
        HashMap<String, Object> theMod = new HashMap<String, Object>();
        theMod.put("name", aSum.getProductName() + " " + aSum.getProductVersion());
        theMod.put("install", Summary.getSummaryInstallModel(aSum));
        theMod.put("config", Summary.getSummaryConfigModel(aSum));
        theMod.put("log_url", aFinalLog);
        return theMod;
    }

    private static Object getSummaryConfigModel(Summary aSum) {
        return Summary.getSummaryInstallModel(aSum);
    }

    private static Object getSummaryInstallModel(Summary aSum) {
        HashMap<String, Object> theMod = new HashMap<String, Object>();
        theMod.put("status", aSum.getStatus());
        theMod.put("statusMsg", aSum.getStatusMsg());
        theMod.put("nextsteps", aSum.getNextSteps());
        theMod.put("docreference", aSum.getDocReference());
        theMod.put("errormsg", Summary.getSummaryErrorMsgModel(aSum));
        return theMod;
    }

    private static Object getSummaryErrorMsgModel(Summary aSum) {
        HashMap<String, String> theMod = new HashMap<String, String>();
        theMod.put("system", aSum.getPlatformError());
        theMod.put("product", aSum.getProductError());
        StringBuilder theOthers = new StringBuilder();
        for (String theMsg : aSum.getOtherDetails()) {
            theOthers.append(theMsg);
            theOthers.append('\n');
        }
        theMod.put("other", theOthers.toString());
        return theMod;
    }

    public Summary() {
    }

    public Operation.OPTYPE getOperation() {
        return this.gOperation;
    }

    public void setOperation(Operation.OPTYPE aOperation) {
        this.gOperation = aOperation;
    }

    public Boolean getStatus() {
        return this.gStatus;
    }

    public void setStatus(boolean aStatus) {
        this.gStatus = aStatus;
    }
}

