/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.util.Iterator;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.StringUtils;
import org.openinstaller.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionRange {
    private static final char INCLUDE_LOW = '[';
    private static final char EXCLUDE_LOW = '(';
    private static final char INCLUDE_HI = ']';
    private static final char EXCLUDE_HI = ')';
    private static final char ENTITY_SEP = '#';
    private final Version gLow;
    private final Version gHigh;
    private final boolean gIsLowInclusive;
    private final boolean gIsHighInclusive;
    public static final VersionRange WIDE_RANGE;

    public VersionRange(String aRangeSpec) throws EnhancedException {
        if (aRangeSpec == null) {
            throw new EnhancedException("RANGE_SPEC_NULL", new String[0]);
        }
        if ('[' == aRangeSpec.charAt(0)) {
            this.gIsLowInclusive = true;
        } else if ('(' == aRangeSpec.charAt(0)) {
            this.gIsLowInclusive = false;
        } else {
            throw new EnhancedException("INVALID_RANGE_SPEC_FIRST_CHAR_INCORRECT", "spec=" + aRangeSpec);
        }
        if (']' == aRangeSpec.charAt(aRangeSpec.length() - 1)) {
            this.gIsHighInclusive = true;
        } else if (')' == aRangeSpec.charAt(aRangeSpec.length() - 1)) {
            this.gIsHighInclusive = false;
        } else {
            throw new EnhancedException("INVALID_RANGE_SPEC_LAST_CHAR_INCORRECT", "spec=" + aRangeSpec);
        }
        String theRangeSpec = aRangeSpec.substring(1, aRangeSpec.length() - 1);
        String[] theLoAndHiElements = theRangeSpec.split("\\s*--\\s*");
        if (2 != theLoAndHiElements.length) {
            throw new EnhancedException("INVALID_RANGE_SPEC_LAST_CHAR_INCORRECT", "spec=" + aRangeSpec);
        }
        this.gLow = new Version(theLoAndHiElements[0]);
        this.gHigh = new Version(theLoAndHiElements[1]);
    }

    public VersionRange(Version aVersion) throws InvalidArgumentException {
        this(aVersion, true, aVersion, true);
    }

    public VersionRange(Version aLowVersion, boolean aLowInclusiveFlag, Version aHighVersion, boolean aHighInclusiveFlag) throws InvalidArgumentException {
        if (aLowVersion == null || aHighVersion == null) {
            throw new InvalidArgumentException("NULL_VERSION_RANGE", "low-version=" + aLowVersion, "high-version=" + aHighVersion);
        }
        this.gLow = aLowVersion;
        this.gHigh = aHighVersion;
        this.gIsLowInclusive = aLowInclusiveFlag;
        this.gIsHighInclusive = aHighInclusiveFlag;
    }

    public static VersionRange[] decodeVersionRanges(String aCompatibleVersionInfo) throws SIMSException {
        return VersionRange.decodeVersionRanges(aCompatibleVersionInfo, '#');
    }

    public static VersionRange[] decodeVersionRanges(String aCompatibleVersionInfo, char aSeparator) throws SIMSException {
        String[] theRangeSpecs = aCompatibleVersionInfo.split(Character.toString(aSeparator));
        VersionRange[] theRanges = new VersionRange[theRangeSpecs.length];
        for (int theIndex = 0; theIndex < theRangeSpecs.length; ++theIndex) {
            try {
                theRanges[theIndex] = new VersionRange(StringUtils.unescape(theRangeSpecs[theIndex], aSeparator));
                continue;
            }
            catch (EnhancedException theEEx) {
                throw new SIMSException((Throwable)theEEx, "CORRUPT_ENCODED_SPEC", new String[0]);
            }
        }
        return theRanges;
    }

    public static String encodeVersionRanges(Iterable<VersionRange> aRangeSet) {
        StringBuilder theContained = new StringBuilder();
        Iterator<VersionRange> theIter = aRangeSet.iterator();
        while (theIter.hasNext()) {
            theContained.append(StringUtils.escape(VersionRange.encode(theIter.next()), '#'));
            if (!theIter.hasNext()) continue;
            theContained.append('#');
        }
        return theContained.toString();
    }

    public Version getLow() {
        return this.gLow;
    }

    public Version getHigh() {
        return this.gHigh;
    }

    public boolean isLowInclusive() {
        return this.gIsLowInclusive;
    }

    public boolean isHighInclusive() {
        return this.gIsHighInclusive;
    }

    public boolean includesVersion(Version aVersion) {
        return this.includesVersion(aVersion, INCLUDE_TYPE.EQUALS);
    }

    public boolean includesVersion(Version aVersion, INCLUDE_TYPE aIncludeType) {
        if (this.gIsLowInclusive && aVersion.equals(this.gLow)) {
            return aIncludeType == INCLUDE_TYPE.EQUALS || aIncludeType == INCLUDE_TYPE.GREATER_THAN;
        }
        if (this.gIsHighInclusive && aVersion.equals(this.gHigh)) {
            return aIncludeType == INCLUDE_TYPE.EQUALS || aIncludeType == INCLUDE_TYPE.LESS_THAN;
        }
        return aVersion.compareTo(this.gLow) > 0 && aVersion.compareTo(this.gHigh) < 0;
    }

    public boolean overlaps(VersionRange aDifferentRange) {
        if (this.isLowInclusive() && aDifferentRange.includesVersion(this.getLow())) {
            return true;
        }
        if (!this.isLowInclusive() && aDifferentRange.includesVersion(this.getLow(), INCLUDE_TYPE.GREATER_THAN)) {
            return true;
        }
        if (aDifferentRange.isLowInclusive() && this.includesVersion(aDifferentRange.getLow())) {
            return true;
        }
        return !aDifferentRange.isLowInclusive() && this.includesVersion(aDifferentRange.getLow(), INCLUDE_TYPE.LESS_THAN);
    }

    public boolean equals(Object aRange) {
        if (aRange == null) {
            return false;
        }
        if (aRange.getClass() != VersionRange.class) {
            return false;
        }
        VersionRange theRange = (VersionRange)aRange;
        return this.gHigh.equals(theRange.gHigh) && this.gLow.equals(theRange.gLow) && this.gIsHighInclusive == theRange.gIsHighInclusive && this.gIsLowInclusive == theRange.gIsLowInclusive;
    }

    public int hashCode() {
        int theCode = 0;
        theCode += this.gHigh.hashCode() + this.gLow.hashCode();
        if (this.gIsLowInclusive) {
            ++theCode;
        }
        if (this.gIsHighInclusive) {
            ++theCode;
        }
        return theCode;
    }

    public static String encode(VersionRange aRange) {
        StringBuffer theEncodedString = new StringBuffer();
        if (aRange.isLowInclusive()) {
            theEncodedString.append('[');
        } else {
            theEncodedString.append('(');
        }
        theEncodedString.append(Version.encode(aRange.getLow()));
        theEncodedString.append("--");
        theEncodedString.append(Version.encode(aRange.getHigh()));
        if (aRange.isHighInclusive()) {
            theEncodedString.append(']');
        } else {
            theEncodedString.append(')');
        }
        return theEncodedString.toString();
    }

    public String toString() {
        return VersionRange.encode(this);
    }

    static {
        try {
            WIDE_RANGE = new VersionRange(new Version("0"), true, Version.INFINITY, false);
        }
        catch (InvalidArgumentException theEx) {
            throw new RuntimeException("Cannot initialize WIDE_RANGE", theEx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum INCLUDE_TYPE {
        EQUALS,
        GREATER_THAN,
        LESS_THAN;

    }
}

