/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.desktopintegration;

import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DesktopType {
    GNOME,
    KDE,
    WINDOWS;


    public static DesktopType detectDesktopEnvironment() throws EnhancedException {
        DesktopType theDesktop = null;
        Platform.OSType theOSType = Platform.getCurrentOsType();
        switch (theOSType) {
            case UNIX: {
                if ("Default".equalsIgnoreCase(System.getenv("GNOME_DESKTOP_SESSION_ID"))) {
                    theDesktop = GNOME;
                    break;
                }
                if ("true".equalsIgnoreCase(System.getenv("KDE_FULL_SESSION"))) {
                    theDesktop = KDE;
                    break;
                }
                throw new EnhancedException("UNSUPPORTED_PLATFORM", "platform=" + (Object)((Object)Platform.getCurrentOsName()), "windowmanager=unknown");
            }
            case WINDOWS: {
                theDesktop = WINDOWS;
                break;
            }
            default: {
                throw new EnhancedException("UNSUPPORTED_PLATFORM", "platform=" + (Object)((Object)Platform.getCurrentOsName()));
            }
        }
        return theDesktop;
    }
}

