/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.desktopintegration;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.provider.conf.oor.OORAddRemoveEntry;
import org.openinstaller.provider.conf.oor.OORDesktop;
import org.openinstaller.provider.conf.oor.OORShortcut;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.desktopintegration.DesktopIntegrator;
import org.openinstaller.util.desktopintegration.DesktopType;
import org.openinstaller.util.desktopintegration.GnomeDesktopIntegrator;
import org.openinstaller.util.desktopintegration.WindowsDesktopIntegrator;

public class LocalDesktop {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static DesktopIntegrator gDesktopIntegrator;

    private LocalDesktop() {
    }

    public static void createShortcuts(OORDesktop aOORDesktop) throws EnhancedException {
        if (aOORDesktop == null) {
            LOGGER.finest(ClassUtils.getMethodName() + ": " + ClassUtils.getCallingMethodName() + "() passed a null instance");
            return;
        }
        if (gDesktopIntegrator == null) {
            gDesktopIntegrator = LocalDesktop.getDIInstance();
        }
        List theShortcuts = aOORDesktop.getShortcuts();
        LOGGER.finest("CREATING SHORTCUTS FOR " + aOORDesktop.getName());
        for (OORShortcut theShortcut : theShortcuts) {
            LOGGER.finest("CreatingShortcut for " + theShortcut.getName());
            try {
                gDesktopIntegrator.createShortcut(theShortcut);
            }
            catch (EnhancedException ex) {
                LOGGER.log(Level.WARNING, "SHORTCUT_CREATION_FAILED", "shortcut=" + theShortcut.getName());
            }
        }
        OORAddRemoveEntry theAddRemoveEntry = new OORAddRemoveEntry();
        try {
            theAddRemoveEntry = aOORDesktop.getAddRemoveEntry();
            if (theAddRemoveEntry != null && theAddRemoveEntry.getDisplayName() != null && theAddRemoveEntry.getUninstallString() != null) {
                gDesktopIntegrator.createAddRemoveEntry(theAddRemoveEntry);
            }
        }
        catch (EnhancedException ex) {
            LOGGER.log(Level.WARNING, "ADDREMOVE_CREATION_FAILED", "ARP=" + theAddRemoveEntry.getDisplayName());
        }
    }

    public static void removeShortcuts(OORDesktop aOORDesktop) throws EnhancedException {
        if (aOORDesktop == null) {
            LOGGER.finest(ClassUtils.getMethodName() + ": " + ClassUtils.getCallingMethodName() + "() passed a null instance");
            return;
        }
        if (gDesktopIntegrator == null) {
            gDesktopIntegrator = LocalDesktop.getDIInstance();
        }
        List theShortcuts = aOORDesktop.getShortcuts();
        OORAddRemoveEntry aAddRemoveEntry = aOORDesktop.getAddRemoveEntry();
        LOGGER.finest("REMOVING SHORTCUTS FOR " + aOORDesktop.getName());
        for (OORShortcut theShortcut : theShortcuts) {
            LOGGER.finest("Removing Shortcut for " + theShortcut.getName());
            try {
                gDesktopIntegrator.removeShortcut(theShortcut);
            }
            catch (EnhancedException ex) {
                LOGGER.log(Level.WARNING, "SHORTCUT_REMOVAL_FAILED", "shortcut=" + theShortcut.getName());
            }
        }
        try {
            if (aAddRemoveEntry != null && aAddRemoveEntry.getDisplayName() != null) {
                gDesktopIntegrator.removeAddRemoveEntry(aAddRemoveEntry);
            }
        }
        catch (EnhancedException ex) {
            LOGGER.log(Level.WARNING, "ADDREMOVE_REMOVAL_FAILED", "addremove=" + aAddRemoveEntry.getDisplayName());
        }
    }

    private static DesktopIntegrator getDIInstance() throws EnhancedException {
        DesktopType theDesktopType = DesktopType.detectDesktopEnvironment();
        switch (theDesktopType) {
            case GNOME: {
                return GnomeDesktopIntegrator.getInstance();
            }
            case WINDOWS: {
                return WindowsDesktopIntegrator.getInstance();
            }
        }
        return null;
    }
}

