/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.substitution;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.substitution.SubstitutionParser;
import org.openinstaller.util.substitution.Token;

public class SubstitutionEngine {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    private SubstitutionEngine() {
    }

    public static String resolve(String aSubVariable) throws EnhancedException {
        StringBuilder theResult = new StringBuilder();
        try {
            SubstitutionParser theParser = new SubstitutionParser(new StringReader(aSubVariable));
            List<Token> theTokenCollection = theParser.getTokens();
            for (Token theToken : theTokenCollection) {
                String theResolvedValue = theToken.resolve();
                if (null == theResolvedValue) {
                    theResult = new StringBuilder();
                    break;
                }
                theResult.append(theResolvedValue);
            }
        }
        catch (IOException theIOException) {
            throw new EnhancedException("SUBSTITUTION_PARSING_ERROR", (Throwable)theIOException, "value=" + aSubVariable);
        }
        return theResult.toString();
    }
}

