/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.substitution;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.substitution.MachineInfo;
import org.openinstaller.util.substitution.SimpleToken;
import org.openinstaller.util.substitution.Token;

public class TargetToken
implements Token {
    private StringBuilder gTokenVariable = new StringBuilder();
    private String gMachineInfo = null;
    private String gHostRedirect = null;

    public boolean validate() {
        boolean theReturnValue = true;
        char theFirstCharacter = this.gTokenVariable.charAt(0);
        if (theFirstCharacter == ':') {
            this.gMachineInfo = this.gTokenVariable.substring(1, this.gTokenVariable.length());
        } else if (theFirstCharacter == '(') {
            this.gHostRedirect = this.gTokenVariable.substring(1, this.gTokenVariable.lastIndexOf(")"));
            this.gMachineInfo = this.gTokenVariable.substring(this.gTokenVariable.lastIndexOf(":") + 1, this.gTokenVariable.length());
            if (this.gHostRedirect.charAt(0) == ':' && this.gHostRedirect.charAt(1) == '[' && this.gHostRedirect.charAt(this.gHostRedirect.length() - 1) != ']') {
                theReturnValue = false;
            }
        }
        return theReturnValue;
    }

    public String resolve() throws EnhancedException {
        String theResult = null;
        if (!this.validate()) {
            throw new EnhancedException("INVALID_TARGET_TOKEN", "token=" + this.gTokenVariable);
        }
        if (null != this.gHostRedirect && this.gHostRedirect.charAt(0) == ':' && this.gHostRedirect.charAt(1) == '[' && this.gHostRedirect.charAt(this.gHostRedirect.length() - 1) == ']') {
            SimpleToken theHostRedirectToken = new SimpleToken();
            theHostRedirectToken.set(new StringBuilder(this.gHostRedirect));
            this.gHostRedirect = theHostRedirectToken.resolve();
        }
        MachineInfo theAttribute = MachineInfo.getTypeForString(this.gMachineInfo);
        switch (theAttribute) {
            case HOST_NAME: {
                InetAddress theAddress;
                try {
                    theAddress = this.gHostRedirect != null ? InetAddress.getByName(this.gHostRedirect) : InetAddress.getLocalHost();
                    theResult = theAddress.getHostName();
                    break;
                }
                catch (UnknownHostException theException) {
                    throw new EnhancedException("UNKNOWN_HOST", theException.getCause(), "host=" + this.gHostRedirect);
                }
            }
            case IP_ADDRESS: {
                InetAddress theAddress;
                try {
                    theAddress = this.gHostRedirect != null ? InetAddress.getByName(this.gHostRedirect) : InetAddress.getLocalHost();
                    theResult = theAddress.getHostAddress();
                    break;
                }
                catch (UnknownHostException theException) {
                    throw new EnhancedException("UNKNOWN_HOST", theException.getCause(), "host=" + this.gHostRedirect);
                }
            }
            case HOME_DIR: {
                if (this.gHostRedirect != null) {
                    throw new EnhancedException("CANNOT_DETERMINE_HOME_DIR", "host=" + this.gHostRedirect);
                }
                theResult = System.getProperty("user.home");
                break;
            }
            case TMP_DIR: {
                if (this.gHostRedirect != null) {
                    throw new EnhancedException("CANNOT_DETERMINE_TMP_DIR", "host=" + this.gHostRedirect);
                }
                theResult = System.getProperty("java.io.tmpdir");
                break;
            }
            case OS_NAME: {
                if (this.gHostRedirect != null) {
                    throw new EnhancedException("CANNOT_DETERMINE_OS_NAME", "host=" + this.gHostRedirect);
                }
                theResult = System.getProperty("os.name");
                break;
            }
            case OS_VERSION: {
                if (this.gHostRedirect != null) {
                    throw new EnhancedException("CANNOT_DETERMINE_OS_VERSION", "host=" + this.gHostRedirect);
                }
                theResult = System.getProperty("os.version");
                break;
            }
            case OS_ARCH: {
                if (this.gHostRedirect != null) {
                    throw new EnhancedException("CANNOT_DETERMINE_OS_ARCH", "host=" + this.gHostRedirect);
                }
                theResult = System.getProperty("os.arch");
                break;
            }
            case USER_NAME: {
                if (this.gHostRedirect != null) {
                    throw new EnhancedException("CANNOT_DETERMINE_USER_NAME", "host=" + this.gHostRedirect);
                }
                theResult = System.getProperty("user.name");
                break;
            }
            case USER_DIR: {
                if (this.gHostRedirect != null) {
                    throw new EnhancedException("CANNOT_DETERMINE_USER_CURRENT_DIRECTORY", "host=" + this.gHostRedirect);
                }
                theResult = System.getProperty("user.dir");
                break;
            }
            default: {
                throw new EnhancedException("CANNOT_DETERMINE_TARGET_TOKEN", "value=" + this.gMachineInfo);
            }
        }
        return theResult;
    }

    public String get() {
        return this.gTokenVariable.toString();
    }

    public void set(StringBuilder aInput) {
        this.gTokenVariable = aInput;
    }
}

