/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.SocketBase;
import org.mozilla.jss.ssl.SocketProxy;

public class SSLServerSocket
extends ServerSocket {
    private SocketProxy sockProxy = null;
    private boolean handshakeAsClient = false;
    private SocketBase base = new SocketBase();
    private boolean isClosed = false;
    private boolean inAccept = false;
    private Object acceptLock = new Object();
    public static final int DEFAULT_BACKLOG = 50;
    private static InetAddress anyLocalAddr;
    private static final String UNIX_TEMP_DIR = "/tmp";
    private static final String WINDOWS_TEMP_DIR = "\\temp";

    public SSLServerSocket(int n) throws IOException {
        this(n, 50, null);
    }

    public SSLServerSocket(int n, int n2) throws IOException {
        this(n, n2, null);
    }

    public SSLServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        this(n, n2, inetAddress, null);
    }

    public SSLServerSocket(int n, int n2, InetAddress inetAddress, SSLCertificateApprovalCallback sSLCertificateApprovalCallback) throws IOException {
        this(n, n2, inetAddress, sSLCertificateApprovalCallback, false);
    }

    public SSLServerSocket(int n, int n2, InetAddress inetAddress, SSLCertificateApprovalCallback sSLCertificateApprovalCallback, boolean bl) throws IOException {
        super(0);
        super.close();
        this.sockProxy = new SocketProxy(this.base.socketCreate(this, sSLCertificateApprovalCallback, null));
        this.base.setProxy(this.sockProxy);
        this.setReuseAddress(bl);
        if (inetAddress == null) {
            inetAddress = anyLocalAddr;
        }
        byte[] byArray = null;
        if (inetAddress != null) {
            byArray = inetAddress.getAddress();
        }
        this.base.socketBind(byArray, n);
        this.socketListen(n2);
    }

    private native void socketListen(int var1) throws SocketException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket accept() throws IOException {
        Object object = this.acceptLock;
        synchronized (object) {
            SSLServerSocket sSLServerSocket;
            Object object2;
            Closeable closeable = this;
            synchronized (closeable) {
                if (this.isClosed) {
                    throw new IOException("SSLServerSocket has been closed, and cannot be reused.");
                }
                this.inAccept = true;
            }
            closeable = new SSLSocket();
            try {
                object2 = null;
                object2 = this.socketAccept((SSLSocket)closeable, this.base.getTimeout(), this.handshakeAsClient);
                SocketProxy socketProxy = new SocketProxy((byte[])object2);
                ((SSLSocket)closeable).setSockProxy(socketProxy);
                sSLServerSocket = this;
            }
            catch (Throwable throwable) {
                SSLServerSocket sSLServerSocket2 = this;
                synchronized (sSLServerSocket2) {
                    this.inAccept = false;
                }
                throw throwable;
            }
            object2 = sSLServerSocket;
            synchronized (sSLServerSocket) {
                this.inAccept = false;
                // ** MonitorExit[var3_4 /* !! */ ] (shouldn't be in output)
                return closeable;
            }
        }
    }

    public void setSoTimeout(int n) {
        this.base.setTimeout(n);
    }

    public int getSoTimeout() {
        return this.base.getTimeout();
    }

    public native void setReuseAddress(boolean var1) throws SocketException;

    public native boolean getReuseAddress() throws SocketException;

    private native void abortAccept() throws SocketException;

    private native byte[] socketAccept(SSLSocket var1, int var2, boolean var3) throws SocketException, SocketTimeoutException;

    public static native void clearSessionCache();

    protected void finalize() throws Throwable {
        this.close();
    }

    public int getLocalPort() {
        return this.base.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (this.sockProxy == null) {
                return;
            }
            if (this.inAccept) {
                this.abortAccept();
            }
        }
        object = this.acceptLock;
        synchronized (object) {
            this.base.close();
            this.sockProxy = null;
            this.base.setProxy(null);
        }
    }

    public static native void configServerSessionIDCache(int var0, int var1, int var2, String var3) throws SocketException;

    public void setServerCertNickname(String string) throws SocketException {
        try {
            this.setServerCert(CryptoManager.getInstance().findCertByNickname(string));
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            throw new SocketException("CryptoManager not initialized");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new SocketException("Object not found: " + objectNotFoundException);
        }
        catch (TokenException tokenException) {
            throw new SocketException("Token Exception: " + tokenException);
        }
    }

    public native void setServerCert(X509Certificate var1) throws SocketException;

    public void requestClientAuth(boolean bl) throws SocketException {
        this.base.requestClientAuth(bl);
    }

    public void setNeedClientAuth(boolean bl) throws SocketException {
        this.base.requestClientAuth(bl);
    }

    public void setNeedClientAuthNoExpiryCheck(boolean bl) throws SocketException {
        this.base.requestClientAuthNoExpiryCheck(bl);
    }

    public void enableSSL2(boolean bl) throws SocketException {
        this.base.enableSSL2(bl);
    }

    public void enableSSL3(boolean bl) throws SocketException {
        this.base.enableSSL3(bl);
    }

    public void enableTLS(boolean bl) throws SocketException {
        this.base.enableTLS(bl);
    }

    public void enableSessionTickets(boolean bl) throws SocketException {
        this.base.enableSessionTickets(bl);
    }

    public void bypassPKCS11(boolean bl) throws SocketException {
        this.base.bypassPKCS11(bl);
    }

    public void enableRollbackDetection(boolean bl) throws SocketException {
        this.base.enableRollbackDetection(bl);
    }

    public void enableStepDown(boolean bl) throws SocketException {
        this.base.enableStepDown(bl);
    }

    public void enableFDX(boolean bl) throws SocketException {
        this.base.enableFDX(bl);
    }

    public void enableV2CompatibleHello(boolean bl) throws SocketException {
        this.base.enableV2CompatibleHello(bl);
    }

    public String getSSLOptions() {
        return this.base.getSSLOptions();
    }

    public InetAddress getInetAddress() {
        return this.base.getLocalAddress();
    }

    public void requireClientAuth(boolean bl, boolean bl2) throws SocketException {
        this.base.requireClientAuth(bl, bl2);
    }

    public void requireClientAuth(int n) throws SocketException {
        if (n < 18 || n > 21) {
            throw new SocketException("Incorrect input value.");
        }
        this.base.requireClientAuth(n);
    }

    public void setClientCertNickname(String string) throws SocketException {
        this.base.setClientCertNickname(string);
    }

    public void setClientCert(X509Certificate x509Certificate) throws SocketException {
        this.base.setClientCert(x509Certificate);
    }

    public void setUseClientMode(boolean bl) {
        this.handshakeAsClient = bl;
    }

    public void useCache(boolean bl) throws SocketException {
        this.base.useCache(bl);
    }

    public String toString() {
        try {
            InetAddress inetAddress = this.getInetAddress();
            int n = this.getLocalPort();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SSLServerSocket[addr=");
            stringBuffer.append(inetAddress);
            stringBuffer.append(",localport=");
            stringBuffer.append(n);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Exception caught in toString(): " + exception.getMessage();
        }
    }

    static {
        try {
            anyLocalAddr = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

