/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.cert.Extension;

public class ListCerts {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 2) {
                System.out.println("Usage: ListCerts <dbdir> <nickname>");
                return;
            }
            String string = stringArray[0];
            String string2 = stringArray[1];
            CryptoManager.initialize(string);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            org.mozilla.jss.crypto.X509Certificate[] x509CertificateArray = cryptoManager.findCertsByNickname(string2);
            System.out.println(x509CertificateArray.length + " certs found with this nickname.");
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                System.out.println("\nSubject: " + x509CertificateArray[i].getSubjectDN());
                Certificate certificate = (Certificate)ASN1Util.decode(Certificate.getTemplate(), x509CertificateArray[i].getEncoded());
                CertificateInfo certificateInfo = certificate.getInfo();
                OBJECT_IDENTIFIER oBJECT_IDENTIFIER = certificateInfo.getSignatureAlgId().getOID();
                System.out.println("Signature oid " + certificateInfo.getSignatureAlgId().getOID());
                SEQUENCE sEQUENCE = certificateInfo.getExtensions();
                for (int j = 0; j < sEQUENCE.size(); ++j) {
                    object5 = (Extension)sEQUENCE.elementAt(i);
                    object4 = ((Extension)object5).getExtnId();
                    object3 = ((Extension)object5).getExtnValue();
                    System.out.println("Extension " + ((OBJECT_IDENTIFIER)object4).toString());
                    if (((Extension)object5).getCritical()) {
                        System.out.println("Critical extension: " + ((OBJECT_IDENTIFIER)object4).toString());
                        continue;
                    }
                    System.out.println("NON Critical extension: " + ((OBJECT_IDENTIFIER)object4).toString());
                }
                System.out.println("Convert to JDK cert");
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                object5 = new ByteArrayInputStream(x509CertificateArray[i].getEncoded());
                object4 = (X509Certificate)certificateFactory.generateCertificate((InputStream)object5);
                ((ByteArrayInputStream)object5).close();
                System.out.println("Subject " + ((X509Certificate)object4).getSubjectDN());
                System.out.println("Signature oid " + ((X509Certificate)object4).getSigAlgName());
                object3 = object4.getNonCriticalExtensionOIDs();
                if (object3 != null && !object3.isEmpty()) {
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        System.out.println((String)object);
                    }
                } else {
                    System.out.println("no NON Critical Extensions");
                }
                object2 = object4.getCriticalExtensionOIDs();
                if (object2 != null && !object2.isEmpty()) {
                    System.out.println("Set of critical extensions:");
                    object = object2.iterator();
                    while (object.hasNext()) {
                        String string3 = (String)object.next();
                        System.out.println(string3);
                    }
                    continue;
                }
                System.out.println("no Critical Extensions");
            }
            System.out.println("END");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

