/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.tools.ant;

import com.sun.pkg.tools.ant.Package;
import com.sun.pkg.tools.ant.Packages;
import com.sun.pkg.tools.ant.PythonEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class Copypkgs
extends Task {
    private List<String> gArguments = new ArrayList<String>();
    private Packages gPackage = null;

    public void setSrcdir(String aSrcdir) {
        this.gArguments.add("-s");
        this.gArguments.add(aSrcdir);
    }

    public void setDestdir(String aDestdir) {
        this.gArguments.add("-d");
        this.gArguments.add(aDestdir);
    }

    public void setForce(boolean aForce) {
        if (aForce) {
            this.gArguments.add("--force");
        }
    }

    public Packages createPackages() {
        if (this.gPackage != null) {
            throw new BuildException("Only one packages element is allowed.");
        }
        this.gPackage = new Packages();
        return this.gPackage;
    }

    public void execute() throws BuildException {
        Project theCurrentAntProject = this.getProject();
        for (Package thePackage : this.gPackage.getPackages()) {
            this.gArguments.add(thePackage.getName());
        }
        String theOutput = null;
        try {
            String thePythonHome = theCurrentAntProject.getProperty("pkg.python.home");
            String thePkgBasedir = theCurrentAntProject.getProperty("pkg.basedir");
            String thePythonCmd = PythonEnvironment.PYTHONCMD.getValue(thePythonHome, thePkgBasedir);
            this.gArguments.add(0, thePkgBasedir + "/../bin/copypkgs.py");
            this.gArguments.add(0, thePythonCmd);
            ProcessBuilder theProcBuilder = new ProcessBuilder(new String[0]);
            theProcBuilder.command(this.gArguments);
            Map<String, String> theEnv = theProcBuilder.environment();
            theEnv.remove("PYTHONPATH");
            theEnv.put("LD_LIBRARY_PATH", PythonEnvironment.LD_LIBRARY_PATH.getValue(thePythonHome, thePkgBasedir));
            theProcBuilder.redirectErrorStream(true);
            Process theProcess = theProcBuilder.start();
            BufferedReader theStdInput = new BufferedReader(new InputStreamReader(theProcess.getInputStream()));
            while ((theOutput = theStdInput.readLine()) != null) {
                System.out.println(theOutput);
            }
            theProcess.waitFor();
            if (theProcess.exitValue() != 0) {
                throw new BuildException("copypkgs.py failed, error code = " + theProcess.exitValue());
            }
        }
        catch (IOException theIOE) {
            theIOE.printStackTrace();
            throw new BuildException("copypkgs failed", (Throwable)theIOE);
        }
        catch (Exception theEx) {
            theEx.printStackTrace();
            throw new BuildException("copypkgs failed", (Throwable)theEx);
        }
    }
}

